#ifndef _GAME_DRIVER_H
#define _GAME_DRIVER_H

#include <linux/ioctl.h>

#define HMAX 640
#define VMAX 480
#define RAD 8

typedef struct {
    unsigned char size, type;
    unsigned x, y;
} tile_t;

typedef struct {
    int score;
    unsigned char state, audio;
} current_score_t;

typedef struct {
    int score;
} best_score_t;

typedef struct {
    tile_t tiles[16];
    current_score_t current_score;
    best_score_t best_score;
} game_arg_t;

#define GAME_DRIVER_MAGIC 'q'

/* ioctls and their arguments */
#define GAME_WRITE_TILES            _IOW(GAME_DRIVER_MAGIC, 1, game_arg_t *)
#define GAME_WRITE_CURRENT_SCORE    _IOW(GAME_DRIVER_MAGIC, 2, game_arg_t *)
#define GAME_WRITE_BEST_SCORE       _IOW(GAME_DRIVER_MAGIC, 3, game_arg_t *)

#endif
