import matplotlib.pyplot as plt
import matplotlib.image as mpimg

img = mpimg.imread('./colors.png') * 255
img = [[[ round(num) for num in pixel ] for pixel in row ] for row in img ]
f = open('./colors.mif', 'w')
f.write('\n' + 
	'-- MADE BY PYTHON\n' + 
	'-- WIDTH =  256\n' + 
        '-- HEIGHT =  256\n' + 
        '\n' + 
        f'DEPTH =  {148 * 1};\n' + 
        'WIDTH = 24;\n' + 
        'ADDRESS_RADIX = DEC;\n' + 
        'DATA_RADIX = DEC;\n' + 
        'CONTENT\n' + 
        'BEGIN\n'
        )

cnt = 0
for row in img:
        for pixel in row:
                r = pixel[0]
                g = pixel[1]
                b = pixel[2]
                f.write(f'{cnt}:\t{r << 16 | g << 8 | b};\n')
                cnt += 1
f.write('END;')