import matplotlib.pyplot as plt
import matplotlib.image as mpimg

img = mpimg.imread('./background.png') * 2
img = [[[ round(num) for num in pixel ] for pixel in row ] for row in img ]
f = open('./background.mif', 'w')
f.write('\n' + 
	'-- MADE BY PYTHON\n' + 
	'-- WIDTH =  256\n' + 
        '-- HEIGHT =  256\n' + 
        '\n' + 
        f'DEPTH =  {640 * 480};\n' + 
        'WIDTH = 4;\n' + 
        'ADDRESS_RADIX = DEC;\n' + 
        'DATA_RADIX = DEC;\n' + 
        'CONTENT\n' + 
        'BEGIN\n'
        )

cnt = 0
for row in img:
        for pixel in row:
                r = pixel[0]
                g = pixel[1]
                b = pixel[2]
                match (r, g, b):
                        case (2, 2, 2):
                                f.write(f'{cnt}:\t0;\n')
                        case (2, 2, 0):
                                f.write(f'{cnt}:\t1;\n')
                        case (0, 2, 0):
                                f.write(f'{cnt}:\t2;\n')
                        case (0, 0, 2):
                                f.write(f'{cnt}:\t3;\n')
                        case (0, 0, 0):
                                f.write(f'{cnt}:\t4;\n')
                        case (2, 0, 0):
                                f.write(f'{cnt}:\t5;\n')
                        case (2, 0, 2):
                                f.write(f'{cnt}:\t6;\n')
                        case (2, 1, 2):
                                f.write(f'{cnt}:\t7;\n')
                        case (0, 2, 2):
                                f.write(f'{cnt}:\t8;\n')
                        case _:
                                f.write(f'{cnt}:\t0;\n')
                cnt += 1
f.write('END;')