#ifndef _SIFT
#define _SIFT

#include "vga_ball.h"

#define MAX_KERNEL_SIZE 25
#define NUM_OCTAVES 4
#define NUM_BLURS 5
#define SIGMA_ROOT 2.5

// typedef struct Kernel {
//     double kernel[25*25];
//     unsigned int size; // e.g. 19
//     double sigma;
// } Kernel;

typedef struct Img {
  unsigned char *array; // where the actual img is held
  unsigned short height;
  unsigned short width;
  double sigma;
  unsigned char octave;   // either 0,1,2,3
  unsigned char blur_idx; // 0,1,2,3,4
} Img;

typedef struct DoG {
  Img *img1;
  Img *img2;     // more blur than img1 (higher sigma than img1)
  double *array; // where the actual DoG is held
  unsigned char octave;
  int width;
  int height;
} DoG;

#endif
