#include "descriptors.h"
#include "sift.h"
#include "sift_utils.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define CLIP(num, l, h) ((num) < (l) ? (l) : (num) > (h) ? (h) : (num))

void assign_orientation(Keypoints *kps, DoG *diffs, int octave_num) {
  int i = 0;
  for (int i = 0; i < kps->count; i++) {
    Kp *kp = kps->kp_list[i];
    if (!kp->is_valid)
      continue;
    int row, col, blur_idx;
    row = (int)kp->kp_precise->y;
    col = (int)kp->kp_precise->x;
    blur_idx =
        CLIP((int)kp->kp_precise->DoG_idx, 0, NUM_OCTAVES * (NUM_BLURS - 1)) %
        (NUM_BLURS - 1);
    if (abs(blur_idx - (kp->DoG_idx % (NUM_BLURS - 1))) >= 1) {
      printf("int DoG_idx (%d) and precise DoG_idx (%f) don't match\n",
             kp->DoG_idx, kp->kp_precise->DoG_idx);
      continue;
    }
    double sigmas[NUM_BLURS];
    get_sigmas(sigmas, SIGMA_ROOT);
    double sigma = get_kernel_size_from_sigma(sigmas[blur_idx]);
    double *kernel = malloc(sigma * sizeof(double));
    get_kernel(kernel, 1.5 * sigmas[blur_idx]);
  }
}