#ifndef _USBGAMEPAD_H
#define _USBGAMEPAD_H

#include <libusb-1.0/libusb.h>

enum gamepad_state {
    START, 
    SELECT,
    DOWN_LEFT, DOWN_RIGHT,
    LEFT, RIGHT, DOWN, TOP,
    A, B,
    NONE
};

// find and open usb gamepad device, store enpoint addressl retrun NULL if no gamepad found
extern struct libusb_device_handle *opengamepad(uint8_t *);

// obtain the current gamepad state
extern char gamepad_state(struct libusb_device_handle *, uint8_t);

#endif
