//combinational circuit to convert the pixel location (hcount,vcount) into
//the correct color code for that specific pixel
//
//

module color_decode(input logic [9:0] hcount, vcount, falling_h, falling_v,                                                              
	output logic [12:0] num);
	
	logic [9:0] x, y;
	                
	assign x = (hcount + 2) - falling_h;
	assign y = vcount - falling_v;

	assign num = (y * 80) + x; 
	
/*	always_comb begin
		if (x == 10'd0) begin
			num = 12'd6399;
		end else begin
			num = (y * 80) + x;
		end
	end
	*/


endmodule    
	   
