
//combinational circuit to convert number code to an actual rgb color string
module color_assign(input logic [7:0] num,
	output logic [23:0] rgb);

	always_comb begin
		case (num)
			  //white
			  16'd0: rgb = 24'hff_ff_ff;
			  //blue
			  16'd1: rgb = 24'h00_00_ff;
			  //black
			  16'd2: rgb = 24'h00_00_00;
			  //red
			  16'd3: rgb = 24'hff_00_00;
			  //transparent - gray for now
			  16'd4: rgb = 24'h01_01_01;
			  //default orange
			  default rgb = 24'hff_7f_00;
		endcase
	end
endmodule

