module sprite_rom_7 (     //可以让bg横着，横轴纵轴个放大两倍+多个note 可实现全16个note，实现另外的note   + final line note_改 + start page
    input  wire logic clk,                            // clock
    input  wire logic rst,                            // reset
    input  logic [9:0]     vcount, 
    input  logic [10:0]	   hcount, note_x_1, note_x_2, note_x_3, note_x_4, 
    input  logic [10:0]	   note_x_5, note_x_6, note_x_7, note_x_8,
    input  logic [10:0]	   note_x_9, note_x_10, note_x_11, note_x_12,
    input  logic [10:0]	   note_x_13, note_x_14, note_x_15, note_x_16, indicater1, indicater2, indicater3, indicater4,
    input  logic [15:0]    score,
    input  logic page,
    output logic drawing,
    output logic  [23:0]   pix_out                        // drawing at position (sx,sy)
    );
    //parameter a = 323(vertical), AA = 382(horizantal,x2ed), b = 18, BB = 156;
    //parameter a = 191, AA = 1292, b = 78, BB = 36;
    //parameter a = 382, AA = 1292, b = 78, BB = 36, bg_x = 1, bg_y = 1;
    parameter a = 382, AA = 1292, b = 34, BB = 12, bg_x = 1, bg_y = 51; //原note_blue的width36 = b，height12 = BB（图片property）
    parameter start_x = 550, start_y = 51, STA = 92, st = 191;
    parameter note_y_1 = 161, note_y_2 = 225, note_y_3 = 289, note_y_4 = 353;
    parameter note_y_5 = 161, note_y_6 = 225, note_y_7 = 289, note_y_8 = 353;
    parameter note_y_9 = 161, note_y_10 = 225, note_y_11 = 289, note_y_12 = 353;
    parameter note_y_13 = 161, note_y_14 = 225, note_y_15 = 289, note_y_16 = 353;
    //--------indicater
    parameter hm = 30, HMM = 60, ind = 35, INDD = 50;
    parameter hm_x = 1075, hm_y_1 = 162, hm_y_2 =226, hm_y_3 = 290, hm_y_4 = 354;
    parameter indi_x = 1020, indi_y_1 = 160, indi_y_2 = 224, indi_y_3 = 288, indi_y_4 = 352;
    parameter finalline_x = 1101, finalline_y = 99, FLL = 8, fl = 286;  //wid53 hei 19
    //--------num
    parameter num_x = 580;
    parameter num_y_3 = 258, num_y_2 = 223, num_y_1 = 188, num_y_0 = 153;
    parameter num_height = 13, num_width = 15 ; // h:13 w:15 


    logic line_active, line_end, bg_active, note_active, frame_finish;
    logic indicater_active, mark_active, finalline_active, start_active, num_active;
    logic [7:0]  address_num;
    logic [10:0] address_note, address_hitind, address_missind, address_hitmark;
    logic [11:0] address_finalline;
    logic [15:0] address_bg, address_start;
    logic [23:0] out_bg, out_note, interbuffer, out_hitind, out_hitmark, out_missind, out_finalline, out_start;
    logic [23:0] out_num0, out_num1, out_num2, out_num3, out_num4, out_num5, out_num6, out_num7, out_num8, out_num9;
    //logic [23:0] out_note5, out_note6, out_note7, out_note8;
    //logic [23:0] out_note9, out_note10, out_note11, out_note12;
    //logic [23:0] out_note13, out_note14, out_note15, out_note16;

    // sprite state machine
    enum {
        IDLE,      // screen
        WAIT,
        DRAW_BG,
        DRAW_NOTE,
        RESET,
        INDICATER,
        DRAW_FINAL,
        MARK,
        DRAW_START,
        DRAW_NUM
    } state;

    
    note_blue tile1(.address(address_note),.clock(clk),.q(out_note));
    background bg(.address(address_bg),.clock(clk),.q(out_bg));
    hit_indicater hitind(.address(address_hitind),.clock(clk),.q(out_hitind));
    hit_mark hitmark(.address(address_hitmark),.clock(clk),.q(out_hitmark));
    miss_indicater missind(.address(address_missind),.clock(clk),.q(out_missind));
    note_red line(.address(address_finalline),.clock(clk),.q(out_finalline));
    start start(.address(address_start),.clock(clk),.q(out_start));
    num_0 num0(.address(address_num),.clock(clk),.q(out_num0));
    num_1 num1(.address(address_num),.clock(clk),.q(out_num1));
    num_2 num2(.address(address_num),.clock(clk),.q(out_num2));
    num_3 num3(.address(address_num),.clock(clk),.q(out_num3));
    num_4 num4(.address(address_num),.clock(clk),.q(out_num4));
    num_5 num5(.address(address_num),.clock(clk),.q(out_num5));
    num_6 num6(.address(address_num),.clock(clk),.q(out_num6));
    num_7 num7(.address(address_num),.clock(clk),.q(out_num7));
    num_8 num8(.address(address_num),.clock(clk),.q(out_num8));
    num_9 num9(.address(address_num),.clock(clk),.q(out_num9));

    always_comb begin
        line_active = ((((vcount - note_y_1 >= 0)&&(vcount - note_y_1 <= b-1)) || 
                      ((vcount - note_y_2 >= 0)&&(vcount - note_y_2 <= b-1)) || 
                      ((vcount - note_y_3 >= 0)&&(vcount - note_y_3 <= b-1)) || 
                      ((vcount - note_y_4 >= 0)&&(vcount - note_y_4 <= b-1)) || 
                      ((vcount - note_y_5 >= 0)&&(vcount - note_y_5 <= b-1)) || 
                      ((vcount - note_y_6 >= 0)&&(vcount - note_y_6 <= b-1)) || 
                      ((vcount - note_y_7 >= 0)&&(vcount - note_y_7 <= b-1)) || 
                      ((vcount - note_y_8 >= 0)&&(vcount - note_y_8 <= b-1)) || 
                      ((vcount - note_y_9 >= 0)&&(vcount - note_y_9 <= b-1)) || 
                      ((vcount - note_y_10 >= 0)&&(vcount - note_y_10 <= b-1)) || 
                      ((vcount - note_y_11 >= 0)&&(vcount - note_y_11 <= b-1)) || 
                      ((vcount - note_y_12 >= 0)&&(vcount - note_y_12 <= b-1)) || 
                      ((vcount - note_y_13 >= 0)&&(vcount - note_y_13 <= b-1)) || 
                      ((vcount - note_y_14 >= 0)&&(vcount - note_y_14 <= b-1)) || 
                      ((vcount - note_y_15 >= 0)&&(vcount - note_y_15 <= b-1)) || 
                      ((vcount - note_y_16 >= 0)&&(vcount - note_y_16 <= b-1)) || 
                      ((vcount - bg_y >= 0)&&(vcount - bg_y <= a-1))) && page)
                        ||
                         ((((vcount - start_y >= 0)&&(vcount - start_y <= 2*st-1)) ||
                         ((vcount - num_y_0 >= 0)&&(vcount - num_y_0 <= num_width - 1))||
                         ((vcount - num_y_1 >= 0)&&(vcount - num_y_1 <= num_width - 1))||
                         ((vcount - num_y_2 >= 0)&&(vcount - num_y_2 <= num_width - 1))||
                         ((vcount - num_y_3 >= 0)&&(vcount - num_y_3 <= num_width - 1)) )&& !page);//多个note的code
        line_end = hcount >= 1260;
        bg_active  = (hcount >= bg_x && hcount <= bg_x + AA - 1) && page;
        note_active  =  ((hcount >= note_x_1 && hcount <= note_x_1 + BB - 1 && vcount - note_y_1 >= 0 && vcount - note_y_1 <= b-1) || 
                        (hcount >= note_x_2 && hcount <= note_x_2 + BB - 1 && vcount - note_y_2 >= 0 && vcount - note_y_2 <= b-1) || 
                        (hcount >= note_x_3 && hcount <= note_x_3 + BB - 1 && vcount - note_y_3 >= 0 && vcount - note_y_3 <= b-1) || 
                        (hcount >= note_x_4 && hcount <= note_x_4 + BB - 1 && vcount - note_y_4 >= 0 && vcount - note_y_4 <= b-1) ||
                        (hcount >= note_x_5 && hcount <= note_x_5 + BB - 1 && vcount - note_y_5 >= 0 && vcount - note_y_5 <= b-1) || 
                        (hcount >= note_x_6 && hcount <= note_x_6 + BB - 1 && vcount - note_y_6 >= 0 && vcount - note_y_6 <= b-1) || 
                        (hcount >= note_x_7 && hcount <= note_x_7 + BB - 1 && vcount - note_y_7 >= 0 && vcount - note_y_7 <= b-1) || 
                        (hcount >= note_x_8 && hcount <= note_x_8 + BB - 1 && vcount - note_y_8 >= 0 && vcount - note_y_8 <= b-1) ||
                        (hcount >= note_x_9 && hcount <= note_x_9 + BB - 1 && vcount - note_y_9 >= 0 && vcount - note_y_9 <= b-1) || 
                        (hcount >= note_x_10 && hcount <= note_x_10 + BB - 1 && vcount - note_y_10 >= 0 && vcount - note_y_10 <= b-1) || 
                        (hcount >= note_x_11 && hcount <= note_x_11 + BB - 1 && vcount - note_y_11 >= 0 && vcount - note_y_11 <= b-1) || 
                        (hcount >= note_x_12 && hcount <= note_x_12 + BB - 1 && vcount - note_y_12 >= 0 && vcount - note_y_12 <= b-1) ||
                        (hcount >= note_x_13 && hcount <= note_x_13 + BB - 1 && vcount - note_y_13 >= 0 && vcount - note_y_13 <= b-1) || 
                        (hcount >= note_x_14 && hcount <= note_x_14 + BB - 1 && vcount - note_y_14 >= 0 && vcount - note_y_14 <= b-1) || 
                        (hcount >= note_x_15 && hcount <= note_x_15 + BB - 1 && vcount - note_y_15 >= 0 && vcount - note_y_15 <= b-1) || 
                        (hcount >= note_x_16 && hcount <= note_x_16 + BB - 1 && vcount - note_y_16 >= 0 && vcount - note_y_16 <= b-1)) && page;
        frame_finish = hcount == 1255 && vcount == 475;
        indicater_active = (((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_1 >= 0 && vcount - indi_y_1 <= ind-1)&&(indicater1==2||indicater1==3||indicater1==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_2 >= 0 && vcount - indi_y_2 <= ind-1)&&(indicater2==2||indicater2==3||indicater2==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_3 >= 0 && vcount - indi_y_3 <= ind-1)&&(indicater3==2||indicater3==3||indicater3==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_4 >= 0 && vcount - indi_y_4 <= ind-1)&&(indicater4==2||indicater4==3||indicater4==4))) && page;

        mark_active = (((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_1 >= 0 && vcount - hm_y_1 <= hm-1)&&(indicater1==1||indicater1==2||indicater1==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_2 >= 0 && vcount - hm_y_2 <= hm-1)&&(indicater2==1||indicater2==2||indicater2==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_3 >= 0 && vcount - hm_y_3 <= hm-1)&&(indicater3==1||indicater3==2||indicater3==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_4 >= 0 && vcount - hm_y_4 <= hm-1)&&(indicater4==1||indicater4==2||indicater4==3))) && page;

        finalline_active = (hcount >= finalline_x && hcount <= finalline_x + FLL - 1 && vcount - finalline_y >= 0 && vcount - finalline_y <= fl-1) && page;

        start_active = (hcount >= start_x && hcount <= start_x + 2*STA - 1) && !page;
        
        num_active = ((hcount >= num_x && hcount <= num_x + 2*num_height - 1)&&((vcount - num_y_0 >= 0 && vcount - num_y_0 <= num_width - 1)||
                     (vcount - num_y_1 >= 0 && vcount - num_y_1 <= num_width - 1)||(vcount - num_y_2 >= 0 && vcount - num_y_2 <= num_width - 1)||
                     (vcount - num_y_3 >= 0 && vcount - num_y_3 <= num_width - 1)))&& !page;
    end

    always_ff @(posedge clk) begin
        if (rst) begin  // prepare for new line
            state <= IDLE;
            pix_out <= 0;
            drawing <= 0;
            address_bg <= 0;
            address_note <= 0;
            address_start <= 0;
            address_finalline <= 0;
            address_hitind <= 0;
            address_hitmark <= 0;
            address_missind <= 0;
            address_num <= 0;
        end else begin
            case (state)
                IDLE:begin
                    if(line_active)begin
                        state <= WAIT;
                    end else begin
                        state <= IDLE;
                    end
                end
                RESET: begin
                    state <= IDLE;
                    pix_out <= 0;
                    drawing <= 0;
                    address_bg <= 0;
                    address_note <= 0; 
                    address_start <= 0;
                    address_finalline <= 0;
                    address_hitind <= 0;
                    address_hitmark <= 0;
                    address_missind <= 0;
                    address_num <= 0;
                end
                WAIT:begin
                    if(frame_finish) state <= RESET;
                    else begin
                        if(line_end) state <= IDLE;
                        else begin
                            if(note_active) begin
				                state <= DRAW_NOTE;
			                end
                            else if(bg_active)begin
                                state <= DRAW_BG;
                            end
                            if(start_active) begin
                                state <= DRAW_START;
                            end
                            
                        end
                    end
                    pix_out <= 0;
                    drawing <= 0;
                end
                DRAW_START:begin
                    if (!start_active && !num_active) state <= WAIT;
                    else if(num_active) state <= DRAW_NUM;
			        else state <= DRAW_START;
                    address_start = (st - 1 - ((vcount - start_y)>>1)) + (((hcount - start_x)>>2)*st);
                    drawing = 1;
                    pix_out = out_start;

                end
                DRAW_NUM:begin
                    if(!num_active) state <= DRAW_START;
                    else state <= DRAW_NUM;
                    if(vcount - num_y_0 >= 0 && vcount - num_y_0 <= num_width - 1 )begin
                    case(score & 16'h000f)
                     0: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num0;
                        end
                     1: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num1;
                        end
                     2: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num2;
                        end
                     3: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num3;
                        end
                     4: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num4;
                        end
                     5: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num5;
                        end
                     6: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num6;
                        end
                     7: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num7;
                        end
                     8: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num8;
                        end
                     9: begin
                        address_num = (num_width - 1 - (vcount - num_y_0)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num9;
                        end
                    endcase
                    end
                    else if(vcount - num_y_1 >= 0 && vcount - num_y_1 <= num_width - 1)begin
                    case((score&16'h00f0)>>4)
                     0: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num0;
                        end
                     1: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num1;
                        end
                     2: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num2;
                        end
                     3: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num3;
                        end
                     4: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num4;
                        end
                     5: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num5;
                        end
                     6: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num6;
                        end
                     7: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num7;
                        end
                     8: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num8;
                        end
                     9: begin
                        address_num = (num_width - 1 - (vcount - num_y_1)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num9;
                        end
                    endcase
                    end
                    else if(vcount - num_y_2 >= 0 && vcount - num_y_2 <= num_width - 1)begin
                    case((score&16'h0f00)>>8)
                     0: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num0;
                        end
                     1: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num1;
                        end
                     2: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num2;
                        end
                     3: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num3;
                        end
                     4: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num4;
                        end
                     5: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num5;
                        end
                     6: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num6;
                        end
                     7: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num7;
                        end
                     8: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num8;
                        end
                     9: begin
                        address_num = (num_width - 1 - (vcount - num_y_2)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num9;
                        end
                    endcase
                    end
                    else if(vcount - num_y_3 >= 0 && vcount - num_y_3 <= num_width - 1)begin
                    case((score&16'hf000)>>12)
                     0: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num0;
                        end
                     1: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num1;
                        end
                     2: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num2;
                        end
                     3: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num3;
                        end
                     4: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num4;
                        end
                     5: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num5;
                        end
                     6: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num6;
                        end
                     7: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num7;
                        end
                     8: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num8;
                        end
                     9: begin
                        address_num = (num_width - 1 - (vcount - num_y_3)) + (((hcount - num_x)>>1)*num_width);
                        pix_out = out_num9;
                        end
                    endcase
                    end
                    drawing <= 1; 
                end
                DRAW_BG:begin
                    if(finalline_active && !note_active && !mark_active)begin
                        state <= DRAW_FINAL;
                    end
                    else begin
                        if(!indicater_active && !mark_active)begin
                            if(note_active) state <= DRAW_NOTE;
                            else  begin
			                    if (!bg_active) state <= WAIT;
			                    else state <= DRAW_BG;
                            end
                        end
                        else if(indicater_active && !mark_active)begin
                              state <= INDICATER;
                        end
                        else if(!indicater_active && mark_active)begin
                            state <= MARK;
                        end
                    end
                    address_bg = (190 - ((vcount - bg_y)>>1)) + (((hcount - bg_x)>>2)*191);
                    drawing = 1;
                    pix_out = out_bg;
                end
                DRAW_NOTE:begin
                    if(!indicater_active && !mark_active)begin
                        if(!note_active && !finalline_active)begin
                            state <= bg_active ? DRAW_BG : WAIT;
                        end
                        else if(!note_active && finalline_active)begin
                            state <= DRAW_FINAL;
                        end
                        else begin
                             state <= DRAW_NOTE;
                        end
                        // if(!note_active)begin
                        //     state <= bg_active ? DRAW_BG : WAIT;
                        // end
                        // else begin
                        //     state <= DRAW_NOTE;
                        // end
                    end
                    else if(indicater_active && !mark_active)begin
                          state <= INDICATER;
                    end
                    else if(!indicater_active && mark_active)begin
                          state <= MARK;
                    end
                    if(hcount >= note_x_1 && hcount <= note_x_1 + BB - 1 && vcount - note_y_1 >= 0 && vcount - note_y_1 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_1)) + (((hcount - note_x_1)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_2 && hcount <= note_x_2 + BB - 1 && vcount - note_y_2 >= 0 && vcount - note_y_2 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_2)) + (((hcount - note_x_2)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_3 && hcount <= note_x_3 + BB - 1 && vcount - note_y_3 >= 0 && vcount - note_y_3 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_3)) + (((hcount - note_x_3)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_4 && hcount <= note_x_4 + BB - 1 && vcount - note_y_4 >= 0 && vcount - note_y_4 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_4)) + (((hcount - note_x_4)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_5 && hcount <= note_x_5 + BB - 1 && vcount - note_y_5 >= 0 && vcount - note_y_5 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_5)) + (((hcount - note_x_5)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_6 && hcount <= note_x_6 + BB - 1 && vcount - note_y_6 >= 0 && vcount - note_y_6 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_6)) + (((hcount - note_x_6)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_7 && hcount <= note_x_7 + BB - 1 && vcount - note_y_7 >= 0 && vcount - note_y_7 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_7)) + (((hcount - note_x_7)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_8 && hcount <= note_x_8 + BB - 1 && vcount - note_y_8 >= 0 && vcount - note_y_8 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_8)) + (((hcount - note_x_8)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_9 && hcount <= note_x_9 + BB - 1 && vcount - note_y_9 >= 0 && vcount - note_y_9 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_9)) + (((hcount - note_x_9)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_10 && hcount <= note_x_10 + BB - 1 && vcount - note_y_10 >= 0 && vcount - note_y_10 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_10)) + (((hcount - note_x_10)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_11 && hcount <= note_x_11 + BB - 1 && vcount - note_y_11 >= 0 && vcount - note_y_11 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_11)) + (((hcount - note_x_11)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_12 && hcount <= note_x_12 + BB - 1 && vcount - note_y_12 >= 0 && vcount - note_y_12 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_12)) + (((hcount - note_x_12)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_13 && hcount <= note_x_13 + BB - 1 && vcount - note_y_13 >= 0 && vcount - note_y_13 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_13)) + (((hcount - note_x_13)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_14 && hcount <= note_x_14 + BB - 1 && vcount - note_y_14 >= 0 && vcount - note_y_14 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_14)) + (((hcount - note_x_14)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_15 && hcount <= note_x_15 + BB - 1 && vcount - note_y_15 >= 0 && vcount - note_y_15 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_15)) + (((hcount - note_x_15)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_16 && hcount <= note_x_16 + BB - 1 && vcount - note_y_16 >= 0 && vcount - note_y_16 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_16)) + (((hcount - note_x_16)>>1)*b);
                          pix_out = out_note;
                    end
                    drawing = 1;
                end
                INDICATER:begin
                    if(indicater_active)begin
                        state <= INDICATER;
                    end
                    else begin
                        if(note_active)begin
                            state <= DRAW_NOTE;
                        end
                        else state <= DRAW_BG;
                    end
                    if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_1 >= 0 && vcount - indi_y_1 <= ind-1)begin
                        if(indicater1==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_1)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_1)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_2 >= 0 && vcount - indi_y_2 <= ind-1)begin
                        if(indicater2==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_2)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_2)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_3 >= 0 && vcount - indi_y_3 <= ind-1)begin
                        if(indicater3==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_3)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_3)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_4 >= 0 && vcount - indi_y_4 <= ind-1)begin
                        if(indicater4==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_4)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_4)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    drawing = 1;
                end
                MARK:begin
                    if(mark_active)begin
                        state <= MARK;
                    end
                    else begin
                        if(note_active)begin
                            state <= DRAW_NOTE;
                        end
                        else if(!note_active && finalline_active)begin
                            state <= DRAW_FINAL;
                        end
                        else state <= DRAW_BG;
                    end
                    if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_1 >= 0 && vcount - hm_y_1 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_1)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_2 >= 0 && vcount - hm_y_2 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_2)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_3 >= 0 && vcount - hm_y_3 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_3)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_4 >= 0 && vcount - hm_y_4 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_4)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    drawing = 1;
                end

                DRAW_FINAL:begin
                    if(!note_active && !mark_active && finalline_active)begin
                        state <= DRAW_FINAL;
                    end
                    else if(note_active && !mark_active)begin
                        state <= DRAW_NOTE;
                    end
                    else if(mark_active)begin
                        state <= MARK;
                    end
                    else state <= DRAW_BG;
                    address_finalline = (fl - 1 - (vcount - finalline_y)) + (((hcount - finalline_x)>>1)*fl);
                    drawing = 1;
                    pix_out = out_finalline;
                end
                default: state <= IDLE;
            endcase
        end
    end

endmodule
