# DE1-SoC-MyPlayer

The project aims to make DE1-SoC board a music player, which can play music from an SD card using the onboard WM8731 chip.

For more detailed information,  check [FPGA 开发笔记：DE1-SoC 音乐播放器的实现 - Nativus' Space (naiv.fun)](https://naiv.fun/hardware/57.html)(in Chinese | 中文文档).

## Requirement

Tested on the following platform/software:

* Quartus Prime 18.0 on Windows 10
* Intel SoC FPGA Embedded Development Suite Standard 18.0 on Windows 10
* Ubuntu 14.04 LTS for DE1-SoC provided by Terasic's website
* FFmpeg

Before you give these codes a try, make sure you have the operating system and all the software installed correctly. Besides, please refer to DE1-SoC User Manual for setting up board to run Linux.

## Hardware

To build sof file:

1. Open the `soc_system.qpf` with Quartus.
2. Click `Compile Design` to build sof file.
3. Use Programmer in Quartus to program the FPGA.

Note: if any change is made to Qsys design, the C header file must be regenerated. The software should also be re-compiled with the newly generated header so that it can work properly. 

## Software

The hardware part only establishes a base to play sounds with DE1-SoC, and the software is here to process the music data and configure the SoC to play correctly.

To build and run the software:

1. Open the SoC EDS Command Shell.
2. Change directory to the `software` folder, for example, `cd ~/DE1-SoC-MyPlayer/software`.
3. Type `make clean` to remove files generated by earlier builds, then type `make`.
4. If the building is successful,  you can find `MyPlayer` binary file in the folder. Download it to the board.
5. Use `chmod +x ./MyPlayer` on board to give the binary permission to execute.
6. Type `./Myplayer filename` to run the program. `filename` should be replaced with your own music filename.

## Known Bugs

These codes still contain minor unresolved bugs, such as having noise when playing some music with a specific frequency.

## Credits

Cited resources:

* Terasic VIP Demo：[Terasic - DE Boards - Cyclone - DE1-SoC Board](https://www.terasic.com.tw/cgi-bin/page/archive.pl?Language=English&CategoryNo=165&No=836&PartNo=5)
* [bsteinsbo/DE1-SoC-Sound (github.com)](https://github.com/bsteinsbo/DE1-SoC-Sound)
* [ffxx283/WM8731_Audio: FPGA Control WM8731 Audio codec (github.com)](https://github.com/ffxx283/WM8731_Audio)

And special thanks to my two workmates on this project.
