#include <stdio.h>
#include "cam_vga.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#define READ_PIXELS 640*480

int main()
{
	static const char filename[] = "/dev/cam_vga";

	int vga_ball_fd;
	char info;

	if ((vga_ball_fd = open(filename, O_RDWR)) == -1) {
		fprintf(stderr, "could not open %s\n", filename);
		return -1;
	}

	while(1){
	
		if (ioctl(vga_ball_fd, cam_vga_READ_INFO, &info)) {
				perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
				return -1;
		}

		printf("%c\n", info);
	}
}	
