module clk_div(
	input logic 	clk_ref,
	output logic 	clk_out);
	
	
	//
	reg [27:0] 	counter = 28'd0;
	parameter 	DIV 	= 28'd2;
	
	always @(posedge clk_ref)
		begin
			counter <= counter + 28'd1;
			if (counter >= (DIV - 1))
				counter <= 28'd0;
			clk_out <= (counter < DIV/2) ? 1'b1 : 1'b0;
		end
endmodule
