//  THIS IS THE SERVER SIDE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "cam_data.h"


#define SERVER_HOST "128.59.19.114" //Placeholder IP Address
#define SERVER_PORT 42000           //PLaceholder Port

#define BUFFER_SIZE 640*480 + 1

int cam_fd;


/* Set the background color */
void set_pixel(const cam_data_pixel_t *p)
{
  cam_data_arg_t vla;
  vla.pixel = *p;
  if (ioctl(cam_fd, CAM_DATA_WRITE_PIXEL, &vla)) {
      perror("ioctl(CAM_DATA_WRITE_PIXEL) failed");
      return;
  }


}

int main(void){
    int sockfd; /* Socket file descriptor */
    struct sockaddr_in server_addr, client_addr;
    cam_data_pixel_t buffer[BUFFER_SIZE];
 		
		if ( (cam_fd = open("/dev/cam_data", O_RDWR)) == -1) {
    	fprintf(stderr, "could not open /dev/cam_data \n");
    	return -1;
 		 }   
    
    // Create UDP socket:
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) {
		perror("socket creation failed");
		exit(EXIT_FAILURE);
	}
    //sockfd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    printf("Socket created successfully\n");

    memset(&server_addr, 0, sizeof(server_addr));
    memset(&client_addr, 0, sizeof(client_addr));
    
    // Set port and IP:
    server_addr.sin_family = AF_INET; // IPv4
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = INADDR_ANY;
    //server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    
    // Bind to the set port and IP:
    if(bind(sockfd, (const struct sockaddr*)&server_addr, sizeof(server_addr)) < 0){
        perror("bind failed");
		exit(EXIT_FAILURE);
    }
    printf("Done with binding\n");
    
    printf("Listening for incoming messages...\n\n");
    
    // Receive client's message:
    int client_length, n;
    int counter = 0;
    //int total_recieved = 0;

    while(1)
    {
        client_length = sizeof(client_addr);
	if (counter > BUFFER_SIZE){
		counter = 0;	
		//Write buffer into block
		//Use drivers
		cam_data_pixel_t temp[32];
		for(int i = 0; i < (640*480)/4; i++){
			int start_index = 32*i;
    			int end_index = 31+32*i;
    			//Go thru range
			int temp_index = 0;
    			for (int j = start_index; j < end_index; j++) {
				temp[temp_index] = buffer[j];
				temp_index++;
        			
    			}
			set_pixel(temp);
		}
	}
        n = recvfrom(sockfd, buffer + counter, sizeof(buffer) - counter, 0, 
        (struct sockaddr*)&client_addr, &client_length);
	counter += n;
	
	

        printf("Received frame from IP: %s and port: %i\n",
           inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));

        // decode video and display frame
        /*
            TODO
        */
    }

    return 0;
}
