#ifndef _HUARONGDAO_H
#define _HUARONGDAO_H

#include <linux/ioctl.h>

typedef struct {
    unsigned char x;
    unsigned char y;
} location_t;

typedef struct {
  unsigned char block_id;
  int type; // 0: Empty, 1: Normal Block, 2: Target Block
  location_t location;
} block_t;

typedef struct {
  location_t cursor_loc;
  location_t selected; // set to 4,4 if none gets selected
  unsigned char win;
  block_t blocks[15];
} vga_ball_arg_t;

#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_BALL_WRITE_BACKGROUND _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_READ_BACKGROUND  _IOR(VGA_BALL_MAGIC, 2, vga_ball_arg_t *)

#endif
