#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "usbgamepad.h"
#include <stdint.h>
#include <stdbool.h>
#include "gamelogic.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

struct libusb_device_handle *gamepad;
uint8_t endpoint_address;

block_t create_block(int id)
{
    block_t b;
    b.block_id = id;
    b.type = 1;
    return b;
};
vga_ball_arg_t vla;
int vga_ball_fd;
int init;
char filename[] = "/dev/vga_ball";
unsigned char win;
void write2hw(vga_ball_arg_t vla)
{
    if (!init)
    {
        if ((vga_ball_fd = open(filename, O_RDWR)) == -1)
        {
            fprintf(stderr, "could not open %s\n", filename);
            return;
        }
        init = 1;
    }

    if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla))
    {
        perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
        return;
    }
}

bool cursor_moving(block_t arr[4][4], location_t location, int direction);
bool block_moving(block_t arr[4][4], location_t location, int direction);
void block_to_string(block_t arr[4][4], location_t cursor_location);
void write_hw(block_t arr[4][4],
              location_t location, location_t selected_loc);
bool arrays_are_equal(block_t arr1[4][4], block_t arr2[4][4])
{
    for (int i = 0; i < 4; i++)
    {
        for (int j = 0; j < 4; j++)
        {
            if (arr1[i][j].block_id != arr2[i][j].block_id)
            {
                return false;
            }
        }
    }
    return true;
}

int main()
{
    int err, col;
    
    struct sockaddr_in serv_addr;

    int transferred;
    // char keystate[12];
    char msg[128];
    memset(msg, 0, 128);

    /* Open the keyboard */
    if ((gamepad = open_gamepad(&endpoint_address)) == NULL)
    {
        fprintf(stderr, "Did not find a keyboard\n");
        exit(1);
    }

    // init() the game state
    // object: move the block to top right corner

    // level one: 15 blocks,target one block under on the right corner

    // we will have a blocks.c file to deal with block moving solely
    // for game logic, please implement in this file!

    // declare variables
    bool selected_block;
    int selected_block_id;
    location_t cursor_location, selected_loc;
    block_t block0;
    block_t block1;
    block_t block2;
    block_t block3;
    block_t block4;
    block_t block5;
    block_t block6;
    block_t block7;
    block_t block8;
    block_t block9;
    block_t block10;
    block_t block11;
    block_t block12;
    block_t block13;
    block_t block14;
    block_t block15;
    win = 0;
    // initialize variables
    selected_block = false;
    selected_block_id = 0;
    cursor_location.x = 0;
    cursor_location.y = 0;
    selected_loc.x = 4;
    selected_loc.y = 4;
    block0 = create_block(0);
    block1 = create_block(1);
    block2 = create_block(2);
    block3 = create_block(3);
    block4 = create_block(4);
    block5 = create_block(5);
    block6 = create_block(6);
    block7 = create_block(7);
    block8 = create_block(8);
    block9 = create_block(9);
    block10 = create_block(10);
    block11 = create_block(11);
    block12 = create_block(12);
    block13 = create_block(13);
    block14 = create_block(14);
    block15 = create_block(15);
    block0.type = 0;
    block1.type = 2;
    // initialize block array
    
    
    // block_t init_arr[16] = {block0, block1, block2, block3, block4, block5, block6, block7, block8, block9, block10, block11, block12, block13, block14, block15};
    // set winning array
    block_t arr[4][4] = {
        {block1, block2, block3, block4},
        {block5, block6, block7, block8},
        {block9, block10, block11, block12},
        {block13, block14, block0, block15}};
    for (int i = 0; i < 4; i++)
                    {
                        for (int j = 0; j < 4; j++)
                            {
                                arr[i][j].location.x = j;
                                arr[i][j].location.y = i;
                            }
                    }

    
    
    block_t winning_arr[4][4] = {
        {block1, block2, block3, block4},
        {block5, block6, block7, block8},
        {block9, block10, block11, block12},
        {block13, block14, block15, block0}};

    // random shuffle block array
    
    // produce a set of array
    // 
    
    

    // DISPLAY THE CURRENT GAMESPACE

    write_hw(arr, cursor_location, selected_loc);
    
    bool game_end = 0;

    /* Look for and handle keypresses */
    for (;;)
    {
        uint8_t data[8];
        int actual_length;
        int r = libusb_interrupt_transfer(gamepad, endpoint_address, data, sizeof(data), &actual_length, 0);
        
        if (r == 0 && actual_length == sizeof(data))
        {
            // Get pressed key
            uint8_t buttons = data[4];

            // Sleep for 50 ms to avoid flooding the console with messages
            // usleep(500);

            // read game states:
            // int

            // game logic to handle block interaction based on the gamepad usage

            // left 6, right 2, up 0, down 4, A 40, B 72, X 24, Y 136

            if (buttons == 6 && game_end == 0)
            {
                // printf("this is the left arrow button\n");
                if (selected_block == false)
                {
                    // TODO
                    // cannot move to empty space
                    selected_loc.x = 4;
                    selected_loc.y = 4;
                    printf("move the cursor to the left\n");
                    if (cursor_moving(arr, cursor_location, 1))
                    {
                        cursor_location.x -= 1;
                        vla.cursor_loc.x = cursor_location.x;
                        write_hw(arr, cursor_location, selected_loc);
                        block_to_string(arr, cursor_location);
                    }
                }
                if (selected_block == true)
                {
                    // TODO
                    // need to verify the blocks movability
                    write_hw(arr, cursor_location, cursor_location);
                    // printf("move the block to the left\n");
                    if (block_moving(arr, cursor_location, 1))
                    {
                        block_t blk1 = arr[cursor_location.y][cursor_location.x];
                        block_t blk2 = arr[cursor_location.y][cursor_location.x - 1];
			            blk1.location.x--;
                        arr[cursor_location.y][cursor_location.x] = blk2;
                        arr[cursor_location.y][cursor_location.x - 1] = blk1;

                        cursor_location.x -= 1;

                        write_hw(arr, cursor_location, cursor_location);
                 
                        block_to_string(arr, cursor_location);
                        if (arrays_are_equal(arr, winning_arr))
                        {
                            game_end =1;
                            win =1;
                            write_hw(arr, cursor_location, cursor_location);
                            // break;
                        } 
                    }
                }
            }
            else if (buttons == 2 && game_end == 0)
            {
                printf("this is the right arrow button\n");

                if (selected_block == false)
                {
                    // TODO
                    // cannot move to empty space
                    selected_loc.x = 4;
                    selected_loc.y = 4;
                    // printf("move the cursor to the right\n");
                    if (cursor_moving(arr, cursor_location, 3))
                    {
                        cursor_location.x += 1;
                        vla.cursor_loc.x = cursor_location.x;
                        write_hw(arr, cursor_location, selected_loc);
                        block_to_string(arr, cursor_location);
                    }
                }
                if (selected_block == true)
                {
                    // TODO
                    // need to verify the blocks movability
                    write_hw(arr, cursor_location, cursor_location);
                    printf("move the block to the right\n");
                    if (block_moving(arr, cursor_location, 3))
                    {
                        block_t blk1 = arr[cursor_location.y][cursor_location.x];
                        block_t blk2 = arr[cursor_location.y][cursor_location.x + 1];
                        blk1.location.x++;
			arr[cursor_location.y][cursor_location.x] = blk2;
                        arr[cursor_location.y][cursor_location.x + 1] = blk1;
			cursor_location.x += 1;

                        write_hw(arr, cursor_location, cursor_location);
                        block_to_string(arr, cursor_location);
                        if (arrays_are_equal(arr, winning_arr))
                            {
                                game_end =1;
                                win =1;
                                write_hw(arr, cursor_location, cursor_location);
                            } 
                    }
                }
            }
            else if (buttons == 0 && game_end == 0)
            {
                printf("this is the up arrow button\n");
                if (selected_block == false)
                {
                    // TODO
                    // cannot move to empty space

                    // printf("move the cursor to the up\n");
                    if (cursor_moving(arr, cursor_location, 2))
                    {
                        cursor_location.y -= 1;
                        vla.cursor_loc.y = cursor_location.y;
                        write_hw(arr, cursor_location, selected_loc);
                        block_to_string(arr, cursor_location);
                    }
                }
                if (selected_block == true)
                {
                    // TODO
                    // need to verify the blocks movability

                    // printf("move the block to the up\n");
                    write_hw(arr, cursor_location, cursor_location);
                    if (block_moving(arr, cursor_location, 2))
                    {
                        block_t blk1 = arr[cursor_location.y][cursor_location.x];
                        block_t blk2 = arr[cursor_location.y - 1][cursor_location.x];
                        blk1.location.y--;
			            arr[cursor_location.y][cursor_location.x] = blk2;
                        arr[cursor_location.y - 1][cursor_location.x] = blk1;

			            cursor_location.y -= 1;

                        write_hw(arr, cursor_location, cursor_location);
                        block_to_string(arr, cursor_location);
                        if (arrays_are_equal(arr, winning_arr))
                        {
                            game_end =1;
                            win =1;
                            write_hw(arr, cursor_location, cursor_location);

                        }
                    }
                }
            }
            else if (buttons == 4 && game_end == 0)
            {
                printf("this is the down arrow button\n");
                if (selected_block == false)
                {
                    // TODO
                    // cannot move to empty space
                    write_hw(arr, cursor_location, selected_loc);
                    // printf("move the cursor to the down\n");
                    if (cursor_moving(arr, cursor_location, 4))
                    {
                        cursor_location.y += 1;
                        vla.cursor_loc.y = cursor_location.y;
                        write_hw(arr, cursor_location, selected_loc);
                        block_to_string(arr, cursor_location);
                    }
                }
                if (selected_block == true)
                {
                    // TODO
                    // need to verify the blocks movability
                    write_hw(arr, cursor_location, cursor_location);
                    // printf("move the block to the down\n");
                    if (block_moving(arr, cursor_location, 4))
                    {
                        block_t blk1 = arr[cursor_location.y][cursor_location.x];
                        block_t blk2 = arr[cursor_location.y + 1][cursor_location.x];
                        blk1.location.y++;
			arr[cursor_location.y][cursor_location.x] = blk2;
                        arr[cursor_location.y + 1][cursor_location.x] = blk1;
			cursor_location.y += 1;

                        write_hw(arr, cursor_location, cursor_location);
                        block_to_string(arr, cursor_location);
                        if (arrays_are_equal(arr, winning_arr))
                        {
                            game_end =1;
                            win =1;
                            write_hw(arr, cursor_location, cursor_location);
                        }
                    }
                }
            }
            else if (buttons == 40 && game_end == 0)
            {
                // printf("this is the A button\n");
                if (selected_block == false)
                {
                    selected_block = true;
                    write_hw(arr, cursor_location, cursor_location);
                    printf("select the current block\n");
                    block_to_string(arr, cursor_location);
                }
                else if (selected_block == true)
                {
                    selected_block = false;
                    write_hw(arr, cursor_location, selected_loc);
                    printf("un-select the block\n");
                    block_to_string(arr, cursor_location);
                }
            }
            else if (buttons == 72)
            {
                printf("this is the B button\n");
            }
            else if (buttons == 24)
            {
                block_to_string(arr, cursor_location);
            }
            else if (buttons == 136)
                
            {
                printf("this is the Y button\n");
                win = 0;
                
                game_end = 0;
                
                size_t i;
                srand(time(NULL));
                block_t init_arr[16] = {block0, block1, block2, block3, block4, block5, block6, block7, block8, block9, block10, block11, block12, block13, block14, block15};
                for (i = 0; i < 16; i++)
                    {
                        size_t j = i + rand() / (RAND_MAX / (16 - i) + 1);
                        
                        block_t t = init_arr[j];
                        init_arr[j] = init_arr[i];
                        init_arr[i] = t;
                    }
                for (int i = 0; i < 4; i++)
                    {
                        for (int j = 0; j < 4; j++)
                            {
                                arr[i][j] = init_arr[i * 4 + j];
                                arr[i][j].location.x = j;
                                arr[i][j].location.y = i;
                            }
                    }
                selected_block = false;
                write_hw(arr, cursor_location, selected_loc);

                
            }
        }
    }

    return 0;
}

block_t *blockat(block_t blocks[4][4], int id)
{
    int i, j;
    block_t *b;

    for (i = 0; i < 4; i++)
    {
        for (j = 0; j < 4; j++)
        {
            if (blocks[i][j].block_id == id)
            {
                printf("1\n");
                b = &blocks[i][j];
                return b;
            }
        }
    }
    return b;
}

void write_hw(block_t arr[4][4], location_t location, location_t selected_loc)
{
    int i, id;
    block_t *block;
    for (id = 1; id < 16; id++)
    {
        block = blockat(arr, id);
        vla.blocks[id - 1].block_id = id;
        vla.blocks[id - 1].location.x = block->location.x;
        vla.blocks[id - 1].location.y = block->location.y;
    }
    vla.selected.x = selected_loc.x;
    vla.selected.y = selected_loc.y;
    vla.win = win;
    vla.cursor_loc.x = location.x;
    vla.cursor_loc.y = location.y;

    for (i = 0; i < 15; i++)
    {
        printf("block [%hu]-x: %hu, y: %hu\n",
               vla.blocks[i].block_id, vla.blocks[i].location.x, vla.blocks[i].location.y);
    }
    printf("cursor (%hu, %hu)\n", vla.cursor_loc.x, vla.cursor_loc.y);
    write2hw(vla);
}

bool cursor_moving(block_t arr[4][4], location_t location, int direction)
{
    if (direction == 1)
    { // left
        if (location.x == 0)
        {
            return false;
        }
        else if (arr[location.y][location.x - 1].type == 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
    else if (direction == 2)
    { // up
        if (location.y == 0)
        {
            return false;
        }
        else if (arr[location.y - 1][location.x].type == 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
    else if (direction == 3)
    { // right
        if (location.x == 3)
        {
            return false;
        }
        else if (arr[location.y][location.x + 1].type == 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
    else
    { // down
        if (location.y == 3)
        {
            return false;
        }
        else if (arr[location.y + 1][location.x].type == 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
}

bool block_moving(block_t arr[4][4], location_t location, int direction)
{
    if (direction == 1)
    { // left
        if (location.x == 0)
        {
            return false;
        }
        else if (arr[location.y][location.x - 1].type != 0)
        {
            return false;
        }
        else
        {
		return true;
        }
    }
    else if (direction == 2)
    { // up
        if (location.y == 0)
        {
            return false;
        }
        else if (arr[location.y - 1][location.x].type != 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
    else if (direction == 3)
    { // right
        if (location.x == 3)
        {
            return false;
        }
        else if (arr[location.y][location.x + 1].type != 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
    else
    { // down
        if (location.y == 3)
        {
            return false;
        }
        else if (arr[location.y + 1][location.x].type != 0)
        {
            return false;
        }
        else
        {
	      return true;
        }
    }
}

void block_to_string(block_t arr[4][4], location_t cursor_location)
{
    printf("cursor: %d, %d\n", cursor_location.x, cursor_location.y);
    for (int i = 0; i < 4; i++)
    {
        for (int j = 0; j < 4; j++)
        {
            if (arr[i][j].type == 0)
            {
                printf(" \t");
            }
            else
            {
                if (cursor_location.x == j && cursor_location.y == i)
                {
                    printf("%d*\t", arr[i][j].block_id);
                }
                else
                {
                    printf("%d\t", arr[i][j].block_id);
                }
            }
            // else if (arr[i][j].type == 1) {
            //     printf("%d\t", arr[i][j].block_id);
            //     // printf("X");
            // }
        }
        printf("\n");
    }
}
// return new array
// void shuffle_and_fill(block_t *init_arr, size_t len, block_t arr[][4])
// {
//     size_t i;
//     srand(time(NULL));
//     for (i = 0; i < len; i++)
//         {
//             size_t j = i + rand() / (RAND_MAX / (len - i) + 1);
            
//             block_t t = init_arr[j];
//             init_arr[j] = init_arr[i];
//             init_arr[i] = t;
//         }
    
//     for (int i = 0; i < 4; i++)
//         {
//             for (int j = 0; j < 4; j++)
//                 {
//                     arr[i][j] = init_arr[i * 4 + j];
//                     arr[i][j].location.x = j;
//                     arr[i][j].location.y = i;
//                 }
//         }
// } 
