/*
* Avalon memory-mapped peripheral that generates VGA
*
* Stephen A. Edwards
* Columbia University
*/

module vga_ball(input logic        clk,
          input logic 	   reset,
    input logic [31:0]  writedata,
    input logic 	   write,
    input 		   chipselect,
    input logic [4:0]  address,

    output logic [7:0] VGA_R, VGA_G, VGA_B,
    output logic 	   VGA_CLK, VGA_HS, VGA_VS,
                      VGA_BLANK_n,
    output logic 	   VGA_SYNC_n);

  logic [10:0]	   hcount;
  logic [9:0]     vcount;

  logic [7:0] 	   background_r, background_g, background_b;

  logic [9:0]     x1, y1;
  logic [9:0]     x2, y2;
  logic [9:0]     x3, y3;
  logic [9:0]     x4, y4;
  logic [9:0]     x5, y5;
  logic [9:0]     x6, y6;
  logic [9:0]     x7, y7;
  logic [9:0]     x8, y8;
  logic [9:0]     x9, y9;
  logic [9:0]     x10, y10;
  logic [9:0]     x11, y11;
  logic [9:0]     x12, y12;
  logic [9:0]     x13, y13;
  logic [9:0]     x14, y14;
  logic [9:0]     x15, y15;
  logic [9:0]     cursor_x, cursor_y;
  logic [9:0]     width;
  logic [9:0]     selected_x, selected_y;
  logic           win;
  vga_counters counters(.clk50(clk), .*);
  logic [23:0]     face_out;
  face f1(hcount[10:1] - 119 + (vcount - 119) * 240, clk, face_out);

  always_ff @(posedge clk)
    if (reset) begin
  width = 10'h5;
  background_r <= 8'h0;
  background_g <= 8'h0;
  background_b <= 8'h0;
  x1 <= 10'h0;
  y1 <= 10'h0;
  x2 <= 10'h78; // 120
  y2 <= 10'h0;
  x3 <= 10'hf0; // 240
  y3 <= 10'h0;
  x4 <= 10'h0;
  y4 <= 10'h78; // 120
  x5 <= 10'h78;
  y5 <= 10'h78;
  x6 <= 10'hf0;
  y6 <= 10'h78;
  x7 <= 10'h168; // 360
  y7 <= 10'h78;
  x8 <= 10'h0;
  y8 <= 10'hf0;
  x9 <= 10'h78;
  y9 <= 10'hf0;
  x10 <= 10'hf0;
  y10 <= 10'hf0;
  x11 <= 10'h168;
  y11 <= 10'hf0;
  x12 <= 10'h00;
  y12 <= 10'h168;
  x13 <= 10'h78;
  y13 <= 10'h168;
  x14 <= 10'hf0;
  y14 <= 10'h168;
  x15 <= 10'h168;
  y15 <= 10'h168;
  cursor_x <= 10'h0;
  cursor_y <= 10'h0;
  selected_x = 10'h4;
  selected_y = 10'h4;
  win <= 1'b0;
    end else if (chipselect && write)
      case (address)
  5'h00 : begin
    x1 <= {1'b0, writedata[31:28] * 120};  
    y1 <= {1'b0, writedata[27:24] * 120};
    x2 <= {1'b0, writedata[23:20] * 120};
    y2 <= {1'b0, writedata[19:16] * 120};
  
    x3 <= {1'b0, writedata[15:12] * 120};
    y3 <= {1'b0, writedata[11:8] * 120};
    x4 <= {1'b0, writedata[7:4] * 120};
    y4 <= {1'b0, writedata[3:0] * 120};
  end
  5'h01 : begin
    x5 <= {1'b0, writedata[31:28] * 120};
    y5 <= {1'b0, writedata[27:24] * 120};
    x6 <= {1'b0, writedata[23:20] * 120};
    y6 <= {1'b0, writedata[19:16] * 120};

    x7 <= {1'b0, writedata[15:12] * 120};
    y7 <= {1'b0, writedata[11:8] * 120}; 
    x8 <= {1'b0, writedata[7:4] * 120};
    y8 <= {1'b0, writedata[3:0] * 120};
  end
  5'h02 : begin 
    x9 <= {1'b0, writedata[31:28] * 120};
    y9 <= {1'b0, writedata[27:24] * 120};
    x10 <= {1'b0, writedata[23:20] * 120};
    y10 <= {1'b0, writedata[19:16] * 120};
  
    x11 <= {1'b0, writedata[15:12] * 120};
    y11 <= {1'b0, writedata[11:8] * 120};
    x12 <= {1'b0, writedata[7:4] * 120};  
    y12 <= {1'b0, writedata[3:0] * 120};
  end
  3'h03 : begin 
    x13 <= {1'b0, writedata[31:28] * 120};
    y13 <= {1'b0, writedata[27:24] * 120};
    x14 <= {1'b0, writedata[23:20] * 120};
    y14 <= {1'b0, writedata[19:16] * 120};

    x15 <= {1'b0, writedata[15:12] * 120};
    y15 <= {1'b0, writedata[11:8] * 120};
    cursor_x <= {1'b0, writedata[7:4] * 120};
    cursor_y <= {1'b0, writedata[3:0] * 120};
  end
  3'h04 : begin
    selected_x <= {1'b0, writedata[15:12]};
    selected_y <= {1'b0, writedata[11:8]};
    win <= writedata[0];
  end
      endcase

  always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      if (VGA_BLANK_n )
  if (hcount[10:1] >= 0 && hcount[10:1] < 480) begin
    if (hcount[10:1] >= x1 + 71 && hcount[10:1] < x1 + 71 + width && vcount >= y1 + 35 && vcount < y1 + 83 + width || // 1
        hcount[10:1] >= x2 + 47 && hcount[10:1] < x2 + 71 + width && 
        (vcount >= y2 + 35 && vcount < y2 + 35 + width ||
        vcount >= y2 + 59 && vcount < y2 + 59 + width ||
        vcount >= y2 + 83 && vcount < y2 + 83 + width) ||
        hcount[10:1] >= x2 + 71 && hcount[10:1] < x2 + 71 + width && vcount >= y2 + 35 && vcount < y2 + 59 + width||
        hcount[10:1] >= x2 + 47 && hcount[10:1] < x2 + 47 + width && vcount >= y2 + 59 && vcount < y2 + 83 + width|| // 2
        hcount[10:1] >= x3 + 47 && hcount[10:1] < x3 + 71 + width && 
        (vcount >= y3 + 35 && vcount < y3 + 35 + width ||
        vcount >= y3 + 59 && vcount < y3 + 59 + width ||
        vcount >= y3 + 83 && vcount < y3 + 83 + width) ||
        hcount[10:1] >= x3 + 71 && hcount[10:1] < x3 + 71 + width && vcount >= y3 + 35 && vcount < y3 + 83 + width|| // 3
        hcount[10:1] >= x4 + 47 && hcount[10:1] < x4 + 71 + width && vcount >= y4 + 59 && vcount < y4 + 59 + width ||
        hcount[10:1] >= x4 + 47 && hcount[10:1] < x4 + 47 + width && vcount >= y4 + 35 && vcount < y4 + 59 + width||
        hcount[10:1] >= x4 + 71 && hcount[10:1] < x4 + 71 + width && vcount >= y4 + 35 && vcount < y4 + 83 + width|| // 4
        hcount[10:1] >= x5 + 47 && hcount[10:1] < x5 + 71 + width && 
        (vcount >= y5 + 35 && vcount < y5 + 35 + width ||
        vcount >= y5 + 59 && vcount < y5 + 59 + width ||
        vcount >= y5 + 83 && vcount < y5 + 83 + width) ||
        hcount[10:1] >= x5 + 71 && hcount[10:1] < x5 + 71 + width && vcount >= y5 + 59 && vcount < y5 + 83 + width ||
        hcount[10:1] >= x5 + 47 && hcount[10:1] < x5 + 47 + width && vcount >= y5 + 35 && vcount < y5 + 59 + width || // 5
        hcount[10:1] >= x6 + 47 && hcount[10:1] < x6 + 71 + width && 
        (vcount >= y6 + 35 && vcount < y6 + 35 + width ||
        vcount >= y6 + 59 && vcount < y6 + 59 + width ||
        vcount >= y6 + 83 && vcount < y6 + 83 + width) ||
        hcount[10:1] >= x6 + 71 && hcount[10:1] < x6 + 71 + width && vcount >= y6 + 59 && vcount < y6 + 83 + width ||
        hcount[10:1] >= x6 + 47 && hcount[10:1] < x6 + 47 + width && vcount >= y6 + 35 && vcount < y6 + 83 + width || // 6
        hcount[10:1] >= x7 + 47 && hcount[10:1] < x7 + 71 + width && vcount >= y7 + 35 && vcount < y7 + 35 + width ||
        hcount[10:1] >= x7 + 71 && hcount[10:1] < x7 + 71 + width && vcount >= y7 + 35 && vcount < y7 + 83 + width || // 7
        hcount[10:1] >= x8 + 47 && hcount[10:1] < x8 + 71 &&
        (vcount >= y8 + 35 && vcount < y8 + 35 + width ||
        vcount >= y8 + 59 && vcount < y8 + 59 + width ||
        vcount >= y8 + 83 && vcount < y8 + 83 + width) ||
        hcount[10:1] >= x8 + 47 && hcount[10:1] < x8 + 47 + width && vcount >= y8 + 35 && vcount < y8 + 83 + width ||
        hcount[10:1] >= x8 + 71 && hcount[10:1] < x8 + 71 + width && vcount >= y8 + 35 && vcount < y8 + 83 + width || // 8
        hcount[10:1] >= x9 + 47 && hcount[10:1] < x9 + 71 + width && 
        (vcount >= y9 + 35 && vcount < y9 + 35 + width ||
        vcount >= y9 + 59 && vcount < y9 + 59 + width ||
        vcount >= y9 + 83 && vcount < y9 + 83 + width) ||
        hcount[10:1] >= x9 + 47 && hcount[10:1] < x9 + 47 + width && vcount >= y9 + 35 && vcount < y9 + 59 + width ||
        hcount[10:1] >= x9 + 71 && hcount[10:1] < x9 + 71 + width && vcount >= y9 + 35 && vcount < y9 + 83 + width || // 9
        hcount[10:1] >= x10 + 47 && hcount[10:1] < x10 + 47 + width && vcount >= y10 + 35 && vcount < y10 + 83 + width ||
        hcount[10:1] >= x10 + 71 && hcount[10:1] < x10 + 95 + width &&
        (vcount >= y10 + 35 && vcount < y10 + 35 + width ||
        vcount >= y10 + 83 && vcount < y10 + 83 + width) ||
        hcount[10:1] >= x10 + 71 && hcount[10:1] < x10 + 71 + width && vcount >= y10 + 35 && vcount < y10 + 83 + width ||
        hcount[10:1] >= x10 + 95 && hcount[10:1] < x10 + 95 + width && vcount >= y10 + 35 && vcount < y10 + 83 + width || // 10
        hcount[10:1] >= x11 + 47 && hcount[10:1] < x11 + 47 + width && vcount >= y11 + 35 && vcount < y11 + 83 + width ||
        hcount[10:1] >= x11 + 95 && hcount[10:1] < x11 + 95 + width && vcount >= y11 + 35 && vcount < y11 + 83 + width || // 11
        hcount[10:1] >= x12 + 47 && hcount[10:1] < x12 + 47 + width && vcount >= y12 + 35 && vcount < y12 + 83 + width ||
        hcount[10:1] >= x12 + 71 && hcount[10:1] < x12 + 95 + width && 
        (vcount >= y12 + 35 && vcount < y12 + 35 + width ||
        vcount >= y12 + 59 && vcount < y12 + 59 + width ||
        vcount >= y12 + 83 && vcount < y12 + 83 + width) ||
        hcount[10:1] >= x12 + 95 && hcount[10:1] < x12 + 95 + width && vcount >= y12 + 35 && vcount < y12 + 59 + width ||
        hcount[10:1] >= x12 + 71 && hcount[10:1] < x12 + 71 + width && vcount >= y12 + 59 && vcount < y12 + 83 + width || // 12
        hcount[10:1] >= x13 + 47 && hcount[10:1] < x13 + 47 + width && vcount >= y13 + 35 && vcount < y13 + 83 + width ||
        hcount[10:1] >= x13 + 71 && hcount[10:1] < x13 + 95 && 
        (vcount >= y13 + 35 && vcount < y13 + 35 + width ||
        vcount >= y13 + 59 && vcount < y13 + 59 + width ||
        vcount >= y13 + 83 && vcount < y13 + 83 + width) ||
        hcount[10:1] >= x13 + 95 && hcount[10:1] < x13 + 95 + width && vcount >= y13 + 35 && vcount < y13 + 83 + width || // 13
        hcount[10:1] >= x14 + 47 && hcount[10:1] < x14 + 47 + width && vcount >= y14 + 35 && vcount < y14 + 83 + width ||
        hcount[10:1] >= x14 + 71 && hcount[10:1] < x14 + 95 + width && vcount >= y14 + 59 && vcount < y14 + 59 + width ||
        hcount[10:1] >= x14 + 71 && hcount[10:1] < x14 + 71 + width && vcount >= y14 + 35 && vcount < y14 + 59 + width ||
        hcount[10:1] >= x14 + 95 && hcount[10:1] < x14 + 95 + width && vcount >= y14 + 35 && vcount < y14 + 83 + width || // 14
        hcount[10:1] >= x15 + 47 && hcount[10:1] < x15 + 47 + width && vcount >= y15 + 35 && vcount < y15 + 83 + width ||
        hcount[10:1] >= x15 + 71 && hcount[10:1] < x15 + 95 + width && 
        (vcount >= y15 + 35 && vcount < y15 + 35 + width ||
        vcount >= y15 + 59 && vcount < y15 + 59 + width ||
        vcount >= y15 + 83 && vcount < y15 + 83 + width) ||
        hcount[10:1] >= x15 + 95 && hcount[10:1] < x15 + 95 + width && vcount >= y15 + 59 && vcount < y15 + 83 + width ||
        hcount[10:1] >= x15 + 71 && hcount[10:1] < x15 + 71 + width && vcount >= y15 + 35 && vcount < y15 + 59 + width // 15
    )
      {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
    else if (hcount[10:1] % 119 == 0 || vcount % 119 == 0)
      {VGA_R, VGA_G, VGA_B} =
              {8'h80, 8'h80, 8'h80};
    else
      {VGA_R, VGA_G, VGA_B} = {8'hbf, 8'h8f, 8'h00};
  end
  else
    {VGA_R, VGA_G, VGA_B} =
            {background_r, background_g, background_b};
  /* cursor */
  if (hcount[10:1] >= cursor_x + 5 && hcount[10:1] < cursor_x + 115 && vcount >= cursor_y + 5 && vcount < cursor_y + 7)
    {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
  if (hcount[10:1] >= cursor_x + 5 && hcount[10:1] < cursor_x + 7 && vcount >= cursor_y + 5 && vcount < cursor_y + 115)
    {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
  if (hcount[10:1] >= cursor_x + 113 && hcount[10:1] < cursor_x + 115 && vcount >= cursor_y + 5 && vcount < cursor_y + 115)
    {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
  if (hcount[10:1] >= cursor_x + 5 && hcount[10:1] < cursor_x + 115 && vcount >= cursor_y + 113 && vcount < cursor_y + 115)
    {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
  if (selected_x < 4 && selected_y < 4) begin
    if (hcount[10:1] >= cursor_x + 7 && hcount[10:1] < cursor_x + 113 && vcount >= cursor_y + 7 && vcount < cursor_y + 9)
      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
    if (hcount[10:1] >= cursor_x + 7 && hcount[10:1] < cursor_x + 9 && vcount >= cursor_y + 7 && vcount < cursor_y + 113)
      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
    if (hcount[10:1] >= cursor_x + 111 && hcount[10:1] < cursor_x + 113 && vcount >= cursor_y + 7 && vcount < cursor_y + 113)
      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
    if (hcount[10:1] >= cursor_x + 7 && hcount[10:1] < cursor_x + 113 && vcount >= cursor_y + 111 && vcount < cursor_y + 113)
      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
  end
  if (win == 1) begin
    if (hcount[10:1] >= 119 && hcount[10:1] < 359 && vcount >= 119 && vcount < 359) begin
      {VGA_R, VGA_G, VGA_B} = face_out;
      /*
      if (face_out[2] == 1)
        VGA_R <= 8'hff;
      else
        VGA_R <= 8'h00;
      if (face_out[1] == 1)
        VGA_G <= 8'hff;
      else
        VGA_G <= 8'h00;
      if (face_out[0] == 1)
        VGA_B <= 8'hff;
      else
        VGA_B <= 8'h00;  
        */
    end
  end
  end
        
endmodule

module vga_counters(
input logic 	     clk50, reset,
output logic [10:0] hcount,  // hcount[10:1] is pixel column
output logic [9:0]  vcount,  // vcount[9:0] is pixel row
output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
* 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
* 
* HCOUNT 1599 0             1279       1599 0
*             _______________              ________
* ___________|    Video      |____________|  Video
* 
* 
* |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
*       _______________________      _____________
* |____|       VGA_HS          |____|
*/
  // Parameters for hcount
  parameter HACTIVE      = 11'd 1280,
            HFRONT_PORCH = 11'd 32,
            HSYNC        = 11'd 192,
            HBACK_PORCH  = 11'd 96,   
            HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
  
  // Parameters for vcount
  parameter VACTIVE      = 10'd 480,
            VFRONT_PORCH = 10'd 10,
            VSYNC        = 10'd 2,
            VBACK_PORCH  = 10'd 33,
            VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

  logic endOfLine;
  
  always_ff @(posedge clk50 or posedge reset)
    if (reset)          hcount <= 0;
    else if (endOfLine) hcount <= 0;
    else  	         hcount <= hcount + 11'd 1;

  assign endOfLine = hcount == HTOTAL - 1;
      
  logic endOfField;
  
  always_ff @(posedge clk50 or posedge reset)
    if (reset)          vcount <= 0;
    else if (endOfLine)
      if (endOfField)   vcount <= 0;
      else              vcount <= vcount + 10'd 1;

  assign endOfField = vcount == VTOTAL - 1;

  // Horizontal sync: from 0x520 to 0x5DF (0x57F)
  // 101 0010 0000 to 101 1101 1111
  assign VGA_HS = !( (hcount[10:8] == 3'b101) &
          !(hcount[7:5] == 3'b111));
  assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

  assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
  
  // Horizontal active: 0 to 1279     Vertical active: 0 to 479
  // 101 0000 0000  1280	       01 1110 0000  480
  // 110 0011 1111  1599	       10 0000 1100  524
  assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
      !( vcount[9] | (vcount[8:5] == 4'b1111) );

  /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
  assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
  
endmodule
