`timescale 1ns / 1ps
module softmax#(parameter M=8)(
input [M-1:0]A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,
output O0,O1,O2,O3,O4,O5,O6,O7,O8,O9);
// Declare wires to hold the maximum values for each group of two input values
wire [M-1:0]w1,w2,w3,w4,w5,w6,w7,w8,w9;

// Compute the maximum value for each group of two input values using max2 modules
max2 #(M)m0(A0,A1,w1);   // Max of A0 and A1
max2 #(M)m1(A2,A3,w2);   // Max of A2 and A3
max2 #(M)m2(A4,A5,w3);   // Max of A4 and A5
max2 #(M)m3(A6,A7,w4);   // Max of A6 and A7
max2 #(M)m4(A8,A9,w5);   // Max of A8 and A9
max2 #(M)m5(w1,w2,w6);   // Max of w1 and w2
max2 #(M)m6(w3,w4,w7);   // Max of w3 and w4
max2 #(M)m7(w6,w7,w8);   // Max of w6 and w7
max2 #(M)m8(w8,w5,w9);   // Max of w8 and w5

// Generate the output probabilities for each class
assign O0 = w9==A0,      // Probability of class 0 is 1 if w9 is equal to A0, 0 otherwise
       O1 = w9==A1,      // Probability of class 1 is 1 if w9 is equal to A1, 0 otherwise
       O2 = w9==A2,      // Probability of class 2 is 1 if w9 is equal to A2, 0 otherwise
       O3 = w9==A3,      // Probability of class 3 is 1 if w9 is equal to A3, 0 otherwise
       O4 = w9==A4,      // Probability of class 4 is 1 if w9 is equal to A4, 0 otherwise
       O5 = w9==A5,      // Probability of class 5 is 1 if w9 is equal to A5, 0 otherwise
       O6 = w9==A6,      // Probability of class 6 is 1 if w9 is equal to A6, 0 otherwise
       O7 = w9==A7,      // Probability of class 7 is 1 if w9 is equal to A7, 0 otherwise
       O8 = w9==A8,      // Probability of class 8 is 1 if w9 is equal to A8, 0 otherwise
       O9 = w9==A9;      // Probability of class 9 is 1 if w9 is equal to A9, 0 otherwise

Endmodule


