/*
 * our cnn
 * read from sdram
 */

module cnn_model(
	input	logic	clk, reset, 
	// OCM read

	input 	logic	start,
	input	logic	[ 7: 0]	ocm0_readdata,
	output	logic	[3:0]	data_out
	
);
	wire 		[9:0]	ocm0_addr;
	wire			ocm0_chip;
	wire			ocm0_clk_enab;
	wire		[28*28-1:0]	image;
	wire		[3:0]	cnn_out;
	logic 		[3:0]	state;
	parameter	[3:0]	IDLE = 0,
				CHIP_SELECT = 1,
				START = 2,
				START_CNN = 3,
				FINISH = 4;

	assign cnn_out = 4'b0001;

	always @ (posedge clk or posedge reset) begin
		if (reset) begin	
			state <= IDLE;	
		end
		else 
		case (state)
			IDLE: begin
				ocm0_clk_enab <= 0;
				ocm0_chip <= 0;
				ocm0_addr <= 0;
				if (start) begin
					state <= START;
				end
			end
			CHIP_SELECT: begin
				ocm0_chip <= 1;
				ocm0_clk_enab <= 1;
				state <= START;
			end

			START: begin
				if (ocm0_addr == 99) begin
					state <= START_CNN;
				end
				// update
				image[ocm0_addr*8 +: 8] = ocm0_readdata;
				ocm0_addr <= ocm0_addr + 1;
				state <= START;
			end
			START_CNN: begin
				data_out <= cnn_out;
				state <= FINISH;
			end
			FINISH: begin
				state <= IDLE;
			end

		endcase
	end
	
endmodule
