#include <stdio.h>


#define guint unsigned int
#define guint8 unsigned char

#include "4-bit-sprites_v3-All_for_export.c"

#define NIBBLE_TO_BINARY_PATTERN "%c%c%c%c"
#define NIBBLE_TO_BINARY(byte)  \
  (byte & 0x08 ? '1' : '0'), \
  (byte & 0x04 ? '1' : '0'), \
  (byte & 0x02 ? '1' : '0'), \
  (byte & 0x01 ? '1' : '0') 



#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"
#define BYTE_TO_BINARY(byte)  \
  (byte & 0x80 ? '1' : '0'), \
  (byte & 0x40 ? '1' : '0'), \
  (byte & 0x20 ? '1' : '0'), \
  (byte & 0x10 ? '1' : '0'), \
  (byte & 0x08 ? '1' : '0'), \
  (byte & 0x04 ? '1' : '0'), \
  (byte & 0x02 ? '1' : '0'), \
  (byte & 0x01 ? '1' : '0') 
void write_chunk(unsigned char counter, char * color)
{
        printf("0b");
        printf(BYTE_TO_BINARY_PATTERN, BYTE_TO_BINARY(counter));
        printf("%s",color);
        printf("\n");
}
#define COLOR_ALPHA         0
#define COLOR_BLACK         1
#define COLOR_RED           2
#define COLOR_LAND          3
#define COLOR_WHITE         4
#define COLOR_TRAIN_GRAY    5
#define COLOR_WATER         6
#define COLOR_ORANGE        7
#define COLOR_BLUE          8
#define COLOR_GREEN         9
#define COLOR_YELLOW        10
#define COLOR_PURPLE        11
#define COLOR_GRAY          12
#define COLOR_BROWN         13
#define COLOR_DARK_GRAY     14
#define COLOR_DARK_GREEN    15

char color_rgb[16][3] =
{
    {0,0,0}, // alpha
    {0,0,0}, // black   
    {0xfe,0x00,0}, // red
    {0xba,0xe3,0xa9}, // land
    {0xff,0xff,0xff}, // white
    {0x7f,0x81,0x7e}, // train gray
    {0x5b,0xac,0xbf}, // water
    {0xf5,0x71,0x11}, // orange
    {0x0b,0x67,0xbe}, // blue
    {0x7f,0xce,0x49}, // green
    {0xff,0xd4,0x0e}, // yellow
    {0xa8,0x49,0xa4}, // purple
    {0x97,0x93,0x91}, // gray
    {0xad,0x66,0x00}, // brown
    {0x2d,0x2c,0x1a}, // dark gray   
    {0x00,0x9f,0x57}, // dark green
};

#define GRAPHIC_WIDTH gimp_image.width
#define GRAPHIC_HEIGHT gimp_image.height

int main()
{
    
    guint x_index = 0;
    guint y_index = 0;
    unsigned  char counter = 0;
    char color_alpha[] = "0000";
    char color_black[] = "0001";
    char color_red[] = "0010";
    char color_land[] = "0011";
    char color_white[] = "0100";
    char color_train_gray[] = "0101";
    char color_water[] = "0110";
    char color_orange[] = "0111";
    char color_blue[] = "1000";
    char color_green[] = "1001";
    char color_yellow[] = "1010";
    char color_purple[] = "1011";
    char color_gray[] = "1100";
    char color_brown[] = "1101";
    char color_dark_gray[] = "1110";
    char color_dark_green[] = "1111";
    unsigned char * colors[16];
    for(char i = 0; i <16; i++)
    {
        colors[i] = NULL;
    }
    colors[COLOR_ALPHA] = color_alpha;
    colors[COLOR_BLACK] = color_black;
    colors[COLOR_RED] = color_red;
    colors[COLOR_LAND] = color_land;
    colors[COLOR_WHITE] = color_white;
    colors[COLOR_TRAIN_GRAY] = color_train_gray;
    colors[COLOR_WATER] = color_water;
    colors[COLOR_ORANGE] = color_orange;
    colors[COLOR_BLUE] = color_blue;
    colors[COLOR_GREEN] = color_green;
    colors[COLOR_YELLOW] = color_yellow;
    colors[COLOR_PURPLE] = color_purple;
    colors[COLOR_GRAY] = color_gray;
    colors[COLOR_BROWN] = color_brown;
    colors[COLOR_DARK_GRAY] = color_dark_gray;
    colors[COLOR_DARK_GREEN] = color_dark_green;
    unsigned char prev_val = 0;
    char * data_ptr = gimp_image.pixel_data;
    char color_found = 0;
    //printf("Leading text "BYTE_TO_BINARY_PATTERN, BYTE_TO_BINARY(byte));
    
    while(y_index<GRAPHIC_HEIGHT)
    {
        color_found = 0;
        if(x_index == 0)
        {
            printf("0b");
        }
        
        unsigned char cur_row = 0;
        if (data_ptr[3] == 0)
        {
            printf("%s", colors[COLOR_ALPHA]);         
            color_found = 1;
        }
        else
        {
            for(char color_index = 1; color_index <16; color_index++)
            {
                if(data_ptr[0] == color_rgb[color_index][0] && data_ptr[1] == color_rgb[color_index][1] && data_ptr[2] == color_rgb[color_index][2])
                {
                    printf("%s", colors[color_index]); 
                    color_found = 1;
                    break;
                }
            }
        }
        if(!color_found)
        {
                printf("color not found: (%02hhx,%02hhx,%02hhx) at x/y: %d,%d\n", data_ptr[0],data_ptr[1],data_ptr[2],x_index,y_index);
                break;
        } 
        data_ptr +=4;
        x_index++;
        if(x_index==GRAPHIC_WIDTH)
        {
            x_index = 0;
            y_index++;
            printf("\n");
        }      
        
    }
	//    printf("expected_size: %d\n",y_index*4*2001);
}

