#include <stdio.h>


#define guint unsigned int
#define guint8 unsigned char

#include "6_stations.c"


#define GRAPHIC_WIDTH gimp_image.width
#define GRAPHIC_HEIGHT gimp_image.height



int main(int argc, char ** argv)
{
    char default_var_name[] = "line_var";
    char *  var_name;
    if (argc == 2)
    {
        var_name = argv[1];
    } else {
        var_name = default_var_name;
    }
    guint x_index = 0;
    guint y_index = 0;
    char * data_ptr = gimp_image.pixel_data;
    char color_found = 0;
    unsigned int train_station_index = 0;
    unsigned int x_start = 0;
    unsigned int x_end = 0;
    unsigned int y_start = 0;
    unsigned int y_end = 0;
    //printf("Leading text "BYTE_TO_BINARY_PATTERN, BYTE_TO_BINARY(byte));
    printf("viewtube_map_position_t %s[] = {",var_name);
    while(y_index<GRAPHIC_HEIGHT)
    {
        
       
        if((data_ptr[0] == 0x00 && data_ptr[1] & 0x0ff  == 0x9e && (data_ptr[2] & 0x0FF) == 0x59) || data_ptr[3] == 0x0)
        {
            if(y_index > y_end && y_end != 0 && x_index==GRAPHIC_WIDTH-1)
            {
                if (x_start != 0 || x_end != 0)
                {
                        /*printf("%s[%d] = {%d,%d};\n",var_name,
                            train_station_index,
                            (x_start + x_end)/2,
                            (y_start + y_end)/2);*/
                        printf("{%d,%d}, ", (x_start + x_end)/2,
                            (y_start + y_end)/2);
                        train_station_index ++;
                        x_start = 0;
                        x_end = 0;
                        y_start = 0;
                        y_end = 0;
                }                
            }
            
        } else 
        {
            //printf("%02x,%02x,%02x\n",data_ptr[0],data_ptr[1],data_ptr[2]);
            if(x_start == 0 || x_start <x_index)
            {
                x_start = x_index;
            }
            x_end = x_index;
            if(y_start == 0)
            {
                y_start = y_index;
            }
            y_end = y_index;
        }
    
 
        data_ptr +=gimp_image.bytes_per_pixel;
        x_index++;
        if(x_index==GRAPHIC_WIDTH)
        {
            x_index = 0;
            y_index++;
        }      
        
    }
    printf("{0,0}};\n");
	//    printf("expected_size: %d\n",y_index*4*2001);
}

