#include <stdio.h>


#define guint unsigned int
#define guint8 unsigned char

#include "6_track.c"


#define GRAPHIC_WIDTH gimp_image.width
#define GRAPHIC_HEIGHT gimp_image.height
#define MODE_INCREMENT 0
#define MODE_DECREMENT 1
#define DIRECTION_HORIZONTAL 0
#define DIRECTION_VERTICAL   1

unsigned char track_color[] = {0x00,0x9e,0x59};


unsigned short ushort_min(unsigned short left, unsigned short right)
{
  if (left > right) return right;
  return left;
}

unsigned short ushort_max(unsigned short left, unsigned short right)
{
  if (left > right) return left;
  return right;
}

unsigned short decrease(unsigned short original, unsigned short interval, unsigned short bound)
{
  if ( (unsigned short) (original - interval) > original)
  {
    return bound;
  }
  return ushort_max(original - interval,bound);
}

unsigned short increase(unsigned short original, unsigned short interval, unsigned short bound)
{
  if ( (unsigned short) (original + interval) < original)
  {
    return bound;
  }
  return ushort_min(original + interval,bound);
}

int main(int argc, char ** argv)
{
    char default_var_name[] = "line_var";
    char *  var_name;
    if (argc == 2)
    {
        var_name = argv[1];
    } else {
        var_name = default_var_name;
    }
    guint x_index = 0;
    guint y_index = 0;
    char * data_ptr = gimp_image.pixel_data;
    char color_found = 0;
    unsigned int x_start = 0;
    unsigned int x_end = 0;
    //printf("Leading text "BYTE_TO_BINARY_PATTERN, BYTE_TO_BINARY(byte));
    printf("unsigned short one_line_lookups[VIEWTUBE_MAX_STATIONS_PER_LINE][2][MAX_GAP_BETWEEN_STATIONS];\n");
/**
 * First, run build_stations_for_line_from_graphic to get the stations_positions array
 * this program will then use that array this program
 */

unsigned short station_positions[][2] = {{692,189}, {689,214}, {684,240}, {667,272}, {649,297}, {631,314}, {614,332}, {592,352}, {570,372}, {550,391}, {544,410}, {534,444}, {530,468}, {524,491}, {516,513}, {497,528}, {435,536}, {380,576}, {379,600}, {379,625}, {379,663}, {378,689}, {380,721}, {379,765}, {378,800}, {380,848}, {378,883}, {378,920}, {368,955}, {367,971}, {368,991}, {372,1024}, {374,1046}, {381,1105}, {383,1126}, {383,1155}, {381,1195}, {0,0}};

unsigned short station_positions_len = 38;


    for(unsigned short station_index =0; station_index<station_positions_len-1; station_index++)
    {
        unsigned short start_x = station_positions[station_index][0];
        unsigned short start_y = station_positions[station_index][1];

        unsigned short stop_x = station_positions[station_index+1][0];
        unsigned short stop_y = station_positions[station_index+1][1];

        unsigned short loop_y_start = 0;
        unsigned short loop_y_stop = 0;

        unsigned short loop_x_start = 0;
        unsigned short loop_x_stop = 0;
        //printf("station: %d, x:%d,%d; y:%d,%d\n", station_index, start_x,stop_x,start_y,stop_y);

        if (start_x < stop_x) {
            loop_x_start = start_x;
            loop_x_stop = stop_x;
        } else {
            loop_x_start = stop_x;
            loop_x_stop = start_x;
        }

        if (start_y < stop_y) {
            loop_y_start = start_y;
            loop_y_stop = stop_y;
        } else {
            loop_y_start = stop_y;
            loop_y_stop = start_y;
        }

        //printf("station_loop: %d, x:%d,%d; y:%d,%d\n", station_index, loop_x_start,loop_x_stop,loop_y_start,loop_y_stop);
        unsigned short train_y_index = 0;
        for(unsigned short y_index = loop_y_start; y_index < loop_y_stop; y_index++)
        {
            unsigned short x_index = decrease(loop_x_start,50, 0); // add some outer padding to hopefully catch where it goes out of bounds
            unsigned short x_max   = increase(loop_x_stop,50,GRAPHIC_WIDTH); // same same

            unsigned short track_x_start = 0;
            unsigned short track_x_stop = 0;

            

            while(x_index < x_max)
            {
                data_ptr = gimp_image.pixel_data + ((y_index * GRAPHIC_WIDTH) + x_index)*gimp_image.bytes_per_pixel;

                if( ((char) data_ptr[0]) == ((char) track_color[0]) && 
                    ((char )  data_ptr[1]) == ((char) track_color[1]) && 
                    ((char) data_ptr[2]) == ((char) track_color[2])) 
                // found track
                {
                    track_x_stop = x_index;
                    if(track_x_start == 0)
                    {
                        track_x_start = x_index;
                    }
                } else {
                    //printf("debug: %02x,%02x,%02x\n", data_ptr[0],data_ptr[1],data_ptr[2]);
                }

                x_index++;

            }
            if (track_x_start != 0)
            {
                printf("station[%d][VERTICAL][%d] = %d;\n",station_index,train_y_index,(track_x_start+track_x_stop)/2);
            }
            train_y_index++;

        }
        unsigned short train_x_index = 0;
        for(unsigned short x_index = loop_x_start; x_index < loop_x_stop; x_index++)
        {
            unsigned short y_index = decrease(loop_y_start,50, 0); // add some outer padding to hopefully catch where it goes out of bounds
            unsigned short y_max   = increase(loop_y_stop,50,GRAPHIC_HEIGHT); // same same

            unsigned short track_y_start = 0;
            unsigned short track_y_stop = 0;

            

            while(y_index < y_max)
            {
                data_ptr = gimp_image.pixel_data + ((y_index * GRAPHIC_WIDTH) + x_index)*gimp_image.bytes_per_pixel;

                if( ((char ) data_ptr[0]) == ((char) track_color[0]) && 
                    ((char) data_ptr[1]) == ((char) track_color[1]) && 
                    ((char) data_ptr[2]) ==  ((char) track_color[2])) 
                // found track
                {
                    track_y_stop = y_index;
                    if(track_y_start == 0)
                    {
                        track_y_start = y_index;
                    }
                }
                else {
                    //printf("debug: %02x,%02x,%02x\n", data_ptr[0],data_ptr[1],data_ptr[2]);
                }

                y_index++;

            }
            if (track_y_start != 0)
            {
                printf("station[%d][HORIZONTAL][%d] = %d;\n",station_index,train_x_index,(track_y_start+track_y_stop)/2);
            }
            train_x_index++;

        }


    }

	//    printf("expected_size: %d\n",y_index*4*2001);
}

