// adapted from this sprite guide here:
// https://projectf.io/posts/hardware-sprites/
// and the memory lecture here:
// http://www.cs.columbia.edu/~sedwards/classes/2022/4840-spring/memory.pdf
module viewtube_dynamic_memory #(
    parameter WIDTH=8,
    parameter ROW=256,
    parameter ROM_FILE="",
    parameter ADDR_WIDTH=$clog2(ROW)
    ) (
    input  logic clk,
    input  logic write,
    input  logic [ADDR_WIDTH-1:0] addr,
    input logic [WIDTH-1:0] data_in,
    output logic [WIDTH-1:0] data_out
    );

    logic [WIDTH-1:0] memory [ROW];

    initial begin
        if (ROM_FILE != 0) begin
            $readmemh(ROM_FILE, memory);
        end
    end

    always_ff @(posedge clk) begin
        if (write) begin
            memory[addr] <= data_in;
        end
        data_out <= memory[addr];
    end
endmodule