#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "lodepng/lodepng.h"
#define DISPLAY_WIDTH  1500
#define DISPLAY_HEIGHT  1814
#define PIXEL_WIDTH 4
#define DISPLAY_BUFF_LEN  DISPLAY_WIDTH * DISPLAY_HEIGHT * PIXEL_WIDTH

/*
Example 1
Encode from raw pixels to disk with a single function call
The image argument has width * height RGBA pixels or width * height * 4 bytes
*/
void encodeOneStep(const char* filename, const unsigned char* image, unsigned width, unsigned height) {
  /*Encode the image*/
  unsigned error = lodepng_encode32_file(filename, image, width, height);

  /*if there's an error, display it*/
  if(error) printf("error %u: %s\n", error, lodepng_error_text(error));
}
#define COLOR_BLACK     0
#define COLOR_RED       1
#define COLOR_LAND      2
#define COLOR_WHITE     3
#define COLOR_ISLAND    4
#define COLOR_WATER     5
#define COLOR_ORANGE    6
#define COLOR_BLUE      7
#define COLOR_GREEN     8
#define COLOR_YELLOW    9
#define COLOR_PURPLE    10
#define COLOR_GRAY      11
#define COLOR_BROWN     12
#define COLOR_DARK_GRAY 13
#define COLOR_DARK_GREEN 14

char color_rgb[16][3] =
{
    {0,0,0}, // black   
    {0xff,0x2c,0}, // red
    {0xba,0xe3,0xa9}, // land
    {0xff,0xff,0xff}, // white
    {0xff,0xfe,0xd4}, // island
    {0x5b,0xac,0xbf}, // water
    {0xf5,0x71,0x11}, // orange
    {0x0b,0x67,0xbe}, // blue
    {0x7e,0xce,0x49}, // green
    {0xff,0xd4,0x0d}, // yellow
    {0xa8,0x49,0xa4}, // purple
    {0x97,0x93,0x91}, // gray
    {0xae,0x66,0x00}, // brown
    {0x2d,0x2c,0x1a}, // dark gray   
    {0x00,0x9f,0x57}, // dark green
    {0,0,0} //
};

int main()
{
    
	unsigned char count = 0;
	unsigned char counter = 0;
	unsigned int  pixel_offset = 0;
	unsigned char color_black[3] = {0, 0, 0};
	unsigned char color_red[3]   = {0xff,0,0};
	unsigned char * colors[16]; 
	unsigned char color = 0;
	colors[0] = color_black;
	colors[1] = color_red; 
	unsigned char * display_buff = malloc(DISPLAY_BUFF_LEN);
	if (NULL == display_buff) 
	{
		perror("malloc");
		exit(1);
	}
	memset(display_buff,0,DISPLAY_BUFF_LEN);
	
	unsigned short read_count;
	unsigned char buffer[32];
	unsigned char count_bytes[3] = {0, 0, 0};
	unsigned char color_bytes[2] = {0, 0};
	unsigned int memory_offset = 0;
	memset(buffer,0, 32);


	FILE *fp_in_file;

	fp_in_file = fopen("../roms/background_map.compressed.mem", "r");

	if (NULL == fp_in_file) 
	{
		perror("fopen");
		exit(1);
	}

	while (! feof(fp_in_file) )
	{
		read_count = fread(buffer, sizeof(char), 4, fp_in_file);
		if(read_count < 3)
		{
			printf("read err. skipping\n");
			printf("read was: %d\n",read_count);
			continue;	
		}
		count_bytes[0] = buffer[0];
		count_bytes[1] = buffer[1];
		color_bytes[0] = buffer[2];
		sscanf(count_bytes, "%02hhx", &count);
		sscanf(color_bytes, "%01hhx", &color);
		printf("%s",buffer);
		printf("%02x%01x\n", count,color);
		printf("%d,%d\n", count,color);
		
		for(counter = 0; counter<count; counter++)
		{
			display_buff[(pixel_offset + counter)*PIXEL_WIDTH + 0] = color_rgb[color][0]; // RED
			display_buff[(pixel_offset + counter)*PIXEL_WIDTH + 1] = color_rgb[color][1]; // GREEN
			display_buff[(pixel_offset + counter)*PIXEL_WIDTH + 2] = color_rgb[color][2]; // BLUE
			display_buff[(pixel_offset + counter)*PIXEL_WIDTH + 3] = 0xff;  	   // OPACITY
		}
//	       	printf("%d,%d,%d\n",pixel_offset*PIXEL_WIDTH+4, DISPLAY_BUFF_LEN, (pixel_offset*PIXEL_WIDTH+4) > DISPLAY_BUFF_LEN);
	       	printf("mem: %08x, pixel_offset: %08x, x:%08x (%u), y:%04x (%u), count:%02x, color:%d\n", memory_offset, pixel_offset, pixel_offset%DISPLAY_WIDTH, pixel_offset % DISPLAY_WIDTH, pixel_offset /DISPLAY_WIDTH, pixel_offset/DISPLAY_WIDTH,count,color);
		pixel_offset += count;
		memory_offset +=1;
	}

	fclose(fp_in_file);

	encodeOneStep("decoded_graphic.png",display_buff, DISPLAY_WIDTH, DISPLAY_HEIGHT);






	return 0;
}
