#ifndef _VIEWTUBE_VIEW_FPGA_H
#define _VIEWTUBE_VIEW_FPGA_H
#include "viewtube_model.h"
#include "../viewtube_kmod.h"
#include "../viewtube_user_lib.h"
#include "view_data/viewtube_fpga_view_lookup_tables.h"




typedef struct {
    unsigned short  width;
    unsigned short  height;
} viewtube_view_color_sprite_t;

typedef struct {

    unsigned char   red;
    unsigned char   green;
    unsigned char   blue;
} viewtube_view_letter_sprite_t;


typedef union {
    viewtube_view_color_sprite_t color;
    viewtube_view_letter_sprite_t letter;
} viewtube_view_sprite_t;

typedef struct {
    unsigned char   type;               // 0 == color or 1 == letter
    unsigned short  sprite_num;         // offset into (letter|color) sprite table
    unsigned short  cur_x;              // position x
    unsigned short  cur_y;              // position y
    unsigned char   active;             // if active, draw, if not, send 0 width, 0 height, sprite 0
    unsigned char   prev_active;        // track previous values so we know 
    unsigned short  prev_sprite_num;    // if one of the values changed this iteration we should
    unsigned short  prev_cur_x;         // draw this sprite
    unsigned short  prev_cur_y;
    unsigned char   prev_type;
    unsigned char   dirty;              // indicates this entry needs to be updated
    viewtube_view_sprite_t sprite;
} viewtube_sprite_table_entry_t;

#define VIEWTUBE_SPRITE_TYPE_COLOR 0 // 4bit color, used for trains and stuff
#define VIEWTUBE_SPRITE_TYPE_MONO  1 // single color, also called letters

#define LETTER_SPACE_OFFSET 92

void start_fpga_view();
void stop_fpga_view();

#endif