#ifndef _VIEWTUBE_MODEL_H
#define _VIEWTUBE_MODEL_H



#define VIEWTUBE_BACKGROUND_GRAPHIC_WIDTH 1500
#define VIEWTUBE_BACKGROUND_GRAPHIC_HEIGHT 1814

#define VIEWTUBE_FPGA_WINDOW_WIDTH  500
#define VIEWTUBE_FPGA_WINDOW_HEIGHT 425

#define VIEWTUBE_DIRECTION_NORTH 'n'
#define VIEWTUBE_DIRECTION_SOUTH 's'

#define VIEWTUBE_ONE_LINE       0
#define VIEWTUBE_SIX_LINE       1


typedef struct {
    unsigned char   direction;
    unsigned short  next_station;
    unsigned short  previous_station;
    float           distance_to_next_station;
} viewtube_train_t;

typedef struct {
    unsigned short  x_pos;
    unsigned short  y_pos;
} viewtube_map_position_t;

typedef struct {
    viewtube_map_position_t position;
    unsigned char   direction;
} viewtube_train_vector_t;

typedef struct {
    char * name;
    unsigned short name_len;
    unsigned short id;
    unsigned char lookup_type;
    viewtube_map_position_t position;
} viewtube_station_t;


typedef struct {
    viewtube_train_t *      trains;
    unsigned short          number_of_trains;
    viewtube_station_t *    stations;
    unsigned short          number_of_stations;
} viewtube_line_t;


void                        set_active_train_line(unsigned char in_active_train_line);
unsigned char               get_active_train_line();

void                        populate_active_line_with_trains(viewtube_train_t * trains, unsigned short num_trains);
void                        populate_line_with_trains(viewtube_train_t * trains, unsigned short num_trains, unsigned char line_id);
unsigned char               get_number_of_trains_on_active_line();
unsigned char               get_number_of_trains_on_line(unsigned char line_id);

void                        scroll_window_left();
void                        scroll_window_right();
void                        scroll_window_up();
void                        scroll_window_down();

unsigned short              get_window_left_position();
unsigned short              get_window_top_position();
void                        set_window_top_position(unsigned short top_pos);
void                        set_window_left_position(unsigned short left_pos);

viewtube_train_vector_t     get_train_vector(unsigned short train_id);

char *                      get_current_status_bar();

void                        initialize_viewtube_model();
void                        cleanup_viewtube_model();
void                        lock_model();
void                        unlock_model();

viewtube_line_t *           alloc_viewtube_line_t();
void                        free_viewtube_line_t(viewtube_line_t ** line);

#endif