#include "viewtube_controller.h"
#include <ncurses.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define INTERFACE_REFRESH_INTERVAL 5000000 // 5 seconds

#define USE_CURSES 0
WINDOW * curses_window;


static unsigned short train_interface_thread_running = 0;
static char line_number = '1';

static pthread_t train_interface_thread;

static void setup_curses(void)
{
  curses_window = initscr();
  keypad(curses_window,1);
  noecho();

}

static void update_display(void)
{
  refresh();
}

static void cleanup(void)
{
  echo();
  endwin();
}

static void * train_interface_thread_func(void * y_do_i_have_to_make_this)
{
    viewtube_line_t * latest_line_data = alloc_viewtube_line_t();
    while(train_interface_thread_running)
    {
        fetch_trains(latest_line_data, line_number);
        print_trains(latest_line_data);
        
        if( NULL != latest_line_data->trains &&
            latest_line_data->number_of_trains != 0)
        {
            populate_active_line_with_trains(latest_line_data->trains, latest_line_data->number_of_trains);
        }
            
        free_trains(latest_line_data);
        latest_line_data->trains = NULL;
        usleep(INTERFACE_REFRESH_INTERVAL);
    }
    free_viewtube_line_t(&latest_line_data);
    return NULL;
}

static void menu(void)
{
  printw("Use arrows to move. Backspace or 'x' to exit\n");
}

void initialize_viewtube_controller()
{
    if(!train_interface_thread_running)
    {
        train_interface_thread_running = 1;
        pthread_create(&train_interface_thread, 0, train_interface_thread_func, NULL);

    }
   
    initialize_viewtube_model();
}

void run_model_tests()
{
    viewtube_train_t trains[6] =
    {
        {VIEWTUBE_DIRECTION_SOUTH,
        8,
        7,
        0.45},
        {VIEWTUBE_DIRECTION_NORTH,
        13,
        12,
        0.9},
        {VIEWTUBE_DIRECTION_NORTH,
        25,
        24,
        0.0},
        {VIEWTUBE_DIRECTION_NORTH,
        3,
        2,
        1.0},
        {VIEWTUBE_DIRECTION_SOUTH,
        28,
        29,
        0.7},
        {VIEWTUBE_DIRECTION_SOUTH,
        1,
        2,
        0.1}
    };
    lock_model();
    populate_active_line_with_trains(trains,6);
    unlock_model();
}

void handle_option(unsigned char option)
{
    switch(option)
            {
            case 'w':
                scroll_window_up();
                break;
            case 'a':
                scroll_window_left();
                break;
            case 's':
                scroll_window_down();
                break;
            case 'd':
                scroll_window_right();
                break;
            case '1':
                lock_model();
                    set_active_train_line('1');
                    line_number = '1';
                unlock_model();
                break;
            case '6':
                lock_model();
                    set_active_train_line('6');
                    line_number = '6';
                unlock_model();
                break;
            default:
                break;
            }
}

void interactive_menu()
{
    if(USE_CURSES)
    {
        setup_curses();
        atexit(cleanup);       
    }

    update_display();
    int ch;

    if(USE_CURSES)
    {
        while( (ch = getch()) != KEY_BACKSPACE )
        {
            clear();
            curs_set(0);
            menu();
            handle_option(ch);
            update_display();
            if(ch == 'x')
            {
                break;
            }
        }
    }
    else
    {
        while( (ch = getchar()) != 'x' )
        {
            handle_option(ch);
        }
    }
    
}

void cleanup_viewtube_controller()
{
    if(train_interface_thread_running)
    {
        pthread_join(train_interface_thread, NULL);
        train_interface_thread_running = 0;   
    }
    
    cleanup_viewtube_model();
}