
#include "viewtube_line_lookup_tables.h"
#include "viewtube_model_objects.h"
#include <stddef.h>

viewtube_station_t one_line_stations[VIEWTUBE_MAX_STATIONS_PER_LINE];
viewtube_train_t   one_line_trains[VIEWTUBE_MAX_TRAINS_PER_LINE];
viewtube_line_t    one_line = {
    .trains =  one_line_trains,
    .number_of_trains = 0,
    .stations =  one_line_stations,
    .number_of_stations = VIEWTUBE_STATION_COUNT_ONE_LINE
};

viewtube_station_t two_line_stations[VIEWTUBE_MAX_STATIONS_PER_LINE];
viewtube_train_t   two_line_trains[VIEWTUBE_MAX_TRAINS_PER_LINE];
viewtube_line_t    two_line = {
    .trains =  two_line_trains,
    .number_of_trains = 0,
    .stations =  two_line_stations,
    .number_of_stations = VIEWTUBE_STATION_COUNT_ONE_LINE
};


viewtube_line_t * get_subway_line(unsigned short line_id)
{
    viewtube_line_t *  return_val;
    if(line_id == 0)
    {
        return_val = &one_line;
    } else if (line_id == 1)
    {
        return_val = &two_line;
    }
    else
    {
        return_val = &one_line;
    }
    return return_val;
}
