
#include "viewtube_line_lookup_tables.h"
#include "viewtube_model_objects.h"
#include "../viewtube_helpers.h"
#include <string.h>
// this is where we put all the gross code that makes this monster work.





viewtube_map_position_t line_one_station_positions[] = {{239,139}, {249,181}, {246,204}, {239,225}, {177,274}, {166,297}, {156,323}, {150,342}, {146,370}, {145,431}, {144,473}, {144,516}, {143,544}, {143,571}, {144,599}, {147,623}, {151,660}, {152,693}, {151,724}, {151,751}, {157,780}, {167,808}, {197,849}, {232,892}, {254,920}, {253,952}, {252,972}, {252,991}, {253,1009}, {253,1029}, {254,1072}, {270,1112}, {283,1146}, {286,1166}, {289,1188}, {290,1248}, {290,1276}, {359,1326}, {359,1326}};
viewtube_map_position_t line_six_stations_positions[] = {{692,189}, {689,214}, {684,240}, {667,272}, {649,297}, {631,314}, {614,332}, {592,352}, {570,372}, {550,391}, {544,410}, {534,444}, {530,468}, {524,491}, {516,513}, {497,528}, {435,536}, {380,576}, {379,600}, {379,625}, {379,663}, {378,689}, {380,721}, {379,765}, {378,800}, {380,848}, {378,883}, {378,920}, {368,955}, {367,971}, {368,991}, {372,1024}, {374,1046}, {381,1105}, {383,1126}, {383,1155}, {381,1195}, {0,0}};

unsigned char line_one_station_lookup_types[] = {
    VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP
};

unsigned char line_six_station_lookup_types[] = {
    VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP, VIEWTUBE_VERTICAL_LOOKUP
};


viewtube_map_position_t * get_train_positions_by_line(unsigned short line_id)
{
    viewtube_map_position_t * return_val = NULL;
    if(line_id == 0)
    {
        return_val = line_one_station_positions;
    } else if(line_id ==1)
    {
        return_val = line_six_stations_positions;
    } else 
    {
            return_val = line_one_station_positions;
    }
    return return_val;
}

/**
 * @brief at a given station, these arrays tell 
 *  which lookup to use when converting the distance
 *  from the current station to the next station into
 *  an x/y value.
 * 
 *  vertical lookup means provide the y value and 
 *  get an x back. (the line goes up and down)
 * 
 *  horizontal lookup means provide the x value
 *  and get a y back (the line goes horizontal)
 * 
 */

unsigned char * get_station_lookup_type_by_line(unsigned short line_id)
{
    unsigned char * return_val = NULL;

    if(line_id == 0)
    {
        return_val = line_one_station_lookup_types;
    } else if(line_id ==1)
    {
        return_val = line_six_station_lookup_types;
    } else 
    {
        return_val = line_one_station_lookup_types;

    }
    return return_val;
}


/*
char * view_tube_line_one_station_names[VIEWTUBE_STATION_COUNT_ONE_LINE] = {
    "Van Cortlandt Park - 242 St",
    "238 St",
    "231 St",
    "Marble Hill - 225 St",
    "215 St",
    "207 St",
    "Dyckman St",
    "191 St",
    "181 St",
    "168 St - Washington Hts",
    "157 St",
    "145 St",
    "137 St - City College",
    "125 St",
    "116 St - Columbia University",
    "Cathedral Pkwy",
    "103 St",
    "96 St",
    "86 St",
    "79 St",
    "72 St",
    "66 St - Lincoln Center",
    "59 St - Columbus Circle",
    "50 St",
    "Times Sq - 42 St",
    "34 St - Penn Station",
    "28 St",
    "23 St",
    "18 St",
    "14 St",
    "Christopher St - Sheridan Sq",
    "Houston St",
    "Canal St",
    "Franklin St",
    "Chambers St",
    "Cortlandt St",
    "Rector St",
    "South Ferry"
};


char *** station_names[VIEWTUBE_NUMBER_OF_LINES] = 
{
    (char ***) &view_tube_line_one_station_names
};
*/
/*
viewtube_map_position_t ** station_locations[VIEWTUBE_NUMBER_OF_LINES] =
{
    (viewtube_map_position_t **) &line_one_station_positions
};
*/
viewtube_map_position_t  * get_station_locations_by_line(unsigned short line_id)
{
    viewtube_map_position_t  * return_val = NULL;
    if(line_id == 0)
    {
            return_val = line_one_station_positions;
    }
    else if (line_id == 1)
    {
            return_val = line_six_stations_positions;
    }
    else 
    {
            return_val = line_one_station_positions;
    }
    return return_val;
}


unsigned short one_line_station_lookup_table[VIEWTUBE_MAX_STATIONS_PER_LINE][2][MAX_GAP_BETWEEN_STATIONS];

/*
unsigned short **** station_lookup_tables[VIEWTUBE_NUMBER_OF_LINES] = 
{
    (unsigned short ****) &one_line_station_lookup_table
};*/

unsigned short six_line_station_lookup_table[VIEWTUBE_MAX_STATIONS_PER_LINE][2][MAX_GAP_BETWEEN_STATIONS];

unsigned short lookup_station_position_by_line(unsigned short line_id, unsigned short station, unsigned short lookup, unsigned short gap)
{
    debug("lookup_station_position_by_line(line_id:%04x, station:%d, lookup:%d, gap:%d\n", line_id, station, lookup, gap);
    unsigned short return_val = 0;
    if(line_id == 0)
    {
            return_val = one_line_station_lookup_table[station][lookup][gap];
    }
    else if (line_id == 1)
    {
            return_val = six_line_station_lookup_table[station][lookup][gap];
    }
    else
    {
            return_val = one_line_station_lookup_table[station][lookup][gap];
            debug("lookup failed. returning default lookup table:%d\n",return_val);

    }
    debug("lookup_station_position_by_line returning: %d\n", return_val);
    return return_val;
}

void initialize_six_line_station_lookup_table()
{
    memset(&six_line_station_lookup_table,0,
    VIEWTUBE_MAX_STATIONS_PER_LINE *
     2 *MAX_GAP_BETWEEN_STATIONS * 
     sizeof(unsigned short));


six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][2] = 691;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][3] = 691;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][4] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][5] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][6] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][7] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][8] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][9] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][10] = 690;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][11] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][12] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][13] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][14] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][15] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][16] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][17] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][18] = 689;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][19] = 688;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][20] = 688;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][21] = 688;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][22] = 688;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][23] = 688;
six_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][24] = 688;
six_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 203;
six_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 199;
six_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 195;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][0] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][1] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][2] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][3] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][4] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][5] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][6] = 687;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][7] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][8] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][9] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][10] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][11] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][12] = 686;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][13] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][14] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][15] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][16] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][17] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][18] = 685;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][19] = 684;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][20] = 684;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][21] = 684;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][22] = 684;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][23] = 684;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][24] = 683;
six_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][25] = 683;
six_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 234;
six_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 229;
six_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 223;
six_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 217;
six_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 210;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][0] = 683;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][1] = 683;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][2] = 682;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][3] = 682;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][4] = 682;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][5] = 681;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][6] = 681;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][7] = 680;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][8] = 680;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][9] = 679;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][10] = 679;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][11] = 678;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][12] = 678;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][13] = 677;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][14] = 676;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][15] = 676;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][16] = 675;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][17] = 675;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][18] = 674;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][19] = 673;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][20] = 673;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][21] = 672;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][22] = 672;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][23] = 671;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][24] = 670;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][25] = 670;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][26] = 669;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][27] = 668;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][28] = 668;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][29] = 667;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][30] = 666;
six_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][31] = 666;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 269;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 268;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 266;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 265;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 263;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 261;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 260;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 258;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 256;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 255;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 253;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 251;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 249;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 248;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 245;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 242;
six_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 238;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][0] = 665;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][1] = 664;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][2] = 664;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][3] = 663;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][4] = 662;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][5] = 661;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][6] = 661;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][7] = 660;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][8] = 659;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][9] = 659;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][10] = 658;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][11] = 657;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][12] = 656;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][13] = 656;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][14] = 655;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][15] = 654;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][16] = 654;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][17] = 653;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][18] = 652;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][19] = 651;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][20] = 651;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][21] = 650;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][22] = 649;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][23] = 648;
six_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][24] = 648;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 295;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 293;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 292;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 291;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 289;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 288;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 286;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 285;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 284;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 282;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 281;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 279;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 278;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 277;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 275;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 274;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 272;
six_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 271;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][0] = 647;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][1] = 646;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][2] = 645;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][3] = 644;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][4] = 643;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][5] = 642;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][6] = 641;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][7] = 640;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][8] = 639;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][9] = 638;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][10] = 637;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][11] = 636;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][12] = 635;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][13] = 634;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][14] = 633;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][15] = 632;
six_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][16] = 631;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 313;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 312;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 311;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 310;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 309;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 308;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 307;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 306;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 305;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 304;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 303;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 302;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 301;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 300;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 299;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 298;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 297;
six_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 296;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][0] = 630;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][1] = 629;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][2] = 628;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][3] = 627;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][4] = 626;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][5] = 625;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][6] = 624;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][7] = 623;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][8] = 621;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][9] = 620;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][10] = 619;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][11] = 618;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][12] = 617;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][13] = 616;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][14] = 615;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][15] = 614;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][16] = 613;
six_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][17] = 612;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 329;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 328;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 327;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 326;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 325;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 324;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 323;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 322;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 321;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 320;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 319;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 319;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 318;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 317;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 316;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 315;
six_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 314;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][0] = 611;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][1] = 610;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][2] = 609;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][3] = 608;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][4] = 607;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][5] = 606;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][6] = 605;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][7] = 604;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][8] = 603;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][9] = 602;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][10] = 601;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][11] = 600;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][12] = 599;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][13] = 598;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][14] = 597;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][15] = 596;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][16] = 595;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][17] = 594;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][18] = 593;
six_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][19] = 591;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 350;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 349;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 348;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 348;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 347;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 346;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 345;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 344;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 343;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 342;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 341;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 340;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 339;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 338;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 337;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 336;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 335;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 334;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 333;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 332;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 331;
six_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 330;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][0] = 590;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][1] = 589;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][2] = 588;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][3] = 587;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][4] = 586;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][5] = 585;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][6] = 584;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][7] = 583;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][8] = 582;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][9] = 581;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][10] = 580;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][11] = 579;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][12] = 578;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][13] = 577;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][14] = 576;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][15] = 575;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][16] = 574;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][17] = 573;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][18] = 572;
six_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][19] = 571;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 371;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 371;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 370;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 369;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 368;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 367;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 366;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 365;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 364;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 363;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 362;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 361;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 360;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 359;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 358;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 357;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 356;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 355;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 354;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 353;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 352;
six_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 351;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][0] = 570;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][1] = 569;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][2] = 567;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][3] = 566;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][4] = 565;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][5] = 564;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][6] = 563;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][7] = 562;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][8] = 561;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][9] = 560;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][10] = 559;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][11] = 558;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][12] = 557;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][13] = 556;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][14] = 555;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][15] = 554;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][16] = 553;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][17] = 552;
six_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][18] = 551;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 391;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 390;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 389;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 388;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 387;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 386;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 385;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 384;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 383;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 382;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 381;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 380;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 379;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 378;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 377;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 376;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 375;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 374;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 373;
six_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 372;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][0] = 550;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][1] = 549;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][2] = 549;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][3] = 548;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][4] = 548;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][5] = 548;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][6] = 547;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][7] = 547;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][8] = 547;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][9] = 546;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][10] = 546;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][11] = 546;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][12] = 545;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][13] = 545;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][14] = 545;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][15] = 545;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][16] = 544;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][17] = 544;
six_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][18] = 544;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 408;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 404;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 401;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 398;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 395;
six_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 393;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][0] = 543;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][1] = 543;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][2] = 543;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][3] = 542;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][4] = 542;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][5] = 542;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][6] = 542;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][7] = 541;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][8] = 541;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][9] = 541;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][10] = 540;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][11] = 540;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][12] = 540;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][13] = 539;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][14] = 539;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][15] = 539;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][16] = 538;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][17] = 538;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][18] = 538;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][19] = 538;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][20] = 537;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][21] = 537;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][22] = 537;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][23] = 536;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][24] = 536;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][25] = 536;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][26] = 535;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][27] = 535;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][28] = 535;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][29] = 535;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][30] = 534;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][31] = 534;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][32] = 534;
six_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][33] = 533;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 441;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 437;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 434;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 431;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 427;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 424;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 421;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 418;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 414;
six_line_station_lookup_table[10][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 411;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][0] = 533;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][1] = 533;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][2] = 533;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][3] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][4] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][5] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][6] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][7] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][8] = 532;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][9] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][10] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][11] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][12] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][13] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][14] = 531;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][15] = 530;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][16] = 530;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][17] = 530;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][18] = 530;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][19] = 530;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][20] = 529;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][21] = 529;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][22] = 529;
six_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][23] = 529;
six_line_station_lookup_table[11][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 460;
six_line_station_lookup_table[11][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 455;
six_line_station_lookup_table[11][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 450;
six_line_station_lookup_table[11][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 446;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][0] = 529;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][1] = 528;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][2] = 528;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][3] = 528;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][4] = 528;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][5] = 527;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][6] = 527;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][7] = 527;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][8] = 527;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][9] = 526;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][10] = 526;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][11] = 526;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][12] = 526;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][13] = 526;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][14] = 525;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][15] = 525;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][16] = 525;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][17] = 525;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][18] = 524;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][19] = 524;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][20] = 524;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][21] = 523;
six_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][22] = 523;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 487;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 483;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 479;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 475;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 470;
six_line_station_lookup_table[12][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 465;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][0] = 523;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][1] = 523;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][2] = 522;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][3] = 522;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][4] = 522;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][5] = 521;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][6] = 521;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][7] = 521;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][8] = 521;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][9] = 520;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][10] = 520;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][11] = 520;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][12] = 519;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][13] = 519;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][14] = 519;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][15] = 518;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][16] = 518;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][17] = 518;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][18] = 517;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][19] = 517;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][20] = 516;
six_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][21] = 516;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 512;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 509;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 507;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 504;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 500;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 497;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 494;
six_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 491;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][0] = 516;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][1] = 515;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][2] = 514;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][3] = 514;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][4] = 513;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][5] = 512;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][6] = 511;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][7] = 510;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][8] = 509;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][9] = 508;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][10] = 506;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][11] = 504;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][12] = 503;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][13] = 501;
six_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][14] = 498;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 528;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 527;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 527;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 526;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 526;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 525;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 525;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 524;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 524;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 523;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 522;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 522;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 521;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 520;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 519;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 518;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 517;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 516;
six_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 514;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][0] = 496;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][1] = 493;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][2] = 490;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][3] = 486;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][4] = 481;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][5] = 475;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][6] = 467;
six_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][7] = 439;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 536;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][30] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][31] = 535;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][32] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][33] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][34] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][35] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][36] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][37] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][38] = 534;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][39] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][40] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][41] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][42] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][43] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][44] = 533;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][45] = 532;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][46] = 532;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][47] = 532;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][48] = 532;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][49] = 532;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][50] = 531;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][51] = 531;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][52] = 531;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][53] = 531;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][54] = 530;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][55] = 530;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][56] = 530;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][57] = 529;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][58] = 529;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][59] = 529;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][60] = 528;
six_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][61] = 528;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][0] = 434;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][1] = 427;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][2] = 401;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][3] = 399;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][4] = 397;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][5] = 396;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][6] = 395;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][7] = 394;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][8] = 393;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][9] = 392;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][10] = 391;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][11] = 390;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][12] = 389;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][13] = 389;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][14] = 388;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][15] = 388;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][16] = 387;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][17] = 387;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][18] = 386;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][19] = 386;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][20] = 385;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][21] = 385;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][22] = 384;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][23] = 384;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][24] = 383;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][25] = 383;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][26] = 383;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][27] = 382;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][28] = 382;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][29] = 382;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][30] = 381;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][31] = 381;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][32] = 381;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][33] = 380;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][34] = 380;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][35] = 380;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][36] = 380;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][37] = 379;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][38] = 379;
six_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][39] = 379;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 571;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 567;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 564;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 561;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 559;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 557;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 555;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 552;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 550;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 549;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 548;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 546;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 545;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 544;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 543;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 542;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 541;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 540;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 539;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 539;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 538;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 538;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 537;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 537;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 537;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 537;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][30] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][31] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][32] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][33] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][34] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][35] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][36] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][37] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][38] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][39] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][40] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][41] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][42] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][43] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][44] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][45] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][46] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][47] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][48] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][49] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][50] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][51] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][52] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][53] = 536;
six_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][54] = 536;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[17][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 609;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][31] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][32] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][33] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][34] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][35] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][36] = 378;
six_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][37] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 675;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][31] = 378;
six_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 704;
six_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 704;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][31] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][32] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][33] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][34] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][35] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][36] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][37] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][38] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][39] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][40] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][41] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][42] = 378;
six_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][43] = 378;
six_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 742;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][31] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][32] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][33] = 378;
six_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][34] = 378;
six_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 782;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][0] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][1] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][2] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][3] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][4] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][5] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][6] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][7] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][8] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][9] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][10] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][11] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][31] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][32] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][33] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][34] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][35] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][36] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][37] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][38] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][39] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][40] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][41] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][42] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][43] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][44] = 378;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][45] = 377;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][46] = 377;
six_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][47] = 377;
six_line_station_lookup_table[24][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 823;
six_line_station_lookup_table[24][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 823;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][0] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][1] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][2] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][3] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][4] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][5] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][6] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][7] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][8] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][9] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][10] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][11] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][12] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][13] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][14] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][15] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][16] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][17] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][18] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][19] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][20] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][21] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][22] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][23] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][24] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][25] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][26] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][27] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][28] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][29] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][30] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][31] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][32] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][33] = 377;
six_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][34] = 377;
six_line_station_lookup_table[25][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 858;
six_line_station_lookup_table[25][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 856;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][0] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][1] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][2] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][3] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][4] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][5] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][6] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][7] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][8] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][9] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][10] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][11] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][12] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][13] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][14] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][15] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][16] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][17] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][18] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][19] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][20] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][21] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][22] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][23] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][24] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][25] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][26] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][27] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][28] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][29] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][30] = 378;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][31] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][32] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][33] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][34] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][35] = 377;
six_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][36] = 377;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][0] = 376;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][1] = 376;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][2] = 375;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][3] = 375;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][4] = 374;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][5] = 374;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][6] = 374;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][7] = 373;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][8] = 373;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][9] = 373;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][10] = 372;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][11] = 372;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][12] = 372;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][13] = 371;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][14] = 371;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][15] = 371;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][16] = 371;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][17] = 370;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][18] = 370;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][19] = 370;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][20] = 370;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][21] = 369;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][22] = 369;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][23] = 369;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][24] = 369;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][25] = 368;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][26] = 368;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][27] = 368;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][28] = 368;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][29] = 367;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][30] = 367;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][31] = 367;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][32] = 367;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][33] = 366;
six_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][34] = 366;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 972;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 970;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 938;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 935;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 931;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 928;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 925;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 923;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 897;
six_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 896;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][0] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][1] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][2] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][3] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][4] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][5] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][6] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][7] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][8] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][9] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][10] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][11] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][12] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][13] = 366;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][14] = 365;
six_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][15] = 365;
six_line_station_lookup_table[28][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 979;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][0] = 365;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][1] = 365;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][2] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][3] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][4] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][5] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][6] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][7] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][8] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][9] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][10] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][11] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][12] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][13] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][14] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][15] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][16] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][17] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][18] = 366;
six_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][19] = 366;
six_line_station_lookup_table[29][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 979;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][0] = 366;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][1] = 366;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][2] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][3] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][4] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][5] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][6] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][7] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][8] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][9] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][10] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][11] = 367;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][12] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][13] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][14] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][15] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][16] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][17] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][18] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][19] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][20] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][21] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][22] = 368;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][23] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][24] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][25] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][26] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][27] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][28] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][29] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][30] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][31] = 369;
six_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][32] = 369;
six_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 982;
six_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 986;
six_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 991;
six_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 1037;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][0] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][1] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][2] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][3] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][4] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][5] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][6] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][7] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][8] = 370;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][9] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][10] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][11] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][12] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][13] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][14] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][15] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][16] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][17] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][18] = 371;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][19] = 372;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][20] = 372;
six_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][21] = 372;
six_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1045;
six_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1055;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][0] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][1] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][2] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][3] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][4] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][5] = 372;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][6] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][7] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][8] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][9] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][10] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][11] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][12] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][13] = 373;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][14] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][15] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][16] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][17] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][18] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][19] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][20] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][21] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][22] = 374;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][23] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][24] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][25] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][26] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][27] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][28] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][29] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][30] = 375;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][31] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][32] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][33] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][34] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][35] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][36] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][37] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][38] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][39] = 376;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][40] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][41] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][42] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][43] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][44] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][45] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][46] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][47] = 377;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][48] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][49] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][50] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][51] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][52] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][53] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][54] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][55] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][56] = 378;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][57] = 379;
six_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][58] = 379;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1063;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1072;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1080;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 1089;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 1097;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 1106;
six_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 1115;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][0] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][1] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][2] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][3] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][4] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][5] = 379;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][6] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][7] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][8] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][9] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][10] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][11] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][12] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][13] = 380;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][14] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][15] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][16] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][17] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][18] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][19] = 381;
six_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][20] = 381;
six_line_station_lookup_table[33][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1142;
six_line_station_lookup_table[33][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1146;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][0] = 381;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][1] = 381;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][2] = 381;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][3] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][4] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][5] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][6] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][7] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][8] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][9] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][10] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][11] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][12] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][13] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][14] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][15] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][16] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][17] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][18] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][19] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][20] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][21] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][22] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][23] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][24] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][25] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][26] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][27] = 382;
six_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][28] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][0] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][1] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][2] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][3] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][4] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][5] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][6] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][7] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][8] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][9] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][10] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][11] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][12] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][13] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][14] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][15] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][16] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][17] = 382;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][18] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][19] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][20] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][21] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][22] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][23] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][24] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][25] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][26] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][27] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][28] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][29] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][30] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][31] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][32] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][33] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][34] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][35] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][36] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][37] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][38] = 381;
six_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][39] = 380;
six_line_station_lookup_table[35][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1153;
six_line_station_lookup_table[35][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1156;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][535] = 418;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][536] = 416;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][537] = 415;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][538] = 401;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][539] = 399;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][540] = 397;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][541] = 396;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][542] = 395;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][543] = 394;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][544] = 393;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][545] = 392;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][546] = 391;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][547] = 390;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][548] = 389;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][549] = 389;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][550] = 388;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][551] = 388;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][552] = 387;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][553] = 387;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][554] = 386;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][555] = 386;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][556] = 385;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][557] = 385;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][558] = 384;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][559] = 384;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][560] = 383;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][561] = 383;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][562] = 383;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][563] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][564] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][565] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][566] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][567] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][568] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][569] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][570] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][571] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][572] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][573] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][574] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][575] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][576] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][577] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][578] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][579] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][580] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][581] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][582] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][583] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][584] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][585] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][586] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][587] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][588] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][589] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][590] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][591] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][592] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][593] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][594] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][595] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][596] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][597] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][598] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][599] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][600] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][601] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][602] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][603] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][604] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][605] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][606] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][607] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][608] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][609] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][610] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][611] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][612] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][613] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][614] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][615] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][616] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][617] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][618] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][619] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][620] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][621] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][622] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][623] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][624] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][625] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][626] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][627] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][628] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][629] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][630] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][631] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][632] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][633] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][634] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][635] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][636] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][637] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][638] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][639] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][640] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][641] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][642] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][643] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][644] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][645] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][646] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][647] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][648] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][649] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][650] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][651] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][652] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][653] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][654] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][655] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][656] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][657] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][658] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][659] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][660] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][661] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][662] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][663] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][664] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][665] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][666] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][667] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][668] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][669] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][670] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][671] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][672] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][673] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][674] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][675] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][676] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][677] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][678] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][679] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][680] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][681] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][682] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][683] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][684] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][685] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][686] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][687] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][688] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][689] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][690] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][691] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][692] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][693] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][694] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][695] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][696] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][697] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][698] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][699] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][700] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][701] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][702] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][703] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][704] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][705] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][706] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][707] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][708] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][709] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][710] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][711] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][712] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][713] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][714] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][715] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][716] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][717] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][718] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][719] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][720] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][721] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][722] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][723] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][724] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][725] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][726] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][727] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][728] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][729] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][730] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][731] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][732] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][733] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][734] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][735] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][736] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][737] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][738] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][739] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][740] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][741] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][742] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][743] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][744] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][745] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][746] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][747] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][748] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][749] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][750] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][751] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][752] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][753] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][754] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][755] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][756] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][757] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][758] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][759] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][760] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][761] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][762] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][763] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][764] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][765] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][766] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][767] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][768] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][769] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][770] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][771] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][772] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][773] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][774] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][775] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][776] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][777] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][778] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][779] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][780] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][781] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][782] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][783] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][784] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][785] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][786] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][787] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][788] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][789] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][790] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][791] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][792] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][793] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][794] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][795] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][796] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][797] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][798] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][799] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][800] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][801] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][802] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][803] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][804] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][805] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][806] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][807] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][808] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][809] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][810] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][811] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][812] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][813] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][814] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][815] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][816] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][817] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][818] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][819] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][820] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][821] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][822] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][823] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][824] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][825] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][826] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][827] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][828] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][829] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][830] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][831] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][832] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][833] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][834] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][835] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][836] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][837] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][838] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][839] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][840] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][841] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][842] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][843] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][844] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][845] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][846] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][847] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][848] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][849] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][850] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][851] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][852] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][853] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][854] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][855] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][856] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][857] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][858] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][859] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][860] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][861] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][862] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][863] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][864] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][865] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][866] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][867] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][868] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][869] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][870] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][871] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][872] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][873] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][874] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][875] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][876] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][877] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][878] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][879] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][880] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][881] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][882] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][883] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][884] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][885] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][886] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][887] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][888] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][889] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][890] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][891] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][892] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][893] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][894] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][895] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][896] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][897] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][898] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][899] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][900] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][901] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][902] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][903] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][904] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][905] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][906] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][907] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][908] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][909] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][910] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][911] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][912] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][913] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][914] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][915] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][916] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][917] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][918] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][919] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][920] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][921] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][922] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][923] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][924] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][925] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][926] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][927] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][928] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][929] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][930] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][931] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][932] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][933] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][934] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][935] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][936] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][937] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][938] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][939] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][940] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][941] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][942] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][943] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][944] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][945] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][946] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][947] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][948] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][949] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][950] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][951] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][952] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][953] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][954] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][955] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][956] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][957] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][958] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][959] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][960] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][961] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][962] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][963] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][964] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][965] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][966] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][967] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][968] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][969] = 365;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][970] = 365;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][971] = 365;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][972] = 365;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][973] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][974] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][975] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][976] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][977] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][978] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][979] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][980] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][981] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][982] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][983] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][984] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][985] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][986] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][987] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][988] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][989] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][990] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][991] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][992] = 366;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][993] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][994] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][995] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][996] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][997] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][998] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][999] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1000] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1001] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1002] = 367;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1003] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1004] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1005] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1006] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1007] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1008] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1009] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1010] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1011] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1012] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1013] = 368;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1014] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1015] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1016] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1017] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1018] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1019] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1020] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1021] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1022] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1023] = 369;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1024] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1025] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1026] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1027] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1028] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1029] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1030] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1031] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1032] = 370;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1033] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1034] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1035] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1036] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1037] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1038] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1039] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1040] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1041] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1042] = 371;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1043] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1044] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1045] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1046] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1047] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1048] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1049] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1050] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1051] = 372;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1052] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1053] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1054] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1055] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1056] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1057] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1058] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1059] = 373;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1060] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1061] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1062] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1063] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1064] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1065] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1066] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1067] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1068] = 374;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1069] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1070] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1071] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1072] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1073] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1074] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1075] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1076] = 375;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1077] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1078] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1079] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1080] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1081] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1082] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1083] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1084] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1085] = 376;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1086] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1087] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1088] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1089] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1090] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1091] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1092] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1093] = 377;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1094] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1095] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1096] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1097] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1098] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1099] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1100] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1101] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1102] = 378;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1103] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1104] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1105] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1106] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1107] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1108] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1109] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1110] = 379;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1111] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1112] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1113] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1114] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1115] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1116] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1117] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1118] = 380;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1119] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1120] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1121] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1122] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1123] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1124] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1125] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1126] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1127] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1128] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1129] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1130] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1131] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1132] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1133] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1134] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1135] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1136] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1137] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1138] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1139] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1140] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1141] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1142] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1143] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1144] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1145] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1146] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1147] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1148] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1149] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1150] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1151] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1152] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1153] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1154] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1155] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1156] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1157] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1158] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1159] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1160] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1161] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1162] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1163] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1164] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1165] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1166] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1167] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1168] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1169] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1170] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1171] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1172] = 382;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1173] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1174] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1175] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1176] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1177] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1178] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1179] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1180] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1181] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1182] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1183] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1184] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1185] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1186] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1187] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1188] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1189] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1190] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1191] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1192] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1193] = 381;
six_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1194] = 380;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][364] = 970;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][365] = 972;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][366] = 975;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][367] = 979;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][368] = 982;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][369] = 984;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][370] = 987;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][371] = 990;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][372] = 993;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][373] = 996;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][374] = 999;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][375] = 1002;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][376] = 969;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][377] = 839;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][378] = 841;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][379] = 883;
six_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][380] = 881;

}


void initialize_one_line_station_lookup_table()
{
    memset(&one_line_station_lookup_table,0,
    VIEWTUBE_MAX_STATIONS_PER_LINE *
     2 *MAX_GAP_BETWEEN_STATIONS * 
     sizeof(unsigned short));

    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][0] = 238;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][1] = 237;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][2] = 238;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][3] = 238;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][4] = 239;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][5] = 239;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][6] = 240;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][7] = 240;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][8] = 241;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][9] = 241;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][10] = 242;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][11] = 242;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][12] = 242;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][13] = 242;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][14] = 243;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][15] = 243;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][16] = 243;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][17] = 243;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][18] = 244;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][19] = 244;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][20] = 244;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][21] = 244;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][22] = 245;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][23] = 245;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][24] = 245;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][25] = 245;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][26] = 245;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][27] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][28] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][29] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][30] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][31] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][32] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][33] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][34] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][35] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][36] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][37] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][38] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][39] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][40] = 246;
    one_line_station_lookup_table[0][VIEWTUBE_VERTICAL_LOOKUP][41] = 247;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 182;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 182;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 182;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 182;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 182;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 181;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 181;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 181;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 180;
    one_line_station_lookup_table[0][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 179;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][0] = 247;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][1] = 247;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][2] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][3] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][4] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][5] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][6] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][7] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][8] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][9] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][10] = 246;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][11] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][12] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][13] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][14] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][15] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][16] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][17] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][18] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][19] = 245;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][20] = 244;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][21] = 244;
    one_line_station_lookup_table[1][VIEWTUBE_VERTICAL_LOOKUP][22] = 244;
    one_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 181;
    one_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 180;
    one_line_station_lookup_table[1][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 179;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][0] = 244;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][1] = 244;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][2] = 244;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][3] = 243;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][4] = 243;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][5] = 243;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][6] = 243;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][7] = 242;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][8] = 242;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][9] = 242;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][10] = 242;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][11] = 241;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][12] = 241;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][13] = 241;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][14] = 241;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][15] = 240;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][16] = 240;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][17] = 239;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][18] = 238;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][19] = 238;
    one_line_station_lookup_table[2][VIEWTUBE_VERTICAL_LOOKUP][20] = 237;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 221;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 219;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 216;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 187;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 186;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 184;
    one_line_station_lookup_table[2][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 182;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][0] = 237;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][1] = 236;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][2] = 236;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][3] = 235;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][4] = 234;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][5] = 234;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][6] = 233;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][7] = 231;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][8] = 230;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][9] = 229;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][10] = 228;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][11] = 226;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][12] = 225;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][13] = 223;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][14] = 222;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][15] = 220;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][16] = 219;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][17] = 217;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][18] = 216;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][19] = 215;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][20] = 213;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][21] = 212;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][22] = 211;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][23] = 209;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][24] = 207;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][25] = 206;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][26] = 204;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][27] = 203;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][28] = 201;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][29] = 199;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][30] = 198;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][31] = 196;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][32] = 194;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][33] = 193;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][34] = 192;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][35] = 190;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][36] = 188;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][37] = 187;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][38] = 186;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][39] = 184;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][40] = 183;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][41] = 182;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][42] = 181;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][43] = 180;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][44] = 179;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][45] = 179;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][46] = 178;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][47] = 177;
    one_line_station_lookup_table[3][VIEWTUBE_VERTICAL_LOOKUP][48] = 176;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 272;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 270;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 269;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 268;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 267;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 266;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 265;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 264;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 264;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 263;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 262;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 261;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 261;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 260;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 259;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 258;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 258;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 257;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 257;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 256;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 255;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 255;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 254;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 254;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 253;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 252;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 252;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 251;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 250;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 250;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][30] = 249;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][31] = 249;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][32] = 248;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][33] = 247;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][34] = 247;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][35] = 246;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][36] = 245;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][37] = 245;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][38] = 244;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][39] = 243;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][40] = 242;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][41] = 242;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][42] = 241;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][43] = 240;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][44] = 239;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][45] = 239;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][46] = 238;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][47] = 237;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][48] = 237;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][49] = 236;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][50] = 236;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][51] = 235;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][52] = 234;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][53] = 234;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][54] = 233;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][55] = 231;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][56] = 230;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][57] = 229;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][58] = 228;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][59] = 226;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][60] = 224;
    one_line_station_lookup_table[3][VIEWTUBE_HORIZONTAL_LOOKUP][61] = 223;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][0] = 175;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][1] = 175;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][2] = 174;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][3] = 174;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][4] = 173;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][5] = 173;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][6] = 172;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][7] = 171;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][8] = 171;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][9] = 170;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][10] = 170;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][11] = 169;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][12] = 169;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][13] = 168;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][14] = 168;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][15] = 168;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][16] = 167;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][17] = 167;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][18] = 166;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][19] = 166;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][20] = 165;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][21] = 165;
    one_line_station_lookup_table[4][VIEWTUBE_VERTICAL_LOOKUP][22] = 164;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 293;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 291;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 289;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 287;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 285;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 282;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 280;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 278;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 276;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 275;
    one_line_station_lookup_table[4][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 274;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][0] = 164;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][1] = 164;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][2] = 163;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][3] = 163;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][4] = 162;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][5] = 162;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][6] = 161;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][7] = 161;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][8] = 161;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][9] = 160;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][10] = 160;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][11] = 159;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][12] = 159;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][13] = 159;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][14] = 158;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][15] = 158;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][16] = 157;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][17] = 157;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][18] = 156;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][19] = 156;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][20] = 156;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][21] = 155;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][22] = 155;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][23] = 154;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][24] = 154;
    one_line_station_lookup_table[5][VIEWTUBE_VERTICAL_LOOKUP][25] = 153;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 316;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 314;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 312;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 309;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 307;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 305;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 302;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 300;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 298;
    one_line_station_lookup_table[5][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 295;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][0] = 153;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][1] = 153;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][2] = 152;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][3] = 152;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][4] = 152;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][5] = 151;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][6] = 151;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][7] = 151;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][8] = 150;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][9] = 150;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][10] = 150;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][11] = 150;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][12] = 149;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][13] = 149;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][14] = 149;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][15] = 148;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][16] = 148;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][17] = 148;
    one_line_station_lookup_table[6][VIEWTUBE_VERTICAL_LOOKUP][18] = 148;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 334;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 331;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 328;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 324;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 322;
    one_line_station_lookup_table[6][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 319;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][0] = 147;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][1] = 147;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][2] = 147;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][3] = 147;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][4] = 147;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][5] = 146;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][6] = 146;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][7] = 146;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][8] = 146;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][9] = 145;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][10] = 145;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][11] = 145;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][12] = 145;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][13] = 145;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][14] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][15] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][16] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][17] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][18] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][19] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][20] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][21] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][22] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][23] = 144;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][24] = 143;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][25] = 143;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][26] = 143;
    one_line_station_lookup_table[7][VIEWTUBE_VERTICAL_LOOKUP][27] = 143;
    one_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 353;
    one_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 346;
    one_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 342;
    one_line_station_lookup_table[7][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 338;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][0] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][1] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][2] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][3] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][4] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][5] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][6] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][7] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][8] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][9] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][10] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][11] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][12] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][13] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][14] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][15] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][16] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][17] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][18] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][19] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][20] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][21] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][22] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][23] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][24] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][25] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][26] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][27] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][28] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][29] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][30] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][31] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][32] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][33] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][34] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][35] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][36] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][37] = 143;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][38] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][39] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][40] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][41] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][42] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][43] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][44] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][45] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][46] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][47] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][48] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][49] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][50] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][51] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][52] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][53] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][54] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][55] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][56] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][57] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][58] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][59] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_VERTICAL_LOOKUP][60] = 142;
    one_line_station_lookup_table[8][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 373;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][0] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][1] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][2] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][3] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][4] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][5] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][6] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][7] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][8] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][9] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][10] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][11] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][12] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][13] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][14] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][15] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][16] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][17] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][18] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][19] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][20] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][21] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][22] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][23] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][24] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][25] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][26] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][27] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][28] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][29] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][30] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][31] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][32] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][33] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][34] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][35] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][36] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][37] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][38] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][39] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][40] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_VERTICAL_LOOKUP][41] = 142;
    one_line_station_lookup_table[9][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 447;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][0] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][1] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][2] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][3] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][4] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][5] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][6] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][7] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][8] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][9] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][10] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][11] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][12] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][13] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][14] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][15] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][16] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][17] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][18] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][19] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][20] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][21] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][22] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][23] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][24] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][25] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][26] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][27] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][28] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][29] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][30] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][31] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][32] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][33] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][34] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][35] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][36] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][37] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][38] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][39] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][40] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][41] = 142;
    one_line_station_lookup_table[10][VIEWTUBE_VERTICAL_LOOKUP][42] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][0] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][1] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][2] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][3] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][4] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][5] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][6] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][7] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][8] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][9] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][10] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][11] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][12] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][13] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][14] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][15] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][16] = 142;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][17] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][18] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][19] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][20] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][21] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][22] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][23] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][24] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][25] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][26] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_VERTICAL_LOOKUP][27] = 141;
    one_line_station_lookup_table[11][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 529;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][0] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][1] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][2] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][3] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][4] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][5] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][6] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][7] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][8] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][9] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][10] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][11] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][12] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][13] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][14] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][15] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][16] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][17] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][18] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][19] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][20] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][21] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][22] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][23] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][24] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][25] = 141;
    one_line_station_lookup_table[12][VIEWTUBE_VERTICAL_LOOKUP][26] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][0] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][1] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][2] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][3] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][4] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][5] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][6] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][7] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][8] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][9] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][10] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][11] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][12] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][13] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][14] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][15] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][16] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][17] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][18] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][19] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][20] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][21] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][22] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][23] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][24] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][25] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][26] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_VERTICAL_LOOKUP][27] = 141;
    one_line_station_lookup_table[13][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 572;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][0] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][1] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][2] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][3] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][4] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][5] = 141;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][6] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][7] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][8] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][9] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][10] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][11] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][12] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][13] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][14] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][15] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][16] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][17] = 142;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][18] = 143;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][19] = 143;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][20] = 143;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][21] = 144;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][22] = 144;
    one_line_station_lookup_table[14][VIEWTUBE_VERTICAL_LOOKUP][23] = 144;
    one_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 617;
    one_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 623;
    one_line_station_lookup_table[14][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 628;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][0] = 144;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][1] = 145;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][2] = 145;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][3] = 145;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][4] = 145;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][5] = 146;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][6] = 146;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][7] = 146;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][8] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][9] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][10] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][11] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][12] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][13] = 147;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][14] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][15] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][16] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][17] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][18] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][19] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][20] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][21] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][22] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][23] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][24] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][25] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][26] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][27] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][28] = 148;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][29] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][30] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][31] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][32] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][33] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][34] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][35] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_VERTICAL_LOOKUP][36] = 149;
    one_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 637;
    one_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 668;
    one_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 670;
    one_line_station_lookup_table[15][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 673;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][0] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][1] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][2] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][3] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][4] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][5] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][6] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][7] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][8] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][9] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][10] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][11] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][12] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][13] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][14] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][15] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][16] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][17] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][18] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][19] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][20] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][21] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][22] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][23] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][24] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][25] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][26] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][27] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][28] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][29] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][30] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][31] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_VERTICAL_LOOKUP][32] = 149;
    one_line_station_lookup_table[16][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 698;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][0] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][1] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][2] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][3] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][4] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][5] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][6] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][7] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][8] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][9] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][10] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][11] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][12] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][13] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][14] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][15] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][16] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][17] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][18] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][19] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][20] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][21] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][22] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][23] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][24] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][25] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][26] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][27] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][28] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][29] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_VERTICAL_LOOKUP][30] = 149;
    one_line_station_lookup_table[17][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 713;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][0] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][1] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][2] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][3] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][4] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][5] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][6] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][7] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][8] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][9] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][10] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][11] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][12] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][13] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][14] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][15] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][16] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][17] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][18] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][19] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][20] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][21] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][22] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][23] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][24] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][25] = 149;
    one_line_station_lookup_table[18][VIEWTUBE_VERTICAL_LOOKUP][26] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][0] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][1] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][2] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][3] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][4] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][5] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][6] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][7] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][8] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][9] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][10] = 149;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][11] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][12] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][13] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][14] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][15] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][16] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][17] = 150;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][18] = 151;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][19] = 151;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][20] = 151;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][21] = 151;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][22] = 151;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][23] = 152;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][24] = 152;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][25] = 152;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][26] = 153;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][27] = 153;
    one_line_station_lookup_table[19][VIEWTUBE_VERTICAL_LOOKUP][28] = 153;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 738;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 771;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 776;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 779;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 782;
    one_line_station_lookup_table[19][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 785;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][0] = 154;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][1] = 154;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][2] = 154;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][3] = 155;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][4] = 155;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][5] = 156;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][6] = 156;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][7] = 156;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][8] = 157;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][9] = 157;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][10] = 158;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][11] = 158;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][12] = 158;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][13] = 159;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][14] = 159;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][15] = 160;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][16] = 160;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][17] = 160;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][18] = 161;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][19] = 161;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][20] = 161;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][21] = 162;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][22] = 162;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][23] = 163;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][24] = 163;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][25] = 163;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][26] = 164;
    one_line_station_lookup_table[20][VIEWTUBE_VERTICAL_LOOKUP][27] = 164;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 787;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 790;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 793;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 795;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 798;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 800;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 803;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 805;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 807;
    one_line_station_lookup_table[20][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 809;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][0] = 165;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][1] = 165;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][2] = 166;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][3] = 166;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][4] = 167;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][5] = 168;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][6] = 168;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][7] = 169;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][8] = 169;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][9] = 170;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][10] = 170;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][11] = 171;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][12] = 172;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][13] = 172;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][14] = 173;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][15] = 173;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][16] = 174;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][17] = 175;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][18] = 175;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][19] = 176;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][20] = 177;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][21] = 177;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][22] = 178;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][23] = 179;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][24] = 180;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][25] = 180;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][26] = 181;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][27] = 182;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][28] = 183;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][29] = 184;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][30] = 184;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][31] = 185;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][32] = 186;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][33] = 187;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][34] = 188;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][35] = 189;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][36] = 189;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][37] = 190;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][38] = 191;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][39] = 192;
    one_line_station_lookup_table[21][VIEWTUBE_VERTICAL_LOOKUP][40] = 193;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 811;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 813;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 815;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 816;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 818;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 820;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 822;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 823;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 825;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 827;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 828;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 830;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 831;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 832;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 833;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 835;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 836;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 837;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 838;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 839;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 841;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 842;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 843;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 844;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 845;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 847;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 848;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 849;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 850;
    one_line_station_lookup_table[21][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 851;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][0] = 194;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][1] = 194;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][2] = 195;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][3] = 196;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][4] = 197;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][5] = 198;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][6] = 199;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][7] = 200;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][8] = 200;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][9] = 201;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][10] = 202;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][11] = 203;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][12] = 204;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][13] = 205;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][14] = 206;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][15] = 207;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][16] = 207;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][17] = 208;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][18] = 209;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][19] = 210;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][20] = 211;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][21] = 212;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][22] = 213;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][23] = 213;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][24] = 214;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][25] = 215;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][26] = 216;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][27] = 217;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][28] = 218;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][29] = 219;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][30] = 220;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][31] = 220;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][32] = 221;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][33] = 222;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][34] = 223;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][35] = 224;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][36] = 225;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][37] = 226;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][38] = 226;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][39] = 227;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][40] = 228;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][41] = 229;
    one_line_station_lookup_table[22][VIEWTUBE_VERTICAL_LOOKUP][42] = 230;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 852;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 854;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 855;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 856;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 857;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 858;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 859;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 860;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 862;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 863;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 864;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 865;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 866;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 867;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 869;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 870;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 871;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 872;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 873;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 874;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 876;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 877;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 878;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 879;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 880;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 881;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 882;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 884;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 885;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 886;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][30] = 887;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][31] = 888;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][32] = 889;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][33] = 891;
    one_line_station_lookup_table[22][VIEWTUBE_HORIZONTAL_LOOKUP][34] = 892;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][0] = 231;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][1] = 232;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][2] = 233;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][3] = 234;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][4] = 234;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][5] = 235;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][6] = 236;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][7] = 237;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][8] = 238;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][9] = 239;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][10] = 240;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][11] = 241;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][12] = 242;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][13] = 243;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][14] = 243;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][15] = 244;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][16] = 244;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][17] = 245;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][18] = 246;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][19] = 246;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][20] = 247;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][21] = 247;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][22] = 248;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][23] = 248;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][24] = 249;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][25] = 249;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][26] = 250;
    one_line_station_lookup_table[23][VIEWTUBE_VERTICAL_LOOKUP][27] = 250;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 893;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 894;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 895;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 896;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 897;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 898;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 899;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 900;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 901;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 902;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 904;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 905;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 907;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 908;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 910;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 912;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 922;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 940;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 941;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 942;
    one_line_station_lookup_table[23][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 943;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][5] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][6] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][7] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][8] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][9] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][10] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][11] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][12] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][13] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][14] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][15] = 249;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][18] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][19] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][20] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][21] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][22] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][23] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][24] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][25] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][26] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][27] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][28] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][29] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][30] = 250;
    one_line_station_lookup_table[24][VIEWTUBE_VERTICAL_LOOKUP][31] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][5] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][6] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][7] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][8] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][9] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][10] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][11] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][12] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][13] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][14] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][15] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][18] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_VERTICAL_LOOKUP][19] = 250;
    one_line_station_lookup_table[25][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 969;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][5] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][6] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][7] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][8] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][9] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][10] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][11] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][12] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][13] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][14] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][15] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[26][VIEWTUBE_VERTICAL_LOOKUP][18] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][5] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][6] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][7] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][8] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][9] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][10] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][11] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][12] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][13] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][14] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][15] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[27][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1000;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][5] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][6] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][7] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][8] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][9] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][10] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][11] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][12] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][13] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][14] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][15] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][18] = 250;
    one_line_station_lookup_table[28][VIEWTUBE_VERTICAL_LOOKUP][19] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][0] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][1] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][2] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][3] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][4] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][5] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][6] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][7] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][8] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][9] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][10] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][11] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][12] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][13] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][14] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][15] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][16] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][17] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][18] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][19] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][20] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][21] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][22] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][23] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][24] = 250;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][25] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][26] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][27] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][28] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][29] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][30] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][31] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][32] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][33] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][34] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][35] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][36] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][37] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][38] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][39] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][40] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][41] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_VERTICAL_LOOKUP][42] = 251;
    one_line_station_lookup_table[29][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1070;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][0] = 251;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][1] = 252;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][2] = 252;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][3] = 252;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][4] = 253;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][5] = 253;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][6] = 253;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][7] = 254;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][8] = 254;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][9] = 254;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][10] = 255;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][11] = 255;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][12] = 255;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][13] = 256;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][14] = 256;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][15] = 257;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][16] = 257;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][17] = 257;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][18] = 258;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][19] = 258;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][20] = 259;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][21] = 259;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][22] = 260;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][23] = 260;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][24] = 261;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][25] = 261;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][26] = 261;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][27] = 262;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][28] = 262;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][29] = 263;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][30] = 263;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][31] = 264;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][32] = 264;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][33] = 265;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][34] = 265;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][35] = 266;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][36] = 266;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][37] = 266;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][38] = 267;
    one_line_station_lookup_table[30][VIEWTUBE_VERTICAL_LOOKUP][39] = 267;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1078;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1081;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1084;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 1087;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 1089;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 1091;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 1094;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 1096;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 1098;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 1100;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 1103;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 1105;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 1107;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 1109;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 1111;
    one_line_station_lookup_table[30][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 1114;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][0] = 268;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][1] = 268;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][2] = 269;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][3] = 269;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][4] = 269;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][5] = 270;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][6] = 270;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][7] = 271;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][8] = 271;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][9] = 271;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][10] = 272;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][11] = 272;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][12] = 273;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][13] = 273;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][14] = 273;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][15] = 274;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][16] = 274;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][17] = 275;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][18] = 275;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][19] = 275;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][20] = 276;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][21] = 276;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][22] = 276;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][23] = 277;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][24] = 277;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][25] = 278;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][26] = 278;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][27] = 278;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][28] = 279;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][29] = 279;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][30] = 279;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][31] = 280;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][32] = 280;
    one_line_station_lookup_table[31][VIEWTUBE_VERTICAL_LOOKUP][33] = 280;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1116;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1119;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1121;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 1124;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 1126;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 1129;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 1132;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 1134;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 1137;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 1140;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 1143;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 1147;
    one_line_station_lookup_table[31][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 1151;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][0] = 281;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][1] = 281;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][2] = 281;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][3] = 281;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][4] = 281;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][5] = 282;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][6] = 282;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][7] = 282;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][8] = 282;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][9] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][10] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][11] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][12] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][13] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][14] = 283;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][15] = 284;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][16] = 284;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][17] = 284;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][18] = 284;
    one_line_station_lookup_table[32][VIEWTUBE_VERTICAL_LOOKUP][19] = 284;
    one_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1158;
    one_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1174;
    one_line_station_lookup_table[32][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1185;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][0] = 284;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][1] = 284;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][2] = 284;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][3] = 284;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][4] = 284;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][5] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][6] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][7] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][8] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][9] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][10] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][11] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][12] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][13] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][14] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][15] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][16] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][17] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][18] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][19] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][20] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_VERTICAL_LOOKUP][21] = 285;
    one_line_station_lookup_table[33][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1199;
    one_line_station_lookup_table[33][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1206;
    one_line_station_lookup_table[33][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1220;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][0] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][1] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][2] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][3] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][4] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][5] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][6] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][7] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][8] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][9] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][10] = 285;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][11] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][12] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][13] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][14] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][15] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][16] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][17] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][18] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][19] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][20] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][21] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][22] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][23] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][24] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][25] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][26] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][27] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][28] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][29] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][30] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][31] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][32] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][33] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][34] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][35] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][36] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][37] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][38] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][39] = 286;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][40] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][41] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][42] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][43] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][44] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][45] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][46] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][47] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][48] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][49] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][50] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][51] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][52] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][53] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][54] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][55] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][56] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][57] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][58] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_VERTICAL_LOOKUP][59] = 287;
    one_line_station_lookup_table[34][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1256;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][0] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][1] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][2] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][3] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][4] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][5] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][6] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][7] = 287;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][8] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][9] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][10] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][11] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][12] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][13] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][14] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][15] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][16] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][17] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][18] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][19] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][20] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][21] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][22] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][23] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][24] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][25] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][26] = 288;
    one_line_station_lookup_table[35][VIEWTUBE_VERTICAL_LOOKUP][27] = 288;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][0] = 288;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][1] = 289;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][2] = 289;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][3] = 289;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][4] = 290;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][5] = 290;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][6] = 290;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][7] = 291;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][8] = 291;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][9] = 292;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][10] = 292;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][11] = 293;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][12] = 293;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][13] = 294;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][14] = 295;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][15] = 296;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][16] = 297;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][17] = 298;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][18] = 299;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][19] = 300;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][20] = 301;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][21] = 302;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][22] = 303;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][23] = 304;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][24] = 305;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][25] = 307;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][26] = 308;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][27] = 309;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][28] = 310;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][29] = 312;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][30] = 313;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][31] = 315;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][32] = 316;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][33] = 318;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][34] = 319;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][35] = 320;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][36] = 322;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][37] = 324;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][38] = 325;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][39] = 327;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][40] = 329;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][41] = 331;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][42] = 333;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][43] = 335;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][44] = 337;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][45] = 340;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][46] = 342;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][47] = 346;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][48] = 349;
    one_line_station_lookup_table[36][VIEWTUBE_VERTICAL_LOOKUP][49] = 351;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][0] = 1272;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][1] = 1281;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][2] = 1284;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][3] = 1286;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][4] = 1288;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][5] = 1289;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][6] = 1291;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][7] = 1292;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][8] = 1293;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][9] = 1293;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][10] = 1294;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][11] = 1295;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][12] = 1296;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][13] = 1297;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][14] = 1298;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][15] = 1299;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][16] = 1300;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][17] = 1301;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][18] = 1302;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][19] = 1303;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][20] = 1303;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][21] = 1304;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][22] = 1305;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][23] = 1306;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][24] = 1306;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][25] = 1307;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][26] = 1308;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][27] = 1309;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][28] = 1309;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][29] = 1310;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][30] = 1310;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][31] = 1311;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][32] = 1312;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][33] = 1312;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][34] = 1313;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][35] = 1313;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][36] = 1314;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][37] = 1315;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][38] = 1315;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][39] = 1316;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][40] = 1316;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][41] = 1317;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][42] = 1317;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][43] = 1318;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][44] = 1318;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][45] = 1319;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][46] = 1319;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][47] = 1320;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][48] = 1320;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][49] = 1320;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][50] = 1321;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][51] = 1321;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][52] = 1322;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][53] = 1322;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][54] = 1322;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][55] = 1322;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][56] = 1323;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][57] = 1323;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][58] = 1323;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][59] = 1324;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][60] = 1324;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][61] = 1324;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][62] = 1324;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][63] = 1325;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][64] = 1325;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][65] = 1325;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][66] = 1325;
    one_line_station_lookup_table[36][VIEWTUBE_HORIZONTAL_LOOKUP][67] = 1325;
}