#include <iostream>
#include <iomanip>
#include "Vvga_ball.h"
#include <verilated.h>
#include <stdio.h>


int main(int argc, const char ** argv, const char ** env) {
  int exitcode = 0;
  
  Verilated::commandArgs(argc, argv);

  Vvga_ball * dut = new Vvga_ball; 

  int time = 0;
  int hcount = 0, hactive = 0, hn = 0;
  int vn = 0;
  int image[3][640][480] = {0};

  int towrite[8] = {150, 200, 0, 3, 90, 90, 0, 4};
  int input_n;

  dut->reset = 1;
  dut->clk = 0;
  dut->writedata = 0;
  dut->write = 0;
  dut->chipselect = 0;
  dut->address = 0;


  while (!Verilated::gotFinish()) {
	if (time > 30000000) break;

        if (time > 100) {
            dut->reset = 0;   // Deassert reset
        }

	input_n = (time/10) % 100;
	if (input_n < (sizeof(towrite)/sizeof(int))){
		dut->write = 1;
		dut->chipselect = 1;
		dut->address = input_n;
		dut->writedata = towrite[input_n];
	}else{
		dut->write = 0;
		dut->chipselect = 0;
	}

        if ((time % 10) == 1) dut->clk = 1;       // Toggle clock
        else if ((time % 10) == 6) dut->clk = 0;


	if ((time % 10) == 1){ 		// rising edge
		if (! dut->VGA_VS){
			vn = -33;
		}

		if (dut->VGA_HS){
			hactive = 1;
			hcount++;
		}else{
			if (hactive){
				vn++;
			}
			hactive = 0;
			hcount = 0;
		}

		hn = (hcount - 96) / 2;
		if (hactive && (hn < 640) && (hn >= 0) && (vn < 480) && (vn >= 0)){
			image[0][hn][vn] = dut->VGA_R;
			image[1][hn][vn] = dut->VGA_G;
			image[2][hn][vn] = dut->VGA_B;
			//std::cout << std::hex;
			//std::cout << (int) dut->VGA_R << " " ;
			//std::cout << (int) dut->VGA_G << " " ;
			//std::cout << (int) dut->VGA_B << " " ;
			//std::cout << std::endl;
		}
	}

        dut->eval();            // Evaluate model
        time++;            // Time passes...
    }

  dut->final(); // Stop the simulation
  delete dut;


  FILE *fp;

  fp = fopen("preview.ppm", "w+");
  fputs("P3\n640 480\n255\n", fp);

  for(int j = 0; j < 480; j++){
	for(int i = 0; i < 640; i++){
		fprintf(fp, "%d %d %d ", image[0][i][j],  image[1][i][j], image[2][i][j]);
		//if (image[0][i][j] == 0x96) fputs("o", fp);
		//else if (image[0][i][j] == 0xff) fputs("i", fp);
		//else fputs("X", fp);
	}
	fputs("\n", fp);
  }

  fclose(fp);
  

  return exitcode;
}

