module sprites(
	input logic [5:0]          n_sprite,
	input logic [9:0]          line,
	input logic                clk,
	output logic [29:0][23:0]  pattern);

	always_ff @(posedge clk) begin
		case (n_sprite)
			6'd1 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h2d2d06}, {24'h605f06}, {24'h646305}, {24'h595806}, {24'h3e3d07}, {24'h090903}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050506}, {24'h58666c}, {24'hcbd54f}, {24'hfdfc06}, {24'hfffd00}, {24'hfffd02}, {24'hf4f203}, {24'hd1cf07}, {24'h5f5e07}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h536375}, {24'hb2d6fe}, {24'hb3d6fb}, {24'hcde3a7}, {24'hfefd04}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfaf801}, {24'h686709}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1f252b}, {24'ha4c5e9}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hd8e984}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hf1ef03}, {24'h2d2d05}, {24'h000000}, {8{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h66798f}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hb2d6fe}, {24'ha6c7ea}, {24'h242403}, {24'ha09f01}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'h818007}, {24'h000000}, {8{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h88a3c0}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hb4d7f8}, {24'hb9d3bd}, {24'h474702}, {24'hafad00}, {24'hfffd00}, {24'hfffd00}, {24'hfde937}, {24'hc59f79}, {24'h181215}, {8{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h8eaac9}, {24'hb2d6fe}, {24'hb2d6fe}, {24'hbddcda}, {24'hedf43b}, {24'hfefc05}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfef220}, {24'hf6b2d1}, {24'hf6b0d6}, {24'h664a5a}, {8{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020202}, {24'h96b3d4}, {24'hb2d6fe}, {24'hcde4a6}, {24'hf9fa14}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfad56f}, {24'hf6b0d6}, {24'hf6b0d6}, {24'h8a6479}, {8{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070809}, {24'h9bbadd}, {24'hbadae4}, {24'hfafb10}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfacd85}, {24'hf6b0d6}, {24'hf6b0d6}, {24'h9a6f87}, {8{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070809}, {24'h9fbcd0}, {24'he4ef5a}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfdf21f}, {24'hca92af}, {24'hf6b0d6}, {24'h966d83}, {8{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040404}, {24'hbbc868}, {24'hfffd01}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hf8f707}, {24'h31252b}, {24'he9a7ca}, {24'h775769}, {8{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1c1c03}, {24'hf1ef03}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd03}, {24'h20200b}, {24'h7a596b}, {24'h21181d}, {8{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h3a3905}, {24'hfefc01}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd01}, {24'hfffd00}, {24'hfffd00}, {24'hfffd05}, {24'h636218}, {24'h030203}, {24'h000000}, {8{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h99980a}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd00}, {24'hfffd24}, {24'hfefd86}, {24'hb2b17c}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1a1a06}, {24'hfcfa03}, {24'hfffd00}, {24'hfffd00}, {24'hfefd53}, {24'hfefd6e}, {24'hfffd6d}, {24'hfefd72}, {24'hfefd80}, {24'hfefd96}, {24'hfefdb1}, {24'hfefdb2}, {24'hf3f2ab}, {24'h222219}, {24'h000000}, {8{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h555407}, {24'hfffd00}, {24'hfffd00}, {24'hfffd28}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'h57573e}, {24'h000000}, {8{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h949308}, {24'hfffd00}, {24'hfffd08}, {24'hfefd7b}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd75}, {24'hfefd7b}, {24'hfefdb1}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'h83835d}, {24'h000000}, {8{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hd7d608}, {24'hfffd00}, {24'hfffd39}, {24'hfefdb1}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfffd3c}, {24'hfffd06}, {24'hfdfc66}, {24'hfdfdb3}, {24'hfefdb2}, {24'hfefdb2}, {24'hbbba84}, {24'h000000}, {8{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1a1a06}, {24'hfffd01}, {24'hfffd05}, {24'hfefd8a}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd6d}, {24'hfffd00}, {24'hedf43c}, {24'hbedcef}, {24'hf9fbb7}, {24'hfefdb2}, {24'hdfde9d}, {24'h161611}, {8{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h525209}, {24'hfffd00}, {24'hfffd28}, {24'hfefdb0}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd89}, {24'hfffd00}, {24'hf8f918}, {24'hb8d9ec}, {24'hdcecd4}, {24'hfefdb2}, {24'hebeaa5}, {24'h2e2e22}, {8{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h7b7a09}, {24'hfffd00}, {24'hfffd66}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd8a}, {24'hfffd00}, {24'hf9fa15}, {24'hb9dae7}, {24'hdfedd2}, {24'hfefdb2}, {24'hebeba6}, {24'h2f2e22}, {8{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'haeac0b}, {24'hfffd07}, {24'hfefda6}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb1}, {24'hfefd72}, {24'hfffd00}, {24'hf6f91e}, {24'hb6d8f1}, {24'heff5be}, {24'hfefdb2}, {24'hdede9d}, {24'h151510}, {8{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc8c707}, {24'hfffd20}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb1}, {24'hfffd29}, {24'hfffd00}, {24'he0ed67}, {24'hbddbf0}, {24'hfefdb1}, {24'hfefdb2}, {24'hcccc91}, {24'h000000}, {8{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0b0a03}, {24'hdfdd04}, {24'hfefd33}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd7e}, {24'hfffd02}, {24'hfafb10}, {24'hc0ddd5}, {24'he6f1c9}, {24'hfefdb2}, {24'hfefdb2}, {24'hbfbe87}, {24'h000000}, {8{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h212103}, {24'hf6f407}, {24'hfefd58}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefda9}, {24'hfffd1c}, {24'hfffd00}, {24'hd5e88b}, {24'hcde4e1}, {24'hfdfdb3}, {24'hfefdb2}, {24'hfefdb2}, {24'hb4b37f}, {24'h000000}, {8{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h545308}, {24'hfffd02}, {24'hfefd8f}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb1}, {24'hfffd52}, {24'hfffd00}, {24'he2ef5f}, {24'hc6e0dd}, {24'hf9fbb1}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'h82825c}, {24'h000000}, {8{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h848307}, {24'hfffd23}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfffd6f}, {24'hfffd06}, {24'hf6f91d}, {24'hc0dde4}, {24'hf9fab7}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfcfbb0}, {24'h424230}, {24'h000000}, {8{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hadac0d}, {24'hfbfb84}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd95}, {24'hfffd0b}, {24'hfefd03}, {24'hcde4a8}, {24'heaf3c6}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hafae7c}, {24'h060604}, {24'h000000}, {8{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h060602}, {24'hc7cd39}, {24'hd9ead4}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefda5}, {24'hfffd33}, {24'hfffd00}, {24'hfcfc23}, {24'he0eec5}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hd3d295}, {24'h1d1d15}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h242508}, {24'hc3d9a6}, {24'hcae2e7}, {24'hfefdb2}, {24'hfefdab}, {24'hfffd2f}, {24'hfffd00}, {24'hfffd29}, {24'hfefd9e}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hd0cf93}, {24'h12120d}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h858822}, {24'hbfdde2}, {24'hedf4c4}, {24'hfefdb1}, {24'hfefd62}, {24'hfffd03}, {24'hfffd10}, {24'hfefd95}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb1}, {24'hc5c48b}, {24'h222219}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h030404}, {24'hb0cbc2}, {24'hdaead6}, {24'hfefdb2}, {24'hfefd76}, {24'hfffd02}, {24'hfffd17}, {24'hfefd8b}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hc0bf86}, {24'h161610}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h505f70}, {24'hbddcf3}, {24'hf7fab9}, {24'hfefda8}, {24'hfffd08}, {24'hfffd18}, {24'hfefd93}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'ha4a474}, {24'h070705}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h252c34}, {24'hb0d1f4}, {24'hf1f6bf}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefd95}, {24'hfefdab}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefda2}, {24'h98974a}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h040403}, {24'h8aa3bb}, {24'he3efcd}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb0}, {24'hfefd73}, {24'hfffd1d}, {24'haeac07}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h474633}, {24'hf2f4b7}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'he0df9e}, {24'hc6c558}, {24'hfffd02}, {24'hfffd00}, {24'hbcba08}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd36 : pattern <= {{24'h27271c}, {24'hdcdb9b}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hcecd92}, {24'h494935}, {24'h040403}, {24'h000000}, {24'h575608}, {24'hefed03}, {24'hdedc09}, {24'h110c0f}, {24'h503a46}, {24'h5c4351}, {24'h59414e}, {24'h261c22}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd37 : pattern <= {{24'h8b8a63}, {24'hfefdb2}, {24'hfefdb2}, {24'hfefdb2}, {24'hfbfab0}, {24'hcbca8f}, {24'h636347}, {24'h030302}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040303}, {24'hb3aa1e}, {24'hfbdc5c}, {24'hecaacd}, {24'hf6b0d6}, {24'hcc93b2}, {24'h9d7189}, {24'h7c5b6d}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd38 : pattern <= {{24'h9a996d}, {24'hfdfcb1}, {24'hdbda9a}, {24'h878760}, {24'h333324}, {24'h080806}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h4c3842}, {24'hc890af}, {24'hcd95b0}, {24'h956c82}, {24'h90697e}, {24'h8f687d}, {24'haf7f99}, {24'h79596a}, {24'h030303}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd39 : pattern <= {{24'h69694b}, {24'h8a8a62}, {24'h191912}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h846073}, {24'h775768}, {24'h1e171b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd2 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'he7d935}, {24'hbfb32c}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h7d751d}, {24'h4e4912}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h413d0f}, {24'h6d6619}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h1d1b07}, {24'ha49a26}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h272509}, {24'he8d936}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'he7d935}, {24'h2f2c0b}, {24'h070702}, {24'h111004}, {24'he7d935}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h1a1806}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h131204}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h33300c}, {24'h010100}, {24'hbbaf2b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h2b280a}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h2b280a}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h877f1f}, {24'h060501}, {24'h4d4812}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h2b280a}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h151405}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h222008}, {24'he7d935}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'he7d935}, {24'hf7e839}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd3 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'h736c1b}, {24'h5a5415}, {24'h0d0c03}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h554f14}, {24'hffef3b}, {24'hffef3b}, {24'hfded3b}, {24'hffef3b}, {24'h444110}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc8bb2e}, {24'hffef3b}, {24'hffef3b}, {24'hebdc36}, {24'hffef3b}, {24'hf7e839}, {24'hffef3b}, {24'h080702}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hbeb22c}, {24'hfdee3b}, {24'he9db36}, {24'h978d23}, {24'hccbf2f}, {24'hffef3b}, {24'hffef3b}, {24'hc7bb2e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc9bc2e}, {24'hffef3b}, {24'hd1c430}, {24'h676118}, {24'h7b731c}, {24'hfaea3a}, {24'hffef3b}, {24'hffef3b}, {24'h81791e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h6f681a}, {24'hffef3b}, {24'hffef3b}, {24'h70691a}, {24'h635d17}, {24'hcfc230}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h312e0b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h928922}, {24'hffef3b}, {24'hffef3b}, {24'hd9cb32}, {24'h222008}, {24'hc4b72e}, {24'hc1b52d}, {24'hf4e538}, {24'hffef3b}, {24'hddcf33}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf4e538}, {24'hffef3b}, {24'hffef3b}, {24'h81791e}, {24'h171606}, {24'h78701c}, {24'hfded3b}, {24'hffef3b}, {24'hffef3b}, {24'h877e1f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h605a16}, {24'hffef3b}, {24'hf0e137}, {24'h575214}, {24'h484311}, {24'h8b8220}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h111104}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha29725}, {24'hf7e839}, {24'hf7e839}, {24'he6d835}, {24'h232108}, {24'ha29825}, {24'he7d835}, {24'hffef3b}, {24'hffef3b}, {24'he8da36}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he2d434}, {24'hffef3b}, {24'hdfd134}, {24'h34310c}, {24'h36330c}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'ha39926}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h474211}, {24'hffef3b}, {24'hffef3b}, {24'hccbf2f}, {24'h7e761d}, {24'h867e1f}, {24'hcbbe2f}, {24'hffef3b}, {24'hffef3b}, {24'h37340c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h8c8421}, {24'hffef3b}, {24'hffef3b}, {24'heee037}, {24'h2a2709}, {24'h534d13}, {24'hecdd37}, {24'hffef3b}, {24'hd8ca32}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc6ba2e}, {24'hffef3b}, {24'hcdc02f}, {24'h8e8521}, {24'h423d0f}, {24'hf0e137}, {24'hfeee3b}, {24'hffef3b}, {24'h7f771d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc0b42c}, {24'hecdd37}, {24'hffef3b}, {24'h827a1e}, {24'h696318}, {24'hebdd36}, {24'hffef3b}, {24'hcbbe2f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h504b12}, {24'hffef3b}, {24'hffef3b}, {24'h776f1b}, {24'he1d334}, {24'hfcec3a}, {24'haca128}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h81781e}, {24'hffef3b}, {24'hfaea3a}, {24'hf7e739}, {24'hffef3b}, {24'hffef3b}, {24'h5c5615}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h696218}, {24'haea328}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hc2b62d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he4d535}, {24'hffef3b}, {24'hffef3b}, {24'h978e23}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h211f07}, {24'h605a16}, {24'hb3a829}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd4 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h524d13}, {24'h6a6319}, {24'h7b731c}, {24'hffef3b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h776f1b}, {24'h9a9024}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h655f17}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha39926}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hf3e438}, {24'hfeef3b}, {24'hffef3b}, {24'ha99f27}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h867e1f}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'haca128}, {24'haa9f27}, {24'hd5c831}, {24'hfeee3b}, {24'h968d23}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h655f17}, {24'hfded3b}, {24'hffef3b}, {24'hffef3b}, {24'h9a9124}, {24'h534d13}, {24'h595314}, {24'he6d735}, {24'hffef3b}, {24'h918822}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h282609}, {24'hffef3b}, {24'heee037}, {24'hbcb02b}, {24'hb2a729}, {24'h322f0c}, {24'h847b1e}, {24'hcec130}, {24'hffef3b}, {24'hecde37}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he6d735}, {24'hffef3b}, {24'hf6e739}, {24'h554f14}, {24'h131305}, {24'hb9ad2b}, {24'he0d234}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h040401}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc1b52d}, {24'hffef3b}, {24'headb36}, {24'headc36}, {24'h3a360d}, {24'h4e4912}, {24'h867d1f}, {24'hfcec3a}, {24'hffef3b}, {24'hffef3b}, {24'h6e6719}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h8d8421}, {24'hffef3b}, {24'hf5e639}, {24'h4f4a12}, {24'h34310c}, {24'h89801f}, {24'hffef3b}, {24'hf5e538}, {24'hfbeb3a}, {24'hffef3b}, {24'h958c22}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hfeee3b}, {24'hffef3b}, {24'h736c1b}, {24'h504b12}, {24'hdcce33}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hbcb02c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf3e438}, {24'hb4a929}, {24'h877f1f}, {24'h5c5615}, {24'hffef3b}, {24'hf5e639}, {24'hffef3b}, {24'hffef3b}, {24'he4d535}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc3b72d}, {24'hffef3b}, {24'h9c9324}, {24'h0f0e03}, {24'ha29825}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h121104}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h8d8421}, {24'hffef3b}, {24'hd2c531}, {24'h29270a}, {24'hada228}, {24'hb6ab2a}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h232108}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hddcf33}, {24'hf8e839}, {24'h464210}, {24'h9f9625}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h766f1b}, {24'h38340d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'heedf37}, {24'hf3e438}, {24'hc5b92d}, {24'hedde36}, {24'hffef3b}, {24'hffef3b}, {24'h716a1a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc5b92e}, {24'hffef3b}, {24'hffef3b}, {24'hfbeb3a}, {24'hfeee3b}, {24'hffef3b}, {24'h8b8220}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf1e238}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'ha39926}, {24'h847c1f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'h7d751d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h555014}, {24'h7c741d}, {24'h5b5615}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd5 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c0c03}, {24'h111004}, {24'h100f04}, {24'h0d0c03}, {24'h0b0a02}, {24'h080702}, {24'h050501}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h151305}, {24'h1c1a06}, {24'heedf37}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hf6e739}, {24'h040301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h211f08}, {24'hf6e739}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hfeee3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hf8e939}, {24'hf5e539}, {24'hf0e138}, {24'headb36}, {24'hd1c430}, {24'h020201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd11 : pattern <= {{24'h161505}, {24'hfcec3a}, {24'hffef3b}, {24'hf7e839}, {24'hecdd37}, {24'hf1e238}, {24'hf8e839}, {24'hfded3b}, {24'hdccf32}, {24'hffef3b}, {24'hffef3b}, {24'hfeee3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hddcf33}, {24'hd3c631}, {24'hcfc230}, {24'h020200}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd12 : pattern <= {{24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hc4b72d}, {24'h534e13}, {24'h696218}, {24'h999024}, {24'hdbcd33}, {24'h111004}, {24'hf6e639}, {24'hf9e93a}, {24'hb9ad2a}, {24'hffef3b}, {24'hffef3b}, {24'h524d13}, {24'hffef3b}, {24'hffef3b}, {24'he9da35}, {24'hf8e939}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hd7ca32}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd13 : pattern <= {{24'ha39926}, {24'hffef3b}, {24'hffef3b}, {24'he9da35}, {24'h8a8120}, {24'h524d13}, {24'h2f2c0b}, {24'h35320c}, {24'h0a0903}, {24'h232108}, {24'h191805}, {24'h020200}, {24'h2b280a}, {24'h2d2a0b}, {24'h080702}, {24'h33300c}, {24'h222008}, {24'h322f0c}, {24'he9da35}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hfbeb3a}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd14 : pattern <= {{24'h040301}, {24'hc8bc2e}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hfaea3a}, {24'h3e3a0e}, {24'hffef3b}, {24'hfaea3a}, {24'h3b380e}, {24'hffef3b}, {24'hf9e93a}, {24'h877f1f}, {24'hf6e739}, {24'hf2e338}, {24'hf1e138}, {24'hfded3b}, {24'hffef3b}, {24'hffef3b}, {24'hf8e839}, {24'h1d1b07}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h040401}, {24'hbdb12c}, {24'hded033}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hfeee3b}, {24'he9db36}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hfcec3a}, {24'hffef3b}, {24'hffef3b}, {24'hffef3b}, {24'hefe037}, {24'h181605}, {24'h1a1806}, {24'h171505}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h060601}, {24'hcfc230}, {24'he3d535}, {24'he9db36}, {24'heddf37}, {24'hf1e238}, {24'hf4e538}, {24'hf8e839}, {24'hfbec3a}, {24'hffef3b}, {24'hffef3b}, {24'he3d434}, {24'h0a0902}, {24'h0c0c03}, {24'h0d0c03}, {24'h0b0a03}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h030301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {5{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd6 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h010101}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd5 : pattern <= {{24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {16{24'h0}}};
					10'd6 : pattern <= {{24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {16{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {16{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {16{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {16{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h837e48}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {16{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd7 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd8 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd9 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'hf44336}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hffffff}, {24'hffffff}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf44336}, {24'hf44336}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {15{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd10 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h007166}, {24'h007d71}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h00796e}, {24'h009284}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h00534c}, {24'h008579}, {24'h00322d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000404}, {24'h042e30}, {24'h0e7683}, {24'h20749f}, {24'h20749f}, {24'h197b9a}, {24'h094e56}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h176885}, {24'h358591}, {24'h73b06e}, {24'hd5dd48}, {24'hd5dd48}, {24'haecb57}, {24'h559e7d}, {24'h1c6f94}, {24'h073b41}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h27649c}, {24'h95be62}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hffeb3b}, {24'hffeb3b}, {24'he3e244}, {24'h366fa0}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h13536c}, {24'h559e7d}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc1d450}, {24'h236799}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h2f6ca3}, {24'hdcdf46}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h519881}, {24'h0e5565}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h074349}, {24'h63a378}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc6d84c}, {24'h196b8a}, {24'h000808}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h71681a}, {24'haa9d27}, {24'haa9d27}, {24'haa9d27}, {24'hb8aa2b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h043b3b}, {24'h519881}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8d350}, {24'h176885}, {24'h000404}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h286aa5}, {24'hc1d450}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'h3e8590}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c4654}, {24'h4a9683}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haecb57}, {24'h1c678d}, {24'h000808}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h1c5a82}, {24'h619b7e}, {24'he3e244}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'haecb57}, {24'h2c62a3}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h0e5d6c}, {24'h2a7c98}, {24'h519881}, {24'haacf55}, {24'haacf55}, {24'h87b967}, {24'h3a898e}, {24'h196b8a}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h043b3b}, {24'h156680}, {24'h156680}, {24'h0e5565}, {24'h002a26}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd11 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h007166}, {24'h007d71}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h00796e}, {24'h009284}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h00534c}, {24'h008579}, {24'h00322d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000404}, {24'h042e30}, {24'h0e7683}, {24'h20749f}, {24'h20749f}, {24'h197b9a}, {24'h094e56}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h176885}, {24'h358591}, {24'h73b06e}, {24'hd5dd48}, {24'hd5dd48}, {24'haecb57}, {24'h559e7d}, {24'h1c6f94}, {24'h073b41}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h27649c}, {24'h95be62}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'ha39626}, {24'hffeb3b}, {24'he3e244}, {24'h366fa0}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h13536c}, {24'h559e7d}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h80761e}, {24'hffeb3b}, {24'hffeb3b}, {24'hc1d450}, {24'h236799}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h2f6ca3}, {24'hdcdf46}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hd5c431}, {24'hd5c431}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h519881}, {24'h0e5565}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h074349}, {24'h63a378}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8aa2b}, {24'he3d134}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc6d84c}, {24'h196b8a}, {24'h000808}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h877c1f}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h71681a}, {24'haa9d27}, {24'haa9d27}, {24'haa9d27}, {24'hb8aa2b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h043b3b}, {24'h519881}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8d350}, {24'h176885}, {24'h000404}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h286aa5}, {24'hc1d450}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'h3e8590}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c4654}, {24'h4a9683}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haecb57}, {24'h1c678d}, {24'h000808}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h1c5a82}, {24'h619b7e}, {24'he3e244}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'haecb57}, {24'h2c62a3}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h0e5d6c}, {24'h2a7c98}, {24'h519881}, {24'haacf55}, {24'haacf55}, {24'h87b967}, {24'h3a898e}, {24'h196b8a}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h043b3b}, {24'h156680}, {24'h156680}, {24'h0e5565}, {24'h002a26}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd12 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h007166}, {24'h007d71}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h00796e}, {24'h009284}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h00534c}, {24'h008579}, {24'h00322d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000404}, {24'h042e30}, {24'h0e7683}, {24'h20749f}, {24'h20749f}, {24'h197b9a}, {24'h094e56}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h176885}, {24'h358591}, {24'h73b06e}, {24'hd5dd48}, {24'hd5dd48}, {24'haecb57}, {24'h559e7d}, {24'h1c6f94}, {24'h073b41}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h27649c}, {24'h95be62}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'he3e244}, {24'h366fa0}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h13536c}, {24'h559e7d}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf1de38}, {24'hb1a329}, {24'hc1d450}, {24'h236799}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h2f6ca3}, {24'hdcdf46}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h877c1f}, {24'hffeb3b}, {24'hffeb3b}, {24'h519881}, {24'h0e5565}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h074349}, {24'h63a378}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'hf1de38}, {24'hffeb3b}, {24'hffeb3b}, {24'hc6d84c}, {24'h196b8a}, {24'h000808}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc6b72e}, {24'hdcca33}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h6a6219}, {24'haa9d27}, {24'haa9d27}, {24'haa9d27}, {24'hb8aa2b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h043b3b}, {24'h519881}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8d350}, {24'h176885}, {24'h000404}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h286aa5}, {24'hc1d450}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'h3e8590}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c4654}, {24'h4a9683}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haecb57}, {24'h1c678d}, {24'h000808}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h1c5a82}, {24'h619b7e}, {24'he3e244}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'haecb57}, {24'h2c62a3}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h0e5d6c}, {24'h2a7c98}, {24'h519881}, {24'haacf55}, {24'haacf55}, {24'h87b967}, {24'h3a898e}, {24'h196b8a}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h043b3b}, {24'h156680}, {24'h156680}, {24'h0e5565}, {24'h002a26}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd13 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h007166}, {24'h007d71}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h00796e}, {24'h009284}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h00534c}, {24'h008579}, {24'h00322d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000404}, {24'h042e30}, {24'h0e7683}, {24'h20749f}, {24'h20749f}, {24'h197b9a}, {24'h094e56}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h176885}, {24'h358591}, {24'h73b06e}, {24'hd5dd48}, {24'hd5dd48}, {24'haecb57}, {24'h559e7d}, {24'h1c6f94}, {24'h073b41}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h27649c}, {24'h95be62}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'he3e244}, {24'h366fa0}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h13536c}, {24'h559e7d}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc1d450}, {24'h236799}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h2f6ca3}, {24'hdcdf46}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h519881}, {24'h0e5565}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h074349}, {24'h63a378}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'he3d134}, {24'ha39626}, {24'hc6d84c}, {24'h196b8a}, {24'h000808}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf1de38}, {24'ha39626}, {24'hc6b72e}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h958922}, {24'h474110}, {24'h9c9024}, {24'haa9d27}, {24'hb8aa2b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h043b3b}, {24'h519881}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8d350}, {24'h176885}, {24'h000404}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h286aa5}, {24'hc1d450}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'h3e8590}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c4654}, {24'h4a9683}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haecb57}, {24'h1c678d}, {24'h000808}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h1c5a82}, {24'h619b7e}, {24'he3e244}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'haecb57}, {24'h2c62a3}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h0e5d6c}, {24'h2a7c98}, {24'h519881}, {24'haacf55}, {24'haacf55}, {24'h87b967}, {24'h3a898e}, {24'h196b8a}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h043b3b}, {24'h156680}, {24'h156680}, {24'h0e5565}, {24'h002a26}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd14 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h007166}, {24'h007d71}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h00796e}, {24'h009284}, {24'h002e2a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h00534c}, {24'h008579}, {24'h00322d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000404}, {24'h042e30}, {24'h0e7683}, {24'h20749f}, {24'h20749f}, {24'h197b9a}, {24'h094e56}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h176885}, {24'h358591}, {24'h73b06e}, {24'hd5dd48}, {24'hd5dd48}, {24'haecb57}, {24'h559e7d}, {24'h1c6f94}, {24'h073b41}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h27649c}, {24'h95be62}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'he3e244}, {24'h366fa0}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h13536c}, {24'h559e7d}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc1d450}, {24'h236799}, {24'h00110f}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00211e}, {24'h2f6ca3}, {24'hdcdf46}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h519881}, {24'h0e5565}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h074349}, {24'h63a378}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hc6d84c}, {24'h196b8a}, {24'h000808}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hdcca33}, {24'hc6b72e}, {24'haa9d27}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haa9d27}, {24'h80761e}, {24'h2b270a}, {24'h71681a}, {24'h958922}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h156680}, {24'haacf55}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'h20749f}, {24'h001917}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h043b3b}, {24'h519881}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hb8d350}, {24'h176885}, {24'h000404}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h286aa5}, {24'hc1d450}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'h3e8590}, {24'h074349}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0c4654}, {24'h4a9683}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'haecb57}, {24'h1c678d}, {24'h000808}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h1c5a82}, {24'h619b7e}, {24'he3e244}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hffeb3b}, {24'hf8e93d}, {24'haecb57}, {24'h2c62a3}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000808}, {24'h0e5d6c}, {24'h2a7c98}, {24'h519881}, {24'haacf55}, {24'haacf55}, {24'h87b967}, {24'h3a898e}, {24'h196b8a}, {24'h042a2c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00110f}, {24'h043b3b}, {24'h156680}, {24'h156680}, {24'h0e5565}, {24'h002a26}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {10{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd15 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h2c12ff}, {24'he600ff}, {24'he600ff}, {24'hea00fa}, {24'h000000}, {24'hfd0002}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h00fbff}, {24'h00f9ff}, {24'h2c12ff}, {24'h2b13fe}, {24'h2b13fe}, {24'hc504fc}, {24'hea00fa}, {24'hea00fa}, {24'hfd0002}, {24'hfd0002}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h39d18d}, {24'h0ef1e0}, {24'h02a4fd}, {24'h0175fd}, {24'h2b13fe}, {24'h9409ff}, {24'hb805ff}, {24'hd702fc}, {24'heb00ec}, {24'heb00ec}, {24'heb00f2}, {24'hf9004a}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h39d18d}, {24'h39d18d}, {24'h39d18d}, {24'h018cfd}, {24'h0175fd}, {24'h0037fe}, {24'h1f15ff}, {24'hb805ff}, {24'hb405ff}, {24'hd902f2}, {24'heb00f2}, {24'hea00fd}, {24'hea00fd}, {24'hed00a4}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h30ff00}, {24'h34ef30}, {24'h00fbfc}, {24'h00fbfc}, {24'h018cfd}, {24'h0018ff}, {24'h0018ff}, {24'h1e15ff}, {24'hb405ff}, {24'had06ff}, {24'h9e07ff}, {24'hd102fe}, {24'hea00fe}, {24'hea00fe}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h30ff00}, {24'h30ff00}, {24'h28fe28}, {24'h0efcb4}, {24'h00fbfc}, {24'h008aff}, {24'h008aff}, {24'h002bff}, {24'h0018ff}, {24'h1e15ff}, {24'h9e07ff}, {24'h9e07ff}, {24'h810af9}, {24'hc304fc}, {24'hea00fe}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h91e000}, {24'h91e000}, {24'h62ef08}, {24'h1bfd6b}, {24'h1bfd6b}, {24'h07d6d8}, {24'h008aff}, {24'h008aff}, {24'h0062ff}, {24'h0024ff}, {24'h0018ff}, {24'h0018ff}, {24'h1a15ff}, {24'h7b0bf8}, {24'h7b0bf8}, {24'h3112db}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hffd400}, {24'ha3de00}, {24'h6fee00}, {24'h48fc00}, {24'h41fc12}, {24'h0efcb2}, {24'h07fcd6}, {24'h07fcd6}, {24'h01affc}, {24'h0062ff}, {24'h0065ff}, {24'h0026ff}, {24'h0018ff}, {24'h0018ff}, {24'h1416fe}, {24'h730cf5}, {24'h2415db}, {24'h2b14db}, {24'h000000}, {8{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'hffa700}, {24'hffd400}, {24'hffd400}, {24'hfcea00}, {24'h66f900}, {24'h38fe00}, {24'h29ff24}, {24'h07fcd6}, {24'h01fcf8}, {24'h01fcf8}, {24'h00b1fc}, {24'h006cfe}, {24'h006cfe}, {24'h002fff}, {24'h0018ff}, {24'h0018ff}, {24'h0418fb}, {24'h2415db}, {24'h2313dc}, {24'h000000}, {8{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'hff6300}, {24'hffa700}, {24'hfcea00}, {24'hfcea00}, {24'hfcea00}, {24'h4bfc00}, {24'h30ff00}, {24'h2ffe04}, {24'h27fe2d}, {24'h01fcf8}, {24'h00fcfe}, {24'h00b4fe}, {24'h0096fe}, {24'h00abfe}, {24'h00b3fe}, {24'h0038ff}, {24'h0018ff}, {24'h0322fc}, {24'h0015ff}, {24'h000000}, {8{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'hff6300}, {24'hff7a00}, {24'hff8c00}, {24'hfebb00}, {24'he0ed00}, {24'hd2ee00}, {24'h4bfc00}, {24'h2ffe04}, {24'h2ffe04}, {24'h23fe41}, {24'h00fcfe}, {24'h00fcfe}, {24'h01d4fb}, {24'h00abfe}, {24'h00d9fe}, {24'h00d9fe}, {24'h0243fc}, {24'h0042ff}, {24'h0042ff}, {24'h000000}, {8{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'hff6d00}, {24'hff6400}, {24'hff8c00}, {24'hff8c00}, {24'hffa400}, {24'he9cf00}, {24'hd2ee00}, {24'hb3f100}, {24'h45fc03}, {24'h2dfe0c}, {24'h2afe1b}, {24'h23fe41}, {24'h01fcf7}, {24'h01fcf7}, {24'h05fce2}, {24'h0debba}, {24'h00d9fe}, {24'h20e2c7}, {24'h0664f3}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'hff5700}, {24'hff5900}, {24'hff5900}, {24'hff7400}, {24'hffb000}, {24'hffb000}, {24'hd9e000}, {24'hb3f100}, {24'hb0f100}, {24'ha9f200}, {24'h3ffc17}, {24'h2cfe12}, {24'h26fe34}, {24'h05fce2}, {24'h19fd76}, {24'h19fd76}, {24'h18ee8c}, {24'h20e2c7}, {24'h1de2c5}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff5600}, {24'hff6a00}, {24'hff7100}, {24'hff7c00}, {24'hffce00}, {24'hffce00}, {24'hd7e300}, {24'ha9f200}, {24'ha9f200}, {24'hb2f100}, {24'h44fc0b}, {24'h32fe0b}, {24'h4afc00}, {24'h42fc14}, {24'h23fd41}, {24'h31fd00}, {24'h2bf543}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff5700}, {24'hff7100}, {24'hff7200}, {24'hff8100}, {24'hffce00}, {24'hffdf00}, {24'hffdf00}, {24'hd9e700}, {24'hb7f100}, {24'hc2f000}, {24'h67f900}, {24'h4afc00}, {24'h74e200}, {24'h9bc900}, {24'h2ffb00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'hff1a00}, {24'hff1d00}, {24'hff1d00}, {24'hff5a00}, {24'hff7200}, {24'hff8400}, {24'hffdf00}, {24'hffdf00}, {24'hffdc00}, {24'hdbe700}, {24'hf7ea00}, {24'hf7ea00}, {24'hf7ea00}, {24'hb2be00}, {24'hb2be00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'hff1800}, {24'hff1d00}, {24'hff2900}, {24'hff2900}, {24'hff5a00}, {24'hff7200}, {24'hff7200}, {24'hff7b00}, {24'hffdc00}, {24'hffd300}, {24'hfbc900}, {24'hf7ea00}, {24'hffe500}, {24'hffe500}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff1400}, {24'hff2900}, {24'hff2a00}, {24'hff5a00}, {24'hff6b00}, {24'hff6700}, {24'hff7100}, {24'hffa800}, {24'hffa800}, {24'hff9300}, {24'hffe500}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff1000}, {24'hff2a00}, {24'hff1300}, {24'hff0700}, {24'hff6700}, {24'hff2200}, {24'hff3b00}, {24'hff9300}, {24'hff3600}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff0800}, {24'hff0700}, {24'hff0700}, {24'hff0000}, {24'hff1c00}, {24'hff2200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd16 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'heb0002}, {24'hfd0005}, {24'h9b005f}, {24'h72004a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdc00eb}, {24'h9e00a9}, {24'hef00b7}, {24'hed00d2}, {24'heb00f6}, {24'hea00fd}, {24'hea00fb}, {24'h870092}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb106fe}, {24'hd302fb}, {24'he301fa}, {24'he800ef}, {24'he700f0}, {24'he001f8}, {24'hda01fe}, {24'hd902fd}, {24'hdf01fd}, {24'h14001c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h2e12fe}, {24'h2d13fe}, {24'ha107fe}, {24'hc204fe}, {24'hc304fb}, {24'hc903f7}, {24'ha207ff}, {24'ha007fd}, {24'h9309fa}, {24'h860af8}, {24'h3013de}, {24'h2814db}, {24'h010005}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000001}, {24'h271efe}, {24'h4111fe}, {24'h6e0dff}, {24'h9e08ff}, {24'h9408ff}, {24'ha107ff}, {24'ha107ff}, {24'h6a0dff}, {24'h640dfa}, {24'h5b0ef9}, {24'h4c10f0}, {24'h2415db}, {24'h1d15e2}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h005152}, {24'h02c3fe}, {24'h0277fd}, {24'h0b48fe}, {24'h0b27fe}, {24'h1616ff}, {24'h1416ff}, {24'h1d15ff}, {24'h2d13ff}, {24'h0817ff}, {24'h0b17ff}, {24'h0b17fe}, {24'h0318fc}, {24'h071af8}, {24'h0228fd}, {24'h002db2}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h0c8477}, {24'h09c2ed}, {24'h018afd}, {24'h017bfd}, {24'h0030ff}, {24'h0036ff}, {24'h0029ff}, {24'h011fff}, {24'h001eff}, {24'h001bff}, {24'h001eff}, {24'h002fff}, {24'h002fff}, {24'h012ffe}, {24'h0145fd}, {24'h012163}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h38d28e}, {24'h35d494}, {24'h06cef1}, {24'h00cffc}, {24'h0084ff}, {24'h008aff}, {24'h0068ff}, {24'h0053ff}, {24'h0053ff}, {24'h0054fe}, {24'h0060ff}, {24'h00affe}, {24'h00b1fe}, {24'h01bffc}, {24'h17b5d6}, {24'h1096e1}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h39d387}, {24'h2aea74}, {24'h04fbe9}, {24'h03fbef}, {24'h01b2f6}, {24'h0092fc}, {24'h019afd}, {24'h0080fe}, {24'h007dfe}, {24'h008bfe}, {24'h00a4fe}, {24'h00affe}, {24'h05dee5}, {24'h04dfe8}, {24'h13e4c0}, {24'h1bbd98}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h25be0b}, {24'h2ffa19}, {24'h1dfd62}, {24'h13f895}, {24'h08e1d4}, {24'h06f1da}, {24'h02e7f1}, {24'h01e6f9}, {24'h00dffe}, {24'h00d1fe}, {24'h01ddfc}, {24'h02e2f4}, {24'h0af8c5}, {24'h16f886}, {24'h21f655}, {24'h2ef215}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h1fa400}, {24'h3bfc02}, {24'h28fb50}, {24'h1ffd6b}, {24'h0dfcb9}, {24'h06fcd9}, {24'h0cfdbb}, {24'h0bfdc4}, {24'h09fdcd}, {24'h03fcec}, {24'h01fbf9}, {24'h04fce8}, {24'h12fd9c}, {24'h29fd49}, {24'h36f62b}, {24'h2ce900}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h3fa300}, {24'h7de703}, {24'h4bf90b}, {24'h40fc0d}, {24'h2afe2b}, {24'h22fe46}, {24'h2dfe10}, {24'h2afe1c}, {24'h26fe30}, {24'h23fe40}, {24'h1ffe59}, {24'h21fd55}, {24'h39fc36}, {24'h51f50b}, {24'h8ad401}, {24'h658100}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h8ed500}, {24'h7ee900}, {24'h7cf500}, {24'h5afa00}, {24'h41fd02}, {24'h3cfe00}, {24'h36fe03}, {24'h34fe06}, {24'h35fd0f}, {24'h38fd19}, {24'h3bfd10}, {24'h37fd0d}, {24'h4dfc03}, {24'h6bf300}, {24'ha2c700}, {24'h717600}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hd8d300}, {24'hd6dc00}, {24'hfce900}, {24'he8ec00}, {24'hbaf100}, {24'habf200}, {24'h88f500}, {24'h6cf802}, {24'h9ef301}, {24'h93f405}, {24'h9bf302}, {24'h9df403}, {24'ha2f300}, {24'hefeb00}, {24'hf0e000}, {24'h928300}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'he5b700}, {24'hfed500}, {24'hfcea00}, {24'hfbd100}, {24'he5e100}, {24'hd9e600}, {24'hc5ec00}, {24'hb4f000}, {24'habf200}, {24'hb9ee00}, {24'hc1ee00}, {24'hd2ec00}, {24'hf7e700}, {24'hf7ea00}, {24'hfee100}, {24'h584f00}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h070500}, {24'hff8d00}, {24'hff9a00}, {24'hfe9a00}, {24'hff9f00}, {24'hf9b000}, {24'hf4bf00}, {24'he6d700}, {24'he0de00}, {24'hdfe500}, {24'hf7e100}, {24'hf3e000}, {24'hebe000}, {24'hfbcf00}, {24'hfcbc00}, {24'hf49700}, {24'h090800}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h381500}, {24'hff6d00}, {24'hff8700}, {24'hff8700}, {24'hff9d00}, {24'hffaa00}, {24'hffcc00}, {24'hfecf00}, {24'hffd900}, {24'hffdf00}, {24'hffc100}, {24'hffd100}, {24'hffb400}, {24'hff9d00}, {24'hff7a00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc54d00}, {24'hff7000}, {24'hff6200}, {24'hff7400}, {24'hff7900}, {24'hff8500}, {24'hff9000}, {24'hff9600}, {24'hff9700}, {24'hff7400}, {24'hff7500}, {24'hff5b00}, {24'hf94200}, {24'h110900}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff5b00}, {24'hff5800}, {24'hff6200}, {24'hff6900}, {24'hff7100}, {24'hff6400}, {24'hff6700}, {24'hff6c00}, {24'hff6a00}, {24'hff6500}, {24'hff6500}, {24'hff2e00}, {24'hff2100}, {24'h040100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020100}, {24'hff3500}, {24'hff4500}, {24'hff4a00}, {24'hff2e00}, {24'hff3200}, {24'hff3300}, {24'hff3c00}, {24'hff4200}, {24'hff1900}, {24'hff1b00}, {24'hff0600}, {24'hff0c00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'h810600}, {24'hff1b00}, {24'hff1d00}, {24'hff2400}, {24'hff2400}, {24'hff2300}, {24'hff2600}, {24'hff0c00}, {24'hff0600}, {24'hff0100}, {24'h320000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h620a00}, {24'hff1600}, {24'hff0500}, {24'hff0800}, {24'hff0a00}, {24'hff0a00}, {24'hff0500}, {24'hfc0000}, {24'h0e0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h520000}, {24'hff0000}, {24'ha80000}, {24'hff0000}, {24'hf30000}, {24'he70000}, {24'hff0000}, {24'h280000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h370000}, {24'h000000}, {24'h1a0000}, {24'h2c0000}, {24'h110000}, {24'h160000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd17 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h270021}, {24'h7a007e}, {24'h82008e}, {24'h520060}, {24'h110225}, {24'h130967}, {24'h060427}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h28000d}, {24'h7d005e}, {24'hb800b1}, {24'hd500e7}, {24'hc802ec}, {24'h9906dc}, {24'h540dd3}, {24'h2914dd}, {24'h191ae8}, {24'h0724cb}, {24'h011b5d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h2a0006}, {24'h9d0048}, {24'hd600b3}, {24'he100ea}, {24'hd102fa}, {24'had06fb}, {24'h8809f7}, {24'h620ef6}, {24'h3214f6}, {24'h0e1df9}, {24'h0434f3}, {24'h064fb8}, {24'h06394c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h680042}, {24'hc80095}, {24'he700dc}, {24'hd902f5}, {24'hb805fc}, {24'h8c09fd}, {24'h5a0efc}, {24'h2714fd}, {24'h071bfe}, {24'h0030ff}, {24'h0362fa}, {24'h0ba8e6}, {24'h14b9a2}, {24'h0d5a31}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h19001a}, {24'h960097}, {24'hd001d7}, {24'hd902f2}, {24'hc603f8}, {24'ha507fd}, {24'h6e0cff}, {24'h2d13ff}, {24'h081cff}, {24'h003cff}, {24'h007dfe}, {24'h01bef6}, {24'h09e2d8}, {24'h17e996}, {24'h22c33a}, {24'h123f03}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h370142}, {24'hb302dc}, {24'hc503f7}, {24'hc004fc}, {24'ha407fd}, {24'h6f0cff}, {24'h3113ff}, {24'h0c19ff}, {24'h0029ff}, {24'h005eff}, {24'h01aafb}, {24'h05d5e7}, {24'h0eeeb5}, {24'h1ff66e}, {24'h38e62a}, {24'h468f04}, {24'h040500}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h30045c}, {24'h8909fb}, {24'h9309fe}, {24'h880aff}, {24'h5f0fff}, {24'h2c15ff}, {24'h0a1fff}, {24'h0230ff}, {24'h0051ff}, {24'h0083fe}, {24'h00b1fc}, {24'h04d7ec}, {24'h0ffab5}, {24'h27fb5d}, {24'h50ed1c}, {24'h7dbb04}, {24'h5d6300}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h1c076c}, {24'h4914fd}, {24'h4f18fe}, {24'h3b19ff}, {24'h1f1cff}, {24'h082eff}, {24'h013fff}, {24'h0056ff}, {24'h0075fe}, {24'h009efe}, {24'h00d1fa}, {24'h04f1e9}, {24'h12fcad}, {24'h31fb4a}, {24'h60f305}, {24'ha2dc00}, {24'hafaa00}, {24'h544b00}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h050623}, {24'h2433fd}, {24'h1a44fe}, {24'h0c41fe}, {24'h0541ff}, {24'h0164ff}, {24'h0070ff}, {24'h0084fe}, {24'h00b3fc}, {24'h00e1fd}, {24'h02f6f1}, {24'h0cfcba}, {24'h21fd63}, {24'h3cfc24}, {24'h6ef700}, {24'hc9ea00}, {24'hebd700}, {24'hb09300}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h01070b}, {24'h0e77fb}, {24'h0578fc}, {24'h0183fd}, {24'h0084fd}, {24'h008dfd}, {24'h02a1f7}, {24'h02caf4}, {24'h02f1f4}, {24'h06fbdc}, {24'h14fd91}, {24'h28fe34}, {24'h39fc17}, {24'h59fa09}, {24'h9af401}, {24'hece800}, {24'hfad900}, {24'heea500}, {24'h211000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h012427}, {24'h0ebae8}, {24'h0d9ee5}, {24'h02c7fb}, {24'h02d0f1}, {24'h03bdea}, {24'h05d3e4}, {24'h05f2e7}, {24'h15fc93}, {24'h21fe4a}, {24'h29fe21}, {24'h40fc17}, {24'h68f80c}, {24'h94f304}, {24'hcded00}, {24'hf5e000}, {24'hfcc600}, {24'hff9500}, {24'h773200}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h1aa791}, {24'h29c59f}, {24'h0cedcd}, {24'h0df6bc}, {24'h0feca8}, {24'h0bf3c2}, {24'h0efcb5}, {24'h26fe35}, {24'h2dfe0c}, {24'h35fe09}, {24'h81f605}, {24'ha0f303}, {24'hc3ed00}, {24'hdde600}, {24'hf5d700}, {24'hfdaf00}, {24'hff7700}, {24'haa3500}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h165d42}, {24'h30cc51}, {24'h22f665}, {24'h1ffc6b}, {24'h21fb63}, {24'h21fc68}, {24'h27fe43}, {24'h32fe0d}, {24'h47fc03}, {24'h66f802}, {24'ha3f100}, {24'hb6ee00}, {24'hdfe600}, {24'hf6d700}, {24'hfdbf00}, {24'hff8f00}, {24'hff5300}, {24'he42b00}, {24'h2e0500}, {24'h000000}, {8{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h1b7b1d}, {24'h28d919}, {24'h39f527}, {24'h3bfa28}, {24'h3ffc1e}, {24'h4bfb0c}, {24'h71f801}, {24'h9af400}, {24'hb4f000}, {24'hc3ea00}, {24'hd8e400}, {24'hf5dd00}, {24'hfec200}, {24'hff9800}, {24'hff6d00}, {24'hff4300}, {24'hfe2200}, {24'h7c0700}, {24'h000000}, {8{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1e8903}, {24'h4ed407}, {24'h62f008}, {24'h7df504}, {24'hb3f101}, {24'hd0ee00}, {24'hd7e800}, {24'hdcdf00}, {24'he9d600}, {24'hf5d000}, {24'hfcc200}, {24'hff9e00}, {24'hff7800}, {24'hff4e00}, {24'hff2b00}, {24'hfd1400}, {24'h710300}, {24'h000000}, {8{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0d2700}, {24'h519700}, {24'h8cd900}, {24'hc1e900}, {24'hebe300}, {24'hf5d300}, {24'hf4c300}, {24'hfab800}, {24'hfeb800}, {24'hffad00}, {24'hff8e00}, {24'hff7200}, {24'hff5c00}, {24'hff3500}, {24'hff1600}, {24'hfc0800}, {24'h7a0100}, {24'h000000}, {8{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h465800}, {24'habb400}, {24'he8db00}, {24'hfacb00}, {24'hfdad00}, {24'hfea000}, {24'hff9900}, {24'hff8e00}, {24'hff7d00}, {24'hff6700}, {24'hff5300}, {24'hff3f00}, {24'hff2700}, {24'hff1200}, {24'hfc0600}, {24'ha50100}, {24'h1f0000}, {8{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h7d6700}, {24'hdfaa00}, {24'hfea500}, {24'hff9000}, {24'hff8400}, {24'hff7600}, {24'hff7000}, {24'hff6200}, {24'hff4600}, {24'hff3300}, {24'hff2600}, {24'hfd1800}, {24'hf50b00}, {24'hd50300}, {24'h7c0000}, {24'h0b0000}, {8{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h080600}, {24'h714500}, {24'hb85c00}, {24'hf06e00}, {24'hff6c00}, {24'hff6400}, {24'hff6000}, {24'hfe4800}, {24'hfe2a00}, {24'hff1f00}, {24'hfb1600}, {24'he50900}, {24'hbb0200}, {24'h760000}, {24'h040000}, {24'h000000}, {8{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h712d00}, {24'hea5500}, {24'hfe5500}, {24'hfa4500}, {24'hec2b00}, {24'hec1d00}, {24'hf11400}, {24'hdb0800}, {24'h8f0100}, {24'h530000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h260b00}, {24'h831100}, {24'h8f0600}, {24'h6e0900}, {24'h690900}, {24'h710600}, {24'h790100}, {24'h190000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd18 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0f118e}, {24'h0729d1}, {24'h086dd1}, {24'h11bab9}, {24'h1cc75c}, {24'h33b920}, {24'h487302}, {24'h6b6c00}, {24'h5b5200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h330b99}, {24'h2617f2}, {24'h0826fb}, {24'h0374f8}, {24'h08d9dd}, {24'h19f08a}, {24'h3cf038}, {24'h72db0c}, {24'habce00}, {24'hd4bd00}, {24'hbe8c00}, {24'h562a00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h790085}, {24'h8e04c0}, {24'h6f0cee}, {24'h3114f9}, {24'h0426fe}, {24'h008ffb}, {24'h06d5e3}, {24'h10f2b2}, {24'h28fb61}, {24'h52f61c}, {24'haaed00}, {24'hede300}, {24'hfbbe00}, {24'hf38100}, {24'ha73400}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h1e001d}, {24'hca00dd}, {24'hb505f6}, {24'h7c0af9}, {24'h2c14fd}, {24'h0331ff}, {24'h0074fe}, {24'h02bcf6}, {24'h05e4e5}, {24'h19fb90}, {24'h3cfc28}, {24'h7ff604}, {24'he0e700}, {24'hf8cd00}, {24'hfe9300}, {24'hfa4a00}, {24'hec2000}, {24'h840600}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h7f006c}, {24'hd400e2}, {24'hbf04fb}, {24'h7c0bfe}, {24'h3113ff}, {24'h0424ff}, {24'h0066ff}, {24'h00b1fc}, {24'h03e5ed}, {24'h16fd8e}, {24'h3afc1e}, {24'h82f506}, {24'hd5e900}, {24'hf2d500}, {24'hfe9b00}, {24'hff6100}, {24'hff2c00}, {24'hed0b00}, {24'h820200}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'ha20077}, {24'hdd01e7}, {24'hc803f8}, {24'h8d09fe}, {24'h2f14ff}, {24'h052dff}, {24'h0066fe}, {24'h00a6fe}, {24'h03f0ea}, {24'h1bfd70}, {24'h4bfb17}, {24'h91f406}, {24'hcbeb00}, {24'hf4d600}, {24'hfea700}, {24'hff5f00}, {24'hff3300}, {24'hfe1100}, {24'hea0500}, {24'h610000}, {24'h000000}, {8{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'haf0073}, {24'hdb01d3}, {24'hc603f8}, {24'h8e09fd}, {24'h2817ff}, {24'h0437ff}, {24'h0066ff}, {24'h01c2fa}, {24'h07f5d7}, {24'h24fe3b}, {24'h4dfb0f}, {24'h95f303}, {24'hc9e900}, {24'hf7d700}, {24'hffa600}, {24'hff6800}, {24'hff3900}, {24'hfd1600}, {24'he40700}, {24'h550000}, {24'h000000}, {8{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h860070}, {24'hc602db}, {24'hbb04fb}, {24'h740cff}, {24'h2420ff}, {24'h0251ff}, {24'h0189fc}, {24'h02d3f3}, {24'h12fa9f}, {24'h28fe25}, {24'h4efb05}, {24'h9ef100}, {24'hcee600}, {24'hf4ce00}, {24'hfe9c00}, {24'hff5d00}, {24'hff3900}, {24'hfb1b00}, {24'hc20500}, {24'h580000}, {24'h000000}, {8{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h2f0032}, {24'hb203e3}, {24'h8f0afd}, {24'h5714ff}, {24'h1234ff}, {24'h0269fe}, {24'h0199f9}, {24'h05dbe3}, {24'h0ffab2}, {24'h2ffe1f}, {24'h60fa03}, {24'hb0ef00}, {24'he3d800}, {24'hfcb800}, {24'hff8500}, {24'hff5a00}, {24'hff3000}, {24'hf91800}, {24'ha80300}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h4b058c}, {24'h5013fd}, {24'h2b33fe}, {24'h0a58fe}, {24'h0194fb}, {24'h04c3e7}, {24'h0ceabb}, {24'h1bfa7c}, {24'h38fd29}, {24'h95f401}, {24'hd3e600}, {24'hf6be00}, {24'hfe9e00}, {24'hff7900}, {24'hff5000}, {24'hfd2500}, {24'hf11400}, {24'h880400}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h150f6c}, {24'h1754fd}, {24'h0784f6}, {24'h04c9f3}, {24'h0cf1c4}, {24'h1af77e}, {24'h31fb41}, {24'h5cf911}, {24'hc3ee01}, {24'hf1d400}, {24'hfbac00}, {24'hff8300}, {24'hff6d00}, {24'hfd4e00}, {24'hef2a00}, {24'h9a0f00}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0fabde}, {24'h21c7a8}, {24'h1bf08a}, {24'h2ef53e}, {24'h45f31e}, {24'h7cf205}, {24'hcce700}, {24'hf8c800}, {24'hfe9900}, {24'hff7c00}, {24'hff6400}, {24'hf54900}, {24'h870d00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1f874d}, {24'h24a92a}, {24'h26c013}, {24'h49bd05}, {24'h83d101}, {24'hd0d100}, {24'hf4b700}, {24'hf08c00}, {24'hdb5e00}, {24'hd54e00}, {24'h871a00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h475b00}, {24'h786f00}, {24'h715200}, {24'h542d00}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {8{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd19 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0f0b05}, {24'h3a2814}, {24'h493319}, {24'h50381c}, {24'h52391c}, {24'h573c1e}, {24'h583d1f}, {24'h543a1d}, {24'h392814}, {24'h040302}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0d0904}, {24'h4b341a}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h674724}, {24'h1b1209}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0b0704}, {24'h654623}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6b4b25}, {24'h2a1e0f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h0e0a05}, {24'h5f4221}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6d4c26}, {24'h362513}, {24'h040301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h0c0804}, {24'h5a3f1f}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6c4b26}, {24'h291d0e}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h020201}, {24'h553b1e}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h735129}, {24'h825e34}, {24'h866237}, {24'h7e5b31}, {24'h75522a}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h664723}, {24'h1d140a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h342412}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6d4c26}, {24'h432f18}, {24'h46341e}, {24'h977247}, {24'ha87f4f}, {24'ha87f4f}, {24'h967145}, {24'h4b351c}, {24'h573d1e}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5a3f1f}, {24'h0b0804}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd7 : pattern <= {{24'h0b0703}, {24'h6c4b25}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5e4121}, {24'h080503}, {24'h010000}, {24'h443420}, {24'ha87f4f}, {24'ha87f4f}, {24'h42321f}, {24'h010101}, {24'h0e0a05}, {24'h654723}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h2b1e0f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd8 : pattern <= {{24'h2f2110}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h7b5a34}, {24'h281e13}, {24'h19130c}, {24'h6d5233}, {24'ha87f4f}, {24'ha77f4f}, {24'h322618}, {24'h010100}, {24'h17110a}, {24'h674825}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h473219}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd9 : pattern <= {{24'h3d2a15}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h724f28}, {24'h8b653a}, {24'ha57d4d}, {24'h9e784b}, {24'h9b7649}, {24'ha77e4f}, {24'ha37b4d}, {24'ha67e4e}, {24'h997448}, {24'h84643e}, {24'h967146}, {24'h906a3e}, {24'h714f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h624422}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd10 : pattern <= {{24'h3e2b16}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h79562e}, {24'ha37b4c}, {24'ha87f4f}, {24'ha87f4f}, {24'ha67e4e}, {24'h634b2f}, {24'h20180f}, {24'h251c11}, {24'h6d5233}, {24'ha87f4f}, {24'ha87f4f}, {24'ha57c4d}, {24'h79562d}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd11 : pattern <= {{24'h3e2b16}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h7f5b31}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha67d4e}, {24'h503c25}, {24'h000000}, {24'h000000}, {24'h2a2014}, {24'ha67d4e}, {24'ha87f4f}, {24'ha87f4f}, {24'h835f35}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd12 : pattern <= {{24'h342412}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h78552d}, {24'ha2794b}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9e784a}, {24'h40301e}, {24'h3b2d1c}, {24'h967147}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h856136}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5a3e1f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd13 : pattern <= {{24'h23180c}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h886339}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h7d5a31}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6e4d26}, {24'h2c1f0f}, {24'h110c06}, {24'h0e0a05}, {24'h030201}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd14 : pattern <= {{24'h040201}, {24'h5d4120}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h876237}, {24'ha37b4b}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h987144}, {24'h725028}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6d4c26}, {24'h473219}, {24'h191209}, {2{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h010000}, {24'h362716}, {24'h916b3f}, {24'h7b582f}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h725029}, {24'h805c33}, {24'h906a3e}, {24'h9c7446}, {24'ha1794b}, {24'ha2794a}, {24'h9b7446}, {24'h8b653a}, {24'h725029}, {24'h704e27}, {24'h714f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {2{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h332618}, {24'ha87f4f}, {24'ha57d4d}, {24'h7d5930}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h896439}, {24'ha37b4c}, {24'h815d33}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6a4925}, {2{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h21190f}, {24'ha87f4f}, {24'ha87f4f}, {24'h977043}, {24'h724f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h906a3e}, {24'ha87f4f}, {24'ha27a4b}, {24'h79562e}, {24'h704e27}, {24'h704e27}, {24'h674724}, {24'h493319}, {24'h2e2010}, {24'h1e150b}, {24'h0b0804}, {2{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h16110a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha67d4e}, {24'h856036}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h967043}, {24'ha87f4f}, {24'ha87f4f}, {24'h705534}, {24'h090704}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h1e170e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9b7345}, {24'h79562d}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h9b7446}, {24'ha87f4f}, {24'ha87f4f}, {24'h9d764a}, {24'h251c11}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h3e2f1d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9a7345}, {24'h7a562e}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h7c582f}, {24'ha57d4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h765937}, {24'h0e0a06}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h4f3c25}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha0794b}, {24'h7a5a34}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h8f693e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h715535}, {24'h050403}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h533f27}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h684f31}, {24'h040302}, {24'h24190d}, {24'h51381c}, {24'h624422}, {24'h694924}, {24'h6d4c26}, {24'h6d4c26}, {24'h674824}, {24'h906c42}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h7b5c3a}, {24'h0c0906}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h634b2f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h4a3823}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050402}, {24'h0c0804}, {24'h100b05}, {24'h100b05}, {24'h090603}, {24'h130f09}, {24'h7f603c}, {24'ha67d4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h906d44}, {24'h251c11}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h6c5133}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9a7549}, {24'h221910}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h080604}, {24'h3e2f1d}, {24'h947046}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha17a4c}, {24'h694f31}, {24'h17120b}, {2{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h725635}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h87663f}, {24'h050402}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h1d160d}, {24'h4f3c25}, {24'h7d5e3b}, {24'ha27a4c}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h906d44}, {2{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h725636}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h6c5233}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0a0705}, {24'h241b11}, {24'h543f28}, {24'h81613d}, {24'ha67d4e}, {24'ha87f4f}, {24'h85643f}, {2{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h6f5434}, {24'ha87f4f}, {24'ha87f4f}, {24'ha57d4e}, {24'h41311e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050402}, {24'h15100a}, {24'h000000}, {2{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h574229}, {24'ha87f4f}, {24'ha87f4f}, {24'h8c6a42}, {24'h0a0705}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h0d0a06}, {24'h9a7549}, {24'ha77f4f}, {24'h5c462b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {2{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd20 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hbf0000}, {24'hc00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h100000}, {24'hef0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h100000}, {24'hef0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h100000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h800000}, {24'hdf0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'hff0000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd21 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h3f0000}, {24'h3f0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hbf0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'h9f0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'haf0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hbf0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hef0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hcf0000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h500000}, {24'h500000}, {24'h900000}, {24'hf00000}, {24'hff0000}, {24'hef0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf00000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h800000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hef0000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hcf0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hf00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h100000}, {24'h200000}, {24'h4f0000}, {24'hef0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hf00000}, {24'hff0000}, {24'hef0000}, {24'h6f0000}, {24'h200000}, {24'h200000}, {24'h5f0000}, {24'hdf0000}, {24'hff0000}, {24'hf00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'he00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hf00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h500000}, {24'h400000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'h500000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd22 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hbf0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hbf0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hbf0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hef0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'he00000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'h600000}, {24'hc00000}, {24'hf00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'h300000}, {24'ha00000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hd00000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'hf00000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h100000}, {24'h000000}, {24'h600000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h400000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h800000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'ha00000}, {24'h000000}, {24'hef0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'hc00000}, {24'h100000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hb00000}, {24'h400000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'hff0000}, {24'h400000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'he00000}, {24'h600000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'hff0000}, {24'hb00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h900000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'hff0000}, {24'hdf0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hf00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'hdf0000}, {24'h4f0000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hff0000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hf00000}, {24'hff0000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h030302}, {24'h030302}, {24'h030302}, {24'h030302}, {24'h020201}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h020202}, {24'h040403}, {24'h060604}, {24'h080805}, {24'h090906}, {24'h0a0a06}, {24'h0a0a06}, {24'h0b0b07}, {24'h0c0c08}, {24'h0f100a}, {24'h13140d}, {24'h15160e}, {24'h14150d}, {24'h13140d}, {24'h0f0f0a}, {24'h080805}, {24'h030302}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h020202}, {24'h030302}, {24'h070705}, {24'h0b0b07}, {24'h10100a}, {24'h11110b}, {24'h11110b}, {24'h13130c}, {24'h14150d}, {24'h16170f}, {24'h1d1e13}, {24'h242418}, {24'h28291b}, {24'h27271a}, {24'h242517}, {24'h1b1c12}, {24'h10100a}, {24'h050503}, {24'h030302}, {24'h010101}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd23 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hbf0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hbf0000}, {24'hbf0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hcd0000}, {24'hdd0000}, {24'h260000}, {24'h000000}, {24'h000000}, {24'hbf0000}, {24'hbf0000}, {24'h300000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h500000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hcf0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hd00000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'he00000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hef0000}, {24'hff0000}, {24'h700000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hd00000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h400000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'h700000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h600000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'h900000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hff0000}, {24'hc00000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hf00000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hf00000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hd00000}, {24'hff0000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'hef0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h600000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'hb00000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h600000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hb00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf00000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h410101}, {24'hff0000}, {24'hff0000}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h410101}, {24'hff0000}, {24'hff0000}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h010101}, {24'h020102}, {24'h040304}, {24'h090608}, {24'h0e0a0d}, {24'h4d0a0d}, {24'hff0000}, {24'hff0000}, {24'h0d090c}, {24'h070507}, {24'h020102}, {24'h010101}, {24'hec0000}, {24'hff0000}, {24'h2c0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h050305}, {24'h080608}, {24'h110c11}, {24'h1c141b}, {24'h241a23}, {24'h231922}, {24'h211820}, {24'h191218}, {24'h0f0a0e}, {24'h040304}, {24'h020102}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020102}, {24'h070607}, {24'h0c090c}, {24'h1c141b}, {24'h2e212c}, {24'h3b2a38}, {24'h3a2937}, {24'h382735}, {24'h2c1f2a}, {24'h1a1319}, {24'h0a070a}, {24'h060406}, {24'h020102}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030203}, {24'h090709}, {24'h110c11}, {24'h281c26}, {24'h422f40}, {24'h583e54}, {24'h5a3f56}, {24'h5c4158}, {24'h4b3548}, {24'h31222f}, {24'h1a1219}, {24'h100b0f}, {24'h060406}, {24'h020102}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040304}, {24'h0c090c}, {24'h161015}, {24'h342532}, {24'h583e54}, {24'h745270}, {24'h7b5675}, {24'h7f597a}, {24'h6b4b66}, {24'h493345}, {24'h281d26}, {24'h191218}, {24'h0b080b}, {24'h030203}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h050305}, {24'h0e0a0e}, {24'h191218}, {24'h3a2a38}, {24'h61455d}, {24'h815b7c}, {24'h8e6488}, {24'h9a6c93}, {24'h845d7f}, {24'h5e425a}, {24'h3b2a38}, {24'h291d27}, {24'h171016}, {24'h0c080b}, {24'h060406}, {24'h010001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h020102}, {24'h060406}, {24'h100c10}, {24'h1c141b}, {24'h3d2c3b}, {24'h664862}, {24'h886083}, {24'h9b6e95}, {24'haf7ba8}, {24'h9a6c94}, {24'h74516f}, {24'h4e374b}, {24'h3b2938}, {24'h271b25}, {24'h171016}, {24'h0d090c}, {24'h020102}, {24'h010001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h020102}, {24'h080508}, {24'h130e13}, {24'h1f161e}, {24'h412f3f}, {24'h694b66}, {24'h8f6589}, {24'ha877a1}, {24'hc289ba}, {24'hb17caa}, {24'h8a6184}, {24'h664862}, {24'h4f384c}, {24'h392836}, {24'h251a23}, {24'h130d13}, {24'h020102}, {24'h010001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020102}, {24'h040304}, {24'h0a070a}, {24'h171117}, {24'h251b24}, {24'h473345}, {24'h6e4e6a}, {24'h92688d}, {24'haf7ca8}, {24'hca8ec2}, {24'hc188ba}, {24'ha775a0}, {24'h8d6387}, {24'h71506d}, {24'h553b51}, {24'h392836}, {24'h1d141c}, {24'h020102}, {24'h010001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020102}, {24'h050405}, {24'h0c080c}, {24'h1b131b}, {24'h2b1f29}, {24'h4d374a}, {24'h73526f}, {24'h976b92}, {24'hb57fad}, {24'hd293c9}, {24'hd393ca}, {24'hc48abc}, {24'hb57fad}, {24'h93688e}, {24'h72506d}, {24'h4d364a}, {24'h271b25}, {24'h020102}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd24 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd25 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h060406}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h0d090c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h231a1f}, {24'h110d0c}, {24'h0d0a08}, {24'h090704}, {24'h060502}, {24'h040401}, {24'h020200}, {24'h010100}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h5d454d}, {24'h483734}, {24'h372c24}, {24'h272114}, {24'h1c180b}, {24'h121007}, {24'h090802}, {24'h060602}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h98707d}, {24'h7d615b}, {24'h614e3f}, {24'h453a23}, {24'h302b13}, {24'h201c0c}, {24'h100f04}, {24'h0a0903}, {24'h040401}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'hb88a92}, {24'ha07e6e}, {24'h846b4e}, {24'h67582f}, {24'h4f461d}, {24'h393313}, {24'h242109}, {24'h171506}, {24'h0b0a03}, {24'h030301}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'hce9d9c}, {24'hbc9579}, {24'ha38659}, {24'h8b793a}, {24'h726527}, {24'h574f1b}, {24'h3c3810}, {24'h28250a}, {24'h131105}, {24'h070602}, {24'h040401}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'he2ada2}, {24'hd5ab7f}, {24'hc1a161}, {24'had9643}, {24'h938330}, {24'h756a23}, {24'h575016}, {24'h3c370f}, {24'h201d08}, {24'h0e0d03}, {24'h080702}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'he6b692}, {24'hdcb676}, {24'hd0b15c}, {24'hc4ad42}, {24'hb19f33}, {24'h9a8b28}, {24'h80761e}, {24'h615917}, {24'h403a0f}, {24'h27230a}, {24'h171506}, {24'h060502}, {24'h030301}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'heabf82}, {24'he4c06b}, {24'he0c257}, {24'hdcc443}, {24'hcfbb36}, {24'hbeac2f}, {24'haa9b27}, {24'h867a1f}, {24'h615817}, {24'h413b10}, {24'h26230a}, {24'h0b0a03}, {24'h050401}, {24'h020201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'heec86f}, {24'hebcb5e}, {24'he9ce4f}, {24'he9d240}, {24'he1cc37}, {24'hd4bf31}, {24'hc6b32b}, {24'ha29324}, {24'h7e731d}, {24'h5b5316}, {24'h39340e}, {24'h171506}, {24'h0e0d04}, {24'h060501}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'hf3d35a}, {24'hf1d54f}, {24'hf1d847}, {24'hf1da3d}, {24'hecd536}, {24'he3cb32}, {24'hd9c02e}, {24'hb9a528}, {24'h998b22}, {24'h766c1b}, {24'h504912}, {24'h2a260a}, {24'h1a1806}, {24'h0c0b03}, {24'h020200}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'hf8dc45}, {24'hf7df42}, {24'hf8e03e}, {24'hf9e13a}, {24'hf7de37}, {24'hf1d533}, {24'hebcc30}, {24'hcfb62c}, {24'hb3a127}, {24'h908321}, {24'h665d17}, {24'h3c370e}, {24'h262309}, {24'h111004}, {24'h040401}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'hfac439}, {24'hf9cf3a}, {24'hf9cf37}, {24'hfbd034}, {24'hf9c930}, {24'hf6bd2d}, {24'hf2b029}, {24'hdea827}, {24'hc99e26}, {24'haa8b21}, {24'h7e6b1a}, {24'h534b13}, {24'h37320c}, {24'h1c1a06}, {24'h090802}, {24'h050501}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'hfbac2d}, {24'hfabf31}, {24'hfbbf30}, {24'hfcbf2e}, {24'hfcb52b}, {24'hfba527}, {24'hfa9622}, {24'hed9923}, {24'he09c25}, {24'hc39122}, {24'h96781d}, {24'h6a6017}, {24'h474110}, {24'h262309}, {24'h0e0d03}, {24'h080702}, {24'h020200}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'hfb8f24}, {24'hfba128}, {24'hfca027}, {24'hfd9e26}, {24'hfe9724}, {24'hfe8c20}, {24'hff821e}, {24'hf79122}, {24'hefa025}, {24'hd59d25}, {24'ha98720}, {24'h7d721b}, {24'h564f14}, {24'h302c0b}, {24'h141205}, {24'h0c0b03}, {24'h030301}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'hfa6b1e}, {24'hfb741e}, {24'hfc711c}, {24'hfd6e1b}, {24'hfe6e1a}, {24'hfe701a}, {24'hfe731b}, {24'hfa8f21}, {24'hf5ac27}, {24'hdfaf29}, {24'hb59624}, {24'h8c7f20}, {24'h635b17}, {24'h3a350e}, {24'h1b1907}, {24'h100f04}, {24'h050501}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'hf94818}, {24'hfa4714}, {24'hfc4212}, {24'hfd3d0f}, {24'hfe4510}, {24'hfe5414}, {24'hfe6518}, {24'hfc8e21}, {24'hfcb82a}, {24'he8c02d}, {24'hc2a728}, {24'h9b8d24}, {24'h6f651b}, {24'h433d10}, {24'h211e08}, {24'h141205}, {24'h060602}, {24'h030301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'hf33c1a}, {24'hf92f0f}, {24'hfa320e}, {24'hfb350e}, {24'hfc4b13}, {24'hfc6d1b}, {24'hfd8f23}, {24'hfcac29}, {24'hfcc82e}, {24'heac92f}, {24'hc8b02b}, {24'ha69826}, {24'h766c1c}, {24'h453f10}, {24'h201d08}, {24'h121105}, {24'h050501}, {24'h020201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'hec341e}, {24'hf71a0a}, {24'hf8250c}, {24'hf9310e}, {24'hfa5716}, {24'hfb8d23}, {24'hfbc02f}, {24'hfbcc31}, {24'hfad932}, {24'hebd231}, {24'hceba2d}, {24'hb0a129}, {24'h7c721d}, {24'h464011}, {24'h1e1b07}, {24'h111004}, {24'h040401}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'he72c20}, {24'hf40d09}, {24'hf5200d}, {24'hf63310}, {24'hf7621b}, {24'hf8a329}, {24'hf9e037}, {24'hf8e136}, {24'hf9e235}, {24'hebd733}, {24'hd0bf2e}, {24'hb5a62a}, {24'h7e741d}, {24'h453f10}, {24'h1c1a07}, {24'h0f0e04}, {24'h030301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'he6241e}, {24'hee1411}, {24'hef2a14}, {24'hf14018}, {24'hf36c21}, {24'hf5a62c}, {24'hf7dd38}, {24'hf7df36}, {24'hf7e236}, {24'he9d633}, {24'hcbba2d}, {24'haea028}, {24'h796f1c}, {24'h423d0f}, {24'h1b1906}, {24'h0f0e03}, {24'h030301}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'he51c1d}, {24'he71a18}, {24'he9331c}, {24'heb4d20}, {24'hee7627}, {24'hf1aa30}, {24'hf4da38}, {24'hf5dd37}, {24'hf7e237}, {24'he7d433}, {24'hc7b72c}, {24'ha69926}, {24'h746b1a}, {24'h3f3a0e}, {24'h191705}, {24'h0e0d03}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'hd63746}, {24'hd8353e}, {24'hdf4236}, {24'he74f2d}, {24'hec722e}, {24'hf0a333}, {24'hf4d139}, {24'hf5d838}, {24'hf8e038}, {24'he6d333}, {24'hbfaf2b}, {24'h998d23}, {24'h696117}, {24'h39340d}, {24'h161405}, {24'h0c0b02}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'hc25e7c}, {24'hc7576f}, {24'hd45256}, {24'he24d3d}, {24'heb6935}, {24'hf09837}, {24'hf6c639}, {24'hf7d239}, {24'hfae038}, {24'he4d233}, {24'hb7a829}, {24'h897e1f}, {24'h5d5515}, {24'h322e0b}, {24'h131104}, {24'h0a0902}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'hb182ad}, {24'hb7779b}, {24'hca6274}, {24'hdd4e4d}, {24'he8643e}, {24'hef923e}, {24'hf6bf3e}, {24'hf8cf3c}, {24'hfadf3b}, {24'he1cf33}, {24'hac9f27}, {24'h786e1b}, {24'h514a12}, {24'h2b2709}, {24'h100e03}, {24'h090802}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'hab97ca}, {24'hb08cba}, {24'hc4728e}, {24'hd85862}, {24'he36d52}, {24'he99d52}, {24'heecc52}, {24'hf1d548}, {24'hf3dd3e}, {24'hd7c733}, {24'h9d9125}, {24'h635b16}, {24'h413c0e}, {24'h211e07}, {24'h0b0a02}, {24'h060501}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'ha5ace7}, {24'haaa2d8}, {24'hbe82a7}, {24'hd26277}, {24'hdd7665}, {24'he2a866}, {24'he7d966}, {24'he9da54}, {24'heddc43}, {24'hcfbf32}, {24'h8e8322}, {24'h4d4711}, {24'h312d0b}, {24'h181605}, {24'h070701}, {24'h040401}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'ha2b6f4}, {24'ha6afe9}, {24'hb695c3}, {24'hc67b9c}, {24'hcd898a}, {24'hd2af84}, {24'hd4d27c}, {24'hd4cd62}, {24'hd4c646}, {24'hb5a830}, {24'h79701f}, {24'h3d380e}, {24'h262308}, {24'h121104}, {24'h040401}, {24'h020200}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'ha2b9f9}, {24'ha4b6f3}, {24'hadaadf}, {24'hb59dca}, {24'hbaa3b8}, {24'hbcb3a7}, {24'hbcc196}, {24'hb5b46f}, {24'haea749}, {24'h938a2e}, {24'h615a1d}, {24'h2f2b0b}, {24'h1c1a07}, {24'h0d0c03}, {24'h020200}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'ha2bcfd}, {24'ha2bcfc}, {24'ha4bdf9}, {24'ha5bef6}, {24'ha5bbe5}, {24'ha5b6c9}, {24'ha4b1ad}, {24'h979d7c}, {24'h8a884c}, {24'h706a2a}, {24'h49451a}, {24'h221f09}, {24'h141205}, {24'h080702}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'ha1bbfc}, {24'ha1bbfb}, {24'ha1bbf8}, {24'ha1b9f4}, {24'h9cb1df}, {24'h93a5bf}, {24'h8b989f}, {24'h7b8171}, {24'h6a6a43}, {24'h535024}, {24'h363316}, {24'h181707}, {24'h0f0e04}, {24'h060502}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd26 : begin
				case(line)
					10'd0 : pattern <= {{24'h12120c}, {24'h0e0e09}, {24'h090906}, {24'h050503}, {24'h030302}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h313220}, {24'h242518}, {24'h17180f}, {24'h0d0e09}, {24'h080805}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h4f5134}, {24'h3b3d27}, {24'h27281a}, {24'h17180f}, {24'h0d0d08}, {24'h020201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h808355}, {24'h6f7149}, {24'h5e613f}, {24'h4d4f33}, {24'h3b3d27}, {24'h2a2b1b}, {24'h1e1f14}, {24'h13140d}, {24'h0b0b07}, {24'h070704}, {24'h030302}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'hb2b676}, {24'ha3a76d}, {24'h959863}, {24'h828557}, {24'h6a6d46}, {24'h525335}, {24'h3c3e27}, {24'h272819}, {24'h16170e}, {24'h0e0e09}, {24'h060604}, {24'h030302}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'hd4d98c}, {24'hc9ce85}, {24'hbfc37f}, {24'hacb072}, {24'h929560}, {24'h787a4e}, {24'h5c5e3c}, {24'h41422a}, {24'h2a2b1b}, {24'h1d1e13}, {24'h10100a}, {24'h090905}, {24'h060504}, {24'h030203}, {24'h050305}, {24'h070506}, {24'h080507}, {24'h090608}, {24'h0a0709}, {24'h080507}, {24'h060406}, {24'h040304}, {24'h020102}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'he5ea97}, {24'hdfe392}, {24'hd7db8d}, {24'hc9cd84}, {24'hb3b776}, {24'h9c9f66}, {24'h818454}, {24'h646641}, {24'h4a4b30}, {24'h363722}, {24'h222215}, {24'h17160e}, {24'h0e0c0a}, {24'h080507}, {24'h0f0a0e}, {24'h150f14}, {24'h1a1219}, {24'h1d141c}, {24'h20161f}, {24'h191117}, {24'h120c11}, {24'h0c080b}, {24'h060405}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'hf6fba1}, {24'hf3f89f}, {24'hf0f59d}, {24'he6eb97}, {24'hd4d88a}, {24'hc2c67f}, {24'ha5a86c}, {24'h878a58}, {24'h6a6c44}, {24'h4f5032}, {24'h343420}, {24'h232216}, {24'h171410}, {24'h0e0a0d}, {24'h1a1218}, {24'h241922}, {24'h2c1f2a}, {24'h322330}, {24'h372635}, {24'h2a1d28}, {24'h1f151d}, {24'h130d11}, {24'h0a0709}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'hf8fda2}, {24'hf6fba1}, {24'hf5faa0}, {24'heef39c}, {24'he2e693}, {24'hd4d88b}, {24'hbec17b}, {24'ha6a96b}, {24'h8e8f59}, {24'h747445}, {24'h5a5931}, {24'h4a4727}, {24'h3d3820}, {24'h362e1d}, {24'h40332a}, {24'h4c3a38}, {24'h563f44}, {24'h5e4451}, {24'h66495c}, {24'h5f4357}, {24'h5a3f53}, {24'h52394d}, {24'h483244}, {24'h3e2b3b}, {24'h362534}, {24'h2e202c}, {24'h261a24}, {24'h1d141c}, {24'h150e13}, {24'h0d090c}, {0{24'h0}}};
					10'd9 : pattern <= {{24'hf8fda2}, {24'hf7fca1}, {24'hf7fca1}, {24'hf3f89f}, {24'hecf19a}, {24'he5e995}, {24'hd5d889}, {24'hc4c77c}, {24'hb2b36c}, {24'h9a9a58}, {24'h838144}, {24'h746f39}, {24'h686031}, {24'h60552e}, {24'h6c593e}, {24'h775e4e}, {24'h82635f}, {24'h8e6972}, {24'h986e84}, {24'h9a6e8b}, {24'h9b6d90}, {24'h976a8f}, {24'h8d6287}, {24'h845c7f}, {24'h73506f}, {24'h63445f}, {24'h51384d}, {24'h3e2b3b}, {24'h2c1f2a}, {24'h1b131a}, {0{24'h0}}};
					10'd10 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf7fca1}, {24'hf4f99f}, {24'hf0f59d}, {24'he6ea93}, {24'hddde88}, {24'hcfd07b}, {24'hbaba66}, {24'ha7a351}, {24'h999246}, {24'h90853f}, {24'h897a3a}, {24'h947d4c}, {24'h9e805e}, {24'haa8473}, {24'hb6898a}, {24'hc28fa1}, {24'hc891af}, {24'hce92bd}, {24'hcd8fc1}, {24'hc48abb}, {24'hbb83b4}, {24'ha875a1}, {24'h93668e}, {24'h7e5778}, {24'h664762}, {24'h4e374a}, {24'h392834}, {0{24'h0}}};
					10'd11 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf7fca1}, {24'hf6fba0}, {24'hf4f99e}, {24'hedf094}, {24'he7e88a}, {24'hdede7c}, {24'hd0cc67}, {24'hc0ba53}, {24'hb7ac48}, {24'hafa140}, {24'ha9983d}, {24'hb39b4e}, {24'hbc9c5f}, {24'hc69f74}, {24'hd0a28c}, {24'hdaa5a3}, {24'hdda3b4}, {24'he1a2c5}, {24'he09fce}, {24'hda9acc}, {24'hd494cb}, {24'hc88cbf}, {24'hbc83b5}, {24'hae79a6}, {24'h9c6d95}, {24'h8c6184}, {24'h75536a}, {0{24'h0}}};
					10'd12 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf7fb9f}, {24'hf7fb9e}, {24'hf4f795}, {24'hf2f28a}, {24'hedeb7d}, {24'he3de68}, {24'hd9d054}, {24'hd3c749}, {24'hcdbd42}, {24'hcab63f}, {24'hd1b84f}, {24'hd9b961}, {24'he1ba75}, {24'he8ba8d}, {24'hf0bba5}, {24'hf2b7ba}, {24'hf3b3ce}, {24'hf3afdb}, {24'hf0aade}, {24'heda6e2}, {24'he8a2de}, {24'he49fda}, {24'hde9ad5}, {24'hd392ca}, {24'hc88bbe}, {24'hb27ea1}, {0{24'h0}}};
					10'd13 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fca0}, {24'hf8fc9d}, {24'hf8fb9a}, {24'hf8f88f}, {24'hf6f582}, {24'hf4ef74}, {24'hefe662}, {24'he9dc4e}, {24'he5d645}, {24'he0ce40}, {24'hdeca3d}, {24'he4ca4b}, {24'he9cb58}, {24'hedc96a}, {24'hf3c97f}, {24'hf8c794}, {24'hf9c1aa}, {24'hf9bcbf}, {24'hf9b6cf}, {24'hf7b3da}, {24'hf5ade3}, {24'hf3abe4}, {24'hf2a9e5}, {24'heea6e2}, {24'he8a2db}, {24'he19dd3}, {24'hce94b6}, {0{24'h0}}};
					10'd14 : pattern <= {{24'hf8fda2}, {24'hf8fda1}, {24'hf8fca0}, {24'hf8fc9d}, {24'hf8fb98}, {24'hf9fa92}, {24'hf8f785}, {24'hf9f578}, {24'hf8f06a}, {24'hf6ea58}, {24'hf4e546}, {24'hf2e040}, {24'hefdc3c}, {24'heed93b}, {24'hf0d744}, {24'hf3d74d}, {24'hf5d65b}, {24'hf8d46b}, {24'hfad17b}, {24'hfbca91}, {24'hfbc4a8}, {24'hfabebc}, {24'hf9b7ce}, {24'hf8b1df}, {24'hf6afe2}, {24'hf6aee4}, {24'hf4ace3}, {24'hf0a9e0}, {24'heca6dc}, {24'hdfa2c0}, {0{24'h0}}};
					10'd15 : pattern <= {{24'hf8fda2}, {24'hf8fda0}, {24'hf8fc9e}, {24'hf8fb9a}, {24'hf9fa92}, {24'hf9f98a}, {24'hfaf67c}, {24'hfbf46e}, {24'hfcf15f}, {24'hfdee4f}, {24'hfeec40}, {24'hfde93b}, {24'hfce738}, {24'hfae438}, {24'hfbe33e}, {24'hfbe243}, {24'hfce04d}, {24'hfcde59}, {24'hfddb65}, {24'hfcd37b}, {24'hfccc90}, {24'hfbc4a7}, {24'hfbbdbf}, {24'hfab5d7}, {24'hfab3dc}, {24'hf9b2e0}, {24'hf9b1e2}, {24'hf7b0e0}, {24'hf6afdf}, {24'hedafc4}, {0{24'h0}}};
					10'd16 : pattern <= {{24'hf8fda2}, {24'hf8fc9f}, {24'hf8fc9b}, {24'hf9fa95}, {24'hf9f98b}, {24'hfaf782}, {24'hfbf573}, {24'hfcf264}, {24'hfdf056}, {24'hfded49}, {24'hfeeb3d}, {24'hfee939}, {24'hfde838}, {24'hfce637}, {24'hfde63b}, {24'hfde53e}, {24'hfde444}, {24'hfde24b}, {24'hfee153}, {24'hfddb64}, {24'hfdd576}, {24'hfcce8a}, {24'hfcc6a2}, {24'hfbbfb9}, {24'hfabcc1}, {24'hfabac7}, {24'hf9b8cb}, {24'hf7b7c9}, {24'hf6b6c7}, {24'hefb6b0}, {0{24'h0}}};
					10'd17 : pattern <= {{24'hf8fda2}, {24'hf8fc9d}, {24'hf9fb98}, {24'hf9fa90}, {24'hfaf885}, {24'hfbf679}, {24'hfbf36a}, {24'hfcf15b}, {24'hfdee4d}, {24'hfeec43}, {24'hffeb39}, {24'hffea37}, {24'hfee937}, {24'hfee936}, {24'hfee837}, {24'hfee838}, {24'hffe93b}, {24'hffe83e}, {24'hffe741}, {24'hfee24e}, {24'hfede5b}, {24'hfdd86d}, {24'hfcd084}, {24'hfcc89c}, {24'hfbc4a6}, {24'hfac1af}, {24'hf9bfb4}, {24'hf7beb1}, {24'hf6bdae}, {24'hf0bd9b}, {0{24'h0}}};
					10'd18 : pattern <= {{24'hf8fda2}, {24'hf8fc9b}, {24'hf9fa95}, {24'hfaf98c}, {24'hfaf77e}, {24'hfbf571}, {24'hfcf262}, {24'hfdef53}, {24'hfded46}, {24'hfeec3f}, {24'hffea38}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hffea38}, {24'hffe939}, {24'hffe642}, {24'hfee34b}, {24'hfede59}, {24'hfdd86c}, {24'hfdd180}, {24'hfcce8a}, {24'hfbcb92}, {24'hfac897}, {24'hf9c793}, {24'hf7c690}, {24'hf3c681}, {0{24'h0}}};
					10'd19 : pattern <= {{24'hf8fda1}, {24'hf9fc99}, {24'hf9fa92}, {24'hfaf887}, {24'hfbf678}, {24'hfcf36a}, {24'hfcf15c}, {24'hfdee4d}, {24'hfeec42}, {24'hfeeb3d}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hffea38}, {24'hffe83d}, {24'hffe642}, {24'hfee34b}, {24'hfedf58}, {24'hfdda65}, {24'hfdd86c}, {24'hfdd672}, {24'hfcd375}, {24'hfbd171}, {24'hf9cf6e}, {24'hf7d165}, {0{24'h0}}};
					10'd20 : pattern <= {{24'hf8fda1}, {24'hf9fb97}, {24'hfafa8e}, {24'hfaf882}, {24'hfbf572}, {24'hfcf263}, {24'hfdf055}, {24'hfded47}, {24'hfeeb3d}, {24'hffea3a}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea38}, {24'hffe939}, {24'hffe83d}, {24'hfee644}, {24'hfee34b}, {24'hfee24f}, {24'hfee052}, {24'hfede53}, {24'hfcdb50}, {24'hfbd74c}, {24'hfad949}, {0{24'h0}}};
					10'd21 : pattern <= {{24'hf8fd9f}, {24'hf9fb95}, {24'hfaf98b}, {24'hfaf77e}, {24'hfbf46e}, {24'hfcf25e}, {24'hfdef51}, {24'hfeec44}, {24'hfeeb3a}, {24'hffea38}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hffea38}, {24'hffe93a}, {24'hffe73f}, {24'hfee643}, {24'hfee545}, {24'hfee447}, {24'hfedc46}, {24'hfdc740}, {24'hfcb239}, {24'hfbb739}, {0{24'h0}}};
					10'd22 : pattern <= {{24'hf8fc9e}, {24'hf9fb93}, {24'hfaf988}, {24'hfaf77b}, {24'hfcf46a}, {24'hfdf15a}, {24'hfdee4d}, {24'hfeec40}, {24'hffea37}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hffea38}, {24'hffe939}, {24'hffe93a}, {24'hffe83b}, {24'hffe83c}, {24'hffdb39}, {24'hfeb430}, {24'hfe8d27}, {24'hfc9528}, {0{24'h0}}};
					10'd23 : pattern <= {{24'hf8fc9c}, {24'hf9fa91}, {24'hfaf986}, {24'hfbf678}, {24'hfcf367}, {24'hfdf056}, {24'hfeee4a}, {24'hfeec3e}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffe936}, {24'hffd833}, {24'hfea528}, {24'hfd721d}, {24'hfc771f}, {0{24'h0}}};
					10'd24 : pattern <= {{24'hf9fb99}, {24'hf9fa8f}, {24'hfaf885}, {24'hfbf677}, {24'hfcf366}, {24'hfdf055}, {24'hfeee49}, {24'hfeeb3e}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffe936}, {24'hffe736}, {24'hfed433}, {24'hfc9c29}, {24'hf9641f}, {24'hf9601d}, {0{24'h0}}};
					10'd25 : pattern <= {{24'hf9fb96}, {24'hf9f98d}, {24'hfaf883}, {24'hfbf676}, {24'hfcf365}, {24'hfdef53}, {24'hfeed48}, {24'hfeeb3d}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffe836}, {24'hfee636}, {24'hfdd033}, {24'hfa932a}, {24'hf65621}, {24'hf7481c}, {0{24'h0}}};
					10'd26 : pattern <= {{24'hf9fb97}, {24'hf9fa8e}, {24'hfaf884}, {24'hfbf677}, {24'hfcf264}, {24'hfdef52}, {24'hfeed47}, {24'hfeeb3d}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hffe937}, {24'hfce539}, {24'hf9df3b}, {24'hf5cb3b}, {24'hee9938}, {24'he76734}, {24'heb4e29}, {0{24'h0}}};
					10'd27 : pattern <= {{24'hf8fc99}, {24'hf9fa8f}, {24'hfaf886}, {24'hfbf578}, {24'hfcf264}, {24'hfdef50}, {24'hfeed46}, {24'hfeeb3d}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffe937}, {24'hfee938}, {24'hf9e13c}, {24'hf3d840}, {24'hecc644}, {24'he1a147}, {24'hd77b49}, {24'hdf5737}, {0{24'h0}}};
					10'd28 : pattern <= {{24'hf8fc9b}, {24'hf9fa91}, {24'hf9f888}, {24'hfaf679}, {24'hfcf264}, {24'hfdee50}, {24'hfeed46}, {24'hfeeb3d}, {24'hffea37}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffe937}, {24'hfee738}, {24'hfde439}, {24'hf7d73e}, {24'hf0c942}, {24'he7b647}, {24'hdb994c}, {24'hcf7d51}, {24'hd8563c}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hf8fc9e}, {24'hf9fb95}, {24'hf9f98b}, {24'hfaf67c}, {24'hfbf266}, {24'hfdee50}, {24'hfeed46}, {24'hfeeb3d}, {24'hffea37}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfee737}, {24'hfde039}, {24'hfcd93a}, {24'hf7c23b}, {24'hf2a93c}, {24'heb8f3d}, {24'he2733d}, {24'hda573d}, {24'hde3d30}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hf8fda1}, {24'hf8fb98}, {24'hf9f98e}, {24'hfaf67f}, {24'hfbf267}, {24'hfdee50}, {24'hfeed46}, {24'hfeeb3e}, {24'hffea38}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfee537}, {24'hfcd939}, {24'hfacd3b}, {24'hf7ad39}, {24'hf38a36}, {24'hef6933}, {24'hea4d2e}, {24'he4322a}, {24'he42424}, {0{24'h0}}};
					10'd31 : pattern <= {{24'hf8fda2}, {24'hf8fb99}, {24'hf9f990}, {24'hfaf781}, {24'hfbf36a}, {24'hfdef54}, {24'hfeed48}, {24'hfeeb3f}, {24'hffea38}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfde338}, {24'hfad43c}, {24'hf7c540}, {24'hf3a13e}, {24'hf07b3c}, {24'heb5e3d}, {24'he15146}, {24'hd7454f}, {24'hd53d4c}, {0{24'h0}}};
					10'd32 : pattern <= {{24'hf8fda1}, {24'hf8fb99}, {24'hf9fa91}, {24'hfaf783}, {24'hfbf36e}, {24'hfdf059}, {24'hfeee4c}, {24'hfeeb40}, {24'hffea38}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfde239}, {24'hf8cf40}, {24'hf3bd46}, {24'hef9946}, {24'hec7245}, {24'he45a4e}, {24'hd3626a}, {24'hc36a86}, {24'hc06685}, {0{24'h0}}};
					10'd33 : pattern <= {{24'hf8fda1}, {24'hf8fb9a}, {24'hf9fa92}, {24'hfaf785}, {24'hfbf471}, {24'hfdf15d}, {24'hfeee4f}, {24'hfeec42}, {24'hffea38}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hfce13c}, {24'hf5cd45}, {24'hefba4f}, {24'hea9653}, {24'he47156}, {24'hda6066}, {24'hc6768f}, {24'hb18cb8}, {24'hae8bb9}, {0{24'h0}}};
					10'd34 : pattern <= {{24'hf8fda1}, {24'hf8fb9a}, {24'hf9fa92}, {24'hfaf886}, {24'hfbf473}, {24'hfcf160}, {24'hfdee51}, {24'hfeec44}, {24'hffea3a}, {24'hffea38}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfee938}, {24'hfde93b}, {24'hf8e243}, {24'hf0d553}, {24'he8c763}, {24'hddaf74}, {24'hd39687}, {24'hc7899c}, {24'hb994b8}, {24'haba0d3}, {24'ha99dd3}, {0{24'h0}}};
					10'd35 : pattern <= {{24'hf8fca1}, {24'hf8fb9a}, {24'hf9fa93}, {24'hfaf887}, {24'hfbf475}, {24'hfcf162}, {24'hfdef54}, {24'hfeec46}, {24'hfeeb3c}, {24'hffea39}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfde93a}, {24'hfbe83f}, {24'hf5e44b}, {24'headc61}, {24'he0d576}, {24'hd1c896}, {24'hc1bab7}, {24'hb4b2d2}, {24'hacb3e0}, {24'ha5b3ef}, {24'ha4b0ed}, {0{24'h0}}};
					10'd36 : pattern <= {{24'hf8fb9c}, {24'hf9fa94}, {24'hf9f98c}, {24'hfaf680}, {24'hfbf470}, {24'hfcf15f}, {24'hfdee52}, {24'hfeec45}, {24'hfeeb3c}, {24'hffea39}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hfeea38}, {24'hfee939}, {24'hfde939}, {24'hfde93a}, {24'hf9e742}, {24'hf6e549}, {24'hefe259}, {24'he3dc71}, {24'hd8d78a}, {24'hc8cfab}, {24'hb8c7ce}, {24'habc1e8}, {24'ha7bef1}, {24'ha2bbf9}, {24'ha2b8f8}, {0{24'h0}}};
					10'd37 : pattern <= {{24'hf9fa94}, {24'hf9f88a}, {24'hfaf781}, {24'hfbf576}, {24'hfcf267}, {24'hfdef59}, {24'hfeee4e}, {24'hfeec43}, {24'hffeb3b}, {24'hffea39}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hfee939}, {24'hfde93b}, {24'hfce83d}, {24'hfbe83f}, {24'hfae741}, {24'hf4e54d}, {24'hefe258}, {24'he6de6a}, {24'hdad884}, {24'hcfd29d}, {24'hc1ccba}, {24'hb4c5d7}, {24'haac0ec}, {24'ha6bef3}, {24'ha2bcfb}, {24'ha2bafb}, {0{24'h0}}};
					10'd38 : pattern <= {{24'hf9f98a}, {24'hfaf780}, {24'hfbf576}, {24'hfcf36b}, {24'hfdf15e}, {24'hfeee52}, {24'hfeed49}, {24'hffec41}, {24'hffeb3a}, {24'hffea38}, {24'hffea36}, {24'hffea36}, {24'hffea36}, {24'hffea37}, {24'hfde93b}, {24'hfbe83f}, {24'hf9e742}, {24'hf8e646}, {24'hf6e54a}, {24'heee259}, {24'he7de68}, {24'hdeda7c}, {24'hd2d496}, {24'hc6cdb1}, {24'hbbc8c8}, {24'hb0c3df}, {24'ha8bff0}, {24'ha5bef6}, {24'ha3bcfc}, {24'ha2bcfd}, {0{24'h0}}};
					10'd39 : pattern <= {{24'hfbf472}, {24'hfbf36a}, {24'hfcf263}, {24'hfdf05b}, {24'hfdef52}, {24'hfeed49}, {24'hffec43}, {24'hffeb3d}, {24'hffeb39}, {24'hffea37}, {24'hffea36}, {24'hfeea38}, {24'hfde93a}, {24'hfbe83e}, {24'hf7e647}, {24'hf3e450}, {24'heee25a}, {24'headf63}, {24'he5dd6d}, {24'hdeda7c}, {24'hd7d68a}, {24'hcfd29c}, {24'hc5cdb1}, {24'hbcc8c6}, {24'hb4c5d7}, {24'hacc1e8}, {24'ha6bef4}, {24'ha4bdf8}, {24'ha1bbfb}, {24'ha1bbfc}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd27 : begin
				case(line)
					10'd0 : pattern <= {{24'h010101}, {24'h010101}, {24'h020201}, {24'h030302}, {24'h050504}, {24'h070705}, {24'h080805}, {24'h0a0a07}, {24'h0f0f0a}, {24'h14140d}, {24'h191911}, {24'h1f2015}, {24'h262618}, {24'h292a1b}, {24'h2d2e1d}, {24'h313220}, {24'h363723}, {24'h393b26}, {24'h40412a}, {24'h47482f}, {24'h4c4d32}, {24'h4a4b31}, {24'h494b30}, {24'h40422a}, {24'h343522}, {24'h292a1b}, {24'h242518}, {24'h1e1f14}, {24'h191a11}, {24'h15160e}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h020201}, {24'h030302}, {24'h050503}, {24'h080805}, {24'h0c0c08}, {24'h11110b}, {24'h15150e}, {24'h191a11}, {24'h242518}, {24'h2e2e1f}, {24'h373725}, {24'h3f3f29}, {24'h47472f}, {24'h4f5034}, {24'h58593a}, {24'h61623f}, {24'h676a43}, {24'h6f7148}, {24'h74764c}, {24'h787a4f}, {24'h7b7d50}, {24'h7b7d50}, {24'h7b7e51}, {24'h76784d}, {24'h6f7149}, {24'h666943}, {24'h5b5e3c}, {24'h515336}, {24'h46482f}, {24'h3c3d27}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h030302}, {24'h050503}, {24'h080805}, {24'h0e0e09}, {24'h14140d}, {24'h1b1b12}, {24'h222317}, {24'h2a2b1c}, {24'h3a3b27}, {24'h484930}, {24'h545538}, {24'h5e5f3e}, {24'h676844}, {24'h76774d}, {24'h838556}, {24'h90925e}, {24'h9a9d64}, {24'ha4a86b}, {24'ha6aa6d}, {24'ha7ab6e}, {24'ha8ac6f}, {24'habaf70}, {24'haeb272}, {24'hacb071}, {24'ha8ac6f}, {24'ha3a76c}, {24'h939661}, {24'h838657}, {24'h72754c}, {24'h616340}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h0f100a}, {24'h16170f}, {24'h1f2015}, {24'h2a2b1c}, {24'h353724}, {24'h42442c}, {24'h4f5134}, {24'h5c5f3d}, {24'h696b46}, {24'h76784e}, {24'h818255}, {24'h888a59}, {24'h8f925f}, {24'h9b9e66}, {24'ha7aa6d}, {24'hb2b574}, {24'hb9bc79}, {24'hc1c47e}, {24'hc2c77f}, {24'hc2c77f}, {24'hc4c980}, {24'hc6cb82}, {24'hc9ce83}, {24'hc8cd83}, {24'hc6cb82}, {24'hc2c780}, {24'hb6ba78}, {24'ha9ad70}, {24'h9c9f67}, {24'h8e915e}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h1c1d13}, {24'h292a1b}, {24'h363824}, {24'h47492f}, {24'h565839}, {24'h696b45}, {24'h7c7f52}, {24'h8f925f}, {24'h9a9d66}, {24'ha5a76c}, {24'hadaf71}, {24'hb3b676}, {24'hb8bc7a}, {24'hc1c57f}, {24'hcace85}, {24'hd2d689}, {24'hd8dc8d}, {24'hdde190}, {24'hdee291}, {24'hdfe391}, {24'he0e492}, {24'he3e794}, {24'he5e995}, {24'he5ea96}, {24'he5e995}, {24'he3e794}, {24'hd9dd8f}, {24'hcfd388}, {24'hc5c982}, {24'hbcc07c}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h353723}, {24'h46482e}, {24'h575a3a}, {24'h6a6d46}, {24'h7d8052}, {24'h90945f}, {24'ha4a86d}, {24'hb7bb79}, {24'hbfc27d}, {24'hc8cb83}, {24'hced087}, {24'hd1d589}, {24'hd5d98d}, {24'hdce090}, {24'he4e895}, {24'he8ed98}, {24'hebf09a}, {24'heef39c}, {24'heff49c}, {24'heff49c}, {24'hf0f59d}, {24'hf3f89f}, {24'hf5faa0}, {24'hf6fba1}, {24'hf6fba1}, {24'hf5faa0}, {24'heef39c}, {24'he7ec98}, {24'he1e594}, {24'hdbdf90}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h5f623f}, {24'h71744b}, {24'h838656}, {24'h969a63}, {24'ha9ad6f}, {24'hb8bc79}, {24'hc5c982}, {24'hd2d68a}, {24'hd7db8d}, {24'hdde190}, {24'he1e593}, {24'he3e795}, {24'he5ea97}, {24'he9ee98}, {24'hedf29b}, {24'hf0f59d}, {24'hf1f69e}, {24'hf3f89f}, {24'hf3f89f}, {24'hf3f89f}, {24'hf4f99f}, {24'hf5faa0}, {24'hf6fba1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf6fba1}, {24'hf3f89f}, {24'heff49c}, {24'hecf19a}, {24'he8ed99}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h898c5b}, {24'h9ca067}, {24'hafb474}, {24'hc2c67f}, {24'hd5d98b}, {24'he0e492}, {24'he6eb97}, {24'hedf29b}, {24'heff49c}, {24'hf1f69e}, {24'hf3f89f}, {24'hf5faa0}, {24'hf6fba1}, {24'hf6fba1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf7fca1}, {24'hf7fca1}, {24'hf7fca1}, {24'hf6fba1}, {0{24'h0}}};
					10'd8 : pattern <= {{24'ha9ae70}, {24'hbabe7b}, {24'hc8cd84}, {24'hd6db8c}, {24'he4e895}, {24'heaef99}, {24'heff49c}, {24'hf3f89f}, {24'hf4f99f}, {24'hf4f9a1}, {24'hf5faa2}, {24'hf6fba3}, {24'hf6fba4}, {24'hf7fca4}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf7fca3}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd9 : pattern <= {{24'hcace84}, {24'hd5da8c}, {24'he0e593}, {24'he6ec97}, {24'hedf29d}, {24'hf1f69f}, {24'hf4f99f}, {24'hf6fba1}, {24'hf5faa2}, {24'hf6fba2}, {24'hf5faa3}, {24'hf5faa5}, {24'hf4f9a6}, {24'hf5faa5}, {24'hf6fba4}, {24'hf6fba4}, {24'hf6fba4}, {24'hf6fba5}, {24'hf6fba5}, {24'hf6fba5}, {24'hf6fba5}, {24'hf7fca4}, {24'hf7fca3}, {24'hf7fca3}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd10 : pattern <= {{24'he3e796}, {24'he8ee9a}, {24'heff59f}, {24'hf1f6a1}, {24'hf3f9a3}, {24'hf4faa4}, {24'hf5fba5}, {24'hf5fba5}, {24'hf4faa6}, {24'hf4f9a7}, {24'hf3f8a8}, {24'hf2f7a9}, {24'hf0f6aa}, {24'hf1f6aa}, {24'hf1f7a9}, {24'hf2f7a9}, {24'hf1f7aa}, {24'hf1f7aa}, {24'hf2f7aa}, {24'hf2f8a9}, {24'hf3f8a8}, {24'hf5faa6}, {24'hf6fba4}, {24'hf7fca3}, {24'hf7fca2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd11 : pattern <= {{24'he8ed9e}, {24'hebf1a2}, {24'heef4a5}, {24'heef4a7}, {24'hf0f6a8}, {24'heff6ab}, {24'heef4ad}, {24'hedf3af}, {24'hecf2af}, {24'hebf1b0}, {24'heaf0b1}, {24'he9efb2}, {24'he8eeb3}, {24'he6edb5}, {24'he5ecb7}, {24'he4ecb8}, {24'he4ecb8}, {24'he5ecb8}, {24'he7edb6}, {24'he9efb2}, {24'hecf2af}, {24'hf0f5ab}, {24'hf3f9a6}, {24'hf5faa4}, {24'hf7fca3}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd12 : pattern <= {{24'heef3a6}, {24'hedf3a9}, {24'hedf2ac}, {24'hecf2ad}, {24'hecf2ae}, {24'he9f0b1}, {24'he7eeb5}, {24'he4ecb9}, {24'he3eab9}, {24'he2e9b9}, {24'he1e8ba}, {24'he0e7ba}, {24'hdfe6bb}, {24'hdce4c0}, {24'hd9e1c5}, {24'hd7e0c8}, {24'hd7e0c7}, {24'hd8e1c6}, {24'hdce4c2}, {24'he0e7bc}, {24'he5ebb6}, {24'hebf1af}, {24'hf1f6a9}, {24'hf4f9a5}, {24'hf6fba4}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd13 : pattern <= {{24'he9eeaf}, {24'he7edb1}, {24'he5eab3}, {24'he4eab5}, {24'he1e8b7}, {24'he0e6b8}, {24'hdee5b9}, {24'hdde3b9}, {24'hdde3b8}, {24'hdce2b7}, {24'hdce1b7}, {24'hdbe1b7}, {24'hdbe0b7}, {24'hd8debb}, {24'hd5dcbf}, {24'hd3dac1}, {24'hd4dbc1}, {24'hd4dbc1}, {24'hd7debe}, {24'hdbe1b9}, {24'he0e6b5}, {24'he7ecaf}, {24'heef3a9}, {24'hf2f7a6}, {24'hf5faa3}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd14 : pattern <= {{24'he0e6b8}, {24'hdde3b9}, {24'hdbe1bb}, {24'hd8debe}, {24'hd5dcc1}, {24'hd4dbbf}, {24'hd6dbbb}, {24'hd7dab7}, {24'hd7dbb4}, {24'hd8dbb1}, {24'hd8dbb0}, {24'hd8dbaf}, {24'hd8dbaf}, {24'hd6d9b0}, {24'hd5d8b1}, {24'hd4d7b3}, {24'hd3d7b4}, {24'hd3d7b5}, {24'hd5d9b4}, {24'hd8dcb3}, {24'hdce1b1}, {24'he3e8ad}, {24'hebefa9}, {24'hf0f4a6}, {24'hf4f9a3}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd15 : pattern <= {{24'hd9dfbe}, {24'hd6dcbd}, {24'hd4d9bd}, {24'hd0d6c0}, {24'hccd2c3}, {24'hcdd2be}, {24'hd0d3b7}, {24'hd3d4af}, {24'hd4d5ab}, {24'hd6d6a7}, {24'hd7d7a4}, {24'hd7d7a3}, {24'hd7d7a2}, {24'hd7d6a2}, {24'hd6d5a1}, {24'hd6d5a1}, {24'hd5d4a3}, {24'hd4d4a5}, {24'hd6d6a7}, {24'hd7d9a8}, {24'hdbdda8}, {24'he2e4a6}, {24'he9eca4}, {24'heff2a2}, {24'hf4f8a0}, {24'hf8fd9e}, {24'hf8fd9f}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {0{24'h0}}};
					10'd16 : pattern <= {{24'hd8dbb0}, {24'hd8daab}, {24'hd8d9a6}, {24'hd9d8a1}, {24'hd9d89c}, {24'hdad898}, {24'hdcd893}, {24'hddd98f}, {24'hdfda8c}, {24'he0db89}, {24'he1db86}, {24'he2dc84}, {24'he3dd81}, {24'he3dc80}, {24'he3dc7f}, {24'he2db80}, {24'he1da83}, {24'he0d986}, {24'he1db88}, {24'he2dd8a}, {24'he4e08b}, {24'he9e68b}, {24'heeec8a}, {24'hf2f18c}, {24'hf6f68f}, {24'hf9fa92}, {24'hf9fb97}, {24'hf8fc9c}, {24'hf8fc9f}, {24'hf8fda1}, {0{24'h0}}};
					10'd17 : pattern <= {{24'hd8d7a3}, {24'hdad899}, {24'hddd98e}, {24'he1db82}, {24'he6dd75}, {24'he8dd71}, {24'he8dd70}, {24'he8dd6f}, {24'he9de6d}, {24'headf6b}, {24'hebe068}, {24'hede164}, {24'hefe360}, {24'hefe25f}, {24'hf0e25d}, {24'hefe15e}, {24'hede063}, {24'hecdf67}, {24'hece069}, {24'hece16b}, {24'hede46d}, {24'hf1e86f}, {24'hf4ed71}, {24'hf6f177}, {24'hf8f57e}, {24'hfaf886}, {24'hf9f98f}, {24'hf8fb98}, {24'hf8fc9d}, {24'hf8fc9f}, {0{24'h0}}};
					10'd18 : pattern <= {{24'hdeda8e}, {24'he1db84}, {24'he5dd78}, {24'heae06c}, {24'hefe260}, {24'hf0e35d}, {24'hf0e360}, {24'hefe362}, {24'hf0e461}, {24'hf1e460}, {24'hf2e55d}, {24'hf4e658}, {24'hf6e753}, {24'hf6e751}, {24'hf7e64f}, {24'hf6e54f}, {24'hf5e451}, {24'hf3e354}, {24'hf3e455}, {24'hf3e556}, {24'hf4e658}, {24'hf6e95a}, {24'hf8ec5c}, {24'hf9ef64}, {24'hfaf36e}, {24'hfbf578}, {24'hfaf885}, {24'hf9fa91}, {24'hf8fb99}, {24'hf8fc9e}, {0{24'h0}}};
					10'd19 : pattern <= {{24'he9e075}, {24'hece26c}, {24'hefe464}, {24'hf2e65d}, {24'hf5e855}, {24'hf6e857}, {24'hf5e95c}, {24'hf5e960}, {24'hf5ea60}, {24'hf6eb60}, {24'hf7eb5d}, {24'hf8eb58}, {24'hfaeb54}, {24'hfaea50}, {24'hfae94d}, {24'hfae94b}, {24'hf9e84a}, {24'hf9e749}, {24'hf9e748}, {24'hf9e847}, {24'hfae847}, {24'hfbea49}, {24'hfcec4a}, {24'hfcee52}, {24'hfcf05d}, {24'hfcf269}, {24'hfaf57a}, {24'hf9f88a}, {24'hf8fa95}, {24'hf8fc9b}, {0{24'h0}}};
					10'd20 : pattern <= {{24'hf3e65d}, {24'hf6e856}, {24'hf9ea50}, {24'hfaec4e}, {24'hfced4c}, {24'hfbee51}, {24'hfbee58}, {24'hfaef5f}, {24'hfaf060}, {24'hfbf160}, {24'hfbf15e}, {24'hfcf05a}, {24'hfdef55}, {24'hfdee51}, {24'hfded4c}, {24'hfdec48}, {24'hfeec44}, {24'hfeeb3f}, {24'hfeeb3c}, {24'hffea39}, {24'hffea37}, {24'hffeb38}, {24'hffeb39}, {24'hfeec41}, {24'hfeee4d}, {24'hfdf05a}, {24'hfbf36e}, {24'hfaf783}, {24'hf9fa91}, {24'hf8fb99}, {0{24'h0}}};
					10'd21 : pattern <= {{24'hf6eb64}, {24'hf8ed62}, {24'hfaef62}, {24'hfaf062}, {24'hfbf163}, {24'hfbf267}, {24'hfaf26c}, {24'hfaf371}, {24'hfaf473}, {24'hfaf575}, {24'hfaf574}, {24'hfbf471}, {24'hfbf46e}, {24'hfcf369}, {24'hfcf263}, {24'hfcf05d}, {24'hfdef57}, {24'hfdee50}, {24'hfeed49}, {24'hfeec43}, {24'hffeb3e}, {24'hffeb3b}, {24'hffeb39}, {24'hffec3f}, {24'hfeed49}, {24'hfdef54}, {24'hfcf268}, {24'hfaf67d}, {24'hf9f98b}, {24'hf9fb95}, {0{24'h0}}};
					10'd22 : pattern <= {{24'hf9f06b}, {24'hf9f26f}, {24'hfaf473}, {24'hfaf577}, {24'hfaf57a}, {24'hfaf67d}, {24'hfaf780}, {24'hf9f783}, {24'hf9f886}, {24'hf9f989}, {24'hfaf989}, {24'hfaf988}, {24'hfaf987}, {24'hfaf781}, {24'hfaf67a}, {24'hfbf573}, {24'hfcf36a}, {24'hfcf261}, {24'hfdf057}, {24'hfeee4d}, {24'hfeec44}, {24'hffeb3e}, {24'hffea39}, {24'hffeb3d}, {24'hfeec45}, {24'hfeee4e}, {24'hfcf262}, {24'hfaf576}, {24'hf9f886}, {24'hf9fa92}, {0{24'h0}}};
					10'd23 : pattern <= {{24'hfaf475}, {24'hfaf67c}, {24'hfaf782}, {24'hfaf887}, {24'hfaf98b}, {24'hf9f98d}, {24'hf9f98f}, {24'hf9fa90}, {24'hf9fa93}, {24'hf9fb96}, {24'hf9fb97}, {24'hf9fb97}, {24'hf9fb97}, {24'hf9fa91}, {24'hf9f98b}, {24'hfaf884}, {24'hfbf67b}, {24'hfbf572}, {24'hfcf366}, {24'hfdf05b}, {24'hfeee50}, {24'hfeed47}, {24'hffeb3e}, {24'hfeeb3f}, {24'hfeec44}, {24'hfeee4b}, {24'hfcf15f}, {24'hfbf472}, {24'hfaf782}, {24'hf9fa8f}, {0{24'h0}}};
					10'd24 : pattern <= {{24'hf9f785}, {24'hf9f98b}, {24'hf9fa90}, {24'hf9fa92}, {24'hf9fb95}, {24'hf9fb96}, {24'hf9fb97}, {24'hf8fb98}, {24'hf8fc9a}, {24'hf8fc9c}, {24'hf8fc9c}, {24'hf8fc9c}, {24'hf8fc9c}, {24'hf9fb98}, {24'hf9fb95}, {24'hf9fa90}, {24'hfaf989}, {24'hfaf883}, {24'hfbf679}, {24'hfcf46e}, {24'hfcf162}, {24'hfdef56}, {24'hfeed49}, {24'hfeec47}, {24'hfeed48}, {24'hfded4c}, {24'hfcf15e}, {24'hfbf471}, {24'hfaf780}, {24'hf9f98c}, {0{24'h0}}};
					10'd25 : pattern <= {{24'hf9fb95}, {24'hf8fc99}, {24'hf8fd9d}, {24'hf8fd9e}, {24'hf8fd9f}, {24'hf8fd9f}, {24'hf8fd9f}, {24'hf8fd9f}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda0}, {24'hf8fc9e}, {24'hf8fc9b}, {24'hf9fb98}, {24'hf9fb95}, {24'hfaf98b}, {24'hfbf781}, {24'hfbf574}, {24'hfcf264}, {24'hfdef55}, {24'hfdee4f}, {24'hfded4d}, {24'hfded4d}, {24'hfcf15e}, {24'hfbf46f}, {24'hfbf67d}, {24'hfaf98a}, {0{24'h0}}};
					10'd26 : pattern <= {{24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fda0}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fca0}, {24'hf8fc9e}, {24'hf8fc9c}, {24'hf9fc9a}, {24'hf9fb93}, {24'hfaf98b}, {24'hfaf781}, {24'hfbf472}, {24'hfcf264}, {24'hfcf05c}, {24'hfcef58}, {24'hfdef56}, {24'hfcf265}, {24'hfbf574}, {24'hfaf781}, {24'hf9f98c}, {0{24'h0}}};
					10'd27 : pattern <= {{24'hf8fc9f}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda0}, {24'hf8fd9f}, {24'hf8fc9e}, {24'hf9fc9a}, {24'hf9fb94}, {24'hfafa8d}, {24'hfaf780}, {24'hfbf574}, {24'hfbf36b}, {24'hfcf264}, {24'hfcf160}, {24'hfbf36d}, {24'hfbf67a}, {24'hfaf885}, {24'hf9fa8f}, {0{24'h0}}};
					10'd28 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fd9e}, {24'hf9fc9b}, {24'hf9fc96}, {24'hf9f98c}, {24'hfaf782}, {24'hfaf679}, {24'hfbf471}, {24'hfcf36b}, {24'hfbf576}, {24'hfaf780}, {24'hf9f98a}, {24'hf9fa93}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda0}, {24'hf8fd9e}, {24'hf9fc9b}, {24'hf9fb93}, {24'hf9f98c}, {24'hfaf885}, {24'hfaf67e}, {24'hfbf579}, {24'hfaf782}, {24'hfaf98a}, {24'hf9fa92}, {24'hf9fb98}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fd9f}, {24'hf8fc9a}, {24'hf8fb96}, {24'hf9fa91}, {24'hfaf88b}, {24'hfaf887}, {24'hfaf98e}, {24'hf9fb94}, {24'hf9fc99}, {24'hf8fc9d}, {0{24'h0}}};
					10'd31 : pattern <= {{24'hf8fc9f}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda0}, {24'hf8fc9e}, {24'hf8fc9b}, {24'hf8fb97}, {24'hf9fa93}, {24'hf9f991}, {24'hf9fb95}, {24'hf9fc9a}, {24'hf9fc9d}, {24'hf8fd9f}, {0{24'h0}}};
					10'd32 : pattern <= {{24'hf8fc9a}, {24'hf8fc9e}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda0}, {24'hf8fc9e}, {24'hf8fc9c}, {24'hf8fb9a}, {24'hf9fb99}, {24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fd9f}, {24'hf8fda0}, {0{24'h0}}};
					10'd33 : pattern <= {{24'hf9fa92}, {24'hf9fb97}, {24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fc9e}, {24'hf8fc9e}, {24'hf8fc9f}, {24'hf8fc9f}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fca0}, {24'hf8fc9f}, {24'hf8fca0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {0{24'h0}}};
					10'd34 : pattern <= {{24'hf9f57b}, {24'hfaf77f}, {24'hfaf882}, {24'hfaf886}, {24'hf9f989}, {24'hf9f98c}, {24'hf9f98e}, {24'hf9fa91}, {24'hf9fb95}, {24'hf9fb99}, {24'hf8fc9c}, {24'hf8fc9f}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fca0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {0{24'h0}}};
					10'd35 : pattern <= {{24'hfbf165}, {24'hfbf367}, {24'hfbf369}, {24'hfbf46e}, {24'hfbf574}, {24'hfaf679}, {24'hfaf67e}, {24'hfaf783}, {24'hf9f98b}, {24'hf9fa92}, {24'hf9fb98}, {24'hf8fb9c}, {24'hf8fca1}, {24'hf8fca1}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fca1}, {0{24'h0}}};
					10'd36 : pattern <= {{24'hf4e751}, {24'hf8ea53}, {24'hfaed56}, {24'hf9ee5b}, {24'hf8ee60}, {24'hf7ee65}, {24'hf6ee6a}, {24'hf6ef6f}, {24'hf7f175}, {24'hf8f47c}, {24'hf8f582}, {24'hf9f787}, {24'hf9f98e}, {24'hf9fa91}, {24'hf9fa94}, {24'hf9fb97}, {24'hf9fb99}, {24'hf9fc9c}, {24'hf8fc9e}, {24'hf8fca0}, {24'hf8fda2}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda0}, {24'hf8fda0}, {24'hf8fc9f}, {24'hf8fc9e}, {24'hf8fc9e}, {24'hf8fc9d}, {24'hf8fc9d}, {0{24'h0}}};
					10'd37 : pattern <= {{24'he9d940}, {24'hf1e142}, {24'hf7e646}, {24'hf4e649}, {24'hf3e54e}, {24'hf2e551}, {24'hf1e454}, {24'hefe455}, {24'hf2e759}, {24'hf6eb5e}, {24'hf8ee62}, {24'hfaf169}, {24'hfbf46f}, {24'hfbf576}, {24'hfaf77e}, {24'hfaf885}, {24'hfaf98b}, {24'hf9fa91}, {24'hf9fb97}, {24'hf8fc9d}, {24'hf8fca1}, {24'hf8fca0}, {24'hf9fc9f}, {24'hf9fc9e}, {24'hf9fc9c}, {24'hf9fc9a}, {24'hf9fb99}, {24'hf9fb99}, {24'hf9fb97}, {24'hf9fa95}, {0{24'h0}}};
					10'd38 : pattern <= {{24'hdbca2f}, {24'he7d433}, {24'hf0dc36}, {24'heeda39}, {24'hebd93c}, {24'he9d83d}, {24'he8d83d}, {24'he8d83e}, {24'heddc3f}, {24'hf2e140}, {24'hf6e644}, {24'hf8e94a}, {24'hfcee52}, {24'hfbf05d}, {24'hfaf268}, {24'hfaf372}, {24'hfaf57c}, {24'hfaf886}, {24'hf9f98f}, {24'hf9fb98}, {24'hf8fc9f}, {24'hf9fc9d}, {24'hf9fc9c}, {24'hf9fb9a}, {24'hf9fb97}, {24'hf9fb95}, {24'hf9fa93}, {24'hf9fa92}, {24'hf9fa90}, {24'hf9f98d}, {0{24'h0}}};
					10'd39 : pattern <= {{24'ha39624}, {24'hab9e26}, {24'hb2a328}, {24'hb6a82b}, {24'hb8aa2e}, {24'hbcae2f}, {24'hc0b230}, {24'hc4b631}, {24'hccbd33}, {24'hd3c335}, {24'hdacb39}, {24'he0d13e}, {24'he5d843}, {24'he9dc4c}, {24'hebe054}, {24'hefe55c}, {24'hf1e863}, {24'hf4eb6a}, {24'hf6ef70}, {24'hf9f377}, {24'hfaf67c}, {24'hfbf67e}, {24'hfbf781}, {24'hfbf781}, {24'hfaf781}, {24'hfaf781}, {24'hfaf67e}, {24'hfbf67b}, {24'hfbf578}, {24'hfbf575}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd28 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030203}, {24'h070507}, {24'h100b0f}, {24'h231922}, {24'h362634}, {24'h583e55}, {24'h7e5979}, {24'ha1719b}, {24'hbd84b6}, {24'hd997d0}, {24'hde9bd5}, {24'hd796ce}, {24'hcc8fc4}, {24'ha5749e}, {24'h7d5878}, {24'h553c51}, {24'h2b1e29}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050305}, {24'h0a070a}, {24'h160f15}, {24'h2c1f2a}, {24'h432f41}, {24'h664862}, {24'h8d6387}, {24'hb07ca9}, {24'hc78bbf}, {24'he09bd7}, {24'he4a0db}, {24'he19dd8}, {24'hd897cf}, {24'hab77a4}, {24'h7d5778}, {24'h533a4f}, {24'h2a1d28}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h060406}, {24'h0d090c}, {24'h1b1319}, {24'h362633}, {24'h51394d}, {24'h755270}, {24'h9d6d96}, {24'hbf85b7}, {24'hd292c9}, {24'he59fdc}, {24'heba3e2}, {24'he9a3e0}, {24'he29ed9}, {24'hb07ba9}, {24'h7d5777}, {24'h50384d}, {24'h291d27}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010001}, {24'h080507}, {24'h100b0f}, {24'h21161f}, {24'h422e3f}, {24'h62445e}, {24'h875e81}, {24'hae79a6}, {24'hce8fc5}, {24'hda98d0}, {24'he5a0db}, {24'he4a0da}, {24'hdc9ad3}, {24'hcf91c7}, {24'h9a6c94}, {24'h654660}, {24'h3d2a3a}, {24'h1e151d}, {24'h010101}, {24'h010101}, {24'h020201}, {24'h030302}, {24'h060604}, {24'h090906}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010001}, {24'h020102}, {24'h0a0709}, {24'h130d12}, {24'h271a24}, {24'h4c3549}, {24'h72506e}, {24'h986a92}, {24'hbe84b6}, {24'hdc98d2}, {24'he19dd7}, {24'he5a0da}, {24'hde9cd3}, {24'hce91c6}, {24'hbc84b5}, {24'h845d7f}, {24'h4d364a}, {24'h281c27}, {24'h140e14}, {24'h010101}, {24'h010101}, {24'h030302}, {24'h060604}, {24'h0c0c08}, {24'h10110b}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h030203}, {24'h060406}, {24'h110b10}, {24'h1d131b}, {24'h342431}, {24'h5d4159}, {24'h865d80}, {24'ha976a1}, {24'hcc8ec1}, {24'he5a0d9}, {24'he5a1d6}, {24'he4a1d4}, {24'hd999c6}, {24'hc48cb3}, {24'had7c9c}, {24'h78576a}, {24'h423137}, {24'h21191a}, {24'h140f0e}, {24'h060502}, {24'h080804}, {24'h0b0b07}, {24'h11110b}, {24'h1b1c12}, {24'h262719}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h010001}, {24'h040304}, {24'h090609}, {24'h0e0a0d}, {24'h1f151d}, {24'h2f212d}, {24'h4a3346}, {24'h73506d}, {24'h9c6d94}, {24'hba82af}, {24'hd496c5}, {24'he8a4d6}, {24'he6a4ce}, {24'he3a4c6}, {24'hd39ab2}, {24'hbd8d99}, {24'ha37c7e}, {24'h765c55}, {24'h483a2b}, {24'h2c2514}, {24'h1f1b0d}, {24'h111006}, {24'h16150b}, {24'h1b1b10}, {24'h252619}, {24'h383a25}, {24'h4d4e33}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h010001}, {24'h020102}, {24'h060406}, {24'h0e0a0d}, {24'h160f15}, {24'h2b1e2a}, {24'h432e40}, {24'h60435c}, {24'h885f81}, {24'hb17ca7}, {24'hca8ebb}, {24'hde9ecb}, {24'heca9d4}, {24'he7a7c6}, {24'he1a5b8}, {24'hcf9c9f}, {24'hb58d7f}, {24'h9a7d5f}, {24'h75613f}, {24'h4f451f}, {24'h36310f}, {24'h2a270d}, {24'h1d1b0a}, {24'h232212}, {24'h2a2a1a}, {24'h3a3b26}, {24'h57583a}, {24'h73764d}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h040304}, {24'h070507}, {24'h110b10}, {24'h1f161e}, {24'h2e202c}, {24'h483245}, {24'h61445d}, {24'h7d5877}, {24'h9e7095}, {24'hbf87b2}, {24'hd397bd}, {24'he2a5c2}, {24'hedb0c2}, {24'heab1af}, {24'he6b39e}, {24'hd8ad86}, {24'hc4a16a}, {24'haf954f}, {24'h907e39}, {24'h716723}, {24'h5d561a}, {24'h504c1b}, {24'h44411d}, {24'h4a4928}, {24'h535433}, {24'h626441}, {24'h7d8053}, {24'h999c64}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h010101}, {24'h070507}, {24'h0c090c}, {24'h1b131a}, {24'h332431}, {24'h4a3346}, {24'h664761}, {24'h825b7d}, {24'h9c6e95}, {24'hb47fa8}, {24'hcb91bc}, {24'hda9ebb}, {24'he4abb6}, {24'heeb6ad}, {24'hedbc98}, {24'hedc383}, {24'he3bf6d}, {24'hd6b958}, {24'hc6b042}, {24'haf9e36}, {24'h998d2a}, {24'h887f27}, {24'h7b742c}, {24'h6e6a31}, {24'h767540}, {24'h80804f}, {24'h8f915f}, {24'ha6aa6d}, {24'hbdc07b}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h010101}, {24'h0c080b}, {24'h161016}, {24'h2c1f2a}, {24'h4a3447}, {24'h6a4a65}, {24'h855d7f}, {24'ha1719b}, {24'hb780ae}, {24'hc38bb5}, {24'hcf95bd}, {24'hdaa1b3}, {24'he2ada5}, {24'heaba96}, {24'hedc480}, {24'hf1ce6a}, {24'hedcf58}, {24'he4cc48}, {24'hdbc73a}, {24'hcbba36}, {24'hbcaf34}, {24'hafa436}, {24'ha39b3e}, {24'h979346}, {24'h9f9e57}, {24'ha8aa68}, {24'hb5b877}, {24'hc7cb83}, {24'hd9dd8f}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h020102}, {24'h150f15}, {24'h291d27}, {24'h463143}, {24'h6d4c69}, {24'h94678e}, {24'ha975a1}, {24'hbb82b3}, {24'hc68bbc}, {24'hc48cb4}, {24'hc28dad}, {24'hca989d}, {24'hd4a88b}, {24'hdeb77a}, {24'he8c569}, {24'hf2d458}, {24'hf1d74c}, {24'hedd743}, {24'he8d53b}, {24'hdece3e}, {24'hd3c641}, {24'hcbc148}, {24'hc4be54}, {24'hbbb95f}, {24'hc1c16d}, {24'hc6c97c}, {24'hced288}, {24'hdadd91}, {24'he4e899}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h020102}, {24'h1e151d}, {24'h3b2938}, {24'h61445d}, {24'h8f648a}, {24'hbf84b8}, {24'hcc8dc3}, {24'hd593cb}, {24'hd694c9}, {24'hc58cb4}, {24'hb4839d}, {24'hba9087}, {24'hc7a271}, {24'hd3b45d}, {24'he2c651}, {24'hf2d945}, {24'hf7e140}, {24'hf6e23e}, {24'hf5e33e}, {24'hf0e146}, {24'hecdf4f}, {24'he8de5b}, {24'he3de6a}, {24'he1e078}, {24'he3e384}, {24'he5e890}, {24'he7ec99}, {24'hebf09e}, {24'heef3a1}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h030203}, {24'h070507}, {24'h261b25}, {24'h443042}, {24'h6b4b67}, {24'h996a93}, {24'hc78abf}, {24'hca8cc2}, {24'hcc8dc3}, {24'hc389b8}, {24'had7c9c}, {24'h976e80}, {24'ha07e6c}, {24'hb29559}, {24'hc3ab49}, {24'hdac343}, {24'hf1da3c}, {24'hf9e43e}, {24'hf9e644}, {24'hf9e94a}, {24'hf6e956}, {24'hf4ea62}, {24'hf1eb6e}, {24'hefec7b}, {24'hedee88}, {24'heef093}, {24'hedf19c}, {24'hedf2a3}, {24'hecf1a7}, {24'hebf1ad}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h070506}, {24'h0d090c}, {24'h2c1f2a}, {24'h4c3549}, {24'h714f6d}, {24'h996a93}, {24'hc287ba}, {24'hbc83b5}, {24'hb57ead}, {24'ha6759c}, {24'h8d667d}, {24'h74565f}, {24'h826a4f}, {24'h998442}, {24'hb29f38}, {24'hd0bc38}, {24'hf0db37}, {24'hfae740}, {24'hfaeb4d}, {24'hfbee5a}, {24'hf8f068}, {24'hf7f276}, {24'hf5f381}, {24'hf4f58c}, {24'hf2f596}, {24'hf0f49d}, {24'heef3a4}, {24'hebf1ab}, {24'he7edb1}, {24'he3e9b6}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h090608}, {24'h110b10}, {24'h30212e}, {24'h4e374c}, {24'h704e6c}, {24'h92668d}, {24'hb57ead}, {24'ha976a1}, {24'h9a6c93}, {24'h87607e}, {24'h6f5160}, {24'h554140}, {24'h675635}, {24'h83752e}, {24'ha1942b}, {24'hc7b730}, {24'hedd936}, {24'hfae945}, {24'hfbee57}, {24'hfcf36a}, {24'hfbf579}, {24'hf9f887}, {24'hf8fa92}, {24'hf7fa9a}, {24'hf6fba1}, {24'hf2f8a6}, {24'heff4ac}, {24'heaf0b1}, {24'he3e9b7}, {24'hdce2bd}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h080508}, {24'h0e0a0d}, {24'h231922}, {24'h392837}, {24'h50384d}, {24'h664862}, {24'h7c5778}, {24'h755270}, {24'h6c4c67}, {24'h604559}, {24'h523d44}, {24'h43352f}, {24'h584c2b}, {24'h766b2b}, {24'h968b2d}, {24'hbcb038}, {24'he3d442}, {24'hf3e754}, {24'hf7ee68}, {24'hfbf57b}, {24'hfaf786}, {24'hf9f991}, {24'hf7fa98}, {24'hf5f99e}, {24'hf4f9a3}, {24'heff5a7}, {24'hebf1ac}, {24'he6ebaf}, {24'he0e4b2}, {24'hd9ddb4}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h060406}, {24'h0a070a}, {24'h171117}, {24'h251a24}, {24'h30222f}, {24'h3b2a39}, {24'h453142}, {24'h422f3f}, {24'h3d2b3a}, {24'h3a2a34}, {24'h362a29}, {24'h31291f}, {24'h4a4221}, {24'h6a6227}, {24'h8c8430}, {24'hb3a940}, {24'hd9ce4f}, {24'hebe362}, {24'hf2ee77}, {24'hf9f88b}, {24'hf9f992}, {24'hf8fb9a}, {24'hf6fb9f}, {24'hf4f9a1}, {24'hf2f7a4}, {24'hedf2a8}, {24'he8edac}, {24'he2e7ae}, {24'hdde0ac}, {24'hd7d8ab}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h040304}, {24'h070507}, {24'h0f0a0e}, {24'h150f15}, {24'h1c141b}, {24'h20171f}, {24'h241a23}, {24'h241a22}, {24'h231921}, {24'h241c1f}, {24'h28221c}, {24'h2c281a}, {24'h484322}, {24'h69652e}, {24'h8c873b}, {24'hb2ac4d}, {24'hd7d15f}, {24'he8e471}, {24'hf1ef83}, {24'hf9fa93}, {24'hf8fa97}, {24'hf8fb9a}, {24'hf6fa9c}, {24'hf5f89c}, {24'hf3f59c}, {24'heef09d}, {24'he9eb9e}, {24'he5e69d}, {24'he0e09a}, {24'hdcda98}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h020102}, {24'h030203}, {24'h070507}, {24'h0b080a}, {24'h0f0a0e}, {24'h100c10}, {24'h120d12}, {24'h130f12}, {24'h161014}, {24'h191515}, {24'h242118}, {24'h2e2c1c}, {24'h4d4b2a}, {24'h716e3a}, {24'h94914b}, {24'hb6b45f}, {24'hd9d571}, {24'he9e780}, {24'hf2f18b}, {24'hf9fa97}, {24'hf9fa96}, {24'hf8fa96}, {24'hf8f993}, {24'hf7f790}, {24'hf5f48c}, {24'hf2f089}, {24'heeeb87}, {24'hebe784}, {24'he9e380}, {24'he6df7d}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h040403}, {24'h080706}, {24'h11100c}, {24'h212115}, {24'h32321f}, {24'h535332}, {24'h797947}, {24'h9d9d5c}, {24'hbbbc6f}, {24'hdbdb83}, {24'heaeb8e}, {24'hf1f393}, {24'hf9fb99}, {24'hf9fa95}, {24'hf9f990}, {24'hf9f88b}, {24'hf8f584}, {24'hf8f37d}, {24'hf6ef76}, {24'hf4eb70}, {24'hf2e86a}, {24'hf1e667}, {24'hf0e464}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h060604}, {24'h0c0c09}, {24'h181811}, {24'h333321}, {24'h4c4d31}, {24'h6f7146}, {24'h95965c}, {24'hb7b871}, {24'hcdcf7e}, {24'he3e58c}, {24'heeef8f}, {24'hf4f58e}, {24'hf9f98d}, {24'hfaf886}, {24'hfaf680}, {24'hfaf579}, {24'hfaf371}, {24'hfaf16a}, {24'hf8ef67}, {24'hf7ec65}, {24'hf5eb63}, {24'hf5ea64}, {24'hf4e965}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h080805}, {24'h0f100b}, {24'h212216}, {24'h44462d}, {24'h666943}, {24'h8c8e5a}, {24'hb0b371}, {24'hd0d385}, {24'hdfe18d}, {24'hecef94}, {24'hf4f591}, {24'hf7f68a}, {24'hfaf781}, {24'hfaf578}, {24'hfbf36f}, {24'hfbf266}, {24'hfcf05f}, {24'hfcef57}, {24'hfbee58}, {24'hfaed5a}, {24'hf9ed5c}, {24'hf8ee61}, {24'hf8ee66}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h020201}, {24'h030302}, {24'h0e0f0a}, {24'h1b1c12}, {24'h323422}, {24'h5a5d3b}, {24'h838556}, {24'ha5a96b}, {24'hc7cb81}, {24'he3e690}, {24'heaed91}, {24'hf3f593}, {24'hf7f68b}, {24'hf9f57e}, {24'hfbf473}, {24'hfbf36a}, {24'hfcf161}, {24'hfcf05a}, {24'hfdef55}, {24'hfdee50}, {24'hfcef55}, {24'hfbef5a}, {24'hfbf060}, {24'hfaf168}, {24'hfaf26f}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h040403}, {24'h070704}, {24'h0a0b07}, {24'h1d1e13}, {24'h313220}, {24'h4d4e33}, {24'h787a4f}, {24'ha2a66a}, {24'hbfc27b}, {24'hd8db8a}, {24'hecf093}, {24'hf1f28c}, {24'hf7f585}, {24'hf9f57b}, {24'hfbf36e}, {24'hfcf162}, {24'hfcf15c}, {24'hfcf056}, {24'hfdef54}, {24'hfdef54}, {24'hfdef54}, {24'hfcf15e}, {24'hfbf268}, {24'hfaf471}, {24'hfaf578}, {24'hf9f67f}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h010101}, {24'h020201}, {24'h060604}, {24'h0b0c08}, {24'h11120b}, {24'h2b2c1c}, {24'h45462d}, {24'h676944}, {24'h959861}, {24'hc2c67f}, {24'hd8dc8a}, {24'he8ec92}, {24'hf5f895}, {24'hf7f687}, {24'hfbf579}, {24'hfbf36b}, {24'hfcf05d}, {24'hfdee51}, {24'hfdee4e}, {24'hfdee4c}, {24'hfdee4e}, {24'hfdef54}, {24'hfdf059}, {24'hfcf267}, {24'hfbf576}, {24'hfaf781}, {24'hf9f889}, {24'hf9f990}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h020201}, {24'h030302}, {24'h060604}, {24'h0a0a06}, {24'h12130c}, {24'h202115}, {24'h2d2f1e}, {24'h4a4c30}, {24'h676943}, {24'h888b59}, {24'hadb171}, {24'hd2d689}, {24'he3e690}, {24'heef294}, {24'hf8fa92}, {24'hf9f783}, {24'hfbf575}, {24'hfbf36a}, {24'hfcf15f}, {24'hfdef56}, {24'hfcf057}, {24'hfcf059}, {24'hfcf15d}, {24'hfcf265}, {24'hfcf36d}, {24'hfbf578}, {24'hfaf883}, {24'hf9f98c}, {24'hf9fa92}, {24'hf9fb97}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h030302}, {24'h060604}, {24'h0c0c08}, {24'h11120b}, {24'h1f2014}, {24'h353723}, {24'h4c4e32}, {24'h6b6e46}, {24'h8b8e5b}, {24'ha9ad6f}, {24'hc5c981}, {24'he2e693}, {24'hecf096}, {24'hf3f593}, {24'hf9fa8f}, {24'hfaf781}, {24'hfbf473}, {24'hfbf369}, {24'hfcf263}, {24'hfcf15e}, {24'hfcf263}, {24'hfbf368}, {24'hfbf46f}, {24'hfaf678}, {24'hfaf782}, {24'hf9f989}, {24'hf9fa90}, {24'hf8fb96}, {24'hf8fc9a}, {24'hf8fc9d}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h060604}, {24'h0b0b08}, {24'h15160e}, {24'h202115}, {24'h333522}, {24'h505335}, {24'h6c7048}, {24'h8c8f5b}, {24'habaf70}, {24'hc5ca81}, {24'hd9dd8e}, {24'hecf19a}, {24'hf3f79a}, {24'hf7f996}, {24'hf9fa8f}, {24'hfaf782}, {24'hfbf575}, {24'hfbf46f}, {24'hfbf36b}, {24'hfcf369}, {24'hfbf470}, {24'hfaf578}, {24'hfaf780}, {24'hf9f989}, {24'hf9fa92}, {24'hf9fb96}, {24'hf8fc9a}, {24'hf8fc9d}, {24'hf8fda0}, {24'hf8fda2}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h0c0c08}, {24'h14140d}, {24'h28291b}, {24'h3c3e28}, {24'h575939}, {24'h76784e}, {24'h969962}, {24'hadb172}, {24'hc4c880}, {24'hd8dc8d}, {24'he5e995}, {24'hf1f69e}, {24'hf5f99d}, {24'hf7fb9a}, {24'hf9fb96}, {24'hf9f98c}, {24'hfaf782}, {24'hfaf67e}, {24'hfaf67c}, {24'hfaf67b}, {24'hfaf782}, {24'hf9f888}, {24'hf9f98e}, {24'hf9fa93}, {24'hf8fc99}, {24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fd9f}, {24'hf8fda0}, {24'hf8fda2}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h12120c}, {24'h1d1d13}, {24'h3b3c27}, {24'h585b3b}, {24'h797b50}, {24'h9c9f67}, {24'hbec17d}, {24'hcfd287}, {24'hdfe391}, {24'heaef99}, {24'hf0f59c}, {24'hf5f99f}, {24'hf7fb9f}, {24'hf7fc9e}, {24'hf8fc9d}, {24'hf9fb96}, {24'hf9fa90}, {24'hf9f98e}, {24'hf9f98e}, {24'hf9f98e}, {24'hf9fa93}, {24'hf8fb98}, {24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fd9f}, {24'hf8fda0}, {24'hf8fda0}, {24'hf8fda1}, {24'hf8fda1}, {24'hf8fda2}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h202115}, {24'h323321}, {24'h545638}, {24'h77794f}, {24'h979a64}, {24'hb6b977}, {24'hd4d78b}, {24'hdfe392}, {24'he9ee98}, {24'hf1f69e}, {24'hf4f89f}, {24'hf7fba0}, {24'hf8fca1}, {24'hf8fca1}, {24'hf8fca0}, {24'hf8fc9c}, {24'hf8fb97}, {24'hf8fa96}, {24'hf9fa96}, {24'hf9fa96}, {24'hf8fb99}, {24'hf8fc9b}, {24'hf8fc9d}, {24'hf8fc9e}, {24'hf8fc9e}, {24'hf8fc9d}, {24'hf8fc9c}, {24'hf8fc9c}, {24'hf8fc9c}, {24'hf8fc9d}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h333421}, {24'h494a30}, {24'h6f7149}, {24'h959862}, {24'hb4b776}, {24'hcbcf86}, {24'he4e895}, {24'heaef99}, {24'hf1f69f}, {24'hf5faa1}, {24'hf6faa1}, {24'hf6fba1}, {24'hf7fca2}, {24'hf7fca2}, {24'hf7fca2}, {24'hf7fc9f}, {24'hf8fb9d}, {24'hf8fb9c}, {24'hf8fb9b}, {24'hf8fb9a}, {24'hf8fb9b}, {24'hf8fc9b}, {24'hf8fc9b}, {24'hf8fc9b}, {24'hf8fc9b}, {24'hf8fb98}, {24'hf9fb96}, {24'hf9fa94}, {24'hf9fb96}, {24'hf9fb97}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h47482f}, {24'h636542}, {24'h8a8d5b}, {24'hb1b474}, {24'hcdd186}, {24'hdfe392}, {24'hf0f59d}, {24'hf4f9a0}, {24'hf6fba2}, {24'hf7fca4}, {24'hf7fca3}, {24'hf6fba3}, {24'hf6fba4}, {24'hf5fba4}, {24'hf5faa5}, {24'hf5faa4}, {24'hf5faa4}, {24'hf6faa2}, {24'hf7fa9f}, {24'hf7fa9d}, {24'hf8fb9a}, {24'hf8fb97}, {24'hf8fb95}, {24'hf8fa94}, {24'hf8fa92}, {24'hf9f98f}, {24'hf9f98c}, {24'hf9f88a}, {24'hf9f98c}, {24'hf9f98e}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h666843}, {24'h838656}, {24'ha3a76b}, {24'hc2c680}, {24'hd9dd8f}, {24'he6eb97}, {24'hf2f7a0}, {24'hf3f8a3}, {24'hf4f9a5}, {24'hf4f9a8}, {24'hf2f8a9}, {24'hf1f6aa}, {24'heff5ab}, {24'heef4ad}, {24'hecf3ae}, {24'hedf2ad}, {24'hecf1aa}, {24'heef2a5}, {24'hf1f39d}, {24'hf4f595}, {24'hf6f58c}, {24'hf8f683}, {24'hf9f67c}, {24'hf9f578}, {24'hfaf575}, {24'hfaf473}, {24'hfaf473}, {24'hfaf474}, {24'hfaf476}, {24'hf9f578}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h858858}, {24'ha4a86c}, {24'hbdc07c}, {24'hd4d98b}, {24'he5ea97}, {24'hecf19d}, {24'hf4f9a4}, {24'hf3f9a6}, {24'hf2f8a9}, {24'hf0f6ac}, {24'heef4ae}, {24'hebf0af}, {24'he8eeb2}, {24'he6edb6}, {24'he3ebb8}, {24'he3e9b4}, {24'he3e9b2}, {24'he6eaa9}, {24'hebec9c}, {24'hefee8e}, {24'hf4f07f}, {24'hf8f070}, {24'hfaf065}, {24'hfbf05e}, {24'hfbef57}, {24'hfbef59}, {24'hfaee5b}, {24'hfaef5d}, {24'hfaef60}, {24'hfaf063}, {0{24'h0}}};
					10'd36 : pattern <= {{24'ha1a56a}, {24'hbfc37d}, {24'hcfd488}, {24'he1e693}, {24'heaf09c}, {24'heef3a1}, {24'hf0f6a6}, {24'hedf3aa}, {24'he9f0ae}, {24'he5ebb1}, {24'he0e7b4}, {24'hdce2b8}, {24'hd9e0bb}, {24'hd6dec0}, {24'hd3dbc0}, {24'hd2dabb}, {24'hd1d8b4}, {24'hd5d8a5}, {24'hdbdb93}, {24'he1de82}, {24'he8e270}, {24'hefe55f}, {24'hf1e552}, {24'hf0e24b}, {24'hefe045}, {24'heee047}, {24'hecde49}, {24'hecde4b}, {24'heee14d}, {24'hf1e550}, {0{24'h0}}};
					10'd37 : pattern <= {{24'hbec17c}, {24'hd5d98b}, {24'hdfe492}, {24'he9ef9a}, {24'hedf3a0}, {24'hecf2a5}, {24'heaf0a9}, {24'he3eaaf}, {24'hdde4b3}, {24'hd5ddb8}, {24'hd0d7bd}, {24'hc8d1c2}, {24'hc4cdc6}, {24'hc2caca}, {24'hbec7ca}, {24'hbdc4bf}, {24'hbcc3b3}, {24'hbfc39f}, {24'hc6c689}, {24'hcdc973}, {24'hd6ce60}, {24'he0d44e}, {24'he2d442}, {24'hded03d}, {24'hdccd39}, {24'hd9ca39}, {24'hd6c739}, {24'hd6c73a}, {24'hdccd3c}, {24'he1d23e}, {0{24'h0}}};
					10'd38 : pattern <= {{24'hd8dc8c}, {24'he9ee97}, {24'hedf39c}, {24'hf1f7a0}, {24'hf0f6a4}, {24'he9f0a8}, {24'he3e9ab}, {24'hd9e0b1}, {24'hcfd7b8}, {24'hc6cdbe}, {24'hbdc5c3}, {24'hb3bcc9}, {24'hb0b9ce}, {24'hacb6d2}, {24'ha9b3d1}, {24'ha7afc0}, {24'ha5acaf}, {24'ha9ac98}, {24'hafae7d}, {24'hb8b163}, {24'hc4ba50}, {24'hcec13d}, {24'hd0c133}, {24'hcbbc30}, {24'hc5b62d}, {24'hc1b32b}, {24'hbdae2a}, {24'hbeaf2a}, {24'hc7b72b}, {24'hd0c02d}, {0{24'h0}}};
					10'd39 : pattern <= {{24'hdfe391}, {24'hebf099}, {24'heef39d}, {24'hf0f6a0}, {24'hecf1a2}, {24'he1e7a2}, {24'hd4daa2}, {24'hc4caa5}, {24'hb3b9a8}, {24'ha5acaa}, {24'h9ba3ad}, {24'h939aae}, {24'h8d94ad}, {24'h8890ab}, {24'h838ba6}, {24'h818898}, {24'h7e838a}, {24'h818377}, {24'h868561}, {24'h8b874b}, {24'h918a3c}, {24'h968c2d}, {24'h978b26}, {24'h948924}, {24'h918722}, {24'h8f8521}, {24'h8d8220}, {24'h8f8420}, {24'h958921}, {24'h9b8f22}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd29 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {11{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030203}, {11{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040304}, {11{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030203}, {11{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020102}, {11{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020102}, {11{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {11{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {11{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {11{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030302}, {11{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050503}, {11{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h070705}, {11{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h010100}, {24'h010101}, {24'h040403}, {24'h060604}, {24'h10110b}, {11{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h010100}, {24'h030302}, {24'h080805}, {24'h0c0d08}, {24'h1d1e13}, {11{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030302}, {24'h030302}, {24'h050503}, {24'h0d0e09}, {24'h17180f}, {24'h2b2d1d}, {11{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h060704}, {24'h060704}, {24'h0a0b07}, {24'h1d1e13}, {24'h2e301f}, {24'h48492f}, {11{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0a0b07}, {24'h0a0b07}, {24'h10110b}, {24'h2b2d1d}, {24'h46472e}, {24'h646642}, {11{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h14150d}, {24'h14150d}, {24'h1c1d12}, {24'h40412a}, {24'h636541}, {24'h838656}, {11{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h222215}, {24'h222215}, {24'h2b2b1b}, {24'h575938}, {24'h858856}, {24'ha4a86b}, {11{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h2f2f1d}, {24'h2f2f1d}, {24'h3a3a24}, {24'h707248}, {24'ha5a96b}, {24'hc4c97f}, {11{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h393924}, {24'h393924}, {24'h44452b}, {24'h7c7f51}, {24'hb5b976}, {24'hd1d589}, {11{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd30 : begin
				case(line)
					10'd0 : pattern <= {{24'ha0bafa}, {24'h9fb9f9}, {24'h9fb7f5}, {24'h9db5f2}, {24'h93a8da}, {24'h8394b5}, {24'h738090}, {24'h5f6666}, {24'h4b4d3b}, {24'h37361f}, {24'h242312}, {24'h100f06}, {24'h090903}, {24'h040401}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h9ab3f1}, {24'h98b0ed}, {24'h96ade8}, {24'h92a8e1}, {24'h8497c7}, {24'h6e7e9f}, {24'h5a6579}, {24'h464d54}, {24'h333530}, {24'h232318}, {24'h16160e}, {24'h0a0a04}, {24'h050502}, {24'h020201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h90a7e0}, {24'h8ba1d6}, {24'h8499cd}, {24'h7f92c3}, {24'h6e7fa7}, {24'h56637f}, {24'h3f4858}, {24'h30363c}, {24'h212322}, {24'h151610}, {24'h0d0e09}, {24'h060603}, {24'h040402}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h869bcf}, {24'h7d90c1}, {24'h7485b2}, {24'h6b7ca5}, {24'h576585}, {24'h3d475d}, {24'h242b36}, {24'h1a1e25}, {24'h0f1113}, {24'h080909}, {24'h060605}, {24'h030302}, {24'h010100}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h697aa2}, {24'h606f94}, {24'h566384}, {24'h4c5774}, {24'h3c465c}, {24'h29303f}, {24'h171c23}, {24'h101318}, {24'h090a0c}, {24'h040505}, {24'h030303}, {24'h010100}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h4b5774}, {24'h424c66}, {24'h373f54}, {24'h2b3242}, {24'h202532}, {24'h151921}, {24'h0b0d10}, {24'h07090b}, {24'h040505}, {24'h020202}, {24'h020201}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h31384b}, {24'h292f3f}, {24'h1e232f}, {24'h14171f}, {24'h0d0f14}, {24'h08090c}, {24'h020304}, {24'h020203}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h1f2330}, {24'h1a1d27}, {24'h12151d}, {24'h0b0d12}, {24'h07080b}, {24'h040507}, {24'h010202}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h0d0f14}, {24'h0a0c10}, {24'h07080b}, {24'h040406}, {24'h020203}, {24'h010102}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h090a0e}, {24'h06070a}, {24'h040507}, {24'h020203}, {24'h010102}, {24'h000001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h090a0e}, {24'h06070a}, {24'h040507}, {24'h020203}, {24'h010102}, {24'h000001}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd31 : begin
				case(line)
					10'd0 : pattern <= {{24'hfcf059}, {24'hfdef54}, {24'hfdef50}, {24'hfeee4b}, {24'hfeed45}, {24'hffec3f}, {24'hffeb3c}, {24'hffeb39}, {24'hffea37}, {24'hffea36}, {24'hffea36}, {24'hfde93a}, {24'hfbe83f}, {24'hf8e645}, {24'hf1e353}, {24'hebe061}, {24'he3dc71}, {24'hdcd881}, {24'hd4d491}, {24'hced19f}, {24'hc7cfac}, {24'hc1cbbb}, {24'hb9c7cb}, {24'hb2c3dc}, {24'hadc1e6}, {24'ha8bff1}, {24'ha4bdf8}, {24'ha2bcf9}, {24'ha1bbfb}, {24'ha1bbfb}, {0{24'h0}}};
					10'd1 : pattern <= {{24'hf9e948}, {24'hf9e846}, {24'hf9e843}, {24'hf8e63f}, {24'hfae73d}, {24'hfae639}, {24'hfbe638}, {24'hfce838}, {24'hfce838}, {24'hfae639}, {24'hf8e53b}, {24'hf4e241}, {24'hf1e049}, {24'hebde53}, {24'he4da65}, {24'hdcd779}, {24'hd4d48b}, {24'hcdd09e}, {24'hc6cdb1}, {24'hc0cabd}, {24'hbac7c7}, {24'hb4c4d3}, {24'hafc0dd}, {24'ha9bee7}, {24'ha6bcef}, {24'ha4bcf6}, {24'ha2bcfa}, {24'ha0baf9}, {24'h9fb8f8}, {24'h9db6f5}, {0{24'h0}}};
					10'd2 : pattern <= {{24'hf2e13f}, {24'hf0df3d}, {24'heddc3b}, {24'heedc39}, {24'hefdc37}, {24'hf0dd36}, {24'hf3e037}, {24'hf6e338}, {24'hf7e33b}, {24'hf1e040}, {24'hebdb44}, {24'he5d74d}, {24'hddd259}, {24'hd6ce67}, {24'hcfcd7e}, {24'hc8cb95}, {24'hc1c8a9}, {24'hbec8bb}, {24'hb9c7cc}, {24'hb4c4d4}, {24'hb0c1db}, {24'habbfe2}, {24'ha6bbe6}, {24'ha1b8eb}, {24'ha1b9f0}, {24'ha1bbf7}, {24'ha1bbfa}, {24'h9eb7f5}, {24'h9bb3f1}, {24'h96ade9}, {0{24'h0}}};
					10'd3 : pattern <= {{24'hecd937}, {24'he7d434}, {24'he3d134}, {24'he2d032}, {24'he4d132}, {24'he6d332}, {24'hebd835}, {24'hf1df39}, {24'hf2e03f}, {24'he8d846}, {24'hddd04d}, {24'hd3ca5b}, {24'hc9c469}, {24'hbfbe7b}, {24'hb9bf97}, {24'hb3bdb1}, {24'hb0bec7}, {24'hafbfd8}, {24'hacc0e8}, {24'ha9bdeb}, {24'ha5bcf0}, {24'ha1b9f0}, {24'h9db6ef}, {24'h99b2ed}, {24'h9cb5f2}, {24'h9fb8f8}, {24'h9fb9f9}, {24'h9ab3f1}, {24'h97aeea}, {24'h8fa4dd}, {0{24'h0}}};
					10'd4 : pattern <= {{24'hab9d27}, {24'had9f27}, {24'hb0a227}, {24'hb3a528}, {24'hb5a628}, {24'hb7a828}, {24'hb8a92a}, {24'hb9ab2d}, {24'hb7a931}, {24'hb1a539}, {24'haaa141}, {24'ha39e4f}, {24'h9d9c60}, {24'h979970}, {24'h939a87}, {24'h8f9a9d}, {24'h8c9aac}, {24'h8d9cb7}, {24'h8b9dc2}, {24'h8a9dc7}, {24'h899dcc}, {24'h879ccd}, {24'h859acc}, {24'h8398cc}, {24'h8398cc}, {24'h8499cd}, {24'h8397cb}, {24'h7e91c3}, {24'h798cbc}, {24'h7283b1}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h655c17}, {24'h6f6619}, {24'h7a701b}, {24'h81761d}, {24'h847a1e}, {24'h867b1e}, {24'h81771f}, {24'h7c721f}, {24'h776f21}, {24'h756e2a}, {24'h736e33}, {24'h716f42}, {24'h6f7053}, {24'h6d7164}, {24'h6b7274}, {24'h697383}, {24'h68748c}, {24'h697592}, {24'h697797}, {24'h6a799c}, {24'h6b7ba1}, {24'h6c7da5}, {24'h6c7da5}, {24'h6c7da7}, {24'h697aa3}, {24'h66769e}, {24'h637299}, {24'h5f6d92}, {24'h5a688c}, {24'h536081}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h302c0b}, {24'h3d380e}, {24'h4b4511}, {24'h544d13}, {24'h564f14}, {24'h585115}, {24'h524b14}, {24'h494413}, {24'h443f15}, {24'h45411c}, {24'h464425}, {24'h474732}, {24'h474a42}, {24'h474c50}, {24'h474e5a}, {24'h464f64}, {24'h475069}, {24'h48526b}, {24'h4a536d}, {24'h4c5773}, {24'h4f5a78}, {24'h505d7b}, {24'h515d7d}, {24'h525e7e}, {24'h4e5977}, {24'h4a5470}, {24'h464f6a}, {24'h424c65}, {24'h3e4860}, {24'h384056}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h1a1806}, {24'h221f08}, {24'h292609}, {24'h2e2a0a}, {24'h2f2b0b}, {24'h302c0b}, {24'h2e2a0b}, {24'h2b270b}, {24'h28250c}, {24'h292711}, {24'h2a2916}, {24'h292a1e}, {24'h292b27}, {24'h2a2d30}, {24'h292d34}, {24'h282e3a}, {24'h2a303f}, {24'h2d3243}, {24'h2f3546}, {24'h303749}, {24'h32394c}, {24'h333b4e}, {24'h323a4d}, {24'h33394d}, {24'h303749}, {24'h2d3344}, {24'h2a3040}, {24'h292f3f}, {24'h282e3e}, {24'h232937}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h050501}, {24'h060501}, {24'h070602}, {24'h080702}, {24'h080702}, {24'h090802}, {24'h0a0903}, {24'h0b0a03}, {24'h0c0a04}, {24'h0d0c06}, {24'h0d0d07}, {24'h0c0d09}, {24'h0c0d0c}, {24'h0c0d0e}, {24'h0b0d0f}, {24'h0b0d10}, {24'h0e1015}, {24'h11131a}, {24'h15171f}, {24'h151820}, {24'h161921}, {24'h161921}, {24'h14171f}, {24'h13151d}, {24'h12141b}, {24'h101219}, {24'h101218}, {24'h101219}, {24'h10131a}, {24'h0f1218}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h040301}, {24'h060502}, {24'h060603}, {24'h070704}, {24'h060705}, {24'h060606}, {24'h050607}, {24'h050607}, {24'h050608}, {24'h07080b}, {24'h0b0c11}, {24'h0f1016}, {24'h101117}, {24'h101218}, {24'h0f1117}, {24'h0e0f15}, {24'h0c0d12}, {24'h0b0c11}, {24'h0b0c10}, {24'h0b0c10}, {24'h0b0d11}, {24'h0c0e13}, {24'h0b0c11}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h040301}, {24'h060502}, {24'h060603}, {24'h070704}, {24'h060705}, {24'h060606}, {24'h050607}, {24'h050607}, {24'h050608}, {24'h07080b}, {24'h0b0c11}, {24'h0f1016}, {24'h101117}, {24'h101218}, {24'h0f1117}, {24'h0e0f15}, {24'h0c0d12}, {24'h0b0c11}, {24'h0b0c10}, {24'h0b0c10}, {24'h0b0d11}, {24'h0c0e13}, {24'h0b0c11}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd32 : begin
				case(line)
					10'd0 : pattern <= {{24'h6a6218}, {24'h6e6519}, {24'h746b1a}, {24'h7d731d}, {24'h877c1f}, {24'h908521}, {24'h998c23}, {24'ha29525}, {24'hab9d28}, {24'hb5a62a}, {24'hbeaf2d}, {24'hc6b731}, {24'hcfc035}, {24'hd6c83a}, {24'hddcf40}, {24'he3d645}, {24'he8da49}, {24'heee04d}, {24'hf3e651}, {24'hf9ec56}, {24'hfdf05a}, {24'hfdf160}, {24'hfcf266}, {24'hfcf369}, {24'hfcf36b}, {24'hfbf46c}, {24'hfcf368}, {24'hfcf263}, {24'hfcf15f}, {24'hfcf15c}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h403b0f}, {24'h423d10}, {24'h464110}, {24'h514b12}, {24'h5c5514}, {24'h665e16}, {24'h706719}, {24'h796f1b}, {24'h83781d}, {24'h8c801f}, {24'h978b22}, {24'ha19525}, {24'hac9f28}, {24'hb6a92c}, {24'hc1b330}, {24'hcbbd33}, {24'hd3c436}, {24'hdacb39}, {24'he2d23c}, {24'he9d93e}, {24'heede42}, {24'hefe048}, {24'heee14f}, {24'hefe353}, {24'hf0e456}, {24'hf1e658}, {24'hf4e754}, {24'hf7e950}, {24'hf9ea4d}, {24'hf9ea4b}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h242109}, {24'h262309}, {24'h292609}, {24'h312d0b}, {24'h38330c}, {24'h3f3a0e}, {24'h46400f}, {24'h4d4711}, {24'h534c12}, {24'h5a5314}, {24'h645c16}, {24'h716819}, {24'h7d741d}, {24'h8a8020}, {24'h978c24}, {24'ha39827}, {24'haea22b}, {24'hb9ac2d}, {24'hc1b330}, {24'hc8ba32}, {24'hcec036}, {24'hcfc139}, {24'hd0c23d}, {24'hd3c63f}, {24'hd7ca41}, {24'hdbcd43}, {24'he4d542}, {24'heddd41}, {24'hf1e040}, {24'hf2e140}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h090802}, {24'h0a0902}, {24'h0c0b03}, {24'h100e03}, {24'h151304}, {24'h191705}, {24'h1c1a06}, {24'h201e07}, {24'h242108}, {24'h272408}, {24'h312d0b}, {24'h403b0e}, {24'h4f4911}, {24'h5e5714}, {24'h6e6518}, {24'h7d731b}, {24'h8a7f1e}, {24'h988c22}, {24'ha09324}, {24'ha89a26}, {24'haea028}, {24'hb1a32a}, {24'hb3a52c}, {24'hb7a92c}, {24'hbdae2c}, {24'hc4b52d}, {24'hd3c230}, {24'he2cf32}, {24'he9d634}, {24'hebd835}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h040401}, {24'h050501}, {24'h060501}, {24'h090802}, {24'h0b0a02}, {24'h0e0d03}, {24'h100f03}, {24'h121104}, {24'h141204}, {24'h171505}, {24'h1e1c06}, {24'h292609}, {24'h34300b}, {24'h403b0e}, {24'h4b4510}, {24'h575013}, {24'h615915}, {24'h6b6317}, {24'h736a1a}, {24'h7a701b}, {24'h80751d}, {24'h847a1f}, {24'h887d20}, {24'h8a7f21}, {24'h8b8021}, {24'h8d8221}, {24'h938721}, {24'h998d22}, {24'h9f9223}, {24'ha59725}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h020201}, {24'h020200}, {24'h030301}, {24'h040401}, {24'h040401}, {24'h050401}, {24'h060501}, {24'h070601}, {24'h080702}, {24'h090802}, {24'h0d0c03}, {24'h141204}, {24'h1b1905}, {24'h221f07}, {24'h2a2709}, {24'h302c0b}, {24'h37320c}, {24'h3d380d}, {24'h443e0f}, {24'h4b4511}, {24'h514a12}, {24'h575014}, {24'h5c5516}, {24'h5b5416}, {24'h575015}, {24'h534d14}, {24'h4f4913}, {24'h4b4512}, {24'h504a12}, {24'h5a5314}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020200}, {24'h060501}, {24'h090802}, {24'h0d0c03}, {24'h110f04}, {24'h141205}, {24'h181605}, {24'h1b1806}, {24'h211e07}, {24'h272409}, {24'h2d290a}, {24'h322e0c}, {24'h38340e}, {24'h35310e}, {24'h2f2c0d}, {24'h28250b}, {24'h1f1d09}, {24'h151406}, {24'h181606}, {24'h242108}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h030300}, {24'h050501}, {24'h070601}, {24'h090802}, {24'h0b0a02}, {24'h0d0c03}, {24'h0f0e03}, {24'h131104}, {24'h171505}, {24'h1b1906}, {24'h1f1d07}, {24'h232008}, {24'h211e08}, {24'h1d1b08}, {24'h191707}, {24'h131205}, {24'h0d0c04}, {24'h0e0d04}, {24'h141205}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h020200}, {24'h020200}, {24'h020200}, {24'h030301}, {24'h050501}, {24'h070701}, {24'h090902}, {24'h0c0b03}, {24'h0e0d03}, {24'h0d0c03}, {24'h0c0b03}, {24'h0a0903}, {24'h070602}, {24'h050502}, {24'h040401}, {24'h040401}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020200}, {24'h040401}, {24'h060601}, {24'h070601}, {24'h090802}, {24'h090802}, {24'h080702}, {24'h070602}, {24'h050402}, {24'h030301}, {24'h020201}, {24'h010100}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020200}, {24'h040401}, {24'h060601}, {24'h070601}, {24'h090802}, {24'h090802}, {24'h080702}, {24'h070602}, {24'h050402}, {24'h030301}, {24'h020201}, {24'h010100}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd33 : begin
				case(line)
					10'd0 : pattern <= {{24'he6eb97}, {24'hedf29b}, {24'heff49e}, {24'hf0f6a0}, {24'he8eea0}, {24'hd8dd9d}, {24'hc6cb9a}, {24'hadb499}, {24'h959c98}, {24'h838a98}, {24'h7a8196}, {24'h727894}, {24'h6a718c}, {24'h646a84}, {24'h5d647b}, {24'h5a5f70}, {24'h585b64}, {24'h595b55}, {24'h5c5b44}, {24'h5f5c33}, {24'h5e5928}, {24'h5d571d}, {24'h5d5618}, {24'h5c5517}, {24'h5c5616}, {24'h5d5716}, {24'h5f5716}, {24'h615916}, {24'h635b16}, {24'h665e18}, {0{24'h0}}};
					10'd1 : pattern <= {{24'hd8dc8d}, {24'hdfe391}, {24'hdfe393}, {24'he1e495}, {24'hd5da92}, {24'hc0c58c}, {24'habaf85}, {24'h909581}, {24'h757a7d}, {24'h616679}, {24'h5a5f76}, {24'h525771}, {24'h4a4f68}, {24'h44495f}, {24'h3f4355}, {24'h3c3f4c}, {24'h383b44}, {24'h393a39}, {24'h3a3a2c}, {24'h3c3920}, {24'h383519}, {24'h353111}, {24'h332f0e}, {24'h34310e}, {24'h36330d}, {24'h39340e}, {24'h3a350e}, {24'h3c370e}, {24'h3d380f}, {24'h3e390f}, {0{24'h0}}};
					10'd2 : pattern <= {{24'hb3b776}, {24'hbfc27d}, {24'hbfc27e}, {24'hbec27f}, {24'hb1b57a}, {24'h9b9e70}, {24'h848766}, {24'h6a6e5e}, {24'h515556}, {24'h3f434f}, {24'h383c4a}, {24'h323546}, {24'h2e3140}, {24'h2b2d3b}, {24'h272935}, {24'h24262e}, {24'h212228}, {24'h212121}, {24'h222119}, {24'h222112}, {24'h201e0e}, {24'h1d1b0a}, {24'h1d1a08}, {24'h1e1b08}, {24'h201d08}, {24'h211e08}, {24'h221f08}, {24'h221f08}, {24'h232009}, {24'h232009}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h8f905d}, {24'h9fa168}, {24'h9ea069}, {24'h9b9e68}, {24'h8d9061}, {24'h757854}, {24'h5d5f46}, {24'h45473b}, {24'h2e302f}, {24'h1d1f25}, {24'h181a20}, {24'h13141b}, {24'h111219}, {24'h111218}, {24'h101016}, {24'h0c0d10}, {24'h0a0a0c}, {24'h090909}, {24'h090806}, {24'h090804}, {24'h070603}, {24'h060602}, {24'h060602}, {24'h070602}, {24'h090802}, {24'h090802}, {24'h090802}, {24'h090802}, {24'h090803}, {24'h080802}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h5a5b3b}, {24'h656642}, {24'h656743}, {24'h656744}, {24'h5e5f40}, {24'h4d4f37}, {24'h3f402f}, {24'h2e2f26}, {24'h1d1f1d}, {24'h111216}, {24'h0e0f13}, {24'h0a0b0f}, {24'h0a0a0e}, {24'h090a0d}, {24'h090a0d}, {24'h07080a}, {24'h050506}, {24'h040404}, {24'h050403}, {24'h040302}, {24'h030301}, {24'h020201}, {24'h020201}, {24'h030301}, {24'h040301}, {24'h040301}, {24'h040301}, {24'h040301}, {24'h040401}, {24'h040401}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h232417}, {24'h28281a}, {24'h2b2b1c}, {24'h2d2d1e}, {24'h2b2c1e}, {24'h27271c}, {24'h212219}, {24'h181914}, {24'h0e0f0e}, {24'h070809}, {24'h060608}, {24'h040406}, {24'h040406}, {24'h040506}, {24'h040405}, {24'h030304}, {24'h020203}, {24'h020202}, {24'h020201}, {24'h020201}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {24'h020201}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h040402}, {24'h080805}, {24'h0a0a06}, {24'h0b0b08}, {24'h0d0d0a}, {24'h080806}, {24'h050504}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h020201}, {24'h040402}, {24'h060604}, {24'h070705}, {24'h070705}, {24'h050503}, {24'h030302}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd34 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h42432b}, {24'h42432b}, {24'h4f5033}, {24'h8a8d5a}, {24'hc5c982}, {24'hdfe391}, {11{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h3e3f28}, {24'h3e3f28}, {24'h4a4b30}, {24'h818455}, {24'hb9bc79}, {24'hd1d589}, {11{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h2d2e1d}, {24'h2d2e1d}, {24'h363824}, {24'h626441}, {24'h8e915d}, {24'ha6aa6d}, {11{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1a1b12}, {24'h1a1b12}, {24'h222317}, {24'h43442c}, {24'h646642}, {24'h7b7e51}, {11{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h10110b}, {24'h10110b}, {24'h14150e}, {24'h2a2b1c}, {24'h3e3f29}, {24'h4d4e32}, {11{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070705}, {24'h070705}, {24'h080805}, {24'h10110b}, {24'h181910}, {24'h1e1f14}, {11{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd35 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h700000}, {24'hbf0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hbf0000}, {24'hc00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h200000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hef0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h100000}, {24'hef0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h800000}, {24'hdf0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd36 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h3f0000}, {24'h3f0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'hbf0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hbf0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'h9f0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'haf0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hef0000}, {24'h300000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hcf0000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h500000}, {24'h500000}, {24'h900000}, {24'hf00000}, {24'hff0000}, {24'hef0000}, {24'h200000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hf00000}, {24'hff0000}, {24'h600000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'he00000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hcf0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hf00000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'he00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hc00000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'hc00000}, {24'hff0000}, {24'h500000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h700000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'hb00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h400000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'hdf0000}, {24'h4f0000}, {24'h100000}, {24'h200000}, {24'h4f0000}, {24'hef0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hf00000}, {24'hff0000}, {24'hef0000}, {24'h6f0000}, {24'h200000}, {24'h200000}, {24'h5f0000}, {24'hdf0000}, {24'hff0000}, {24'hf00000}, {24'h300000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h400000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'he00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hf00000}, {24'h300000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'h500000}, {24'h400000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'h500000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h070502}, {24'h030201}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h1e150b}, {24'h0e0905}, {24'h060502}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd37 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h300000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h9f0000}, {24'hef0000}, {24'hff0000}, {24'hff0000}, {24'hef0000}, {24'h9f0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hbf0000}, {24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hdf0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'hf00000}, {24'h900000}, {24'h400000}, {24'h500000}, {24'ha00000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h300000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h700000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hcf0000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'hcf0000}, {24'h5f0000}, {24'h100000}, {24'h300000}, {24'h6f0000}, {24'hef0000}, {24'hff0000}, {24'hd00000}, {24'h100000}, {24'h000000}, {24'h400000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'hdf0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hd00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hd00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hb00000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h100000}, {24'h500000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h0e0a05}, {24'h1d140a}, {24'h171008}, {24'h060402}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070502}, {24'h2e2010}, {24'h614322}, {24'h6c4b25}, {24'h6b4a25}, {24'h5c4020}, {24'h2f2010}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h312211}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5c4020}, {24'h1e150a}, {24'h090603}, {24'h0b0704}, {24'h0b0804}, {24'h0b0804}, {24'h0b0804}, {24'h0b0804}, {24'h0b0804}, {24'h0b0804}, {24'h0b0704}, {24'h0a0703}, {24'h080603}, {24'h070502}, {24'h050402}, {24'h030201}, {24'h020101}, {24'h010100}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h080503}, {24'h674824}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h684824}, {24'h2c1e0f}, {24'h281c0e}, {24'h2c1f0f}, {24'h2f2010}, {24'h312211}, {24'h342412}, {24'h372613}, {24'h392814}, {24'h392714}, {24'h372612}, {24'h322311}, {24'h2c1e0f}, {24'h24190c}, {24'h1b1309}, {24'h100c05}, {24'h080603}, {24'h020100}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h161008}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5e4221}, {24'h483219}, {24'h4a3419}, {24'h4d351b}, {24'h4f371c}, {24'h533a1d}, {24'h563c1e}, {24'h593e20}, {24'h593e1f}, {24'h583d1d}, {24'h52391c}, {24'h4c341a}, {24'h422e17}, {24'h372713}, {24'h281c0e}, {24'h1b1309}, {24'h0e0a04}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h110c06}, {24'h694925}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h674824}, {24'h664724}, {24'h674824}, {24'h684824}, {24'h684824}, {24'h694925}, {24'h6a4a25}, {24'h694925}, {24'h694924}, {24'h674824}, {24'h644623}, {24'h604321}, {24'h5a3f20}, {24'h51391c}, {24'h432e17}, {24'h2f2210}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd38 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h3f0000}, {24'h3f0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'hbf0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h5f0000}, {24'haf0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hef0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h900000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'he00000}, {24'h700000}, {24'h400000}, {24'h400000}, {24'h400000}, {24'hc00000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hef0000}, {24'hff0000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'ha00000}, {24'hff0000}, {24'hf00000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'he00000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hdf0000}, {24'hff0000}, {24'h900000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'he00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'h7f0000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h100000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'h5f0000}, {24'hbf0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {24'hef0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'h800000}, {24'ha00000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hf00000}, {24'ha00000}, {24'h200000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hf00000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'ha00000}, {24'h500000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'ha00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {24'hff0000}, {24'h400000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'he00000}, {24'hff0000}, {24'h700000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'h600000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h900000}, {24'hff0000}, {24'hd00000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hb00000}, {24'hff0000}, {24'h800000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hff0000}, {24'hff0000}, {24'h300000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hef0000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100000}, {24'hb00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {24'hff0000}, {24'hdf0000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h7f0000}, {24'h9f0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'hf00000}, {24'hff0000}, {24'hcf0000}, {24'h4f0000}, {24'h100000}, {24'h000000}, {24'h300000}, {24'h8f0000}, {24'hef0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'hf00000}, {24'hff0000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hff0000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hc00000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h500000}, {24'hf00000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hff0000}, {24'hb00000}, {24'h400000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h300000}, {24'h500000}, {24'h700000}, {24'h400000}, {24'h100000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd39 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hbf0000}, {11{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hff0000}, {11{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h800000}, {11{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {11{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'hc00000}, {11{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h600000}, {11{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h200000}, {24'h7f0000}, {11{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {11{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h400000}, {24'hff0000}, {11{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd40 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd41 : begin
				case(line)
					10'd0 : pattern <= {{24'h3a2814}, {24'h261a0d}, {24'h140e07}, {24'h070503}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h5a3f20}, {24'h4a341a}, {24'h2a1d0f}, {24'h110c06}, {24'h070502}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h664724}, {24'h5b4020}, {24'h402d16}, {24'h271b0d}, {24'h130d06}, {24'h070502}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h6c4c26}, {24'h674824}, {24'h563c1d}, {24'h412d16}, {24'h22180b}, {24'h0f0a04}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h6e4d26}, {24'h6c4b25}, {24'h634523}, {24'h533a1d}, {24'h372613}, {24'h1e150b}, {24'h090603}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h6d4c26}, {24'h634623}, {24'h4b341b}, {24'h2f2111}, {24'h100b06}, {24'h060402}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6a4a25}, {24'h5f4221}, {24'h442f18}, {24'h20170b}, {24'h0e0a05}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6d4b25}, {24'h533a1d}, {24'h2f2010}, {24'h150f07}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h5a3f1f}, {24'h3a2914}, {24'h1b1309}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5d4020}, {24'h412d16}, {24'h1e150a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5e4121}, {24'h432e18}, {24'h1f150b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h5f4221}, {24'h463118}, {24'h20160b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h604321}, {24'h4a3419}, {24'h21170b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h614422}, {24'h4d361b}, {24'h22180c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h624422}, {24'h50381c}, {24'h23180c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h714f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h634522}, {24'h51391d}, {24'h23180d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h724f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h634522}, {24'h52391d}, {24'h23180c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h725029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h634523}, {24'h52391d}, {24'h22180c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h735029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h644623}, {24'h543a1d}, {24'h23180c}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h725029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h654723}, {24'h553c1f}, {24'h23180d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h714f28}, {24'h704e27}, {24'h704e27}, {24'h6e4d26}, {24'h6b4b25}, {24'h593e1f}, {24'h432f18}, {24'h1b130a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h75522a}, {24'h75532b}, {24'h76532b}, {24'h6f4e28}, {24'h654724}, {24'h4b351b}, {24'h2f2111}, {24'h130d07}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h805c32}, {24'h866136}, {24'h8c673b}, {24'h846139}, {24'h6b4f2d}, {24'h3d2c18}, {24'h191109}, {24'h0a0703}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h8b663a}, {24'h966f42}, {24'ha27a4a}, {24'ha37c4d}, {24'h9a7548}, {24'h4e3a23}, {24'h0d0905}, {24'h050302}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h977043}, {24'ha37b4b}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h82623e}, {24'h1a140c}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h9d7547}, {24'ha77e4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9f784b}, {24'h271d12}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd26 : pattern <= {{24'ha07849}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha67d4e}, {24'h2b2014}, {24'h030202}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd27 : pattern <= {{24'ha37b4b}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h2c2115}, {24'h030202}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd28 : pattern <= {{24'ha57d4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha57d4e}, {24'h2b2014}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd29 : pattern <= {{24'ha77e4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h987348}, {24'h17110b}, {24'h020101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h674e30}, {24'h050402}, {24'h010101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd31 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4e}, {24'h473621}, {24'h010100}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd32 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha17a4c}, {24'h2b2014}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd33 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h977247}, {24'h221910}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd34 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h926e44}, {24'h1c150d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd35 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h86663f}, {24'h18120b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd36 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h82623d}, {24'h16110a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd37 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h83633e}, {24'h16110a}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd38 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h8a6941}, {24'h18120b}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd39 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h977247}, {24'h21190f}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd42 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h050402}, {24'h50381c}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6e4c26}, {24'h6e4c26}, {24'h6e4d26}, {24'h6e4d26}, {24'h6f4d27}, {24'h6f4d27}, {24'h6f4d27}, {24'h6f4d27}, {24'h6f4d27}, {24'h6f4d27}, {24'h6e4c26}, {24'h6d4c26}, {24'h6b4a25}, {24'h664724}, {24'h5c4020}, {24'h4d361b}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h020101}, {24'h1f150b}, {24'h6e4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6e4d26}, {24'h6c4b25}, {24'h684824}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h060402}, {24'h171008}, {24'h483219}, {24'h6c4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6e4d26}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h010100}, {24'h0c0904}, {24'h291c0e}, {24'h463118}, {24'h634623}, {24'h6c4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h030201}, {24'h150f07}, {24'h3f2c16}, {24'h593e1f}, {24'h6b4b25}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h020101}, {24'h0a0703}, {24'h21170b}, {24'h4c351b}, {24'h634522}, {24'h6e4d26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h725028}, {24'h725028}, {24'h714f28}, {24'h714f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h030201}, {24'h130d07}, {24'h2e2010}, {24'h563c1e}, {24'h694924}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h725029}, {24'h73512a}, {24'h76542c}, {24'h78552c}, {24'h74522a}, {24'h725029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h050302}, {24'h1b120a}, {24'h372613}, {24'h5b4020}, {24'h6a4a25}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6e4d27}, {24'h6d4c26}, {24'h6d4c26}, {24'h6e4c27}, {24'h73522b}, {24'h846036}, {24'h977043}, {24'h977043}, {24'h8a653a}, {24'h77542d}, {24'h6e4d27}, {24'h6e4c26}, {24'h6e4d26}, {24'h6f4d26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h070502}, {24'h23180d}, {24'h412d16}, {24'h604321}, {24'h6c4b26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h694925}, {24'h543a1d}, {24'h4c351b}, {24'h5d4122}, {24'h78562e}, {24'ha07849}, {24'ha87f4f}, {24'ha87f4f}, {24'ha37b4b}, {24'h825f35}, {24'h674825}, {24'h593e1f}, {24'h614422}, {24'h6d4c26}, {24'h6f4d26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h010100}, {24'h0a0704}, {24'h2d1f10}, {24'h4b341a}, {24'h654623}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6a4926}, {24'h493319}, {24'h110c06}, {24'h0a0704}, {24'h20170c}, {24'h765835}, {24'ha77f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h7e5f39}, {24'h22180c}, {24'h0b0804}, {24'h130d06}, {24'h4c351a}, {24'h6a4a25}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h040301}, {24'h100c06}, {24'h372613}, {24'h543b1d}, {24'h694924}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6e4d27}, {24'h5e4222}, {24'h281c0e}, {24'h000000}, {24'h000000}, {24'h060402}, {24'h5a442a}, {24'ha27b4c}, {24'ha87f4f}, {24'ha87f4f}, {24'ha37c4d}, {24'h61492d}, {24'h050402}, {24'h000000}, {24'h000000}, {24'h281b0d}, {24'h5d4020}, {24'h6e4d26}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h090703}, {24'h1a1309}, {24'h412e17}, {24'h5c4020}, {24'h6c4b25}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h704f28}, {24'h654826}, {24'h2b1e11}, {24'h000000}, {24'h000000}, {24'h060503}, {24'h574129}, {24'ha37c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27b4c}, {24'h533e26}, {24'h030201}, {24'h000000}, {24'h000000}, {24'h20160b}, {24'h583d1f}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h140e07}, {24'h291d0e}, {24'h4c351a}, {24'h624422}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h725029}, {24'h76542c}, {24'h7a5831}, {24'h573f24}, {24'h150f09}, {24'h0c0906}, {24'h251c12}, {24'h6b5132}, {24'ha47c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha57d4e}, {24'h60492d}, {24'h0f0b07}, {24'h040302}, {24'h070503}, {24'h392915}, {24'h624523}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h20170b}, {24'h3a2914}, {24'h563c1e}, {24'h664724}, {24'h6e4d26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h74522a}, {24'h805c33}, {24'h946f41}, {24'h977146}, {24'h7b5d3a}, {24'h664d30}, {24'h735736}, {24'h7a5b39}, {24'h735836}, {24'h6f5434}, {24'h795b38}, {24'h896740}, {24'h785b39}, {24'h574229}, {24'h3e2f1d}, {24'h4c3822}, {24'h715230}, {24'h7c5a32}, {24'h76542c}, {24'h725028}, {24'h704e27}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h2b1e0f}, {24'h483219}, {24'h5e4121}, {24'h6a4a25}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h724f28}, {24'h76532b}, {24'h8a6539}, {24'ha47c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27a4c}, {24'h7a5c39}, {24'h2c2114}, {24'h090704}, {24'h020201}, {24'h0b0805}, {24'h3e2e1d}, {24'h82633d}, {24'h8d6a42}, {24'h987247}, {24'ha0794b}, {24'ha37a4c}, {24'h9f7749}, {24'h946d41}, {24'h7b572e}, {24'h714e27}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h352412}, {24'h553a1e}, {24'h654723}, {24'h6d4c26}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h725029}, {24'h78552c}, {24'h977043}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27a4d}, {24'h40301e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0a0705}, {24'h755836}, {24'ha47c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h916b3f}, {24'h74522b}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h3a2914}, {24'h5a3e20}, {24'h684824}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h735129}, {24'h7a562e}, {24'h9c7547}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9b7549}, {24'h2d2215}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040302}, {24'h6a5032}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9a7345}, {24'h78552d}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h3d2b16}, {24'h5d4021}, {24'h694925}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h75512a}, {24'h7c582f}, {24'h9d7547}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha37b4d}, {24'h40311e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0e0b07}, {24'h7a5d39}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h956f42}, {24'h77542d}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h3d2b15}, {24'h5c4020}, {24'h694925}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h725028}, {24'h76532b}, {24'h7f5b32}, {24'h9f7748}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h86653f}, {24'h18120b}, {24'h0b0607}, {24'h2d1825}, {24'h22141b}, {24'h4e3a25}, {24'h977247}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h8f693d}, {24'h76542c}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h372613}, {24'h51391c}, {24'h624422}, {24'h6b4b25}, {24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h725028}, {24'h76542b}, {24'h815d34}, {24'ha1784a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha47c4d}, {24'ha27355}, {24'hcc7699}, {24'heb7fbf}, {24'hea80bc}, {24'hc27d7e}, {24'ha87d51}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h8a653a}, {24'h76542b}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h2b1e0f}, {24'h412d16}, {24'h563c1e}, {24'h644623}, {24'h6e4c26}, {24'h704e27}, {24'h704e27}, {24'h724f28}, {24'h76532b}, {24'h815c33}, {24'ha1794a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'haa7f52}, {24'hc5807d}, {24'hf483c8}, {24'hf683cc}, {24'hf683cc}, {24'hf383c7}, {24'hc3807a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9f7748}, {24'h805d33}, {24'h73512a}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h3e2b16}, {24'h4a341a}, {24'h5a3f20}, {24'h654723}, {24'h6e4d26}, {24'h7b5830}, {24'h8c663b}, {24'h8d673c}, {24'h825e34}, {24'h7d5a31}, {24'h997345}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'hab7f53}, {24'hd18190}, {24'hf683cc}, {24'hf683cc}, {24'hf683cc}, {24'hf683cc}, {24'he582b1}, {24'hab7f54}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27a4b}, {24'h886238}, {24'h7b572f}, {24'h73512a}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h553b1e}, {24'h593d1f}, {24'h624422}, {24'h694925}, {24'h725028}, {24'h9c7547}, {24'ha77e4e}, {24'ha77e4e}, {24'h9f7748}, {24'h815c33}, {24'h866237}, {24'ha67d4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'hc28078}, {24'hf583ca}, {24'hf683cc}, {24'hf683cc}, {24'hf683cc}, {24'hec82bc}, {24'hb48062}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27a4b}, {24'h845f35}, {24'h79562e}, {24'h77542c}, {24'h78552c}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h654623}, {24'h674824}, {24'h6a4a25}, {24'h6e4d27}, {24'h856237}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4e}, {24'h8f693d}, {24'h7a572f}, {24'h8f693d}, {24'ha57c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'hae7f58}, {24'he282ac}, {24'hf683cc}, {24'hf683cc}, {24'hf683cc}, {24'he181ab}, {24'haf7d5d}, {24'ha37b4b}, {24'h997244}, {24'h835f35}, {24'h78552d}, {24'h73512a}, {24'h78552d}, {24'h7e5a31}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h75532a}, {24'h946e41}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h946d41}, {24'h78552d}, {24'h735029}, {24'h76532c}, {24'h7d5931}, {24'h7f5b31}, {24'h805b32}, {24'h805c34}, {24'h9a6554}, {24'he27cb1}, {24'hf282c7}, {24'hed80c0}, {24'hac6c69}, {24'h845f36}, {24'h7d5a31}, {24'h78552c}, {24'h735029}, {24'h724f28}, {24'h704e27}, {24'h7b582f}, {24'h876237}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h6f4d27}, {24'h704e27}, {24'h704e27}, {24'h78552d}, {24'h9a7245}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h946d41}, {24'h7c582f}, {24'h735129}, {24'h725029}, {24'h714f28}, {24'h725028}, {24'h725029}, {24'h735129}, {24'h76522d}, {24'h8c5a48}, {24'hab676f}, {24'h9b605a}, {24'h7b5431}, {24'h74522a}, {24'h735129}, {24'h725028}, {24'h714f28}, {24'h714f28}, {24'h714f28}, {24'h805c32}, {24'h8e693d}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h573d1e}, {24'h5a3e1f}, {24'h5b3f20}, {24'h6e4e2a}, {24'h987144}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9f7749}, {24'h805c33}, {24'h74512a}, {24'h724f28}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f28}, {24'h73512a}, {24'h856136}, {24'h956f41}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h2d2010}, {24'h302211}, {24'h342512}, {24'h5a4125}, {24'h936c42}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4e}, {24'h8a6439}, {24'h74522a}, {24'h725028}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h73512a}, {24'h78552d}, {24'h8b663a}, {24'h9a7345}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h140e07}, {24'h1b130a}, {24'h251a0e}, {24'h563f26}, {24'h946f44}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h966f42}, {24'h75532b}, {24'h725029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h76542c}, {24'h7e5b32}, {24'h916b3f}, {24'h9f7849}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h010100}, {24'h0c0905}, {24'h1f160e}, {24'h5c452b}, {24'ha47c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9d7547}, {24'h76532b}, {24'h735029}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f27}, {24'h714f28}, {24'h7c592f}, {24'h886338}, {24'h987144}, {24'ha47b4c}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h040301}, {24'h1c150d}, {24'h423220}, {24'h906d43}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha47c4c}, {24'h7b562e}, {24'h735129}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f27}, {24'h724f28}, {24'h75532b}, {24'h7a572e}, {24'h866237}, {24'h936d40}, {24'h9e7748}, {24'ha67d4e}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h0c0906}, {24'h312517}, {24'h755938}, {24'ha77e4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h825d34}, {24'h74512a}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h714f27}, {24'h725028}, {24'h75522a}, {24'h7d5930}, {24'h896439}, {24'h956e42}, {24'ha07849}, {24'ha47c4d}, {24'ha87f4f}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h281e13}, {24'h5e472c}, {24'ha17a4c}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h866136}, {24'h76532b}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h704e27}, {24'h6f4d27}, {24'h6f4d27}, {24'h714f27}, {24'h77542c}, {24'h805d33}, {24'h8b663a}, {24'h977043}, {24'h9f7748}, {24'ha57c4d}, {24'ha77e4e}, {24'ha87f4f}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h503c26}, {24'h977247}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h866138}, {24'h75522a}, {24'h6f4d26}, {24'h6e4c26}, {24'h6e4c26}, {24'h6d4c26}, {24'h6d4c26}, {24'h6c4c26}, {24'h6c4b25}, {24'h6c4c25}, {24'h6f4e28}, {24'h7a582f}, {24'h8f693e}, {24'h9f7749}, {24'ha67e4e}, {24'ha77e4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h997448}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha67d4f}, {24'h7b5833}, {24'h6c4b27}, {24'h664623}, {24'h654623}, {24'h644623}, {24'h634522}, {24'h614422}, {24'h5f4321}, {24'h5c4020}, {24'h5b3f1f}, {24'h5e4222}, {24'h6e502c}, {24'h9e774a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {0{24'h0}}};
					10'd35 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9a7447}, {24'h594023}, {24'h50381e}, {24'h4c341a}, {24'h4b341a}, {24'h4a341a}, {24'h493319}, {24'h473118}, {24'h453118}, {24'h422e17}, {24'h412d17}, {24'h443019}, {24'h694e2e}, {24'ha77e4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {0{24'h0}}};
					10'd36 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h9c7649}, {24'h574128}, {24'h281d10}, {24'h23190d}, {24'h1f160b}, {24'h1e150b}, {24'h1d140a}, {24'h1c1309}, {24'h1a1209}, {24'h191209}, {24'h191109}, {24'h191108}, {24'h1a130a}, {24'h4a3721}, {24'ha67d4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd37 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h957046}, {24'h4d3a24}, {24'h291f13}, {24'h120d08}, {24'h0e0a05}, {24'h0b0804}, {24'h0a0704}, {24'h090703}, {24'h080603}, {24'h070502}, {24'h060503}, {24'h060402}, {24'h060402}, {24'h070402}, {24'h21190f}, {24'h9d774a}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd38 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h967147}, {24'h4b3923}, {24'h15110a}, {24'h0a0805}, {24'h030201}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h010100}, {24'h110d08}, {24'h4d3a24}, {24'ha67d4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd39 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h886740}, {24'h3e2e1d}, {24'h1e160e}, {24'h0a0705}, {24'h050302}, {24'h010100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h0a0805}, {24'h1e170e}, {24'h81623d}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd43 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h020101}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h040302}, {0{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h070503}, {0{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030301}, {24'h0a0704}, {0{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h040301}, {24'h0d0905}, {0{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h060402}, {24'h110c06}, {0{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070502}, {24'h130d07}, {0{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070503}, {24'h140e07}, {0{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h040301}, {24'h0a0704}, {24'h160f08}, {0{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h050402}, {24'h0a0704}, {24'h100b05}, {24'h181108}, {0{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070502}, {24'h0d0905}, {24'h160f07}, {24'h1c140a}, {24'h21180b}, {24'h281c0e}, {24'h2e2010}, {24'h312211}, {24'h362613}, {0{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h0d0905}, {24'h1b120a}, {24'h2c1e0f}, {24'h382714}, {24'h432f17}, {24'h4b341a}, {24'h52391d}, {24'h543a1d}, {24'h563b1e}, {0{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h150f07}, {24'h2a1d0e}, {24'h412c16}, {24'h51381c}, {24'h5b3f20}, {24'h604321}, {24'h644623}, {24'h654623}, {24'h654723}, {0{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h040301}, {24'h1b1209}, {24'h332312}, {24'h4e351b}, {24'h5f4121}, {24'h684825}, {24'h6b4b25}, {24'h6d4c26}, {24'h6e4d26}, {24'h704e27}, {0{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h050302}, {24'h1d140a}, {24'h352512}, {24'h50371c}, {24'h5d4121}, {24'h634522}, {24'h654623}, {24'h664724}, {24'h6a4a25}, {24'h6d4c26}, {0{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h040201}, {24'h150f07}, {24'h281c0e}, {24'h3b2815}, {24'h442f17}, {24'h483219}, {24'h49331a}, {24'h4b341a}, {24'h50381c}, {24'h543b1d}, {0{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020100}, {24'h0a0604}, {24'h120c06}, {24'h1a1209}, {24'h1f150b}, {24'h20150b}, {24'h21170b}, {24'h22180c}, {24'h261b0d}, {24'h2a1d0e}, {0{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h040301}, {24'h080503}, {24'h0b0804}, {24'h0d0904}, {24'h0e0905}, {24'h0e0a05}, {24'h0e0a05}, {24'h100b05}, {24'h120d06}, {0{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010100}, {0{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h050302}, {0{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h050302}, {24'h110d08}, {0{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010000}, {24'h030201}, {24'h070503}, {24'h130e09}, {24'h271d12}, {0{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h030201}, {24'h090704}, {24'h140f09}, {24'h2a2014}, {24'h4e3a25}, {0{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h030202}, {24'h0a0705}, {24'h130e08}, {24'h281e13}, {24'h42321f}, {24'h6d5233}, {24'h9d764a}, {0{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h040302}, {24'h090705}, {24'h1a140c}, {24'h3f301d}, {24'h755937}, {24'h967146}, {24'ha67d4e}, {24'ha87f4f}, {0{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030201}, {24'h0a0805}, {24'h18120b}, {24'h2d2216}, {24'h694f31}, {24'h9e774a}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h070503}, {24'h19130c}, {24'h382b1b}, {24'h8a6941}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010100}, {24'h0f0b07}, {24'h362919}, {24'h82623d}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd44 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd13 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd14 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd15 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd16 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd17 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd18 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd19 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd20 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd21 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd22 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd23 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd24 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd25 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd26 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd27 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd28 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd29 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd30 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd31 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd32 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd33 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd34 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd35 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd36 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd37 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd38 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					10'd39 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {11{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd45 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd46 : begin
				case(line)
					10'd0 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha0794b}, {24'h2d2215}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd1 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4e}, {24'h41311e}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd2 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h60492d}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd3 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h755837}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd4 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h755937}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd5 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha77e4f}, {24'h644c2f}, {24'h020101}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd6 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'h997348}, {24'h302417}, {24'h020101}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha27b4d}, {24'h564128}, {24'h130e09}, {24'h020101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'ha27b4d}, {24'h987347}, {24'h80603c}, {24'h483722}, {24'h1d160e}, {24'h0a0704}, {24'h020100}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h4b3823}, {24'h3a2b1b}, {24'h2d2115}, {24'h1a140d}, {24'h0b0906}, {24'h040302}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h18120b}, {24'h16100a}, {24'h130e09}, {24'h0b0805}, {24'h050402}, {24'h020101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd47 : begin
				case(line)
					10'd0 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha57d4e}, {24'h7b5d3a}, {24'h37291a}, {24'h130e09}, {24'h060403}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050302}, {24'h0d0a06}, {24'h4a3723}, {24'h9c7649}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd1 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha17a4c}, {24'h5b452b}, {24'h251c12}, {24'h120d08}, {24'h070503}, {24'h020101}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020101}, {24'h060403}, {24'h2d2215}, {24'h715435}, {24'ha37b4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd2 : pattern <= {{24'ha87f4f}, {24'ha87f4f}, {24'h926f45}, {24'h453420}, {24'h16100a}, {24'h090604}, {24'h020101}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h251b11}, {24'h503c25}, {24'h84643e}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd3 : pattern <= {{24'ha37b4d}, {24'h6e5334}, {24'h120d08}, {24'h060403}, {24'h030201}, {24'h010101}, {24'h010000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010101}, {24'h291f13}, {24'h574229}, {24'h8a6941}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h312517}, {24'h080604}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010101}, {24'h2d2215}, {24'h5d472c}, {24'h926f45}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h020101}, {24'h302416}, {24'h614a2d}, {24'h967247}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010000}, {24'h010100}, {24'h291f13}, {24'h533f27}, {24'h8b6a41}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h1d160d}, {24'h3d2e1c}, {24'h6e5233}, {24'ha17a4c}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h100d08}, {24'h241c11}, {24'h3e2e1d}, {24'h6d5233}, {24'ha07a4b}, {24'ha67d4e}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h060403}, {24'h0e0a07}, {24'h1a140c}, {24'h281f13}, {24'h3d2e1d}, {24'h4f3c25}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020101}, {24'h050403}, {24'h0a0805}, {24'h0f0c07}, {24'h15100a}, {24'h17110b}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			6'd48 : begin
				case(line)
					10'd0 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050302}, {24'h18120b}, {24'h60492d}, {24'ha57d4e}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd1 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h090704}, {24'h312517}, {24'h997448}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd2 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020201}, {24'h0e0b07}, {24'h58432a}, {24'ha67d4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd3 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h030201}, {24'h120e09}, {24'h6c5233}, {24'ha77e4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {0{24'h0}}};
					10'd4 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h010101}, {24'h090604}, {24'h473621}, {24'ha47c4d}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha87f4f}, {24'ha37b4d}, {24'h7d5f3b}, {0{24'h0}}};
					10'd5 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h020101}, {24'h1a130c}, {24'h6f5434}, {24'ha27a4c}, {24'ha77e4e}, {24'ha57d4e}, {24'h9f784b}, {24'h8c6a42}, {24'h6f5434}, {24'h352819}, {24'h0a0705}, {0{24'h0}}};
					10'd6 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h050402}, {24'h17110b}, {24'h37291a}, {24'h453420}, {24'h372a1a}, {24'h291f13}, {24'h120d08}, {24'h060503}, {24'h020201}, {24'h010000}, {0{24'h0}}};
					10'd7 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd8 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd9 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd10 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd11 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					10'd12 : pattern <= {{24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {24'h000000}, {0{24'h0}}};
					default : pattern <= {30{24'h0}};
				endcase
			end
			default : begin
				pattern <= {30{24'h0}};
			end
		endcase
	end
endmodule
