/* module:vga_ball.h
 * Team - River Raid
 * Rojan Banmali (rb3199)
 * Xinhao Su (xs2413)
 *
 * CSEE4840
 * Stephen A. Edwards
 * Columbia University
 */


#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>


typedef union {
  
  struct{
    	uint32_t palID:2;
      uint32_t tileID:5;
      uint32_t tileMAP_addr:9;
      uint32_t unused:16;
  }bits;
  uint32_t raw32;

} tileMAP_t;

typedef union {
  struct{
      uint32_t palID:2;
      uint32_t spriteID:5;
      uint32_t spriteMAP_addr:5;
    	uint32_t x:9;
      uint32_t y:8;
      uint32_t unused:3;
  }bits;
  uint32_t raw32;
} spriteMAP_t;

typedef union {
  struct{
    	uint32_t audioID:2;
      uint32_t unused:29;
  }bits;
  uint32_t raw32;

} audio_t;

typedef union {
  struct{
    	uint32_t vscroll:8;
      uint32_t unused:24;
  }bits;
  uint32_t raw32;

} vscroll_t;

typedef union {
  struct{
    	uint32_t joystick_UP:1;
      uint32_t joystick_DOWN:1;
      uint32_t joystick_LEFT:1;
      uint32_t joystick_RIGHT:1;
      uint32_t joystick_FIRE:1;
      uint32_t update_frame:1;
  }bits;
  uint32_t raw32;

} status_t;


typedef struct {

  tileMAP_t    tileMAP;
  spriteMAP_t  spriteMAP;
  audio_t      audio; 
  vscroll_t    vscroll;
  status_t     status;

} vga_ball_arg_t;


#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_BALL_WRITE_TILE_MAP       _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_WRITE_SPRITE_MAP     _IOW(VGA_BALL_MAGIC, 2, vga_ball_arg_t *)
#define VGA_BALL_WRITE_AUDIO          _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg_t *)
#define VGA_BALL_WRITE_VSCROLL        _IOW(VGA_BALL_MAGIC, 4, vga_ball_arg_t *)

#define VGA_BALL_READ_STATUS          _IOR(VGA_BALL_MAGIC, 5, vga_ball_arg_t *)

#endif
