/* module:utils.h
 * Team - River Raid
 * Rojan Banmali (rb3199)
 * Xinhao Su (xs2413)
 *
 * CSEE4840
 * Stephen A. Edwards
 * Columbia University
 */


#include "rr.h"

/*
* game_init
*
*
*
*
*/

int game_init(rr_game_t *gm, game_thread_fp gfn, const char *drv_fn,  const char *tile_fn){

  //open driver file
  printf("Game Userspace program started\n");

  if ( (gm->driver_fd = open(drv_fn, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", drv_fn);
    perror("game_init driver fail\n");
    exit(1);
  }

  printf("driver_fd:%d\n",gm->driver_fd);
  
  //open tile map file
  FILE *fp = fopen(tile_fn, "r");

  if(fp == NULL)
  {
      printf("Error opening tileMAP file\n");
      exit(1);
  }
  gm->tile_fp=fp;

  //set terminal
  gm->term_old = (struct termios) {0};
  
  if (tcgetattr(0, &(gm->term_old)) < 0)
  perror("tcsetattr()");
  
  gm->term_old.c_lflag &= ~ICANON;
  gm->term_old.c_lflag &= ~ECHO;
  gm->term_old.c_cc[VMIN] = 1;
  gm->term_old.c_cc[VTIME] = 0;
  
  if (tcsetattr(0, TCSANOW, &gm->term_old) < 0)
  perror("tcsetattr ICANON");
  
  gm->play=0;
  //start game thread
  pthread_create(&(gm->thread), NULL, gfn, NULL);


  return 0;
}

/*
* game_init
*
*
*
*
*/

void game_close(rr_game_t *gm){
  
  set_audio(gm, AUDIO_OFF);

  fclose(gm->tile_fp);
  pthread_cancel(gm->thread);
  pthread_join(gm->thread, NULL);

  //set to orignal terminal flag
  gm->term_old.c_lflag |= ICANON;
  gm->term_old.c_lflag |= ECHO;
  if (tcsetattr(0, TCSADRAIN, &gm->term_old) < 0) perror ("tcsetattr ~ICANON");

}


/*
* read_status
*
*
*
*
*/

int read_status(rr_game_t *gm, status_t *st) {

  vga_ball_arg_t vla;

  if (ioctl(gm->driver_fd, VGA_BALL_READ_STATUS, &vla)) {
      perror("ioctl(VGA_BALL_READ_STATUS) failed");
      return -1; 
  }

  *st = vla.status;
  
  return  0;

}

/*
* print_status
*
*
*
*
*/
void print_status(rr_game_t *gm) {
  
  vga_ball_arg_t vla;
  
  if (ioctl(gm->driver_fd, VGA_BALL_READ_STATUS, &vla)) {
      perror("ioctl(VGA_BALL_READ_STATUS) failed");
      return; 
  }

  printf("status: %d, %d, %d, %d, %d, %d\n",
          vla.status.bits.joystick_UP,
          vla.status.bits.joystick_DOWN,
          vla.status.bits.joystick_LEFT,
          vla.status.bits.joystick_RIGHT,
          vla.status.bits.joystick_FIRE,
          vla.status.bits.update_frame);
         // printf("status: %d\n",vla.status.raw32);
}


/*
* set_vscroll
*
*
*
*
*/
/* Set the background color */
void set_vscroll(rr_game_t *gm, vscroll_t *scroll)
{
  vga_ball_arg_t vla;
  vla.vscroll = *scroll;
  if (ioctl(gm->driver_fd, VGA_BALL_WRITE_VSCROLL, &vla)) {
      printf("driver_fd:%d\n",gm->driver_fd);
      perror("ioctl(VGA_BALL_WRITE_VSCROLL) failed:%d");
      return;
  }
}

/*
* set_tileMAP
*
*
*
*
*/
/* Set the tile MAP color */
void set_tileMAP(rr_game_t *gm, tileMAP_t *tm)
{
  vga_ball_arg_t vla;
  vla.tileMAP = *tm;
  if (ioctl(gm->driver_fd, VGA_BALL_WRITE_TILE_MAP, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_TILE_MAP) failed");
      return;
  }
}

/*
* set_audio
*
*
*
*
*/
/* Set the background color */
void set_audio(rr_game_t *gm, uint8_t cmd)
{
  vga_ball_arg_t vla;
  vla.audio.raw32 = (uint32_t)cmd;
  if (ioctl(gm->driver_fd, VGA_BALL_WRITE_AUDIO, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_AUDIO) failed");
      return;
  }
}

/*
* set_spriteMAP
*
*
*
*
*/
/* Set the tile MAP color */
void set_spriteMAP(rr_game_t *gm, uint8_t spNum, uint8_t spID, uint8_t palID, int16_t x, int16_t y)
{

  vga_ball_arg_t vla;
  spriteMAP_t sm;

  sm.raw32 = ((spNum & 0x1F)<<26)|
             ((0x3FF & x)<<16) | 
             ((0x1FF & y) <<7) | 
             (spID<<2) |
             (palID & 0x03);

  vla.spriteMAP = sm;
  if (ioctl(gm->driver_fd, VGA_BALL_WRITE_SPRITE_MAP, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_SPRITE_MAP) failed");
      return;
  }
}