/* module:rr.h
 * Team - River Raid
 * Rojan Banmali (rb3199)
 * Xinhao Su (xs2413)
 *
 * CSEE4840
 * Stephen A. Edwards
 * Columbia University
 */

#ifndef _RR_H
#define _RR_H

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <time.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <termios.h>
#include <time.h>

#define FPS 10
#define REF_PREIOD ((1/FPS)*1000000)

#define SCREEN_MAX_X 320
#define SCREEN_MAX_Y 240
#define SCREEN_MIN_X 0
#define SCREEN_MIN_Y 0

#define GAME_MAX_X 320+16
#define GAME_MAX_Y 240+16
#define GAME_MIN_X 0-18
#define GAME_MIN_Y 0-18
#define GAME_MAX_ENEMY 7
#define GAME_POLL_WAIT 2*5000


#define SP_W 16
#define SP_L 16

#define EXPLODE_TICKS 30

#define ENEMY_SP_ID_START 2
#define ENEMY_COLSN_SP_ID 7
#define ENEMY_COLSN2_SP_ID 6
#define ENEMY_SP_TOTAL_NUM 5
#define ENEMY_SP_NUM_START 0
#define ENEMY_SP_PID 3
#define ENEMY_ATTACK_SP_PID 1
#define ENEMY_SP_SPEED 1
#define ENEMY_ATTACK_TICKS 300
#define FUEL_REWARD 2

#define FUEL_SP_ID 9

#define PLAYER_SP_ID 0
#define PLAYER_COLSN_SP_ID 7
#define PLAYER_SP_NUM 8
#define PLAYER_SP_EMTPY_PID 1
#define PLAYER_SP_PID  2

#define PLAYER_SPEED_X 2
#define PLAYER_SPEED_Y 2
#define PLAYER_MAX_X 320-18
#define PLAYER_MAX_Y 240-16
#define PLAYER_MIN_X 0
#define PLAYER_MIN_Y 2
#define PLAYER_MAX_MISSILE 2
#define PLAYER_MAX_FUEL 10
#define PLAYER_FUEL_TICKS 300



#define MISSILE_SP_ID 1
#define MISSILE_SP_NUM 7
#define MISSILE_SP_PID 3
#define MISSILE_VY 4

//ReadStatus Mask
#define JOYSTICK_UP     0x01 //UP
#define JOYSTICK_DOWN   0x02 //DOWN
#define JOYSTICK_LEFT   0x04 //LEFT
#define JOYSTICK_RIGHT  0x08 //RIGHT
#define JOYSTICK_FIRE   0x10 //FIRE
#define UPDATE_FRAME    0x20 //update frame

#define AUDIO_SAMPLE_TICKS 35
#define AUDIO_OFF 0
#define AUDIO_FLYING 0b00000001
#define AUDIO_FIRE 0b00000011
#define AUDIO_FUEL 0b00000101
#define AUDIO_EXPLODE 0b00001001


#define DIGIT_O_SP_ID 13

/* Fuel Related */
#define FUEL_SIGN_X 10
#define FUEL_SIGN_Y 24
#define FUEL_SIGN_SP_ID 12
#define FUEL_FIRST_DIGIT_X 25
#define FUEL_SECOND_DIGIT_X 38
#define FUEL_SP_NUM_END 11
#define FUEL_PAL_ID 3
#define FUEL_DEC_TICK 500

/* Score Related */
#define SCORE_SIGN_X 10
#define SCORE_SIGN_Y 40
#define SCORE_SIGN_SP_ID 11
#define SCORE_FIRST_DIGIT_X 25
#define SCORE_SECOND_DIGIT_X 38
#define SCORE_THIRD_DIGIT_X 51
#define SCORE_SP_NUM_END 15
#define SCORE_PAL_ID 3

//Uncomment to print debug messages
//#define DEBUG_PRINT


typedef void *(*game_thread_fp)(void*);

typedef struct{
    int posX;
    int posY;
    int vx;
    int vy;
    uint8_t sp_num;
    uint8_t sp_id;
    uint8_t sp_pid;
    uint8_t alive;
    int16_t die_ticks;
    uint8_t hitcount;
}rr_ship_t;

typedef struct{
    rr_ship_t ship;
}rr_missile_t;

typedef struct{
    rr_ship_t ship;
    uint8_t fire_pressed;
    int8_t  fuel;
    int16_t fuel_ticks;
}rr_player_t;

typedef struct{
    rr_ship_t ship;
    uint8_t ticks;
    uint8_t toggle;
    uint8_t attack;
    int16_t attack_ticks;

}rr_enemy_t;



typedef struct termios termios_t;

typedef struct{
    int driver_fd; //driver file desc.
    FILE *tile_fp; //tileMap file pointer
        //tile map file data
    pthread_t thread; //thread
    struct termios term_old;
    uint64_t ticks;
    uint8_t  vspd;
    uint32_t add_enemy_ticks;
    int16_t score;
    int audio_ticks;
    uint8_t play;
    int start_ticks;
    uint32_t hw_stat;
    uint8_t reset_dash;
}rr_game_t;

typedef struct{        
    vscroll_t vs; //veritcal scroll
    tileMAP_t tm; //tile map
    int32_t addr;
    int32_t line;
    int bound;
}rr_tile_t;

//utils.c prototype
int game_init(rr_game_t *gm, game_thread_fp gfn, const char* drv_fn,  const char* tile_fn);
void game_close(rr_game_t *gm);
int read_status(rr_game_t *gm, status_t *st);
int read_status(rr_game_t *gm, status_t *st);
void print_status(rr_game_t *gm);
void set_vscroll(rr_game_t *gm, vscroll_t *scroll);
void set_tileMAP(rr_game_t *gm, tileMAP_t *tm);
void set_audio(rr_game_t *gm, uint8_t cmd);
void set_spriteMAP(rr_game_t *gm, uint8_t spNum, uint8_t spID, uint8_t palID, int16_t x, int16_t y);



//rr.c prototype
void rr_reset(rr_game_t *gm, rr_player_t *pl);
void rr_tile_init(rr_game_t*gm, rr_tile_t* tl);
void rr_tile_update(rr_game_t*gm, rr_tile_t* tl);
void rr_player_update(rr_game_t*gm, rr_player_t *pl);

void rr_enemy_update(rr_game_t*gm, rr_player_t*pl);

void rr_spriteMap_update(rr_game_t*gm, rr_player_t *pl);
void rr_collision_detect(rr_game_t*gm, rr_player_t *pl);

int rr_is_fbtn_pressed(rr_game_t*gm);
void rr_read_hw_stat(rr_game_t*gm);
int rr_is_frame_update(rr_game_t*gm);

#endif