/* module:rr.c
 * Team - River Raid
 * Rojan Banmali (rb3199)
 * Xinhao Su (xs2413)
 *
 * CSEE4840
 * Stephen A. Edwards
 * Columbia University
 */

#include "rr.h"

//TODO: make this part of the enemy and missile object
static rr_missile_t missile[PLAYER_MAX_MISSILE];
static rr_enemy_t enemy_table[GAME_MAX_ENEMY];

static void fuel_sprite_update(rr_game_t *gm, rr_player_t *pl);
static void score_sprite_update(rr_game_t *gm);
//static void fuel_update(rr_player_t *pl);
static void player_stop_game (rr_game_t *gm, rr_player_t *pl);



/*
* rr_tile_init()
* 
*
*
*
*
*
*/
void rr_tile_init(rr_game_t*gm, rr_tile_t* tl){

  tl->line = 14;
  tl->addr = 20*tl->line;
  tl->vs.bits.vscroll = 0; 
  tl->bound=0;
  set_vscroll(gm, &(tl->vs));

}

/*
*rr_tile_update
*
*
*
*
*/
void rr_tile_update(rr_game_t*gm, rr_tile_t* tl){
   
   int fdata;
   uint8_t tileid;
    gm->ticks++; //game timer
    
    tl->vs.bits.vscroll-=gm->vspd;
     
     if(tl->bound>15) {//tl->vs.bits.vscroll%16==0 //use bound variable instead of %
        tl->bound=0;
        tl->tm.raw32=0;
        for(int i=0;i<20;i++){

          if(fscanf(gm->tile_fp, "%d", &fdata)==EOF) {
           fseek(gm->tile_fp, 0, SEEK_SET);
           fscanf(gm->tile_fp, "%d", &fdata);
           // break;
          }
          //printf("fdata: %d\n",fdata); //DEBUG
          tileid = (uint8_t)fdata;
          tl->tm.raw32 = tl->addr<<7 | tileid;
          set_tileMAP(gm, &(tl->tm));

          tl->addr++;
        }
        //tileid = rand()%32;
        tl->line--;
        if(tl->line<0) tl->line = 15;
        tl->addr=tl->line*20;

      }
       tl->bound++;
      set_vscroll(gm, &(tl->vs));
      

}



/*
* rr_reset()
* Initialize player object
*
*
*
*
*
*/

void rr_reset (rr_game_t *gm, rr_player_t* pl){

    //reset tilemap file;
    fseek(gm->tile_fp, 0, SEEK_SET);
    gm->ticks=0;
    gm->score=0;
    gm->vspd=1;
    gm->reset_dash=1;

    srand(time(NULL)); //seed randgom gen.
    
    //init player sprite

    pl->ship.posX=(SCREEN_MAX_X/2-8);
    pl->ship.posY=SCREEN_MAX_Y-20;
    pl->ship.vx=0;
    pl->ship.vy=0;
    pl->fire_pressed=0;
    pl->ship.sp_num=PLAYER_SP_NUM;
    pl->ship.sp_id=PLAYER_SP_ID;
    pl->ship.sp_pid=PLAYER_SP_PID;
    pl->fuel=PLAYER_MAX_FUEL;
    pl->fuel_ticks=PLAYER_FUEL_TICKS;

    //init. sprite RAM
    for(int i=0;i<31;i++){
      set_spriteMAP(gm, i,0,0, GAME_MIN_X, GAME_MIN_Y);
    }

    //reset enemy
    for(int i=0; i<GAME_MAX_ENEMY; i++){
        enemy_table[i].ship.alive=0;
        enemy_table[i].ship.die_ticks=0;
     }

    //TODO: not possible to do something like pl->missile[i] so using local missile array.
    //TODO:remove this explicit use of missile array
    for(int i=0; i<PLAYER_MAX_MISSILE;i++){
     missile[i].ship.alive=0;
     missile[i].ship.die_ticks=0;
     missile[i].ship.posX=GAME_MIN_X;
     missile[i].ship.posY=GAME_MIN_Y;
    }

     set_spriteMAP(gm, pl->ship.sp_num,
                    pl->ship.sp_id,
                    pl->ship.sp_pid,
                    pl->ship.posX,
                    pl->ship.posY);

  set_audio(gm, AUDIO_FLYING);
}


/*
* rr_player_update
* Reads GPIO for Joystick
*
*
*
*
*
*/
static int flashing_tick = 0;
void rr_player_update(rr_game_t*gm, rr_player_t *pl)

{ 
  
  //status_t status;

  //Consume fuel
  pl->fuel_ticks--;
  if(pl->fuel_ticks<=0){

    #ifdef DEBUG_PRINT
     printf("Fuel--\n");
    #endif

     pl->fuel_ticks=PLAYER_FUEL_TICKS;
     pl->fuel--;
   
     
  }

  if (pl->fuel <= 5) {
       flashing_tick++;
        if (flashing_tick < 50) pl->ship.sp_pid =  PLAYER_SP_EMTPY_PID; //change color if low on fuel
        else pl->ship.sp_pid =  PLAYER_SP_PID; //change color if low on fuel
        flashing_tick = flashing_tick >= 100 ? 0 : flashing_tick;
     }
     if (pl->fuel > 5) pl->ship.sp_pid = PLAYER_SP_PID; //change color if low on fuel
     
     if(pl->fuel<=0){
      
       #ifdef DEBUG_PRINT
        printf("Emtpy Fuel\n");//DEBUG
       #endif

      player_stop_game(gm,pl);

     }
  //check update missile
  //TODO: not possible to do something like pl->missile[i] so using local missile array.

  for(int i=0; i<PLAYER_MAX_MISSILE;i++){
     
     if(missile[i].ship.alive==0){
       continue;
     } 
      
      missile[i].ship.posY+=missile[i].ship.vy;

      if (missile[i].ship.posY<=GAME_MIN_Y){
         missile[i].ship.alive=0;
        //DEBUG:printf("missile terminated\n");
       }

  }

  //read_status(gm, &status); //GPIO status

  uint8_t st = 0x1F & (uint8_t)gm->hw_stat;//status.raw32;
 
  pl->ship.vy= !(st & JOYSTICK_DOWN) * (PLAYER_SPEED_Y) +  !(st & JOYSTICK_UP) * (-PLAYER_SPEED_Y);
  pl->ship.vx= !(st & JOYSTICK_RIGHT) * (PLAYER_SPEED_X) + !(st & JOYSTICK_LEFT) * (-PLAYER_SPEED_X);

  pl->ship.posX = pl->ship.posX + pl->ship.vx;
  pl->ship.posY = pl->ship.posY + pl->ship.vy;

  if(pl->ship.posX > PLAYER_MAX_X) //clamp player x position
    pl->ship.posX=PLAYER_MAX_X;
  else if (pl->ship.posX < PLAYER_MIN_X)
    pl->ship.posX=PLAYER_MIN_X;
  
  if(pl->ship.posY > PLAYER_MAX_Y) //clamp player y position
    pl->ship.posY=PLAYER_MAX_Y;
  else if (pl->ship.posY < PLAYER_MIN_Y)
    pl->ship.posY=PLAYER_MIN_Y;

  //Check fire button and fire missile
  if(!(st & JOYSTICK_FIRE) && !pl->fire_pressed) {
    //DEBUG: printf("Fire pressed\n");

    pl->fire_pressed=1;


    for(int i=0; i<PLAYER_MAX_MISSILE;i++){
      if(missile[i].ship.alive==1) continue;
      missile[i].ship.alive = 1;
      missile[i].ship.die_ticks=0;
      missile[i].ship.posX=pl->ship.posX;
      missile[i].ship.posY=pl->ship.posY;
      missile[i].ship.vy=-MISSILE_VY;
      missile[i].ship.vx=0;
      missile[i].ship.sp_id = MISSILE_SP_ID;
      missile[i].ship.sp_num = MISSILE_SP_NUM-i;
      missile[i].ship.sp_pid = MISSILE_SP_PID;
      
      set_audio(gm, AUDIO_FIRE);

     /*DEBUG: printf("missile fired:%d, x:%d, y:%d\n",
      missile[i].ship.sp_num,
      missile[i].ship.posX,
      missile[i].ship.posY);*/

      break;
    }

  }else if((st & JOYSTICK_FIRE)){
    pl->fire_pressed=0;

  }
  
  return;
}

/*
* rr_enemy_create
* Create Enemy
*
*
*
*
*
*/
void rr_enemy_update(rr_game_t*gm, rr_player_t*pl ){

  
  uint16_t x,y;
  int vx,vy;
  uint8_t max_enemy=1;
  
  gm->add_enemy_ticks++;

  if(gm->add_enemy_ticks>100){ // add enemy every 100 ticks

    gm->add_enemy_ticks=0;

  //make things more interesting as ticks++
    if(gm->ticks>6000){
       max_enemy = 6;
       gm->vspd = 2; //increase game speed
    }

    else if (gm->ticks>3000)
      max_enemy = 5;
    else if (gm->ticks>2000)
    {
      max_enemy = 3;
    }
    else if (gm->ticks>1000)
    max_enemy = 2;
    

    //create enemy

  for(int i=0; i<max_enemy;i++){

      if(enemy_table[i].ship.alive==1) continue;

        uint8_t r = (rand()%ENEMY_SP_TOTAL_NUM) + ENEMY_SP_ID_START; //ENEMY sprite_id 1-4
        uint8_t sp_id;
        if (r==ENEMY_SP_ID_START+ENEMY_SP_TOTAL_NUM-1) sp_id=FUEL_SP_ID; else sp_id=r; //make last enemy fuel

        uint16_t rand_posxy = rand()%1024;

        if(rand_posxy & 0x01){ // position horizontally
        
        x = rand_posxy>>1; 
        
        if(x & 0x01){
            y = GAME_MAX_Y; //come from top
            vy=-ENEMY_SP_SPEED;
        }
        
          else{
            y = GAME_MIN_Y; //come from bottom
            vy=ENEMY_SP_SPEED;
          }

          if(x>GAME_MAX_X){
            x=GAME_MAX_X;
            vx=-ENEMY_SP_SPEED;
          }else{
            vx=1;
          }

        }else{ //position vertically

          y = rand_posxy>>1; 
          
          if(y & 0x01){
            x = GAME_MAX_X; //come from RIGHT
            vx = -ENEMY_SP_SPEED;
          }
          else{
            x = GAME_MIN_X; //come from LEFT
            vx=ENEMY_SP_SPEED;
          }
            
          if(y>GAME_MAX_Y){
            x=GAME_MAX_Y;
            vy=-ENEMY_SP_SPEED;
          } else{
            vy=ENEMY_SP_SPEED;
          }
        }
        //starting parm. for new enemy
        enemy_table[i].ship.posX=x;
        enemy_table[i].ship.posY=y;
        enemy_table[i].ship.vx=vx;
        enemy_table[i].ship.vy=vy;
        enemy_table[i].ship.sp_id = sp_id;
        enemy_table[i].ship.sp_pid = ENEMY_SP_PID;
        enemy_table[i].ship.alive=1;
        enemy_table[i].ship.die_ticks=0;
        enemy_table[i].attack=0;
        enemy_table[i].attack_ticks=ENEMY_ATTACK_TICKS;

  }
  }

   int dx;
   int dy;
  //update enemy
  //TODO: use various motion profile for enemies
  for(int i=0; i<GAME_MAX_ENEMY; i++){

    if(enemy_table[i].ship.alive==0 ||
     (enemy_table[i].ship.alive==1 && enemy_table[i].ship.die_ticks>0)){
      continue;
    } 
    
    //Lame attack code
    //TODO: enemies clutter up near the player. improve. maybe add motion profile.
       
    enemy_table[i].attack_ticks--; 

    if(enemy_table[i].attack==0 &&
      enemy_table[i].attack_ticks<=0 &&
      enemy_table[i].ship.sp_id!=FUEL_SP_ID){

      if (rand()%2==1) {enemy_table[i].attack=1;enemy_table[i].ship.sp_pid=ENEMY_ATTACK_SP_PID;}
    } 

   
    if(enemy_table[i].attack_ticks<=0){enemy_table[i].attack_ticks=ENEMY_ATTACK_TICKS;}


    if (enemy_table[i].ship.posX>0 &&
       enemy_table[i].ship.posX<SCREEN_MAX_X-SP_W && 
       enemy_table[i].ship.posY>0 && 
       enemy_table[i].ship.posY<SCREEN_MAX_Y-SP_L &&
       enemy_table[i].attack){

        dx = pl->ship.posX - enemy_table[i].ship.posX;
        dy = pl->ship.posY - enemy_table[i].ship.posY;

        if (dx>ENEMY_SP_SPEED)
        dx=ENEMY_SP_SPEED;
        else if(dx<-ENEMY_SP_SPEED)
        dx=-ENEMY_SP_SPEED;


        if (dy>ENEMY_SP_SPEED||dy==0)
        dy=ENEMY_SP_SPEED;
        else if(dy<-ENEMY_SP_SPEED)
        dy=-ENEMY_SP_SPEED;
        
        int miss = rand()%6; //miss tracking

        if(miss>3) enemy_table[i].ship.vx=dx;

        if(miss>2) enemy_table[i].ship.vy=dy;
       
       }

        

    if (enemy_table[i].ship.posX>=GAME_MAX_X) {enemy_table[i].ship.posX=GAME_MAX_X; enemy_table[i].ship.vx=-ENEMY_SP_SPEED;}
    else if (enemy_table[i].ship.posX<=GAME_MIN_X){enemy_table[i].ship.posX=GAME_MIN_X; enemy_table[i].ship.vx=ENEMY_SP_SPEED;};

    if (enemy_table[i].ship.posY>=GAME_MAX_Y) {enemy_table[i].ship.posY=GAME_MAX_Y; enemy_table[i].ship.vy=-ENEMY_SP_SPEED;}
    else if (enemy_table[i].ship.posY<=GAME_MIN_Y) {enemy_table[i].ship.posY=GAME_MIN_Y;enemy_table[i].ship.vy=ENEMY_SP_SPEED;}
   
    enemy_table[i].ship.posX+=enemy_table[i].ship.vx;
    enemy_table[i].ship.posY+=enemy_table[i].ship.vy;
    
    //blink/toggle fuel sprite color
    enemy_table[i].ticks++; enemy_table[i].ticks&=0x1F;
    if(enemy_table[i].ticks==0) enemy_table[i].toggle^=1;
    if(enemy_table[i].ship.sp_id==FUEL_SP_ID)enemy_table[i].ship.sp_pid = ENEMY_SP_PID+enemy_table[i].toggle;


  }


}

/*
* Update Sprite Map
*
*
*
*
*/


void rr_spriteMap_update(rr_game_t*gm, rr_player_t *pl){

  //player sprites

/*// animate explosion before stopping game
   if(pl->ship.die_ticks>0){
      pl->ship.die_ticks--;
      if(pl->ship.die_ticks==EXPLODE_TICKS/2) {pl->ship.sp_id=ENEMY_COLSN2_SP_ID;}

      if(pl->ship.die_ticks<=0){
        gm->play=0;
        pl->ship.posX=GAME_MIN_X;
        pl->ship.posY=GAME_MIN_Y;
      }
    }*/

  set_spriteMAP(gm,
                  pl->ship.sp_num,
                  pl->ship.sp_id,
                  pl->ship.sp_pid,
                  pl->ship.posX,
                  pl->ship.posY);
    
    //enemy sprites
   for(int i=0; i<GAME_MAX_ENEMY; i++){

    if(enemy_table[i].ship.alive==0) {
      continue;
    } else if(enemy_table[i].ship.die_ticks>0){
      enemy_table[i].ship.die_ticks--;
      if(enemy_table[i].ship.die_ticks==EXPLODE_TICKS/2) {enemy_table[i].ship.sp_id=ENEMY_COLSN2_SP_ID;}
      //printf("Die Ticks:%d\n", enemy_table[i].ship.die_ticks);//DEBUG
      if(enemy_table[i].ship.die_ticks<=0){
        enemy_table[i].ship.alive=0;
        enemy_table[i].ship.posX=GAME_MIN_X;
        enemy_table[i].ship.posY=GAME_MIN_Y;
        gm->score++;

        #ifdef DEBUG_PRINT
        printf("Enemy:%d removed\n",i); //DEBUG
        #endif

      }

    }
 

      set_spriteMAP(gm, 
                    i+ENEMY_SP_NUM_START,
                   enemy_table[i].ship.sp_id, 
                   enemy_table[i].ship.sp_pid, 
                   enemy_table[i].ship.posX, 
                   enemy_table[i].ship.posY);
   }

    
    //missile sprites
    for(int i=0; i<PLAYER_MAX_MISSILE;i++){
     
     if(missile[i].ship.alive==0){
       continue;
      }else if(missile[i].ship.die_ticks>0){
         missile[i].ship.die_ticks--;
       if (missile[i].ship.die_ticks<=0){
          missile[i].ship.alive=0;
          missile[i].ship.posX=GAME_MIN_X;
          missile[i].ship.posY=GAME_MIN_Y;
       }
     }

     set_spriteMAP(gm, 
                    missile[i].ship.sp_num, 
                    missile[i].ship.sp_id, 
                    missile[i].ship.sp_pid, 
                    missile[i].ship.posX,
                    missile[i].ship.posY);
    
    }

    fuel_sprite_update(gm, pl);
    // fuel_update(&player);
    score_sprite_update(gm);

    if(gm->reset_dash)gm->reset_dash=0; //reset dashboard after reset

}

/*
* Collision detection
* Note: Collision could be detected during enemy_update or player_update
*
*
*
*/


void rr_collision_detect(rr_game_t*gm, rr_player_t *pl){

   for(int i=0; i<GAME_MAX_ENEMY; i++){
     if(enemy_table[i].ship.alive==0 || enemy_table[i].ship.die_ticks>0) continue;
  //player-enemy collision detection
   if (((enemy_table[i].ship.posX + SP_W >= pl->ship.posX)&&
        (enemy_table[i].ship.posX<=pl->ship.posX + SP_W)&&
        (enemy_table[i].ship.posY + SP_L >= pl->ship.posY)&&
        (enemy_table[i].ship.posY<=pl->ship.posY + SP_L)))
        {

         //TODO: crash player ship
          if(enemy_table[i].ship.sp_id==FUEL_SP_ID) {
            enemy_table[i].ship.die_ticks=1;
            if(pl->fuel<PLAYER_MAX_FUEL) {
              pl->fuel = pl->fuel + FUEL_REWARD > PLAYER_MAX_FUEL ? PLAYER_MAX_FUEL : pl->fuel + FUEL_REWARD;
              pl->fuel_ticks = PLAYER_FUEL_TICKS;
              
            }
            set_audio(gm, AUDIO_FUEL);
            #ifdef DEBUG_PRINT
            printf("Fuel++\n");//DEBUG
            #endif

          }else{
                //crash enemy ship
                player_stop_game(gm,pl);
          }

        }


    for(int j=0; j<PLAYER_MAX_MISSILE;j++){

     if(missile[j].ship.alive==0) continue;

        //missile-enemy collision detection
        if (((enemy_table[i].ship.posX + SP_W >= missile[j].ship.posX)&&
              (enemy_table[i].ship.posX<=missile[j].ship.posX + SP_W)&&
              (enemy_table[i].ship.posY + SP_L >= missile[j].ship.posY)&&
              (enemy_table[i].ship.posY<=missile[j].ship.posY + SP_L)))
              {
                #ifdef DEBUG_PRINT
                printf("Missile Strike on enemy#:%d\n",j);//DEBUG
                #endif

                set_audio(gm, AUDIO_EXPLODE);
              
                //destroy missile. update during rr_player_update
                //missile[j].ship.alive=0;
                missile[j].ship.die_ticks=1;
                missile[j].ship.posX=GAME_MIN_X;
                missile[j].ship.posX=GAME_MIN_Y;

                //crash enemy ship
                enemy_table[i].ship.sp_id = ENEMY_COLSN_SP_ID;
                enemy_table[i].ship.die_ticks = EXPLODE_TICKS;

              }
    }

   }



}

/*
 * Fuel Sprite Update
 *
 */
static int PREV_FUEL = -1;

void fuel_sprite_update(rr_game_t*gm, rr_player_t *pl) {
  if (PREV_FUEL == pl->fuel && !gm->reset_dash) return;
  else PREV_FUEL = pl->fuel;
  
  #ifdef DEBUG_PRINT
  printf("Fuel Level: %d\n", pl->fuel); //DEBUG
  #endif
  
  uint8_t sp_num = FUEL_SP_NUM_END;

  // The sign
  set_spriteMAP(gm, 
                sp_num--, 
                FUEL_SIGN_SP_ID, 
                FUEL_PAL_ID,
                FUEL_SIGN_X,
                FUEL_SIGN_Y
  );

  if (pl->fuel >= 10) {
    // The digit 1
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + 1, 
                  FUEL_PAL_ID,
                  FUEL_FIRST_DIGIT_X,
                  FUEL_SIGN_Y
    );
    // The digit 0
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID, 
                  FUEL_PAL_ID,
                  FUEL_SECOND_DIGIT_X,
                  FUEL_SIGN_Y
    );
  } 
  else if (pl->fuel < 10) {
    // The first digit 
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID, 
                  FUEL_PAL_ID,
                  FUEL_FIRST_DIGIT_X,
                  FUEL_SIGN_Y
    );

    // The first digit 
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + pl->fuel, 
                  FUEL_PAL_ID,
                  FUEL_SECOND_DIGIT_X,
                  FUEL_SIGN_Y
    );
  }  
}

/*
 * Fuel Update
 * 
 *
int FUEL_TICKS = 0;
void fuel_update(rr_player_t *pl) {
  if (pl->fuel <= 0) return;

  if (FUEL_TICKS < FUEL_DEC_TICK) {
    FUEL_TICKS++;
  }
  else {
    FUEL_TICKS = 0;
    pl->fuel--;
  }
}*/


/*
 * Score Sprite Update
 */
static int PREV_SCORE = -1;

void score_sprite_update(rr_game_t*gm) {
  if (PREV_SCORE == gm->score && !gm->reset_dash) return; 
  else PREV_SCORE = gm->score;

  uint8_t sp_num = SCORE_SP_NUM_END;
  
  #ifdef DEBUG_PRINT
  printf("Score Point: %d\n",gm->score);//DEBUG
  #endif
  
  // The sign
  set_spriteMAP(gm, 
                sp_num--, 
                SCORE_SIGN_SP_ID, 
                SCORE_PAL_ID,
                SCORE_SIGN_X,
                SCORE_SIGN_Y
  );

  int last_digit = (int)(gm->score % 10);

  if (gm->score >= 100) {
    // The first digit
    int first_digit = (int)(gm->score / 100);
    int second_digit = (int)((gm->score % 100) / 10);
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + first_digit, 
                  SCORE_PAL_ID,
                  SCORE_FIRST_DIGIT_X,
                  SCORE_SIGN_Y
    );
    // The second digit 
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + second_digit, 
                  SCORE_PAL_ID,
                  SCORE_FIRST_DIGIT_X,
                  SCORE_SIGN_Y
    );

    // The third digit
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + last_digit, 
                  SCORE_PAL_ID,
                  SCORE_SECOND_DIGIT_X,
                  SCORE_SIGN_Y
    );
  } 
  else if (gm->score < 100 && gm->score >= 10) {
    // The first digit 
    int first_digit = (int)(gm->score / 10);
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + first_digit, 
                  SCORE_PAL_ID,
                  SCORE_FIRST_DIGIT_X,
                  SCORE_SIGN_Y
    );

    // The last digit
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + last_digit, 
                  SCORE_PAL_ID,
                  SCORE_SECOND_DIGIT_X,
                  SCORE_SIGN_Y
    );
  } else if (gm->score < 10) {
    set_spriteMAP(gm, 
                  sp_num--, 
                  DIGIT_O_SP_ID + last_digit, 
                  SCORE_PAL_ID,
                  SCORE_FIRST_DIGIT_X,
                  SCORE_SIGN_Y
    );
  }
}

/*
* rr_read_hw_stat
* Reads hardware status
*
*
*
*
*
*/
void rr_read_hw_stat(rr_game_t*gm){
  status_t status;

  read_status(gm, &status); //GPIO status
  gm->hw_stat = status.raw32;

}

/*
*  player_stop_game()
* 
*
*
*
*
*
*/
static void player_stop_game( rr_game_t *gm, rr_player_t *pl){
  pl->ship.sp_id = ENEMY_COLSN_SP_ID;
  pl->ship.sp_pid = PLAYER_SP_PID;
  pl->ship.die_ticks = EXPLODE_TICKS;
  gm->play=0;   //stop game
  gm->start_ticks=50;
  set_audio(gm, AUDIO_EXPLODE);
}

/*
* rr_is_fbtn_pressed
* Check to see if fire button is pressed
*
*
*
*
*
*/

int rr_is_fbtn_pressed(rr_game_t*gm)

{ 

  int ret = -1;
  uint8_t st = 0x1F &gm->hw_stat;
  
  if(!(st & JOYSTICK_FIRE)) ret = 1;
  
  return ret;
}

/*
* rr_is_frame_update
* Check to see if frame update bit is high
*
*
*
*
*
*/

int rr_is_frame_update(rr_game_t*gm)

{ 

  int ret = -1;
  uint8_t st = 0x1F &gm->hw_stat;
  if(!(st & UPDATE_FRAME)) ret = 1;
  
  return ret;
}