/* module:main.c
 * Team - River Raid
 * Rojan Banmali (rb3199)
 * Xinhao Su (xs2413)
 *
 * CSEE4840
 * Stephen A. Edwards
 * Columbia University
 */

#include "rr.h"

//objects
rr_player_t player;
rr_game_t game;
rr_tile_t tile;

void *game_thread_f(void *);

struct timespec ts_t1, ts_t2;
long  del_ms, elapsed_ms;

/*
* C main program
* Start game thread and handle keyboard,etc.
*
*
*
*
*/

int main()
{

  game_init(&game, &game_thread_f,  "/dev/vga_ball", "screen-arrange.txt");

  printf("Type 'q' and return to quit\n");

  //set echo off
  char buf = 0;
      
    clock_gettime(CLOCK_MONOTONIC,&ts_t1);
    clock_gettime(CLOCK_MONOTONIC,&ts_t2);
    
    while (buf!='q'){
    
      clock_gettime(CLOCK_MONOTONIC,&ts_t2);
      del_ms = (ts_t2.tv_sec-ts_t1.tv_sec)*1000000 + (ts_t2.tv_nsec-ts_t1.tv_nsec)/1000;
      elapsed_ms+=del_ms;
      ts_t1=ts_t2;
      
      //FOR TESTING
      if (read(0, &buf, 1) < 0) perror ("read()");

      switch(buf){

        case 'k':{ //LEFT
      
          break;
        }

        case ';':{ //RIGHT
          
          break;
        }
        case 'l':{ //DOWN
                  
          break;
        }

        case 'o':{ //UP
          
          break;
        }

     }

    }
   
  game_close(&game);

  return 0;
}

/*
* Main Game loop.
*
*
*
*
*/

void *game_thread_f(void *ignored)
{


  rr_tile_init(&game, &tile);
  

  while (1) {
    
    rr_read_hw_stat(&game);

    if(game.play){
    
      rr_player_update(&game, &player);
      rr_enemy_update(&game, &player);
      rr_collision_detect(&game, &player);
      if(rr_is_frame_update(&game)>0) {
        rr_spriteMap_update(&game, &player);
        rr_tile_update(&game, &tile);
      }
    
    }else{

      if (rr_is_fbtn_pressed(&game)>0 && game.start_ticks<=0) { //wait for a few ticks
        game.play=1;
        printf("Begin Mission!\n");//DEBUG
        rr_reset(&game, &player);
      }else if(game.start_ticks>0){
        game.start_ticks--;
        if (game.start_ticks<=0) set_audio(&game, AUDIO_OFF);
      
      }

    }

    usleep(GAME_POLL_WAIT); //in usec
  }

  return NULL;
}
