module colorPals (
  input logic [1:0] palID,
  input logic [5:0] address,
  output logic [23:0] rgb_out
);

	always_comb begin
		rgb_out = 24'd0;
		if (palID==0) begin 
			case(address)
				0: rgb_out = 24'h000000;
				1: rgb_out = 24'h1d2b53;
				2: rgb_out = 24'h7e2553;
				3: rgb_out = 24'h008751;
				4: rgb_out = 24'hab5236;
				5: rgb_out = 24'h5f574f;
				6: rgb_out = 24'hc2c3c7;
				7: rgb_out = 24'hfff1e8;
				8: rgb_out = 24'hff004d;
				9: rgb_out = 24'hffa300;
				10: rgb_out = 24'hffec27;
				11: rgb_out = 24'h00e436;
				12: rgb_out = 24'h29adff;
				13: rgb_out = 24'h83769c;
				14: rgb_out = 24'hff77a8;
				15: rgb_out = 24'hffccaa;
				16: rgb_out = 24'h291814;
				17: rgb_out = 24'h111d35;
				18: rgb_out = 24'h422136;
				19: rgb_out = 24'h125359;
				20: rgb_out = 24'h742f29;
				21: rgb_out = 24'h49333b;
				22: rgb_out = 24'ha28879;
				23: rgb_out = 24'hf3ef7d;
				24: rgb_out = 24'hbe1250;
				25: rgb_out = 24'hff6c24;
				26: rgb_out = 24'ha8e72e;
				27: rgb_out = 24'h00b543;
				28: rgb_out = 24'h065ab5;
				29: rgb_out = 24'h754665;
				30: rgb_out = 24'hff6e59;
				31: rgb_out = 24'hff9d81;
				default: rgb_out = 24'h000000;
			endcase
		end

		else if (palID==1) begin
			case(address)
				0: rgb_out = 24'h000000;
				1: rgb_out = 24'h000000;
				2: rgb_out = 24'hffffff;
				3: rgb_out = 24'h595a5b;
				4: rgb_out = 24'h0c0c0c;
				5: rgb_out = 24'hcacaca;
				6: rgb_out = 24'ha8b3bc;
				7: rgb_out = 24'hb0b9c7;
				8: rgb_out = 24'h2f3133;
				9: rgb_out = 24'hcc0000;
				10: rgb_out = 24'h858b92;
				11: rgb_out = 24'ha1c7c6;
				12: rgb_out = 24'h8fa4a8;
				13: rgb_out = 24'hd3e9e5;
				14: rgb_out = 24'h86969a;
				15: rgb_out = 24'h89c5bb;
				16: rgb_out = 24'hd2d3d6;
				17: rgb_out = 24'hbbc7d2;
				18: rgb_out = 24'h323539;
				19: rgb_out = 24'h96a0a9;
				20: rgb_out = 24'h342d2e;
				21: rgb_out = 24'h45494d;
				22: rgb_out = 24'h2b2f31;
				23: rgb_out = 24'h2c2f32;
				24: rgb_out = 24'h141617;
				25: rgb_out = 24'h151420;
				26: rgb_out = 24'h610f1a;
				27: rgb_out = 24'hff7149;
				28: rgb_out = 24'h0b2458;
				29: rgb_out = 24'h0c5c67;
				30: rgb_out = 24'h12916b;
				31: rgb_out = 24'h27e931;
				32: rgb_out = 24'hfff34f;
				33: rgb_out = 24'hf6c23b;
				34: rgb_out = 24'he97b21;
				35: rgb_out = 24'hd44b49;
				36: rgb_out = 24'ha21839;
				37: rgb_out = 24'h5d093a;
				38: rgb_out = 24'h3e0346;
				39: rgb_out = 24'h7d1475;
				40: rgb_out = 24'hba2e89;
				41: rgb_out = 24'hf481b0;
				42: rgb_out = 24'heeb8b4;
				43: rgb_out = 24'h9756c7;
				44: rgb_out = 24'h2c226e;
				45: rgb_out = 24'h11073a;
				46: rgb_out = 24'h2424af;
				47: rgb_out = 24'h4b7cdb;
				48: rgb_out = 24'h6acaf4;
				49: rgb_out = 24'h86ffed;
				50: rgb_out = 24'hfff7e9;
				51: rgb_out = 24'hffd8a5;
				52: rgb_out = 24'hdd9c60;
				53: rgb_out = 24'h752314;
				54: rgb_out = 24'h4b050a;
				55: rgb_out = 24'h2c0008;
				56: rgb_out = 24'h35281f;
				57: rgb_out = 24'h3c3c3c;
				58: rgb_out = 24'h7f7f7f;
				59: rgb_out = 24'hb8a7b9;
				default: rgb_out = 24'h000000;
			endcase
		end

		else if (palID==2) begin
			case(address)
				0: rgb_out = 24'h000000;
				1: rgb_out = 24'h000000;
				2: rgb_out = 24'hffffff;
				3: rgb_out = 24'h595a5b;
				4: rgb_out = 24'h0c0c0c;
				5: rgb_out = 24'hcacaca;
				6: rgb_out = 24'ha8b3bc;
				7: rgb_out = 24'hb0b9c7;
				8: rgb_out = 24'h2f3133;
				9: rgb_out = 24'hf0f5f6;
				10: rgb_out = 24'h858b92;
				11: rgb_out = 24'ha1c7c6;
				12: rgb_out = 24'h8fa4a8;
				13: rgb_out = 24'hd3e9e5;
				14: rgb_out = 24'h86969a;
				15: rgb_out = 24'h89c5bb;
				16: rgb_out = 24'hd2d3d6;
				17: rgb_out = 24'hbbc7d2;
				18: rgb_out = 24'h323539;
				19: rgb_out = 24'h96a0a9;
				20: rgb_out = 24'h342d2e;
				21: rgb_out = 24'h45494d;
				22: rgb_out = 24'h2b2f31;
				23: rgb_out = 24'h2c2f32;
				24: rgb_out = 24'h141617;
				25: rgb_out = 24'h151420;
				26: rgb_out = 24'h610f1a;
				27: rgb_out = 24'hff7149;
				28: rgb_out = 24'h0b2458;
				29: rgb_out = 24'h0c5c67;
				30: rgb_out = 24'h12916b;
				31: rgb_out = 24'h27e931;
				32: rgb_out = 24'hfff34f;
				33: rgb_out = 24'hf6c23b;
				34: rgb_out = 24'he97b21;
				35: rgb_out = 24'hd44b49;
				36: rgb_out = 24'ha21839;
				37: rgb_out = 24'h5d093a;
				38: rgb_out = 24'h3e0346;
				39: rgb_out = 24'h7d1475;
				40: rgb_out = 24'hba2e89;
				41: rgb_out = 24'hf481b0;
				42: rgb_out = 24'heeb8b4;
				43: rgb_out = 24'h9756c7;
				44: rgb_out = 24'h2c226e;
				45: rgb_out = 24'h11073a;
				46: rgb_out = 24'h2424af;
				47: rgb_out = 24'h4b7cdb;
				48: rgb_out = 24'h6acaf4;
				49: rgb_out = 24'h86ffed;
				50: rgb_out = 24'hfff7e9;
				51: rgb_out = 24'hffd8a5;
				52: rgb_out = 24'hdd9c60;
				53: rgb_out = 24'h752314;
				54: rgb_out = 24'h4b050a;
				55: rgb_out = 24'h2c0008;
				56: rgb_out = 24'h35281f;
				57: rgb_out = 24'h3c3c3c;
				58: rgb_out = 24'h7f7f7f;
				59: rgb_out = 24'hb8a7b9;
				default: rgb_out = 24'h000000;
			endcase
		end

		else if (palID==3) begin
			case(address)
				0: rgb_out = 24'h000000;
				1: rgb_out = 24'h000000;
				2: rgb_out = 24'hffffff;
				3: rgb_out = 24'h595a5b;
				4: rgb_out = 24'h0c0c0c;
				5: rgb_out = 24'hcacaca;
				6: rgb_out = 24'ha8b3bc;
				7: rgb_out = 24'hb0b9c7;
				8: rgb_out = 24'h2f3133;
				9: rgb_out = 24'hf0f5f6;
				10: rgb_out = 24'h858b92;
				11: rgb_out = 24'h685a34;
				12: rgb_out = 24'hfcfc7f;
				13: rgb_out = 24'h9d8a34;
				14: rgb_out = 24'hb2a859;
				15: rgb_out = 24'hfefe6a;
				16: rgb_out = 24'hcebe3d;
				17: rgb_out = 24'h9d853a;
				18: rgb_out = 24'hfefe50;
				19: rgb_out = 24'h838383;
				20: rgb_out = 24'h4d4d4d;
				21: rgb_out = 24'ha3a3a3;
				22: rgb_out = 24'h4b79f1;
				23: rgb_out = 24'h1c598c;
				24: rgb_out = 24'he84af4;
				25: rgb_out = 24'had256c;
				26: rgb_out = 24'hc4c4c4;
				27: rgb_out = 24'h010000;
				28: rgb_out = 24'h482200;
				29: rgb_out = 24'h1f0e00;
				30: rgb_out = 24'h341700;
				31: rgb_out = 24'h0c0500;
				32: rgb_out = 24'h020100;
				33: rgb_out = 24'h1f0d00;
				34: rgb_out = 24'h602a00;
				35: rgb_out = 24'h361509;
				36: rgb_out = 24'hd95427;
				37: rgb_out = 24'h7a2f16;
				38: rgb_out = 24'hde6621;
				39: rgb_out = 24'he3791c;
				40: rgb_out = 24'h0d0502;
				41: rgb_out = 24'hf6ce88;
				42: rgb_out = 24'hed9e11;
				43: rgb_out = 24'h434a5f;
				44: rgb_out = 24'h11a5d4;
				45: rgb_out = 24'h2cc5f6;
				46: rgb_out = 24'he1240f;
				47: rgb_out = 24'hf05a5a;
				48: rgb_out = 24'h040200;
				49: rgb_out = 24'h110700;
				50: rgb_out = 24'h959ab1;
				51: rgb_out = 24'hfc683b;
				52: rgb_out = 24'hde4b1e;
				53: rgb_out = 24'hdce1e7;
				54: rgb_out = 24'hcfc6b8;
				default: rgb_out = 24'h000000;
			endcase
		end
	end

endmodule