/*
 * Userspace program that communicates with the vga_ball device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <pthread.h>
#include "usbkeyboard.h"
#include <stdlib.h>


#define MAXHOR 480
#define MAXVER 608

int vga_ball_fd;
int map[15][19];

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;

/* Read and print the background color */
void print_background_color() {
  vga_ball_arg_t vla;
  
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
      return;
  }
  printf("%02x %02x\n",
	 vla.background.red, vla.background.green);
}

/* Set the background color */
void set_background_color(const vga_ball_color_t *c)
{
  vga_ball_arg_t vla;
  vla.background = *c;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      return;
  }
}

/* print position */
/*
void print_position() {
  vga_ball_arg_t vla;
 
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
      return;
  }
  printf("%02x %02x %02x\n",
         vla.background.red, vla.background.green, vla.background.blue);
}
*/

/* set position */
/*
void set_background_color(uint hx, uint vy)
{
*/
 /* Plan is to send hx and vy to move hardware */
 /* unimplemented due to technical issues */
 /*
  vga_ball_arg_t vla;
  vga_ball_color_t position;
  position.red = (unsigned char) hx;
  position.green = (unsigned char) vy;
  position.blue = (unsigned char) 0;
  
  vla.background = position;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      return;
  }
}
*/



int main()
{
  vga_ball_arg_t vla;
  struct usb_keyboard_packet packet;
  int transferred;
  char keystate[12];
  int i;

  /* bools for direction of movement */
  int x1 = 200;
  int y1 = 300;

  static const char filename[] = "/dev/vga_ball";
/*
   static const vga_ball_color_t colors[] = {
    { 0xff, 0x00, 0x00 }, * Red *
    { 0x00, 0xff, 0x00 }, * Green *
    { 0x00, 0x00, 0xff }, * Blue *
    { 0xff, 0xff, 0x00 }, * Yellow *
    { 0x00, 0xff, 0xff }, * Cyan *
    { 0xff, 0x00, 0xff }, * Magenta *
    { 0x80, 0x80, 0x80 }, * Gray *
    { 0x00, 0x00, 0x00 }, * Black *
    { 0xff, 0xff, 0xff }  * White *
  };

# define COLORS 9
*/
  printf("VGA ball Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }
 /*
  printf("initial state: ");
  print_background_color();

  for (i = 0 ; i < 24 ; i++) {
    set_background_color(&colors[i % COLORS ]);
    //print_background_color();
    set_position(40*i, 20*i);
    print_position();
    usleep(400000);
  }
 */
 if ( (keyboard = openkeyboard(&endpoint_address)) == NULL) {
	fprintf(stderr, "Did not find a keyboard\n");
	exit(1);
 }

  /* Look for and handle keypresses */
  for (;;) {
	libusb_interrupt_transfer(keyboard, endpoint_address,
				  (unsigned char *) &packet, sizeof(packet),
				  &transferred, 0);
	if (transferred == sizeof(packet)) {
		/* right */
		if (packet.keycode[4] == 0x4F) {
			if (x1 < 464) {
				x1 += 1;
			}
		}
		/* left */
		else if (packet.keycode[4] == 0x50) {
			if (x1 > 16) {
				x1 -= 1;
			}
		}
		/* down */
		else if (packet.keycode[4] == 0x51) {
			if (y1 > 16) {
				y1 -= 1;
			}
		}
		/* up */
		else if (packet.keycode[4] == 0x52) {
			if (y1 < 592) {
				y1 += 1;
			}
		}
	}
  } 
  printf("VGA BALL Userspace program terminating\n");
  return 0;
}
