#ifndef _BIQUAD_H
#define _BIQUAD_H

#include <linux/ioctl.h>

typedef struct {
	short signed int biquadcoeff[21];
} biquad_param_t;

typedef struct {
  biquad_param_t biquadparam;
} biquad_arg_t;

#define BIQUAD_MAGIC 'q'

/* ioctls and their arguments */
#define BIQUAD_WRITE_PARAM _IOW(BIQUAD_MAGIC, 1, biquad_arg_t *)
#define BIQUAD_READ_PARAM  _IOR(BIQUAD_MAGIC, 2, biquad_arg_t *)

#endif
