`timescale 1 ps / 1 ps
module hardclip (
//AVALON ST
		input  wire        clk,              //                     clk.clk
		input  wire        reset,          //                     havent done any reset logic yet
		input  wire signed [15:0] ast_sink_data,    //   avalon_streaming_sink.data
		input  wire        ast_sink_valid,   //                        .valid
		output reg        ast_sink_ready,   //                        .ready
		output reg signed [15:0] ast_source_data,  // avalon_streaming_source.data
		output reg        ast_source_valid, //                        .valid
		input  wire        ast_source_ready,  //                        .ready
		
//AVALON MM
		input wire signed [15:0]  writedata,
		input wire 	   write,
		input 		   chipselect,
		input wire [2:0]  address

);
	
//AVALON ST
reg signed [15:0] tp;
reg signed [15:0] tn;


always @(posedge clk) begin

	if(ast_sink_data>tp)
		if (tp > 16'd1600)
			ast_source_data<=tp;
		else    ast_source_data<=16'd1600;
	else if(ast_sink_data<tn)
		if (tp > 16'd1600)
			ast_source_data<=tn;
		else    ast_source_data<=-16'd1600;
	else if(tp > 16'd1600)
		ast_source_data<=ast_sink_data;
	else 
		ast_source_data<=(ast_sink_data * 25) / (tp >> 6);
		
	ast_source_valid<=ast_sink_valid;
	ast_sink_ready<=ast_source_ready;
end

	
	
//AVALON MM 
always @(posedge clk) begin
     if (reset) begin
	     tp <= 16'd3000;
	     tn <= -16'd3000;

     end else if (chipselect && write)
       case (address)
	 3'h0 : tp <= writedata;
	 3'h1 : tn <= writedata;
       endcase
end
	
	
endmodule
	
	
	
