`timescale 1ns/1ns
module delay
  (
  
  //AVALON ST
   input clk,
   input reset,
   input avalon_source_ready,
   output reg avalon_source_valid,
   output reg signed [DATA_WIDTH-1:0] avalon_source_data,

   output reg avalon_sink_ready,
   input avalon_sink_valid,
   input signed [DATA_WIDTH-1:0] avalon_sink_data,
//AVALON MM
		input wire signed [15:0]  writedata,
		input wire 	   write,
		input 		   chipselect,
		input wire [2:0]  address
		//input wire bypass
   );


//AVALON MM REG
reg signed [15:0] mix;//adjust gain by software >>>1=-6dB, 2=12dB, etc.
wire signed [15:0] s_mix;
assign s_mix=mix;
reg [15:0] MAX_DELAY; //amount of samples to delay (no larger than 8192)
reg [15:0] bypass;//bypass
wire signed [31:0] result; //amount of samples to delay (no larger than 8192)
assign result = fifo_reg*s_mix;
parameter DATA_WIDTH = 16;
reg signed [DATA_WIDTH-1:0] in_reg;
wire signed [DATA_WIDTH-1:0] fifo_reg;
reg signed [15:0] mixin=16'd16380;
wire signed [31:0] indat=avalon_sink_data*mixin;
always @(posedge clk)begin
if (avalon_sink_valid) begin
		in_reg <= avalon_sink_data;
		//avalon_source_data = fifo_reg+avalon_sink_data;
end
		avalon_source_data <= |bypass?avalon_sink_data:result[31:16]+indat[30:15];

 end
//BEGIN AVALON MM
always @(posedge clk) begin

     if (reset) begin
			mix<=16'd30000;//adjust gain by software >>>1=-6dB, 2=12dB, etc.
			MAX_DELAY<= 6000; //amount of samples to delay
			bypass<=16'd0;//default to bypass
     end else if (chipselect && write)
       case (address)
	 3'h0 : bypass <= writedata;
	 3'h1 : MAX_DELAY <= writedata;
	 3'h2 : mix<=writedata;//adjust gain by software >>>1=-6dB, 2=12dB, etc.

       endcase
end

 

//END AVALON MM
 
  reg [15:0] ptr; //8192 samples =2^13
  reg [15:0] ptrr;

  always @(posedge clk)begin
  
 avalon_sink_ready<=avalon_source_ready;
 avalon_source_valid<=avalon_sink_valid;
    if (reset) begin
      ptr <= 0;
      ptrr <= ptrr+1;
end    
else 
	 if (avalon_source_valid&&avalon_source_ready)begin
      if (ptr == MAX_DELAY)begin
	ptr <= 0;
      ptrr <= ptrr+1;
end else  if (ptrr == MAX_DELAY)begin
	ptrr<=0;
		ptr <= ptr+1;

end
      else begin
	ptr <= ptr+1;
      ptrr <= ptrr+1;
	end
	end
 end
delayram	delayram_inst (
	.clock ( clk ),
	.data ( in_reg ),
	.rdaddress ( ptrr[12:0]),
	.rden (1),
	.wraddress ( ptr[12:0] ),
	.wren ( avalon_source_valid&&avalon_source_ready),
	.q ( fifo_reg )
	);
 
endmodule
