#ifndef _USBDEVICES_H
#define _USBDEVICES_H

#include <libusb-1.0/libusb.h>
#include <stdbool.h>

#define USB_HID_KEYBOARD_PROTOCOL 1
#define USB_HID_CONTROLLER_PROTOCOL 0

/* Modifier bits */
#define USB_LCTRL  (1 << 0)
#define USB_LSHIFT (1 << 1)
#define USB_LALT   (1 << 2)
#define USB_LGUI   (1 << 3)
#define USB_RCTRL  (1 << 4)
#define USB_RSHIFT (1 << 5)
#define USB_RALT   (1 << 6) 
#define USB_RGUI   (1 << 7)

struct usb_keyboard_packet {
  uint8_t modifiers;
  uint8_t reserved;
  uint8_t keycode[6];
};

/* Find and open a USB keyboard device.  Argument should point to
   space to store an endpoint address.  Returns NULL if no keyboard
   device was found. */
extern struct libusb_device_handle *openkeyboard(uint8_t *);
extern struct libusb_device_handle *opencontroller(uint8_t *);

extern char get_char_from_keystate(struct usb_keyboard_packet *);
extern char get_gameplay_key(uint8_t);
extern bool is_key_pressed(uint8_t, uint8_t[6]);
extern bool is_controller_key_pressed(int, uint8_t, uint8_t[6]);

extern uint8_t get_last_keycode(uint8_t[6]);
extern int get_last_keycode_pos(uint8_t[6]);

#endif