%
% Title: PMDC cascaded control
% Version: 0.0
% Date: 4/30/22
% Author: Alexandre Msellati
% Description: Model for C implementation
%
% License: CC BY-NC-ND
% Creative Commons Attribution-NonCommercial-NoDerivs
% https://creativecommons.org/licenses/by-nc-nd/4.0/
%


clear all
close all
clc


%% Operation point %%%%%%%%%%%%%%%%%%%%%%
% N_ref=1000; %(rpm) speed reference
% T_L=0; %(Nm) load torque
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Drive system %%%%%%%%%%%%%%%%%%%%%%%%%

% PMSM parameters %%%%%%%%%%%%%%%%%%%%%%%
Ra = 0.2;  % Ohm
La = 1e-3;  % H
J = 1e-4;  % kgm2
B = 1e-5;  % Nms/rad
% B = 0;  % Nms/rad
k = 2e-2 % Machine constant

% test
% P = 3336  % W
% Va_rated = 140  % V
% Ia_rated = 25  % A
% Wm_rated = 3000 * 2 * pi / 60  % rad/s
% Te_rated = P / Wm_rated  % Nm
% Ra = 0.26;  % Ohm
% La = 1.7e-3;  % H
% J = 2.52e-3;  % kgm2
% B = 0;  % Nms/rad
% k = Te_rated / Ia_rated % Machine constant

% Time constants %%%%%%%%%%%%%%%%%%%%%%%
Ta = La / Ra;  % s
omega_a = 1 / Ta;  % rad/s
Tm = J / B;  % s
omega_m = 1 / Tm;  % rad/s
% c.Rs = 0.4; %(Ohms) Stator resistance
% c.L = 10.5e-3; %(H) d-axis inductance
% c.psi = 3.491; %[Wb] rotor flux linkage
% c.J = 22.76e-3; %(kg-m^2) Inertia
% c.B = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Gain %%%%%%%%%%%%%%%%%%%%%%%
Ka = 1 / Ra

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Inverter parameters  %%%%%%%%%%%%%%%%%%
fs = 25e3;  % Hz, switching frequency
omega_s = 2 * pi * fs;  % rad/s
% c.Ts = 100e-6; %[s] Inverter switching period
% c.uc = 800; %(V) DC link voltage
% c.im = 10; %[A] Max. current
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ADC parameters %%%%%%%%%%%%%%%%%%
f_sample = 100e3  % Hz, sampling frequency
T_sample = 1 / f_sample  % s, sampling period


% Simulation parameters %%%%%%%%%%%%%%%%%
% c.Tstep = 1e-6; %[s]
% c.Tsim = .5; %[s]
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%% Control system %%%%%%%%%%%%%%%%%%%%%%%

% % Current PI regulator
% omega_cc = omega_s / 10;  % rad/s
omega_cc = 5000;  % rad/s
Kp_i = La * omega_cc;
Ki_i = Kp_i * Ra / La;
Ka_i = 1 / Kp_i  % anti-windup
Tpi = Kp_i / Ki_i;  % s
omega_pi = 1 / Tpi;  % rad/s

% % Speed controller
omega_cs = omega_cc / 5
Kp_s = J * omega_cs / k;
Ki_s = J * omega_cs^2 / (5 * k);
Ka_s = 1 / Kp_s
% 

% % Speed controller
Kp_p = 2.5;
% 
% % Bode plots
s = tf('s');
% % Physical tf
Ga = 1 / (Ra +s*La);
Gm = 1/( B + s*J);
% % Controller tf
Gpi = (Kp_i + Ki_i / s);
% tf_pii = Ki_i * (1 + Tpi * s) / s;
% tf_piw = Kp_w +Ki_w/s;
% Continuous open loop tf
% tf_ic = tf_pii * tf_arm;
L = Gpi * Ga
% tf_wc = tf_piw*tf_mec;
% % Discrete open loop tf
L_d = c2d(L, T_sample)
% tf_id = c2d(tf_ic,c.Ts);
% tf_wd = c2d(tf_wc,c.Ts);
% 
% Gain margin (gm) [factor, not dB!], phase margin (pm) [deg], 
    % and related frequencies w [rad/s]
% fig = bodeplot(L_d, {1e-3, omega_cc * 1e3})
% margin(L)
% margin(L_d)
% grid on
% [Gm_i,Pm_i,Wgm_i,Wpm_i] = margin(tf_id);
% [Gm_w,Pm_w,Wgm_w,Wpm_w] = margin(tf_wd);
% 
% % Armature bode plot
% h = bodeplot(tf_ic,tf_wc);
% grid on, hold on
% xlims = getoptions(h,'XLim'); % size of ylims for this plot will be 2x1 (mag;phase)
% xlims{1} = [1,2*pi/c.Ts];
% setoptions(h,'XLimMode','manual','XLim',xlims)
% % Plot margins
% margin(tf_id);
% margin(tf_wd);
