module writeOCM8(
	input logic						clk, reset,
	input logic						out_dv,
	input logic		[ 9: 0][ 7: 0]	out_data,

	// On-Chip RAM 1 s1 (write)
	output logic	[ 7: 0]			ocm1_writedata,
	output logic	[16: 0]			ocm1_addr,
	output logic					ocm1_chip,
	output logic					ocm1_clk_enab,
	output logic					ocm1_write,
	
	output logic 	[15: 0]			count
);

	// FSM
	logic [ 2: 0]	state;
	parameter S0 = 0, S1 = 1, S2 = 2, S3 = 3, S4 = 4, S5 = 5;
	
	logic [16*10*8-1:0]	out_buf;
	logic [16: 0]		index_buf_in = 0;	// to index out_buf during input
	logic [16: 0]		index_buf_out = 0;	// to index out_buf during output
	
	logic [16: 0]		addr_write = 0;		// to address memory write
	
	always @ (posedge clk) begin
		case (state)
			S0:	// Reset
				begin
					count = 0;
					index_buf_in = 0;
					index_buf_out = 0;
					addr_write = 0;
					
					ocm1_chip = 1;
					ocm1_clk_enab = 1;
					ocm1_write = 1;
					
				end
			S1:	// Erase memory
				begin
					ocm1_writedata = 0;
					ocm1_addr = addr_write;
					addr_write = addr_write + 1;
				end
			S2:	// Prepare for data -> buf
				begin
					addr_write = 0;
					index_buf_in = 0;
				end
			S3:	// data -> buf
				begin
					if(out_dv == 1)
					begin
						out_buf[index_buf_in+(8*0) +: 8] = out_data[0];
						out_buf[index_buf_in+(8*1) +: 8] = out_data[1];
						out_buf[index_buf_in+(8*2) +: 8] = out_data[2];
						out_buf[index_buf_in+(8*3) +: 8] = out_data[3];
						out_buf[index_buf_in+(8*4) +: 8] = out_data[4];
						out_buf[index_buf_in+(8*5) +: 8] = out_data[5];
						out_buf[index_buf_in+(8*6) +: 8] = out_data[6];
						out_buf[index_buf_in+(8*7) +: 8] = out_data[7];
						out_buf[index_buf_in+(8*8) +: 8] = out_data[8];
						out_buf[index_buf_in+(8*9) +: 8] = out_data[9];
						index_buf_in = index_buf_in + 8*10;
					end
				end
			S4:	// Prepare for buf -> OCM
				begin
					count = 0;
					index_buf_out = 0;
				end
			S5:	// buf -> OCM
				begin
					if(index_buf_out < index_buf_in) begin
							ocm1_chip = 1;
							ocm1_clk_enab = 1;
							ocm1_write = 1;
							ocm1_writedata = out_buf[index_buf_out +: 8];
							ocm1_addr = addr_write;
						
							index_buf_out = index_buf_out + 8;
							addr_write = addr_write + 1;
							count = count + 1;
					end
				end
		endcase
	end
	
	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)
			begin
				state <= S0;
			end
		else
			case (state)
				S0:
					state <= S1;
				S1:
					if(addr_write > 4000)
						state <= S2;
				S2:
					state <= S3;
				S3:
					if(index_buf_in >= (16-1)*10*8)  // TODO: do not hardcode this length
						state <= S4;
				S4:
					state <= S5;
				S5:
					if(index_buf_out >= index_buf_in)
						state <= S2;
			endcase
	end

endmodule

