module writeFeatMap(
	input 	logic						clk, reset,

	// Input from HPS
	input	logic						start,
	input	logic	[15: 0]				write_length,
	input	logic	[31: 0]				buf_offset,

	// Output to HPS
	output	logic						finish,
	output	logic	[ 2: 0]				debug_state,

	// On-Chip RAM 1 s1 (write)
	output logic	[ 7: 0]				ocm1_writedata,
	output logic	[16: 0]				ocm1_addr,
	output logic						ocm1_chip,
	output logic						ocm1_clk_enab,
	output logic						ocm1_write,

	// Input from pipeline
	input	logic						out_data_ready,
	input	logic	[32*32*16-1: 0]		feat_map_out,

	// Debug with seven-segment display
	output logic 	[15: 0]				count
);

	// FSM
	logic [ 2: 0]	state;
	assign debug_state = state;
	parameter S0 = 0, S1 = 1, S2 = 2, S3 = 3, S4 = 4, S5 = 5;
	
	// For OCM Write
	logic [16: 0]	addr = 0;
	logic [15: 0]	write_counter = 0;
	
	always @ (posedge clk) begin
		case (state)
			S0:	// Reset
				begin
					count = 0;
				end
			S1:	// Prepare to write
				begin
					addr = 0;
					finish = 0;
					write_counter = 0;

					ocm1_chip = 0;
					ocm1_clk_enab = 0;
					ocm1_write = 0;
				end
			S2:	// Write
				begin
					ocm1_addr = addr;
					ocm1_chip = 1;
					ocm1_clk_enab = 1;
					ocm1_write = 1;
					ocm1_writedata = feat_map_out[(buf_offset + write_counter)*8 +: 8];

					addr = addr + 1;
					write_counter = write_counter + 1;
				end
			S3:	// Finished, wait for start->0
				begin
					finish = 1;
					ocm1_clk_enab = 0;
				end
		endcase
	end
	
	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)
			begin
				state <= S0;
			end
		else
			case (state)
				S0:
					state <= S1;
				S1:
					if(start)
						state <= S2;
				S2:
					if(addr >= write_length)
						state <= S3;
				S3:
					if(start == 0)
						state <= S1;
			endcase
	end

endmodule

