#include <iostream>
#include "VtestEcho.h"
#include <verilated.h>
#include <verilated_vcd_c.h>

int main(int argc, const char ** argv, const char ** env) {
  Verilated::commandArgs(argc, argv);

  VtestEcho * dut = new VtestEcho;
  
  Verilated::traceEverOn(true);
  VerilatedVcdC * tfp = new VerilatedVcdC;
  dut->trace(tfp, 99);
  tfp->open("testEcho.vcd");

  dut->clk = 0;
  dut->reset = 0;
  dut->in_dv = 0;
  dut->in_data = 0;

  int time = 0;
  int byte_index = 0;
  for ( ; time < 20000000 ; time += 10) {
    dut->clk = ((time % 20) >= 10) ? 1 : 0;
    if (time == 0) dut->reset = 1;
    if (time == 40) dut->reset = 0;

    if (time >= 100) {
      if ((time % 20) >= 10) {
        // Every clock cycle
        if (byte_index < 784) {
          dut->in_dv = 1;
          dut->in_data = byte_index % 50;
          byte_index++;
        } else {
          dut->in_dv = 0;
          dut->in_data = 0;
        }
      }
    }
    dut->eval();
    
    tfp->dump( time );

  }
  
  tfp->close();
  delete tfp;

  dut->final();
  delete dut;

  return 0;
}