module tbRWFeatureMap(
	input	logic						clk, reset,

	// Input from HPS
	input	logic						h2f_start,
	input	logic	[15: 0]				h2f_read_length,
	input	logic	[31: 0]				h2f_buf_offset,

	input	logic						f2h_start,
	input	logic	[15: 0]				f2h_write_length,
	input	logic	[31: 0]				f2h_buf_offset,

	// Output to HPS
	output	logic						h2f_finish,
	output	logic	[ 2: 0]				h2f_debug_state,

	output	logic						f2h_finish,
	output	logic	[ 2: 0]				f2h_debug_state,

	// On-Chip RAM 0 s2 (read)
	input	logic	[ 7: 0]				ocm0_readdata,
	output	logic	[16: 0]				ocm0_addr,
	output	logic						ocm0_chip,
	output	logic						ocm0_clk_enab,

	// On-Chip RAM 1 s1 (write)
	output	logic	[ 7: 0]				ocm1_writedata,
	output	logic	[16: 0]				ocm1_addr,
	output	logic						ocm1_chip,
	output	logic						ocm1_clk_enab,
	output	logic						ocm1_write,

	// inout	logic	[32*32*64*16-1:0]	feat_map,
	// inout	logic	[10000-1:0]	feat_map,
	// inout	logic	[1000-1:0]			feat_map

	output	logic	[15: 0]				write_count,
	output	logic	[10000-1:0]			feat_map
);

logic						in_dv;
// wire	[10000-1:0]			feat_map;

readImg rd(
	.clk				(clk),
	.reset				(reset),
	.start				(h2f_start),
	.read_length		(h2f_read_length),
	.buf_offset			(h2f_buf_offset),
	.finish				(h2f_finish),
	.debug_state		(h2f_debug_state),
	.ocm0_readdata		(ocm0_readdata),
	.ocm0_addr			(ocm0_addr),
	.ocm0_chip			(ocm0_chip),
	.ocm0_clk_enab		(ocm0_clk_enab),
	.feat_map			(feat_map),
	.in_dv				(in_dv)
);

writeFeatMap wr(
	.clk				(clk),
	.reset				(reset),
	.start				(f2h_start),
	.write_length		(f2h_write_length),
	.buf_offset			(f2h_buf_offset),
	.finish				(f2h_finish),
	.debug_state		(f2h_debug_state),
	.ocm1_writedata		(ocm1_writedata),
	.ocm1_addr			(ocm1_addr),
	.ocm1_chip			(ocm1_chip),
	.ocm1_clk_enab		(ocm1_clk_enab),
	.ocm1_write			(ocm1_write),
	.feat_map			(feat_map),
	.count				(write_count)
);

endmodule
