module tbOpt(
	input	logic						clk, reset,

	// Input from HPS
	input	logic						start,
	input	logic	[15: 0]				read_length,
	input	logic	[5: 0]				read_data_dim,

	// On-Chip RAM 0 s2 (read)
	input	logic	[ 7: 0]				ocm0_readdata,
	output	logic	[16: 0]				ocm0_addr,
	output	logic						ocm0_chip,
	output	logic						ocm0_clk_enab,

	// On-Chip RAM 1 s1 (write)
	output	logic	[ 7: 0]				ocm1_writedata,
	output	logic	[16: 0]				ocm1_addr,
	output	logic						ocm1_chip,
	output	logic						ocm1_clk_enab,
	output	logic						ocm1_write,

	// Output
	output	logic						finish,

	// DEBUG
	output	logic	[3*3*16-1: 0]		feat_map_in,
	output	logic	[3*3*16-1: 0]		feat_map_out,
	output	logic	[2:0]				read_state,
	output	logic	[2:0]				conv_state,
	output	logic	[2:0]				write_state,
	output	logic	[15: 0]				write_count
);

wire						in_data_ready;
wire						out_data_ready;

// wire	[3*3*16-1: 0]		feat_map_in;
wire	[(3*3+1)*16-1: 0]	weight_bias;

// ReadOCM <-> Conv
wire						start_fm;
wire	[15: 0]				conv_idx;
wire						finish_fm;

// Conv <-> WriteOCM
wire						start_out;
wire	[15: 0]				out_idx;
// wire	[3*3*16-1: 0]		feat_map_out;
wire						finish_out;

readOCM rd(
	.clk						(clk),
	.reset						(reset),

	// Input from HPS
	.start						(start),
	.read_length				(read_length),
	.read_data_dim				(read_data_dim),

	// Output to pipeline
	.in_data_ready				(in_data_ready),
	.weight_bias				(weight_bias),

	// Read feature map 3x3
	.start_fm					(start_fm),
	.conv_idx					(conv_idx),
	.finish_fm					(finish_fm),
	.feat_map_in				(feat_map_in),

	// On-Chip RAM 0 s2 (read)
	.ocm0_readdata				(ocm0_readdata),
	.ocm0_addr					(ocm0_addr),
	.ocm0_chip					(ocm0_chip),
	.ocm0_clk_enab				(ocm0_clk_enab),

	// Debug
	.debug_state				(read_state)
);

convOpt cv(
	.clk						(clk),
	.reset						(reset),

	// Input from pipeline
	.in_data_ready				(in_data_ready),
	.in_data_dim				(read_data_dim),
	.weight_bias				(weight_bias),

	// Request FM from pipeline
	.start_fm					(start_fm),
	.conv_idx					(conv_idx),
	.finish_fm					(finish_fm),
	.feat_map_in				(feat_map_in),

    // Output to pipeline
	.start_out					(start_out),
	.out_idx					(out_idx),
	.feat_map_out				(feat_map_out),

	.finish_out					(finish_out),
	// Output to HPS
	.finish						(finish),

	// Debug
	.debug_state				(conv_state)
);

writeOCM wr(
	.clk						(clk),
	.reset						(reset),

	// Input from pipeline
	.start_out					(start_out),
	.out_idx					(out_idx),
	.feat_map_out				(feat_map_out),
	
	// Output to HPS
	.finish_out					(finish_out),

	// On-Chip RAM 1 s1 (write)
	.ocm1_writedata				(ocm1_writedata),
	.ocm1_addr					(ocm1_addr),
	.ocm1_chip					(ocm1_chip),
	.ocm1_clk_enab				(ocm1_clk_enab),
	.ocm1_write					(ocm1_write),

	// Debug
	.debug_state				(write_state),
	.count						(write_count)
);

endmodule
