module tbFPU(
	input	logic						clk, reset,
	input	logic	[ 15: 0]			in_1,
	input	logic	[ 15: 0]			in_2,

	output	logic	[ 16: 0]			out_mult,
	output	logic	[ 16: 0]			out_add,
	
	output	logic						overflow_mult,
	output	logic						zero_mult,
	output	logic						nan_mult,
	output	logic						precision_lost_mult,

	output	logic						overflow_add,
	output	logic						zero_add,
	output	logic						nan_add,
	output	logic						precision_lost_add
);


float_multi mu(
	.num1				(in_1),
	.num2				(in_2),
	.result				(out_mult),
	.overflow			(overflow_mult),
	.zero				(zero_mult),
	.NaN				(nan_mult),
	.precisionLost		(precision_lost_mult)
);

float_adder ad(
	.num1				(in_1),
	.num2				(in_2),
	.result				(out_add),
	.overflow			(overflow_add),
	.zero				(zero_add),
	.NaN				(nan_add),
	.precisionLost		(precision_lost_add)
);

endmodule

