#include <iostream>
#include "VtbFPU.h"
#include <verilated.h>
#include <verilated_vcd_c.h>

int main(int argc, const char ** argv, const char ** env) {
  Verilated::commandArgs(argc, argv);

  VtbFPU * dut = new VtbFPU;
  
  Verilated::traceEverOn(true);
  VerilatedVcdC * tfp = new VerilatedVcdC;
  dut->trace(tfp, 99);
  tfp->open("tbFPU.vcd");

  dut->clk = 0;
  dut->reset = 0;
  dut->in_1 = 0;
  dut->in_2 = 0;

  int time = 0;

  // writeOCM erases memory: 4000 clock cycles
  for ( ; time < 200 ; time += 10) {
    dut->clk = ((time % 20) >= 10) ? 1 : 0;
    if (time == 0) dut->reset = 1;
    if (time == 40) dut->reset = 0;

    if (time == 90) {
      dut->in_1 = 0x3E00;
      dut->in_2 = 0x3E00;
    }

    if (time > 100 && (time % 20) >= 10) {
      printf("[%d] %04x * %04x = %04x\t", time, dut->in_1, dut->in_2, dut->out_mult);
      printf("%04x + %04x = %04x\n", dut->in_1, dut->in_2, dut->out_add);
    }

    dut->eval();
    tfp->dump( time );
  }

  tfp->close();
  delete tfp;

  dut->final();
  delete dut;

  return 0;
}