module tbEchoWrite(
	input	logic						clk, reset,

	input	logic						in_dv,
	input	logic	[ 7: 0]				in_data,

	output 	logic	[ 7: 0]				ocm1_writedata,
	output 	logic	[16: 0]				ocm1_addr,
	output 	logic						ocm1_chip,
	output 	logic						ocm1_clk_enab,
	output 	logic						ocm1_write,

	output 	logic 	[15: 0]				count
);

logic	[3:0]			debug1;
logic	[3:0]			debug2;

logic					out_dv;
logic	[9:0][7:0]		out_data;

testEcho te(
	.clk							(clk),
	.reset							(reset),
	
	.in_data						(in_data),
	.in_dv							(in_dv),
	
	.out_data						(out_data),
	.out_dv							(out_dv),
	.debug1							(debug1),
	.debug2							(debug2)
);

writeOCM8 wo(
	.clk							(clk),
	.reset							(reset),
	
	// data from testEcho
	.out_dv							(out_dv),
	.out_data						(out_data),

	
	// On-Chip RAM 1 s1 (write)
	.ocm1_writedata					(ocm1_writedata),
	.ocm1_addr						(ocm1_addr),
	.ocm1_chip						(ocm1_chip),
	.ocm1_clk_enab					(ocm1_clk_enab),
	.ocm1_write						(ocm1_write),
	
	.count							(count)
);


endmodule

